/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const PixienautToiletSvg: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len,react/no-unknown-property */
  <svg {...props} width='882' height='1045' viewBox='0 0 882 1045' fill='none' xmlns='http://www.w3.org/2000/svg'>
    <path
      d='M184.025 691.843L275.173 695.709C294.849 696.544 304.686 696.961 312.753 700.741C319.769 704.028 325.802 709.094 330.256 715.434C335.376 722.724 337.491 732.34 341.721 751.574L341.721 751.574C348.015 780.193 351.163 794.503 345.206 807.858C340.886 817.545 328.496 828.707 318.412 831.996C304.51 836.531 294.116 833.079 273.33 826.174C222.881 809.417 184.025 771.539 184.025 691.843Z'
      fill='url(#paint0_linear)'
    />
    <path
      d='M111.65 481.007C116.702 496.207 126.109 501.706 130.181 502.556L352.331 511.936L409.076 466.62C412.152 435.462 414.963 372.201 401.605 368.427C384.907 363.709 183.57 357.059 173.044 360.208C162.518 363.357 109.215 394.146 106.666 406.361C104.117 418.577 105.334 462.007 111.65 481.007Z'
      fill='url(#paint1_linear)'
    />
    <path
      opacity='0.4'
      d='M181.039 498.256C173.176 466.497 170.494 423.091 170.094 387.709C169.971 376.831 174.022 367.012 180.738 359.569C219.733 358.288 386.474 364.15 401.604 368.426C412.641 371.544 412.64 415.271 410.572 447.947C409.815 459.907 403.794 470.836 394.43 478.315L366.066 500.966C357.242 508.013 346.066 511.435 334.809 510.536L181.039 498.256Z'
      fill='url(#paint2_linear)'
    />
    <path
      d='M169.658 691.724C223.47 751.111 286.878 744.147 318.701 740.096L348.997 466.829C280.559 465.706 128.724 468.943 128.231 490.223C127.615 516.823 131.204 649.285 169.658 691.724Z'
      fill='url(#paint3_linear)'
    />
    <path
      opacity='0.4'
      d='M177.083 471.75C222.198 463.626 302.449 462.146 349.837 462.798L318.741 739.9C316.762 740.161 314.711 740.45 312.592 740.749C286.052 744.494 248.855 749.742 208.195 719.229C185.016 656.528 177.484 538.59 177.083 471.75Z'
      fill='url(#paint4_linear)'
    />
    <path
      d='M209.644 605.246C225.413 690.406 262.496 716.289 279.066 718.585C311.162 718.72 380.332 712.567 400.247 686.877C425.141 654.765 429.417 634.047 443.175 584.14C456.933 534.232 491.112 340.122 414.664 334.996C338.215 329.871 248.35 345.879 218.237 380.608C188.123 415.336 189.932 498.797 209.644 605.246Z'
      fill='url(#paint5_linear)'
    />
    <path
      opacity='0.4'
      d='M235.284 609.465C249.135 684.677 281.763 707.527 296.345 709.55C324.593 709.658 385.473 704.201 403.008 681.504C424.928 653.133 428.698 634.832 440.822 590.746C452.947 546.66 483.092 375.2 415.811 370.698C348.53 366.196 269.434 380.364 242.92 411.048C216.405 441.732 217.97 515.449 235.284 609.465Z'
      fill='url(#paint6_linear)'
    />
    <path
      opacity='0.4'
      d='M429.048 374.246C425.126 372.248 420.729 371.027 415.811 370.698C348.53 366.196 269.434 380.364 242.92 411.048C216.405 441.732 217.97 515.449 235.284 609.465C242.54 648.867 254.95 673.898 267.218 689.093C272.794 692.98 277.798 694.91 281.585 695.435C309.833 695.543 370.713 690.086 388.248 667.389C408.432 641.265 413.227 623.679 423.326 586.638C424.195 583.452 425.102 580.123 426.063 576.631C435.952 540.672 457.832 419.965 429.048 374.246Z'
      fill='url(#paint7_linear)'
    />
    <path
      d='M518.604 973.534C514.737 966.237 512.354 956.54 511.165 945.811L511.165 945.811C505.656 896.084 502.902 871.221 496.238 861.215C489.574 851.21 477.909 844.747 454.578 831.82C404.263 803.942 351.339 782.945 345.664 810.142C335.236 860.115 325.025 915.622 320.326 931.566C291.822 1028.27 535.5 1005.42 518.604 973.534Z'
      fill='url(#paint8_linear)'
    />
    <path
      d='M636.243 762.921C636.243 799.029 604.449 908.007 450.407 908.007C296.366 908.007 264.572 799.029 264.572 762.921C264.572 726.814 347.774 697.543 450.407 697.543C553.041 697.543 636.243 726.814 636.243 762.921Z'
      fill='url(#paint9_linear)'
    />
    <ellipse opacity='0.4' cx='458.549' cy='763.762' rx='185.835' ry='65.3782' fill='url(#paint10_linear)' />
    <ellipse opacity='0.4' cx='458.176' cy='753.53' rx='135.839' ry='47.789' fill='url(#paint11_linear)' />
    <path
      d='M573.08 507.336C713.177 507.336 826.748 393.765 826.748 253.668C826.748 113.571 713.177 0 573.08 0C432.983 0 319.412 113.571 319.412 253.668C319.412 393.765 432.983 507.336 573.08 507.336Z'
      fill='url(#paint12_linear)'
    />
    <mask id='mask0' mask-type='alpha' maskUnits='userSpaceOnUse' x='319' y='0' width='508' height='508'>
      <path
        d='M573.08 507.336C713.177 507.336 826.748 393.765 826.748 253.668C826.748 113.571 713.177 0 573.08 0C432.983 0 319.412 113.571 319.412 253.668C319.412 393.765 432.983 507.336 573.08 507.336Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask0)'>
      <path
        d='M324.877 113.191C324.877 113.191 415.594 58.835 472.787 58.835C529.981 58.835 605.062 98.8983 677.86 98.8983C750.657 98.8983 751.271 20.6041 751.271 20.6041L517.094 -23.8969L367.046 20.6041L324.877 113.191Z'
        fill='url(#paint13_linear)'
      />
      <path
        d='M448.242 -0.94591L454.656 -2.03618C503.14 -10.1176 535.99 -11.7985 566.702 -5.64977C607.144 2.44673 638.621 24.635 661.828 64.495C663.606 67.549 662.571 71.4663 659.517 73.2444C656.463 75.0225 652.546 73.9881 650.768 70.934C629.42 34.267 601.069 14.2821 564.19 6.89888C534.097 0.874201 501.015 2.90418 450.426 11.6641C446.943 12.2671 443.632 9.933 443.029 6.45085C442.426 2.96869 444.76 -0.342952 448.242 -0.94591Z'
        fill='#17413B'
      />
      <path
        d='M801.364 108.063C801.364 108.063 784.651 94.328 766.578 101.195C748.504 108.063 746.179 130.972 702.281 143.973C658.383 156.974 584.316 122.532 538.073 143.973C476.999 172.291 436.418 263.996 461.174 365.805C473.641 417.073 555.832 525.554 555.832 525.554L769.661 474.127L866.321 270.777L801.364 108.063Z'
        fill='url(#paint14_linear)'
      />
      <path
        d='M535.702 221.876C540.771 209.787 546.758 197.637 553.667 185.427C556.464 180.484 554.724 174.21 549.78 171.413C544.837 168.616 538.563 170.356 535.766 175.299C528.466 188.201 522.121 201.076 516.734 213.923C514.538 219.161 517.003 225.187 522.241 227.383C527.479 229.58 533.506 227.114 535.702 221.876Z'
        fill='white'
        fillOpacity='0.326978'
      />
      <path
        d='M526.152 422.196C531.409 420.047 533.929 414.044 531.78 408.786C521.492 383.613 517.4 354.322 518.225 322.151C518.798 299.798 521.127 282.013 525.63 257.031C526.637 251.441 522.923 246.094 517.333 245.086C511.744 244.079 506.396 247.793 505.388 253.383C500.714 279.316 498.271 297.978 497.664 321.624C496.772 356.418 501.245 388.439 512.741 416.567C514.89 421.825 520.894 424.345 526.152 422.196Z'
        fill='white'
        fillOpacity='0.326978'
      />
    </g>
    <rect
      x='306.548'
      y='248.954'
      width='82.2706'
      height='100.553'
      rx='14.6305'
      transform='rotate(-4 306.548 248.954)'
      fill='url(#paint15_linear)'
    />
    <rect
      x='297.576'
      y='250.699'
      width='82.2706'
      height='100.553'
      rx='14.6305'
      transform='rotate(-4 297.576 250.699)'
      fill='url(#paint16_linear)'
    />
    <path
      opacity='0.482399'
      d='M382.513 285.995L383.789 304.233C384.305 311.618 382.839 318.684 379.843 324.909L358.189 325.239L354.257 267.503L373.324 262.821C378.536 269.184 381.896 277.166 382.513 285.995Z'
      fill='url(#paint17_linear)'
    />
    <path
      d='M357.091 264.863C357.016 263.585 355.356 263.14 354.652 264.209L351.261 269.358L354.386 323.755L358.405 328.749C359.216 329.758 360.844 329.13 360.769 327.838L357.091 264.863Z'
      fill='#17413B'
    />
    <path
      d='M800.042 300.37C823.106 293.085 847.682 305.531 855.558 328.238L855.957 329.442L875.446 391.146L875.933 392.723C895.204 456.734 866.322 530.408 769.135 559.018L767.203 559.617L753.276 563.81C729.709 570.905 731.757 542.977 724.662 519.411C717.689 496.25 730.465 471.844 753.276 464.275L754.486 463.892L768.413 459.699C785.579 454.531 795.458 436.689 790.894 419.491L790.458 417.989L770.969 356.286C763.557 332.817 776.573 307.783 800.042 300.37Z'
      fill='url(#paint18_linear)'
    />
    <path
      opacity='0.198103'
      fillRule='evenodd'
      clipRule='evenodd'
      d='M740.144 471.234C744 468.266 748.406 465.888 753.267 464.275L754.477 463.892L768.404 459.699C784.487 454.857 794.173 438.89 791.578 422.75C796.393 431.078 802.151 449.363 802.151 489.187C802.151 512.449 800.937 532.029 799.334 547.742C790.108 552.018 780.048 555.803 769.126 559.018L767.194 559.617L753.267 563.81C746.86 565.739 742.346 565.079 739.027 562.622L740.144 471.234Z'
      fill='url(#paint19_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M392.541 402.212C395.066 402.212 397.112 400.166 397.112 397.641C397.112 395.117 395.066 393.071 392.541 393.071C390.017 393.071 387.971 395.117 387.971 397.641C387.971 400.166 390.017 402.212 392.541 402.212Z'
      fill='url(#paint20_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M410.824 420.494C413.349 420.494 415.395 418.448 415.395 415.924C415.395 413.399 413.349 411.353 410.824 411.353C408.3 411.353 406.254 413.399 406.254 415.924C406.254 418.448 408.3 420.494 410.824 420.494Z'
      fill='url(#paint21_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M429.107 434.206C431.631 434.206 433.677 432.16 433.677 429.636C433.677 427.111 431.631 425.065 429.107 425.065C426.582 425.065 424.536 427.111 424.536 429.636C424.536 432.16 426.582 434.206 429.107 434.206Z'
      fill='url(#paint22_linear)'
    />
    <path
      d='M387.971 479.912H753.619L765.228 770.145C766.375 798.827 743.432 822.706 714.727 822.706H462.755C378.862 822.706 317.766 743.183 339.382 662.123L387.971 479.912Z'
      fill='url(#paint23_linear)'
    />
    <mask id='mask1' mask-type='alpha' maskUnits='userSpaceOnUse' x='311' y='479' width='455' height='344'>
      <path
        d='M387.971 479.912H753.619L765.228 770.145C766.375 798.827 743.432 822.706 714.727 822.706H362.345C329.138 822.706 304.954 791.228 313.51 759.142L387.971 479.912Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask1)'>
      <path
        opacity='0.2'
        d='M505.565 682C662.365 657.2 745.899 604 768.065 580.5L803.565 725C638.899 721 348.765 706.8 505.565 682Z'
        fill='url(#paint24_linear)'
      />
      <path
        d='M623.178 519.843C620.22 519.843 617.787 522.092 617.495 524.972L617.465 525.557V616.262C617.465 619.418 620.023 621.975 623.178 621.975C626.136 621.975 628.57 619.727 628.862 616.846L628.892 616.262V525.557C628.892 522.401 626.334 519.843 623.178 519.843Z'
        fill='#17413B'
      />
      <rect x='547.942' y='557.613' width='22.853' height='73.1294' fill='#A7DFFF' />
      <path
        d='M721.19 569.553V597.607H707.741V590.751H714.333V576.409L694.184 576.409V569.553H721.19Z'
        fill='#A7DFFF'
      />
      <path d='M701.147 584.47V617.232H694.291V584.47H701.147Z' fill='#A7DFFF' />
    </g>
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M522.565 735.892C522.565 695.083 555.648 662 596.458 662H741.895C796.098 662 842.649 700.527 852.783 753.775L871.684 853.089C879.313 893.179 852.999 931.863 812.909 939.493C772.819 947.122 734.135 920.808 726.505 880.718L715.671 823.79C714.125 815.664 707.02 809.784 698.748 809.784H596.458C555.648 809.784 522.565 776.702 522.565 735.892Z'
      fill='url(#paint25_linear)'
    />
    <path
      opacity='0.3'
      fillRule='evenodd'
      clipRule='evenodd'
      d='M579.31 664C546.769 671.733 522.565 700.986 522.565 735.892C522.565 776.702 555.648 809.784 596.458 809.784H698.748C707.02 809.784 714.125 815.664 715.671 823.79L726.505 880.718C733.905 919.601 770.517 945.525 809.292 940.09C790.023 929.456 772.678 911.795 767.685 881.949L748.808 768.675C738.687 707.943 692.194 664 638.058 664H579.31Z'
      fill='url(#paint26_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M409.065 743.5C409.065 698.489 445.554 662 490.565 662H596.209C668.648 662 725.793 723.605 720.358 795.84L711.836 906.614C708.459 951.499 669.335 985.147 624.451 981.77C579.567 978.393 545.918 939.27 549.295 894.386L553.328 840.775C554.071 830.912 546.268 822.5 536.376 822.5H490.565C445.554 822.5 409.065 788.511 409.065 743.5Z'
      fill='url(#paint27_linear)'
    />
    <path
      opacity='0.2'
      d='M609.481 979.241C572.331 969.338 546.306 934.119 549.295 894.386L553.328 840.775C554.071 830.912 546.268 822.5 536.376 822.5H494.801C522.052 813.312 558.578 800.46 583.565 790C626.565 772 630.065 796 621.065 860C619.477 871.293 617.344 882.928 615.224 894.493C609.44 926.05 603.75 957.089 609.481 979.241Z'
      fill='url(#paint28_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M744.316 436.802C756.21 426.436 774.254 427.673 784.62 439.567C794.986 451.46 793.748 469.505 781.855 479.871C727.23 527.482 647.669 549.102 562.152 545.851C485.57 542.94 412.499 519.825 373.603 485.088C361.836 474.579 360.816 456.52 371.325 444.753C381.577 433.273 399.016 432.022 410.787 441.727L411.659 442.475C439.272 467.135 499.889 486.311 564.322 488.76C636.466 491.502 701.984 473.698 744.316 436.802Z'
      fill='url(#paint29_linear)'
    />
    <mask id='mask2' mask-type='alpha' maskUnits='userSpaceOnUse' x='364' y='429' width='428' height='118'>
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M744.316 436.802C756.21 426.436 774.254 427.673 784.62 439.567C794.986 451.46 793.748 469.505 781.855 479.871C727.23 527.482 647.669 549.102 562.152 545.851C485.57 542.94 412.499 519.825 373.603 485.088C361.836 474.579 360.816 456.52 371.325 444.753C381.577 433.273 399.016 432.022 410.787 441.727L411.659 442.475C439.272 467.135 499.889 486.311 564.322 488.76C636.466 491.502 701.984 473.698 744.316 436.802Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask2)'>
      <path
        opacity='0.969457'
        d='M433.239 443.964L436.61 449.934C409.057 465.49 397.017 489.608 400.704 523.283L400.921 525.129L394.118 525.981C389.522 489.264 402.274 462.14 431.676 444.864L433.239 443.964Z'
        fill='url(#paint30_linear)'
      />
      <path
        opacity='0.969457'
        d='M481.575 464.183L487.117 468.218C471.623 489.498 463.038 513.957 460.207 542.475L459.944 545.341L453.112 544.76C455.66 514.791 464.224 488.911 480.023 466.355L481.575 464.183Z'
        fill='url(#paint31_linear)'
      />
      <path
        opacity='0.969457'
        d='M541.544 466.763L548.309 467.875L547.552 472.297L546.275 479.277C540.614 509.769 539.577 527.816 544.099 565.405L544.458 568.335L537.655 569.182L536.946 563.285C532.85 527.863 533.846 509.343 539.099 480.396L541.061 469.626L541.544 466.763Z'
        fill='url(#paint32_linear)'
      />
      <path
        opacity='0.969457'
        d='M602.638 458.812L609.388 457.613L611.002 466.519C618.512 507.543 620.397 529.373 616.749 565.947L616.423 569.119L609.605 568.398C613.489 531.706 611.966 510.557 604.879 471.174L602.638 458.812Z'
        fill='url(#paint33_linear)'
      />
      <path
        opacity='0.969457'
        d='M675.251 456.567C687.865 493.647 693.319 519.042 693.332 552.324L693.318 555.468L686.462 555.403C686.778 522.486 681.854 497.876 669.902 462.157L668.76 458.775L675.251 456.567Z'
        fill='url(#paint34_linear)'
      />
      <path
        opacity='0.969457'
        d='M721.911 435.599L727.716 431.952L729.871 435.372C752.46 471.179 760.086 490.436 758.775 523.592L758.679 525.728L751.832 525.385C753.401 494.02 747.023 476.045 726.79 443.377L721.911 435.599Z'
        fill='url(#paint35_linear)'
      />
    </g>
    <path
      opacity='0.198103'
      d='M538.93 456.034C544.62 433.388 567.59 419.642 590.235 425.332C612.484 430.921 626.142 453.19 621.219 475.445L620.938 476.637L603.249 547.047C599.509 561.931 592.296 575.717 582.201 587.276C547.301 627.231 473.191 636.295 432.785 602.252L431.446 601.103L397.107 571.109C379.521 555.749 391.429 524.47 406.789 506.884C421.86 489.631 447.854 487.568 465.438 502.004L466.443 502.855L500.782 532.849C506.01 537.415 513.951 536.879 518.517 531.651C519.606 530.404 520.436 528.958 520.962 527.395L521.241 526.445L538.93 456.034Z'
      fill='url(#paint36_linear)'
    />
    <path
      d='M520.65 446.893C526.34 424.247 549.31 410.501 571.955 416.19C594.204 421.78 607.862 444.049 602.939 466.303L602.658 467.495L584.969 537.906C581.23 552.79 574.017 566.576 563.921 578.134C529.021 618.09 468.623 622.583 428.217 588.54L426.878 587.391L392.538 557.397C374.953 542.037 373.149 515.329 388.509 497.743C403.58 480.489 429.574 478.427 447.158 492.862L448.163 493.714L482.502 523.707C487.731 528.274 495.671 527.738 500.237 522.509C501.326 521.263 502.156 519.816 502.682 518.254L502.961 517.303L520.65 446.893Z'
      fill='url(#paint37_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M358.525 537.014C349.488 494.003 402.544 448.613 449.558 469.659C463.515 475.907 465.628 500.267 458.788 497.912C423.364 485.714 381.376 515.949 380.816 549.821L380.812 550.869C380.877 558.227 362.358 555.258 358.525 537.014Z'
      fill='url(#paint38_linear)'
    />
    <defs>
      <linearGradient
        id='paint0_linear'
        x1='-76.7735'
        y1='729.739'
        x2='297.509'
        y2='1013'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#83D3FF' />
        <stop offset='1' stopColor='#456AF1' />
      </linearGradient>
      <linearGradient
        id='paint1_linear'
        x1='-48.3672'
        y1='402.917'
        x2='416.889'
        y2='917.291'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#A0DDFF' />
        <stop offset='1' stopColor='#1070A5' />
      </linearGradient>
      <linearGradient
        id='paint2_linear'
        x1='135.657'
        y1='317.267'
        x2='142.238'
        y2='560.896'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint3_linear'
        x1='-2.53793'
        y1='647.938'
        x2='498.636'
        y2='887.63'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#A0DDFF' />
        <stop offset='1' stopColor='#1070A5' />
      </linearGradient>
      <linearGradient
        id='paint4_linear'
        x1='148.782'
        y1='428.248'
        x2='249.946'
        y2='791.453'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint5_linear'
        x1='64.4099'
        y1='561.154'
        x2='620.564'
        y2='824.707'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#A0DDFF' />
        <stop offset='1' stopColor='#1070A5' />
      </linearGradient>
      <linearGradient
        id='paint6_linear'
        x1='208.336'
        y1='370.447'
        x2='370.64'
        y2='771.995'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint7_linear'
        x1='193.576'
        y1='356.332'
        x2='355.881'
        y2='757.88'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint8_linear'
        x1='56.4783'
        y1='905.454'
        x2='494.374'
        y2='1156.11'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#83D3FF' />
        <stop offset='1' stopColor='#456AF1' />
      </linearGradient>
      <linearGradient
        id='paint9_linear'
        x1='97.9902'
        y1='836.287'
        x2='587.021'
        y2='1290.12'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#A0DDFF' />
        <stop offset='1' stopColor='#1070A5' />
      </linearGradient>
      <linearGradient
        id='paint10_linear'
        x1='232.777'
        y1='706.209'
        x2='255.329'
        y2='886.777'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint11_linear'
        x1='293.145'
        y1='711.461'
        x2='309.629'
        y2='843.449'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#0E7AB5' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint12_linear'
        x1='319.412'
        y1='-0.000173113'
        x2='319.412'
        y2='507.336'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint13_linear'
        x1='244.174'
        y1='362.046'
        x2='371.313'
        y2='38.0894'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#34D7E8' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint14_linear'
        x1='352.69'
        y1='449.27'
        x2='910.703'
        y2='686.952'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint15_linear'
        x1='290.977'
        y1='532.04'
        x2='417.8'
        y2='447.035'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#34D7E8' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint16_linear'
        x1='204.684'
        y1='456.19'
        x2='439.106'
        y2='481.444'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#B1F5FF' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint17_linear'
        x1='374.571'
        y1='440.941'
        x2='428.939'
        y2='404.752'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#34D7E8' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint18_linear'
        x1='761.463'
        y1='626.154'
        x2='933.833'
        y2='600.419'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#1C899A' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint19_linear'
        x1='742.73'
        y1='347.238'
        x2='637.147'
        y2='410.899'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint20_linear'
        x1='389.931'
        y1='396.133'
        x2='387.561'
        y2='404.718'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint21_linear'
        x1='408.214'
        y1='414.416'
        x2='405.844'
        y2='423'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint22_linear'
        x1='426.496'
        y1='428.128'
        x2='424.126'
        y2='436.712'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint23_linear'
        x1='696.565'
        y1='532.5'
        x2='531.942'
        y2='932.551'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#128698' />
        <stop offset='1' stopColor='#43CBC1' />
      </linearGradient>
      <linearGradient
        id='paint24_linear'
        x1='455.098'
        y1='460.177'
        x2='257.033'
        y2='1455.91'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint25_linear'
        x1='779.148'
        y1='1099.01'
        x2='613.371'
        y2='669.539'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint26_linear'
        x1='413.452'
        y1='399.207'
        x2='-411.952'
        y2='2323.08'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint27_linear'
        x1='239.065'
        y1='982'
        x2='669.74'
        y2='706.904'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint28_linear'
        x1='492.735'
        y1='621.783'
        x2='-165.851'
        y2='1553.45'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint29_linear'
        x1='455.741'
        y1='468.768'
        x2='446.95'
        y2='585.747'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint30_linear'
        x1='377.081'
        y1='393.821'
        x2='371.782'
        y2='548.419'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint31_linear'
        x1='440.482'
        y1='414.566'
        x2='433.864'
        y2='567.437'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint32_linear'
        x1='529.259'
        y1='404.147'
        x2='503.861'
        y2='594.032'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint33_linear'
        x1='596.728'
        y1='389.442'
        x2='570.402'
        y2='596.526'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint34_linear'
        x1='661.06'
        y1='395.758'
        x2='640.32'
        y2='579.412'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint35_linear'
        x1='708.166'
        y1='374.621'
        x2='700.048'
        y2='551.218'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint36_linear'
        x1='402.081'
        y1='318.259'
        x2='251.51'
        y2='558.336'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint37_linear'
        x1='637.85'
        y1='371.698'
        x2='312.769'
        y2='357.98'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint38_linear'
        x1='384.508'
        y1='534.341'
        x2='460.273'
        y2='582.607'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
    </defs>
  </svg>
  /* eslint-enable max-len */
);
