/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const CPPIcon: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len */
  <svg
    {...props}
    width='20'
    height='22'
    viewBox='0 0 20 22'
    fill='none'
    xmlns='http://www.w3.org/2000/svg'
  >
    <g clipPath='url(#clip0)'>
      <path
        d={`M19.7456 16.4999C19.9025 16.2342 20 15.9348 20 15.666V6.33387C20 6.06503 19.9026 5.76571
          19.7456 5.5L10 11L19.7456 16.4999Z`}
        fill='#00599C'
      />
      <path
        d={`M10.866 21.7983L19.1339 17.1323C19.3721 16.9979 19.5886 16.7658 19.7455 16.5L9.99995
          11L0.254395 16.5C0.411323 16.7658 0.627859 16.9979 0.865963 17.1323L9.13394 21.7983C9.61021
          22.0672 10.3897 22.0672 10.866 21.7983Z`}
        fill='#004482'
      />
      <path
        d={`M19.7456 5.49997C19.5886 5.23419 19.3721 5.00209 19.134 4.86766L10.866 0.201632C10.3897
          -0.0672107 9.61026 -0.0672107 9.13399 0.201632L0.866013 4.86766C0.389673 5.13644 0 5.79628 0
          6.3339V15.666C0 15.9349 0.097451 16.2343 0.254444 16.5L10 11L19.7456 5.49997Z`}
        fill='#659AD2'
      />
      <path
        d={`M10.0002 17.5165C6.32415 17.5165 3.3335 14.5932 3.3335 10.9999C3.3335 7.40662 6.32415 4.48328
          10.0002 4.48328C12.3722 4.48328 14.5844 5.73102 15.7734 7.73954L12.8883 9.37151C12.2932 8.36616
          11.1864 7.74159 10.0002 7.74159C8.16212 7.74159 6.66683 9.20322 6.66683 10.9999C6.66683 12.7965
          8.16212 14.2582 10.0002 14.2582C11.1866 14.2582 12.2933 13.6336 12.8885 12.6281L15.7736
          14.26C14.5846 16.2687 12.3723 17.5165 10.0002 17.5165Z`}
        fill='white'
      />
      <path
        d='M16.6666 10.6379H15.9258V9.91382H15.1851V10.6379H14.4443V11.3619H15.1851V12.086H15.9258V11.3619H16.6666V10.6379Z'
        fill='white'
      />
      <path
        d='M19.4444 10.6379H18.7036V9.91382H17.963V10.6379H17.2222V11.3619H17.963V12.086H18.7036V11.3619H19.4444V10.6379Z'
        fill='white'
      />
    </g>
    <defs>
      <clipPath id='clip0'>
        <rect width='20' height='22' fill='white' />
      </clipPath>
    </defs>
  </svg>
  /* eslint-enable max-len */
);
