/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const GolangIcon: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len */
  <svg
    {...props}
    width='17'
    height='23'
    viewBox='0 0 17 23'
    fill='none'
    xmlns='http://www.w3.org/2000/svg'
  >
    <path
      d='M16.605 12.2315C16.5731 12.8999 15.897 12.5851 15.6031 12.38C15.3093 12.1749 15.2491 12.3482 15.2066 11.9556C15.1805 11.6994 15.1699 11.4419 15.1748 11.1845C15.6209 11.1389 16.0687 11.253 16.4386 11.5064C16.6227 11.6408 16.9661 12.0652 16.6085 12.2138'
      fill='#F6D2A2'
    />
    <path
      d='M16.2582 12.7161C16.3243 12.717 16.3898 12.7024 16.4493 12.6736C16.5174 12.6344 16.5737 12.5775 16.6124 12.5091C16.651 12.4406 16.6705 12.3631 16.6688 12.2845C16.7126 12.2627 16.7502 12.2302 16.778 12.19C16.8059 12.1499 16.8231 12.1033 16.8281 12.0546C16.8154 11.9369 16.7772 11.8234 16.716 11.722C16.6549 11.6206 16.5723 11.5337 16.4741 11.4675C16.0922 11.2048 15.629 11.0869 15.1678 11.135H15.1147V11.1881C15.1073 11.3899 15.1132 11.5919 15.1324 11.7929V11.9698C15.1501 12.2456 15.2032 12.2881 15.3448 12.3235C15.4204 12.3468 15.492 12.3814 15.5572 12.426C15.7609 12.5832 16.0029 12.6833 16.2582 12.7161V12.7161ZM15.359 11.2553C15.7308 11.2495 16.0949 11.3609 16.3998 11.5736C16.479 11.6283 16.5462 11.6985 16.5973 11.78C16.6485 11.8615 16.6824 11.9525 16.6971 12.0476C16.6928 12.0806 16.6792 12.1118 16.6579 12.1374C16.6366 12.1631 16.6085 12.1822 16.5768 12.1926H16.5414V12.2315C16.5465 12.2929 16.5355 12.3546 16.5094 12.4104C16.4833 12.4662 16.4431 12.5143 16.3927 12.5498C16.2586 12.5706 16.1216 12.5617 15.9913 12.5238C15.861 12.486 15.7406 12.42 15.6386 12.3305C15.5648 12.2788 15.4837 12.2383 15.3979 12.2103C15.3059 12.1784 15.2846 12.1714 15.2705 11.9521V11.7752C15.2539 11.5989 15.2468 11.4218 15.2492 11.2447H15.359V11.2553Z'
      fill='#010101'
    />
    <path
      d='M16.605 12.2314C16.5038 12.2091 16.4114 12.1574 16.3395 12.0829Z'
      fill='#C7B199'
    />
    <path
      d='M16.605 12.295C16.6215 12.3002 16.6393 12.2986 16.6546 12.2907C16.6698 12.2827 16.6813 12.269 16.6865 12.2526C16.6916 12.2362 16.6901 12.2184 16.6821 12.2031C16.6741 12.1879 16.6604 12.1764 16.644 12.1712H16.6015C16.5267 12.1539 16.4588 12.1145 16.4068 12.0581C16.4017 12.0513 16.3953 12.0457 16.388 12.0414C16.3807 12.0371 16.3726 12.0343 16.3642 12.0332C16.3558 12.032 16.3473 12.0326 16.3391 12.0347C16.3309 12.0368 16.3233 12.0406 16.3165 12.0457C16.3098 12.0508 16.3041 12.0572 16.2998 12.0645C16.2956 12.0718 16.2928 12.0798 16.2916 12.0882C16.2905 12.0966 16.291 12.1051 16.2931 12.1133C16.2953 12.1215 16.299 12.1291 16.3041 12.1359C16.3711 12.2127 16.4601 12.2671 16.559 12.2915H16.605V12.295Z'
      fill='#010101'
    />
    <path
      d='M15.0614 4.27682C17.6209 3.56942 15.7163 0.304797 13.6453 1.64177L15.0614 4.27682Z'
      fill='#74CDDD'
    />
    <path
      d='M15.0299 4.35103H15.0795C15.8088 4.14588 16.2584 3.71437 16.3433 3.13784C16.3734 2.82439 16.3155 2.50875 16.1761 2.22636C16.0366 1.94396 15.8212 1.70598 15.5539 1.53913C15.2635 1.35558 14.9246 1.26351 14.5811 1.27486C14.2377 1.28622 13.9056 1.40047 13.628 1.60279L13.5785 1.63463L15.0299 4.35103ZM14.6759 1.38704C14.9664 1.38741 15.2506 1.47221 15.4937 1.63109C15.7411 1.78447 15.9407 2.00378 16.0702 2.26434C16.1997 2.52491 16.2538 2.81639 16.2265 3.10601C16.1486 3.61887 15.7521 4.00794 15.1043 4.20247L13.759 1.66646C14.0311 1.49642 14.3444 1.40351 14.6653 1.39765L14.6759 1.38704Z'
      fill='#010101'
    />
    <path
      d='M3.69043 1.39772C1.66547 -0.0170701 -0.164776 3.16621 2.18941 3.99032L3.69043 1.39772Z'
      fill='#74CDDD'
    />
    <path
      d='M2.21823 4.06809L3.77588 1.37999L3.72986 1.34816C3.47064 1.14056 3.15538 1.01488 2.82433 0.987157C2.49328 0.959436 2.16147 1.03094 1.87129 1.19253C1.59748 1.35274 1.37347 1.58563 1.22411 1.86535C1.07476 2.14506 1.00591 2.46065 1.0252 2.77709C1.0606 3.13079 1.25177 3.73561 2.16866 4.0504L2.21823 4.06809ZM3.60595 1.41536L2.16158 3.91246C1.89942 3.84143 1.66397 3.6949 1.48456 3.49112C1.30515 3.28734 1.18972 3.03533 1.15265 2.76648C1.13412 2.47341 1.19746 2.18097 1.33561 1.92177C1.47376 1.66258 1.68128 1.44685 1.93501 1.29864C2.19375 1.15044 2.49073 1.08241 2.78824 1.10319C3.08576 1.12398 3.37037 1.23263 3.60595 1.41536V1.41536Z'
      fill='#010101'
    />
    <path
      d='M3.2551 20.4514C2.74178 20.7697 1.80011 21.7318 2.57186 22.1987C3.31174 22.8778 3.72948 21.4524 4.38086 21.2578C4.25574 21.0559 4.09185 20.8806 3.89864 20.7422C3.70543 20.6038 3.48672 20.505 3.2551 20.4514Z'
      fill='#F6D2A2'
    />
    <path
      d='M2.96469 22.4427H2.99301C3.28684 22.425 3.52757 22.1385 3.76122 21.8661C3.92266 21.6315 4.1422 21.4426 4.39844 21.3179L4.4834 21.2931L4.4303 21.2047C4.16696 20.7851 3.74835 20.4863 3.2656 20.3735H3.21958C2.89035 20.5787 2.21065 21.1729 2.21419 21.7105C2.21623 21.8167 2.2469 21.9204 2.30297 22.0107C2.35904 22.1009 2.43844 22.1744 2.5328 22.2234C2.64249 22.3501 2.79755 22.4288 2.96469 22.4427ZM4.28161 21.2259C4.04146 21.3671 3.83298 21.5561 3.66917 21.7812C3.51439 22.0353 3.27303 22.2249 2.98947 22.3153C2.92238 22.3125 2.85652 22.2963 2.79575 22.2677C2.73497 22.2392 2.68048 22.1989 2.63546 22.1491C2.55826 22.1114 2.49296 22.0531 2.44674 21.9807C2.40052 21.9084 2.37518 21.8246 2.37349 21.7388C2.37349 21.3073 2.91867 20.7661 3.29746 20.5221C3.70101 20.6258 4.05094 20.8769 4.27807 21.2259H4.28161Z'
      fill='#010101'
    />
    <path
      d='M2.57195 22.2659C2.58374 22.2658 2.59528 22.2625 2.60528 22.2562C2.61528 22.25 2.62335 22.2411 2.62859 22.2305C2.66604 22.1522 2.69913 22.0719 2.72772 21.99C2.77079 21.8299 2.85081 21.6821 2.96136 21.5585C2.96741 21.5527 2.97225 21.5458 2.97561 21.5381C2.97897 21.5304 2.98078 21.5221 2.98094 21.5138C2.98111 21.5054 2.97962 21.4971 2.97656 21.4893C2.97351 21.4815 2.96894 21.4743 2.96313 21.4683C2.95732 21.4623 2.95038 21.4574 2.9427 21.4541C2.93501 21.4507 2.92675 21.4489 2.91836 21.4487C2.90998 21.4486 2.90165 21.4501 2.89384 21.4531C2.88603 21.4562 2.8789 21.4607 2.87286 21.4665C2.75062 21.5999 2.66096 21.7597 2.61089 21.9334C2.58315 22.0105 2.55124 22.0861 2.51531 22.1598C2.5079 22.1748 2.50672 22.1922 2.51203 22.208C2.51733 22.2239 2.52868 22.2371 2.54363 22.2447L2.57195 22.2659Z'
      fill='#010101'
    />
    <path
      d='M12.449 21.5372C13.0543 21.6292 13.3942 22.1738 13.8969 22.4497C13.9496 22.4984 14.0135 22.5334 14.0829 22.5516C14.1523 22.5699 14.2252 22.5708 14.2951 22.5544C14.3649 22.538 14.4297 22.5047 14.4837 22.4575C14.5378 22.4103 14.5794 22.3505 14.6049 22.2835C14.64 22.2843 14.6749 22.2771 14.7068 22.2624C14.7387 22.2477 14.7668 22.2259 14.789 22.1986C15.228 21.4912 14.3323 20.9996 13.8615 20.653C13.1995 20.5256 12.7924 21.088 12.449 21.5372V21.5372Z'
      fill='#F6D2A2'
    />
    <path
      d='M14.2154 22.6196C14.253 22.6245 14.2911 22.6245 14.3287 22.6196C14.3952 22.5981 14.4566 22.5635 14.5095 22.518C14.5624 22.4724 14.6057 22.4168 14.6367 22.3543C14.6709 22.354 14.7045 22.3455 14.7347 22.3295C14.7649 22.3135 14.7908 22.2905 14.8102 22.2623C15.235 21.5938 14.5128 21.088 14.0349 20.752L13.8685 20.6318C13.1994 20.4974 12.7746 21.0491 12.4348 21.4948L12.3392 21.6221H12.4454C12.787 21.7037 13.0979 21.8817 13.341 22.135C13.5041 22.2847 13.682 22.4175 13.872 22.5311C13.9771 22.5892 14.0953 22.6197 14.2154 22.6196V22.6196ZM14.6403 22.2093C14.6158 22.2039 14.5904 22.2039 14.5659 22.2093H14.5482L14.5199 22.2659C14.4969 22.3159 14.464 22.3608 14.4233 22.3978C14.3825 22.4349 14.3347 22.4634 14.2827 22.4816C14.1581 22.5003 14.0312 22.4699 13.9287 22.3967C13.7451 22.2871 13.5731 22.1591 13.4154 22.0147C13.1764 21.7761 12.8839 21.5978 12.5622 21.4948C12.8879 21.0704 13.2702 20.6105 13.826 20.7167L13.9853 20.8298C14.4739 21.1835 15.0792 21.6009 14.7288 22.1633C14.7209 22.1766 14.7101 22.188 14.6973 22.1965C14.6844 22.2051 14.6697 22.2107 14.6544 22.2128L14.6403 22.2093Z'
      fill='#010101'
    />
    <path
      d='M14.5944 22.3507C14.6049 22.3513 14.6154 22.3493 14.6249 22.3449C14.6345 22.3405 14.6428 22.3338 14.6491 22.3254C14.6554 22.3169 14.6595 22.3071 14.6611 22.2967C14.6627 22.2863 14.6617 22.2757 14.6581 22.2658C14.632 22.0959 14.5612 21.936 14.4528 21.8025C14.4016 21.7323 14.3565 21.6577 14.3183 21.5797C14.3112 21.5642 14.2983 21.5521 14.2824 21.5462C14.2665 21.5402 14.2488 21.5408 14.2333 21.5478C14.2178 21.5549 14.2058 21.5678 14.1998 21.5837C14.1938 21.5996 14.1944 21.6172 14.2015 21.6327C14.2426 21.7182 14.2911 21.7998 14.3466 21.8768C14.4401 21.9969 14.4999 22.1397 14.5201 22.2906C14.5204 22.2996 14.5227 22.3085 14.5268 22.3165C14.5309 22.3246 14.5366 22.3317 14.5436 22.3374C14.5507 22.3431 14.5588 22.3472 14.5676 22.3495C14.5763 22.3518 14.5855 22.3522 14.5944 22.3507V22.3507ZM14.9555 3.37838C15.3095 3.20153 15.5396 2.95748 15.3343 2.56841C15.129 2.17934 14.7891 2.24654 14.4493 2.42339L14.9555 3.37838ZM2.72438 3.03883C2.37037 2.86198 2.14026 2.61793 2.34559 2.22886C2.55091 1.83979 2.89076 1.90699 3.23062 2.08384L2.72438 3.03883Z'
      fill='#010101'
    />
    <path
      d='M0.398233 12.1466C0.430094 12.8151 1.10626 12.5003 1.40008 12.2952C1.69391 12.09 1.7541 12.2633 1.79658 11.8707C1.82268 11.6146 1.83332 11.3571 1.82844 11.0997C1.38231 11.0541 0.934466 11.1681 0.564618 11.4215C0.380533 11.5559 0.0371419 11.9804 0.394693 12.1289'
      fill='#F6D2A2'
    />
    <path
      d='M0.745424 12.6169C0.988731 12.5905 1.22136 12.5029 1.42159 12.3623C1.48685 12.3177 1.55845 12.2831 1.63399 12.2597C1.7756 12.2102 1.8287 12.1678 1.8464 11.906V11.7292C1.86559 11.5282 1.8715 11.3261 1.8641 11.1243V11.0395H1.811C1.34983 10.9913 0.886617 11.1092 0.504695 11.3719C0.40648 11.4382 0.323917 11.525 0.262773 11.6264C0.201628 11.7278 0.163375 11.8414 0.150682 11.9591C0.155691 12.0077 0.172922 12.0543 0.200773 12.0945C0.228625 12.1347 0.266192 12.1672 0.309987 12.189C0.30834 12.2675 0.327841 12.3451 0.366452 12.4135C0.405063 12.482 0.461366 12.5388 0.529476 12.578C0.596856 12.6095 0.671281 12.6229 0.745424 12.6169V12.6169ZM1.7756 11.1597C1.77799 11.3368 1.7709 11.5139 1.75436 11.6903V11.8671C1.75436 12.0829 1.7225 12.0899 1.62691 12.1253C1.54117 12.1533 1.46004 12.1938 1.38619 12.2456C1.28434 12.3352 1.16397 12.4013 1.03364 12.4392C0.903316 12.4771 0.766232 12.4859 0.632138 12.4649C0.58175 12.4293 0.541525 12.3813 0.515446 12.3254C0.489367 12.2696 0.478339 12.2079 0.483454 12.1465V12.1041H0.448053C0.416351 12.0937 0.38823 12.0746 0.366934 12.0489C0.345638 12.0233 0.332034 11.9921 0.327689 11.9591C0.342403 11.864 0.376363 11.773 0.427492 11.6915C0.478622 11.61 0.545847 11.5398 0.625059 11.4851C0.960445 11.2492 1.36623 11.1345 1.7756 11.1597V11.1597Z'
      fill='#010101'
    />
    <path
      d='M0.398552 12.1466C0.498528 12.1272 0.590744 12.0793 0.664062 12.0087Z'
      fill='#C7B199'
    />
    <path
      d='M0.398398 12.2102H0.46566C0.56479 12.1787 0.651486 12.1168 0.713464 12.0333C0.718578 12.0266 0.722313 12.0189 0.724458 12.0107C0.726603 12.0026 0.727114 11.9941 0.725964 11.9857C0.724813 11.9773 0.722024 11.9692 0.717753 11.9619C0.713483 11.9546 0.707815 11.9483 0.701074 11.9431C0.694333 11.938 0.68665 11.9343 0.678465 11.9322C0.670281 11.93 0.661754 11.9295 0.653372 11.9307C0.644989 11.9318 0.636915 11.9346 0.629611 11.9389C0.622307 11.9431 0.615916 11.9488 0.610802 11.9555C0.55875 12.0119 0.490904 12.0514 0.416099 12.0687H0.373617C0.354839 12.072 0.338137 12.0826 0.327183 12.0982C0.316229 12.1138 0.311921 12.1331 0.315207 12.1518C0.318493 12.1706 0.329103 12.1873 0.344705 12.1982C0.360306 12.2092 0.37962 12.2135 0.398398 12.2102V12.2102Z'
      fill='#010101'
    />
    <path
      d='M8.75665 0.0466309C6.1936 0.0466309 3.80048 0.400328 2.54019 2.87621C1.41798 5.63152 1.83217 8.60611 1.64454 11.517C1.49586 14.0177 1.17017 16.9074 2.33133 19.2276C3.54559 21.6611 6.61133 22.2659 9.12482 22.1846C11.1002 22.1138 13.4862 21.4772 14.6014 19.6662C15.9112 17.5441 15.2917 14.4032 15.1961 12.0511C15.0828 9.26399 15.9537 6.46624 15.0368 3.7357C14.0845 0.906116 11.5215 0.265923 8.76019 0.0466309'
      fill='#74CDDD'
    />
    <path
      d='M8.68929 22.2659H9.12826C10.1835 22.2362 11.2261 22.0282 12.2117 21.6504C13.2152 21.287 14.0736 20.6081 14.6579 19.7157C15.72 18.0038 15.5288 15.6411 15.366 13.5543C15.3235 13.0308 15.2845 12.5321 15.2668 12.0652C15.2481 11.0756 15.2906 10.0857 15.3943 9.10124C15.543 7.33276 15.6987 5.50414 15.104 3.73212C14.9121 3.10956 14.5927 2.53368 14.1661 2.04107C13.7395 1.54847 13.215 1.1499 12.6259 0.870705C11.6701 0.403824 10.5018 0.135014 8.78487 0.000609396C6.25722 -0.0170755 3.76498 0.336622 2.48345 2.84434C1.66215 4.86041 1.65153 7.02504 1.63736 9.11893C1.63736 9.90414 1.63736 10.7141 1.58072 11.5064C1.58072 11.7469 1.5524 11.991 1.5347 12.235C1.38602 14.5305 1.21609 17.1372 2.27459 19.2453C3.59859 21.8839 6.92631 22.2659 8.68929 22.2659ZM8.75655 0.110256C11.4223 0.336622 14.0207 0.909612 14.9765 3.75688C15.5642 5.50414 15.4084 7.31861 15.2633 9.06234C15.1593 10.0515 15.1167 11.0461 15.1358 12.0405C15.1535 12.5109 15.196 13.0096 15.235 13.5366C15.3978 15.6022 15.589 17.9472 14.5517 19.6202C14.1163 20.3276 12.7144 21.9794 9.12472 22.0961C7.57061 22.1527 3.81454 21.9758 2.39849 19.1675C1.3577 17.0877 1.52408 14.5022 1.67277 12.2209C1.67277 11.9733 1.70463 11.7292 1.71879 11.4922C1.75773 10.7212 1.77543 9.90767 1.77543 9.12247C1.77543 7.04273 1.79667 4.8781 2.6109 2.89739C3.13464 1.82068 4.06182 0.993437 5.19165 0.594821C6.34357 0.231237 7.54928 0.0673484 8.75655 0.110256V0.110256Z'
      fill='#010101'
    />
    <path
      d='M8.30706 3.48099C7.84685 6.15141 3.47834 5.44755 4.10494 2.75237C4.66782 0.336619 8.45929 1.00511 8.30706 3.48099Z'
      fill='white'
    />
    <path
      d='M6.22878 5.22467C6.50089 5.22581 6.7713 5.18158 7.02884 5.0938C7.37925 4.97798 7.69026 4.76656 7.92673 4.48343C8.1632 4.2003 8.3157 3.85673 8.36701 3.49156C8.3908 3.2057 8.3539 2.91805 8.25873 2.64743C8.16356 2.3768 8.01227 2.12931 7.81475 1.92114C7.4359 1.5328 6.93696 1.28356 6.3987 1.21375C5.90539 1.13574 5.4001 1.22278 4.96141 1.46133C4.7274 1.59789 4.5248 1.78217 4.36682 2.00217C4.20884 2.22217 4.09902 2.47295 4.04452 2.73818C3.94924 3.07353 3.9498 3.42883 4.04615 3.76387C4.1425 4.09891 4.33078 4.40032 4.5897 4.634C5.04648 5.02264 5.62886 5.23251 6.22878 5.22467V5.22467ZM8.24311 3.47387C8.19465 3.81655 8.0513 4.13888 7.82924 4.40449C7.60717 4.6701 7.31524 4.86842 6.98636 4.97708C6.59455 5.10799 6.17571 5.13641 5.76978 5.05963C5.36385 4.98286 4.98438 4.80344 4.66758 4.5385C4.42896 4.31847 4.25552 4.0371 4.16623 3.72519C4.07694 3.41327 4.07525 3.08283 4.16134 2.77001C4.27 2.28898 4.56264 1.86949 4.97674 1.60116C5.39084 1.33283 5.89355 1.23695 6.37746 1.334C6.90553 1.37917 7.39536 1.62764 7.74348 2.02693C8.0916 2.42621 8.27076 2.94506 8.24311 3.47387V3.47387Z'
      fill='#010101'
    />
    <path
      d='M13.5286 3.9161C12.9339 6.23989 9.20966 5.64214 9.34773 3.31128C9.51411 0.517065 14.0986 1.04407 13.5286 3.9161Z'
      fill='white'
    />
    <path
      d='M11.5393 5.44755C11.918 5.45039 12.2915 5.35923 12.6262 5.18227C12.8658 5.05255 13.0751 4.87358 13.2405 4.65715C13.4059 4.44073 13.5235 4.19176 13.5855 3.92665C13.6779 3.56485 13.6642 3.18417 13.5462 2.82989C13.4282 2.47562 13.2109 2.16266 12.92 1.92826C12.5683 1.66013 12.152 1.48951 11.7131 1.43361C11.2743 1.37772 10.8285 1.43854 10.4207 1.60993C10.089 1.75483 9.80586 1.99185 9.60504 2.29281C9.40422 2.59377 9.29412 2.94602 9.28783 3.30768C9.21349 4.54562 10.1976 5.26716 11.1393 5.42986C11.272 5.44607 11.4057 5.45198 11.5393 5.44755V5.44755ZM13.4581 3.90189C13.3356 4.39355 13.0245 4.8174 12.5921 5.08206C12.1597 5.34672 11.6404 5.43098 11.1464 5.31668C10.2543 5.1752 9.32323 4.4961 9.39403 3.33244C9.39831 2.99211 9.50079 2.66024 9.68917 2.37666C9.87755 2.09308 10.1438 1.86984 10.4561 1.73372C10.8438 1.57113 11.2676 1.51363 11.6847 1.56704C12.1018 1.62045 12.4973 1.78287 12.8315 2.0379C13.1021 2.25725 13.3047 2.54896 13.4157 2.87901C13.5266 3.20905 13.5413 3.56381 13.4581 3.90189V3.90189Z'
      fill='#010101'
    />
    <path
      d='M7.79403 6.70316C7.75996 7.0714 7.75996 7.442 7.79403 7.81024C7.89767 7.94132 8.0444 8.03154 8.20822 8.0649C8.30898 8.04944 8.40424 8.00896 8.48526 7.94716C8.56629 7.88536 8.63049 7.80423 8.67198 7.7112C8.69471 7.29365 8.68406 6.87496 8.64012 6.45911L7.79403 6.70316Z'
      fill='white'
    />
    <path
      d='M8.16861 8.11798H8.18631C8.29884 8.10051 8.40505 8.05463 8.49488 7.98469C8.58471 7.91475 8.65518 7.82306 8.69963 7.7183C8.72903 7.43256 8.72903 7.14455 8.69963 6.85881C8.69963 6.72794 8.67839 6.59 8.67485 6.4556V6.34949L7.71901 6.64306V6.70319C7.71901 6.81637 7.71901 6.93663 7.70131 7.05688C7.66936 7.30936 7.66936 7.56485 7.70131 7.81733V7.83502C7.73842 7.89555 7.7873 7.94802 7.84507 7.98933C7.90283 8.03065 7.96831 8.05996 8.03762 8.07553L8.14737 8.11798H8.16861ZM8.57926 7.67232C8.54385 7.75309 8.48921 7.824 8.42011 7.87886C8.351 7.93373 8.26953 7.97089 8.18277 7.98711L8.08364 7.9482C7.97696 7.92254 7.88435 7.85663 7.82522 7.76428C7.79712 7.52932 7.79712 7.29185 7.82522 7.05688C7.82522 6.94724 7.82521 6.84113 7.84292 6.73502L8.55094 6.51926C8.55094 6.62891 8.55094 6.73855 8.57218 6.84466C8.60354 7.11831 8.6071 7.39442 8.5828 7.66878L8.57926 7.67232Z'
      fill='#010101'
    />
    <path
      d='M12.5022 4.21671C12.1542 4.21671 11.872 3.91109 11.872 3.53408C11.872 3.15707 12.1542 2.85144 12.5022 2.85144C12.8502 2.85144 13.1323 3.15707 13.1323 3.53408C13.1323 3.91109 12.8502 4.21671 12.5022 4.21671Z'
      fill='#010101'
    />
    <path
      d='M12.2156 3.86298C12.1335 3.86298 12.0669 3.78539 12.0669 3.68967C12.0669 3.59395 12.1335 3.51636 12.2156 3.51636C12.2977 3.51636 12.3643 3.59395 12.3643 3.68967C12.3643 3.78539 12.2977 3.86298 12.2156 3.86298Z'
      fill='white'
    />
    <path
      d='M7.22716 4.04691C6.885 4.04691 6.60763 3.74129 6.60763 3.36428C6.60763 2.98727 6.885 2.68164 7.22716 2.68164C7.56931 2.68164 7.84668 2.98727 7.84668 3.36428C7.84668 3.74129 7.56931 4.04691 7.22716 4.04691Z'
      fill='#010101'
    />
    <path
      d='M6.94763 3.69318C6.86747 3.69318 6.80249 3.61559 6.80249 3.51987C6.80249 3.42415 6.86747 3.34656 6.94763 3.34656C7.02779 3.34656 7.09277 3.42415 7.09277 3.51987C7.09277 3.61559 7.02779 3.69318 6.94763 3.69318Z'
      fill='white'
    />
    <path
      d='M9.56361 6.65006C9.83974 7.31501 9.41138 8.64491 8.66442 7.66517C8.68716 7.24763 8.6765 6.82894 8.63256 6.41309L9.56361 6.65006Z'
      fill='white'
    />
    <path
      d='M9.17788 8.07904C9.24262 8.07966 9.30629 8.06253 9.36197 8.02952C9.66288 7.85621 9.8505 7.14528 9.6381 6.61473V6.58644L8.57606 6.31763V6.40251C8.57606 6.54046 8.57606 6.6784 8.60084 6.80927C8.62967 7.08676 8.62967 7.36649 8.60084 7.64399V7.68997C8.65818 7.79676 8.74069 7.88798 8.84123 7.95577C8.94176 8.02356 9.05731 8.06587 9.17788 8.07904V8.07904ZM9.52835 6.70316C9.68058 7.11698 9.56021 7.76425 9.29471 7.91634C9.10354 8.02598 8.89113 7.83499 8.74245 7.64399C8.76938 7.3664 8.76938 7.08686 8.74245 6.80927C8.74245 6.70669 8.74245 6.59705 8.72121 6.49094L9.52835 6.70316Z'
      fill='#010101'
    />
    <path
      d='M9.48242 5.36969C9.61009 5.38182 9.73305 5.42405 9.84121 5.4929C9.94937 5.56174 10.0396 5.65525 10.1046 5.76572C10.1696 5.8762 10.2074 6.0005 10.2149 6.12841C10.2224 6.25632 10.1995 6.38419 10.148 6.50152C9.79395 7.13817 9.00804 6.44493 8.51951 6.50152C7.95663 6.50152 7.49287 7.09573 7.03974 6.60763C6.53704 6.06293 7.25568 5.54654 7.81856 5.29541L9.48242 5.36969Z'
      fill='#F6D2A2'
    />
    <path
      d='M7.43952 6.87651C7.61948 6.86154 7.79492 6.81232 7.95638 6.7315C8.13144 6.64513 8.32117 6.59234 8.51572 6.57587C8.71847 6.57579 8.91887 6.61921 9.10338 6.7032C9.49987 6.84114 9.94947 6.99677 10.2044 6.5405C10.2676 6.42692 10.3008 6.29909 10.3008 6.16912C10.3008 6.03914 10.2676 5.91132 10.2044 5.79773C10.1356 5.6648 10.0349 5.55097 9.91139 5.46641C9.78783 5.38185 9.64523 5.3292 9.49633 5.31317L7.79353 5.23889C7.3758 5.41574 6.89788 5.73761 6.81646 6.11253C6.80413 6.20406 6.81073 6.29715 6.83583 6.38603C6.86093 6.47492 6.90401 6.55772 6.9624 6.62932C7.02079 6.70092 7.09326 6.7598 7.17532 6.80232C7.25739 6.84483 7.3473 6.87008 7.43952 6.87651V6.87651ZM8.50156 6.44854C8.29225 6.46551 8.08805 6.52192 7.89974 6.61478C7.58112 6.74918 7.32978 6.85175 7.07489 6.57587C7.01668 6.52244 6.97288 6.45523 6.94751 6.38044C6.92215 6.30564 6.91604 6.22567 6.92974 6.1479C7.00054 5.82249 7.45014 5.52539 7.81831 5.36976L9.46447 5.43696C9.59116 5.45247 9.71217 5.49858 9.81703 5.5713C9.92189 5.64402 10.0074 5.74116 10.0663 5.85433C10.1187 5.94908 10.1461 6.05556 10.1461 6.16381C10.1461 6.27206 10.1187 6.37854 10.0663 6.4733C9.8645 6.827 9.50341 6.71027 9.11754 6.57941C8.92378 6.49276 8.71384 6.44815 8.50156 6.44854V6.44854Z'
      fill='#231F20'
    />
    <path
      d='M9.56379 5.34497C9.60273 4.46073 7.91056 4.34755 7.71231 5.09031C7.51406 5.83308 9.48237 6.00285 9.56379 5.34497Z'
      fill='#010101'
    />
  </svg>
  /* eslint-enable max-len */
);
