/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const RustIcon: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len */
  <svg
    {...props}
    width='22'
    height='22'
    viewBox='0 0 22 22'
    fill='none'
    xmlns='http://www.w3.org/2000/svg'
  >
    <path
      d='M21.713 10.7334L20.801 10.1689C20.7934 10.08 20.7846 9.9914 20.7751 9.90319L21.5588 9.17221C21.6385 9.09791 21.6742 8.98791 21.6526 8.88144C21.6316 8.77455 21.5567 8.68655 21.4548 8.64857L20.453 8.27395C20.4279 8.18719 20.4015 8.10106 20.3745 8.01534L20.9994 7.14738C21.0632 7.05917 21.0762 6.9444 21.0347 6.84374C20.9932 6.74349 20.9025 6.67168 20.7952 6.65404L19.7388 6.48219C19.6977 6.40208 19.655 6.32321 19.6118 6.24497L20.0557 5.27053C20.1012 5.17132 20.0918 5.05593 20.0312 4.96585C19.9708 4.87536 19.8685 4.82244 19.7594 4.82659L18.6872 4.86395C18.6317 4.79463 18.5753 4.72593 18.5178 4.65847L18.7642 3.6141C18.7891 3.50804 18.7577 3.397 18.6805 3.32C18.6039 3.24321 18.4927 3.21146 18.3866 3.23636L17.3425 3.48251C17.2748 3.42523 17.2061 3.36857 17.1366 3.31315L17.1741 2.24097C17.1783 2.13242 17.1254 2.02927 17.0349 1.96908C16.9442 1.90848 16.8294 1.89934 16.7304 1.94438L15.7562 2.38853C15.6775 2.34536 15.5987 2.30261 15.519 2.26131L15.3467 1.20468C15.3293 1.09759 15.2574 1.00668 15.157 0.965173C15.0567 0.923456 14.9418 0.936947 14.8536 1.00046L13.985 1.62538C13.8995 1.59819 13.8135 1.57204 13.7268 1.54714L13.3522 0.545098C13.3142 0.442985 13.2262 0.36806 13.1193 0.34689C13.0126 0.325928 12.9028 0.361419 12.8287 0.440702L12.0977 1.22502C12.0095 1.21527 11.9207 1.20634 11.8321 1.19908L11.2676 0.286909C11.2105 0.194551 11.1094 0.138306 11.0007 0.138306C10.8919 0.138306 10.7908 0.194551 10.734 0.286909L10.1694 1.19908C10.0806 1.20634 9.99177 1.21527 9.90356 1.22502L9.17237 0.440702C9.09828 0.361419 8.98828 0.325928 8.8818 0.34689C8.77492 0.368268 8.68692 0.442985 8.64894 0.545098L8.27431 1.54714C8.18756 1.57204 8.10163 1.5984 8.01592 1.62538L7.14754 1.00046C7.05933 0.936739 6.94435 0.923249 6.8439 0.965173C6.74365 1.00668 6.67163 1.09759 6.6542 1.20468L6.48194 2.26131C6.40224 2.30261 6.32337 2.34515 6.24471 2.38853L5.27048 1.94438C5.17148 1.89914 5.05609 1.90848 4.96601 1.96908C4.87552 2.02927 4.8226 2.13242 4.82675 2.24097L4.86411 3.31315C4.79479 3.36857 4.72609 3.42523 4.65822 3.48251L3.61405 3.23636C3.50799 3.21166 3.39675 3.24321 3.31995 3.32C3.24275 3.397 3.21141 3.50804 3.23631 3.6141L3.48226 4.65847C3.42518 4.72614 3.36873 4.79463 3.31331 4.86395L2.24112 4.82659C2.13299 4.82348 2.02963 4.87536 1.96924 4.96585C1.90863 5.05593 1.8995 5.17132 1.94454 5.27053L2.38869 6.24497C2.34552 6.32321 2.30277 6.40208 2.26146 6.48219L1.20505 6.65404C1.09775 6.67148 1.00726 6.74329 0.96554 6.84374C0.92403 6.9444 0.937521 7.05917 1.00082 7.14738L1.62575 8.01534C1.59856 8.10106 1.5722 8.18719 1.54729 8.27395L0.545257 8.64857C0.443559 8.68655 0.368634 8.77455 0.347464 8.88144C0.326295 8.98812 0.361785 9.09791 0.441276 9.17221L1.22518 9.90319C1.21543 9.9914 1.20671 10.0802 1.19924 10.1689L0.287276 10.7334C0.194917 10.7905 0.138672 10.8913 0.138672 11.0003C0.138672 11.1092 0.194917 11.2101 0.287276 11.267L1.19924 11.8315C1.20671 11.9203 1.21543 12.009 1.22518 12.0972L0.441276 12.8284C0.361785 12.9025 0.326295 13.0125 0.347464 13.1189C0.368634 13.2258 0.443559 13.3136 0.545257 13.3518L1.54729 13.7264C1.5722 13.8132 1.59856 13.8993 1.62575 13.985L1.00082 14.8532C0.937313 14.9416 0.923823 15.0564 0.96554 15.1566C1.00726 15.2573 1.09795 15.3291 1.20526 15.3463L2.26146 15.5182C2.30277 15.5983 2.34511 15.6772 2.38869 15.7558L1.94454 16.7298C1.89929 16.8288 1.90863 16.944 1.96924 17.0345C2.02984 17.1252 2.13299 17.1781 2.24112 17.1738L3.3129 17.1362C3.36873 17.2059 3.42497 17.2742 3.48226 17.3421L3.23631 18.3867C3.21141 18.4925 3.24275 18.6032 3.31995 18.6802C3.39654 18.7576 3.50799 18.7885 3.61405 18.7636L4.65822 18.5176C4.72609 18.5753 4.79479 18.6314 4.86411 18.6866L4.82675 19.759C4.8226 19.8675 4.87552 19.9705 4.96601 20.0311C5.05609 20.0915 5.17148 20.1006 5.27048 20.0554L6.24471 19.6114C6.32316 19.655 6.40203 19.6973 6.48194 19.7386L6.6542 20.7946C6.67163 20.9022 6.74345 20.9931 6.8439 21.0344C6.94414 21.0761 7.05933 21.0626 7.14754 20.9993L8.0155 20.3739C8.10122 20.4011 8.18735 20.4277 8.27411 20.4526L8.64873 21.4542C8.68671 21.5559 8.77471 21.6313 8.8816 21.652C8.98828 21.6736 9.09807 21.6379 9.17216 21.5582L9.90335 20.7743C9.99156 20.7845 10.0804 20.793 10.1692 20.8009L10.7337 21.7128C10.7906 21.8048 10.8917 21.8614 11.0004 21.8614C11.1092 21.8614 11.2103 21.805 11.2674 21.7128L11.8319 20.8009C11.9207 20.793 12.0093 20.7845 12.0975 20.7743L12.8285 21.5582C12.9026 21.6379 13.0126 21.6736 13.1191 21.652C13.226 21.6311 13.314 21.5559 13.352 21.4542L13.7266 20.4526C13.8133 20.4277 13.8995 20.4011 13.9852 20.3739L14.8534 20.9993C14.9416 21.0626 15.0565 21.0761 15.1568 21.0344C15.2572 20.9931 15.3291 20.9019 15.3465 20.7946L15.5187 19.7386C15.5984 19.6973 15.6773 19.6544 15.756 19.6114L16.7302 20.0554C16.8292 20.1006 16.9444 20.0915 17.0347 20.0311C17.1252 19.9705 17.1779 19.8677 17.1739 19.759L17.1366 18.6866C17.2059 18.6312 17.2746 18.5753 17.3423 18.5176L18.3864 18.7636C18.4925 18.7885 18.6037 18.7576 18.6803 18.6802C18.7575 18.6032 18.7889 18.4925 18.764 18.3867L18.518 17.3421C18.5753 17.2742 18.6317 17.2059 18.687 17.1362L19.7591 17.1738C19.8673 17.1781 19.9706 17.1252 20.031 17.0345C20.0916 16.944 20.101 16.8288 20.0555 16.7298L19.6116 15.7558C19.655 15.6772 19.6975 15.5983 19.7386 15.5182L20.795 15.3463C20.9025 15.3291 20.993 15.2573 21.0345 15.1566C21.076 15.0564 21.063 14.9416 20.9992 14.8532L20.3743 13.985C20.4013 13.8993 20.4277 13.8132 20.4528 13.7264L21.4546 13.3518C21.5565 13.3136 21.6316 13.2258 21.6524 13.1189C21.674 13.0122 21.6383 12.9025 21.5586 12.8284L20.7749 12.0972C20.7844 12.009 20.7931 11.9201 20.8008 11.8315L21.7128 11.267C21.8051 11.2101 21.8614 11.109 21.8614 11.0003C21.8614 10.8915 21.8054 10.7905 21.713 10.7334ZM15.6092 18.2987C15.261 18.2235 15.0395 17.8803 15.1142 17.531C15.1887 17.1821 15.5318 16.96 15.8799 17.0351C16.2281 17.1096 16.45 17.4535 16.3753 17.8022C16.3006 18.1509 15.9573 18.3732 15.6092 18.2987ZM15.2994 16.2029C14.9816 16.1348 14.669 16.3369 14.601 16.6553L14.2772 18.1663C13.2781 18.6198 12.1685 18.8717 11 18.8717C9.80477 18.8717 8.67114 18.6073 7.65416 18.1345L7.3306 16.6236C7.26252 16.3056 6.94995 16.103 6.63241 16.1713L5.2985 16.4577C5.0509 16.2029 4.82052 15.9314 4.60882 15.6448H11.0992C11.1727 15.6448 11.2217 15.6315 11.2217 15.5647V13.2688C11.2217 13.2019 11.1727 13.1887 11.0992 13.1887H9.20101V11.7333H11.2541C11.4415 11.7333 12.2561 11.7869 12.5166 12.8282C12.5981 13.1484 12.7773 14.1901 12.8997 14.5236C13.0217 14.8976 13.5186 15.6448 14.0481 15.6448H17.2823C17.319 15.6448 17.3582 15.6406 17.3995 15.6332C17.1752 15.938 16.929 16.2265 16.664 16.4961L15.2994 16.2029ZM6.32254 18.2671C5.97428 18.3423 5.63141 18.1202 5.55648 17.7713C5.48197 17.4218 5.70343 17.0787 6.05169 17.0036C6.39995 16.9291 6.74303 17.1512 6.81775 17.5C6.89226 17.8487 6.6706 18.1924 6.32254 18.2671ZM3.86041 8.28308C4.00486 8.60914 3.85792 8.99123 3.53228 9.13547C3.20663 9.28013 2.82558 9.13298 2.68112 8.80672C2.53667 8.48046 2.68362 8.09898 3.00926 7.95432C3.33511 7.80987 3.71595 7.95682 3.86041 8.28308ZM3.10369 10.0769L4.49322 9.45946C4.79001 9.32766 4.92409 8.97981 4.79229 8.6824L4.50609 8.03527H5.63162V13.1085H3.36084C3.16388 12.4162 3.05824 11.6854 3.05824 10.9301C3.05824 10.6419 3.0738 10.3569 3.10369 10.0769ZM9.20143 9.58419V8.08881H11.8817C12.0201 8.08881 12.8592 8.24883 12.8592 8.87625C12.8592 9.39719 12.2156 9.58398 11.6864 9.58398L9.20143 9.58419ZM18.942 10.9301C18.942 11.1286 18.9348 11.3249 18.9202 11.5198H18.1054C18.0238 11.5198 17.991 11.5733 17.991 11.6532V12.0274C17.991 12.9083 17.4944 13.0998 17.0592 13.1486C16.6447 13.1953 16.1852 12.9751 16.1285 12.7215C15.884 11.3463 15.4766 11.0526 14.8332 10.5451C15.6317 10.0381 16.4625 9.2901 16.4625 8.28889C16.4625 7.20778 15.7213 6.52681 15.2161 6.19287C14.5074 5.72568 13.7226 5.63208 13.5109 5.63208H5.0839C6.22665 4.3567 7.77537 3.45325 9.52707 3.12449L10.5204 4.16659C10.745 4.40174 11.1169 4.41046 11.3518 4.18568L12.4632 3.12263C14.7921 3.55619 16.7638 5.00591 17.9001 6.99483L17.1393 8.71332C17.0079 9.01074 17.142 9.35859 17.4386 9.49038L18.9034 10.141C18.9287 10.4011 18.942 10.6639 18.942 10.9301ZM10.5208 2.23806C10.7782 1.99149 11.1864 2.00125 11.4328 2.25902C11.6787 2.51742 11.6694 2.92608 11.4114 3.17244C11.154 3.419 10.7458 3.40946 10.4994 3.15127C10.2537 2.89329 10.263 2.48463 10.5208 2.23806ZM18.0714 8.31442C18.2156 7.98836 18.5967 7.84121 18.9223 7.98587C19.248 8.13032 19.3949 8.51221 19.2504 8.83827C19.1062 9.16453 18.7251 9.31168 18.3993 9.16702C18.0741 9.02257 17.9271 8.64089 18.0714 8.31442Z'
      fill='#9696A5'
    />
  </svg>
  /* eslint-enable max-len */
);
