#include "tremo_rcc.h"
#include "drv.h"
#include "sha224_sha256.h"
#include "ecc.h"

// secp256r1 parameter
U8 g_ecc256_a[32]  = { 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF };
U8 g_ecc256_b[32]  = { 0x4B, 0x60, 0xD2, 0x27, 0x3E, 0x3C, 0xCE, 0x3B, 0xF6, 0xB0, 0x53, 0xCC, 0xB0, 0x06, 0x1D, 0x65,
    0xBC, 0x86, 0x98, 0x76, 0x55, 0xBD, 0xEB, 0xB3, 0xE7, 0x93, 0x3A, 0xAA, 0xD8, 0x35, 0xC6, 0x5A };
U8 g_ecc256_p[32]  = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF };
U8 g_ecc256_n[32]  = { 0x51, 0x25, 0x63, 0xFC, 0xC2, 0xCA, 0xB9, 0xF3, 0x84, 0x9E, 0x17, 0xA7, 0xAD, 0xFA, 0xE6, 0xBC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF };
U8 g_ecc256_Gx[32] = { 0x96, 0xC2, 0x98, 0xD8, 0x45, 0x39, 0xA1, 0xF4, 0xA0, 0x33, 0xEB, 0x2D, 0x81, 0x7D, 0x03, 0x77,
    0xF2, 0x40, 0xA4, 0x63, 0xE5, 0xE6, 0xBC, 0xF8, 0x47, 0x42, 0x2C, 0xE1, 0xF2, 0xD1, 0x17, 0x6B };
U8 g_ecc256_Gy[32] = { 0xF5, 0x51, 0xBF, 0x37, 0x68, 0x40, 0xB6, 0xCB, 0xCE, 0x5E, 0x31, 0x6B, 0x57, 0x33, 0xCE, 0x2B,
    0x16, 0x9E, 0x0F, 0x7C, 0x4A, 0xEB, 0xE7, 0x8E, 0x9B, 0x7F, 0x1A, 0xFE, 0xE2, 0x42, 0xE3, 0x4F };

void print_buf(U8* buf, UINT16 len, char* name)
{
    buf  = buf;
    len  = len;
    name = name;
    // endian = endian;
}

bool ecc_test(void)
{
    ECC_PARA ecc256_para;
    U8 sign_r[32];
    U8 sign_s[32];
    ECC_POINT sign_rs;
    U8 prikey[32];
    U8 pubkey_x[32];
    U8 pubkey_y[32];
    ECC_POINT pubkey;
    U8 message[16] = { 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef };
    U8 sha256_digest[32];
    U8 error_status;

    // clear message digest buffer
    memset(sha256_digest, 0x00, 32);
    // gernerate digest by SHA-256
    error_status = sha256_hash(message, 16, sha256_digest);
    if (error_status != HashSuccess) {
        return false;
    }
    // Initialize the ECC_PARA stucture
    ecc256_para.ECC_p      = g_ecc256_p;
    ecc256_para.ECC_a      = g_ecc256_a;
    ecc256_para.ECC_b      = g_ecc256_b;
    ecc256_para.ECC_n      = g_ecc256_n;
    ecc256_para.ECC_G0x    = g_ecc256_Gx;
    ecc256_para.ECC_G0y    = g_ecc256_Gy;
    ecc256_para.ECC_NUMBIT = 256;
    // Initialize the ECC engine
    error_status = ecc_init(&ecc256_para); // initial ecc para
    if (error_status != ECCSUCCESS) {
        return false;
    }

    // Initialize the ECC_POINT stucture of public key
    pubkey.x = pubkey_x;
    pubkey.y = pubkey_y;
    // gernerate the ECC key para
    error_status = ecc_genkey(prikey, &pubkey);
    if (error_status != ECCSUCCESS) {
        return false;
    }

    // Initialize the ECC_POINT stucture of signature
    sign_rs.x = sign_r;
    sign_rs.y = sign_s;
    // sign the digest by private key
    error_status = ecdsa_sign(prikey, sha256_digest, &sign_rs);
    if (error_status != ECCSUCCESS) {
        return false;
    }
    // verify the signature by public key
    error_status = ecdsa_verify(&pubkey, sha256_digest, &sign_rs);
    if (error_status == ECCSUCCESS) {
        return true;
    } else {
        return false;
    }
}

int main(void)
{
    bool ret;

    rcc_enable_peripheral_clk(RCC_PERIPHERAL_SAC, true);
    rcc_enable_peripheral_clk(RCC_PERIPHERAL_RNGC, true);

    ret = ecc_test();
    if (ret == true) {
        //OK
    } else {
        //ERROR
    }

    /* Infinite loop */
    while (1) { }

    return 0;
}

#ifdef USE_FULL_ASSERT
void assert_failed(void* file, uint32_t line)
{
    (void)file;
    (void)line;

    while (1) { }
}
#endif
