/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#ifdef assert
#   undef assert
#endif
#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 333
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 79
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  SqliteColumnType* yy1;
  ParserCreateTableColumnConstraintList* yy11;
  QVariant* yy13;
  ParserTermOrLiteral* yy14;
  SqliteCreateTable::Constraint* yy15;
  SqliteUpsert* yy16;
  SqliteLimit* yy44;
  SqliteSelect::Core::JoinOp* yy85;
  SqliteCreateTrigger::Event* yy87;
  SqliteWindowDefinition::Window::Frame* yy89;
  SqliteSelect* yy113;
  SqliteCreateTrigger::Scope* yy115;
  SqliteCreateTable::Column* yy123;
  SqliteInitially* yy136;
  SqliteWith* yy137;
  ParserExprList* yy143;
  SqliteQuery* yy147;
  ParserXFullName* yy148;
  SqliteWith::CommonTableExpression* yy158;
  QStringList* yy159;
  SqliteForeignKey::Condition::Reaction* yy160;
  SqliteWindowDefinition::Window::Frame::Bound* yy169;
  ParserSetValueList* yy177;
  SqliteSelect::Core* yy182;
  ParserFkConditionList* yy184;
  SqliteSelect::Core::JoinConstraint* yy191;
  SqliteConflictAlgo* yy194;
  ParserQueryList* yy198;
  SqliteWindowDefinition::Window* yy199;
  SqliteExpr::LikeOp* yy232;
  QString* yy239;
  ParserIndexedColumnList* yy240;
  SqliteSelect::Core::SingleSource* yy257;
  ParserDeferSubClause* yy265;
  SqliteWindowDefinition::Window::Frame::Exclude* yy271;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy282;
  ParserStubTransDetails* yy284;
  ParserExprNestedList* yy294;
  ParserStubCreateTableOption* yy303;
  SqliteNulls* yy331;
  ParserWindowDefList* yy339;
  SqliteFilterOver::Filter* yy341;
  ParserStubInsertOrReplace* yy368;
  ParserResultColumnList* yy373;
  SqliteWith::CommonTableExpression::AsMode* yy407;
  ParserCreateTableColumnList* yy426;
  SqliteSelect::Core::JoinSource* yy455;
  SqliteExpr* yy456;
  ParserStubAlias* yy457;
  ParserOrderByList* yy459;
  SqliteIndexedColumn* yy460;
  SqliteForeignKey::Condition* yy475;
  ParserCreateTableOptionList* yy497;
  SqliteCreateTrigger::Time* yy500;
  ParserIndexedBy* yy504;
  SqliteSortOrder* yy509;
  ParserCteList* yy512;
  bool* yy515;
  SqliteWindowDefinition* yy522;
  SqliteCreateTable::Column::Constraint* yy552;
  SqliteFilterOver* yy567;
  int* yy642;
  ParserStubExplain* yy643;
  ParserCreateTableConstraintList* yy645;
  SqliteSelect::CompoundOperator* yy646;
  ParserFullName* yy648;
  ParserOtherSourceList* yy659;
  SqliteFilterOver::Over* yy663;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 904
#define YYNRULE 508
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (3484)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   896,  385,  851,  539,   30,  832,  687,  274,   72,   73,
 /*    10 */   544,  296,  543,  122,  847,  847,   70,   70,   71,   71,
 /*    20 */    71,   71,  901,   69,   69,   69,   69,   68,   68,   67,
 /*    30 */    67,   67,   66,   64,  276,  844,   72,   73,  544,  296,
 /*    40 */    63,  126,  847,  847,   70,   70,   71,   71,   71,   71,
 /*    50 */   546,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*    60 */    66,   64,  276,  896, 1331,  445,  700,  349,  483,  896,
 /*    70 */   268,  738,  845,  493,   71,   71,   71,   71,   61,   69,
 /*    80 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*    90 */   276,  610,  896,  842,  478,   58,   59,  745,   93,  416,
 /*   100 */   840,  839,  371,   60, 1078,  494,  803,  740,  739,  896,
 /*   110 */   699,    2, 1078,   56,  802,  173,  855, 1078,  896,   84,
 /*   120 */   540,  543,  896,  896,  864,  893,  850,  376,  612, 1153,
 /*   130 */   867,   67,   67,   67,   66,   64,  276,  855,  866,  865,
 /*   140 */   864,  721, 1078,   69,   69,   69,   69,   68,   68,   67,
 /*   150 */    67,   67,   66,   64,  276, 1078,   14, 1078, 1078,  546,
 /*   160 */   818, 1078,  765,  332,  259,  258,  334, 1078, 1078, 1078,
 /*   170 */  1078, 1078, 1078,  855,  862,  585,  855,  835,  843,   12,
 /*   180 */    74,  845,  701,  702,  639,  896,  896,   61,  552,  895,
 /*   190 */  1078,  896,  896,  864,  904,  586,  587,  863,  234,  867,
 /*   200 */   537,  482,  406,  116,   58,   59,  548,  866,  865,  864,
 /*   210 */   346,  369,   60, 1153,  896,  896,  894,  893,  896,  279,
 /*   220 */     2, 1153,  827,  420,  662,  855, 1153,  118,  345,  540,
 /*   230 */   543,  896,  896,  864,  893,  530,  521,  110,  864,  867,
 /*   240 */   896,  896,  894,  893,  867,  825,  855,  866,  865,  864,
 /*   250 */   895, 1153,  866,  865,  864,  758,  408,  824,  766,  812,
 /*   260 */   868,  633,   86,  869, 1153,  651, 1153, 1153,  546,  118,
 /*   270 */   757,  588,  835,  314,  458,  324, 1153, 1153, 1153, 1153,
 /*   280 */   272, 1153,  855,  291,  496,  855,  188,  843,   12,  622,
 /*   290 */   845, 1000,  634,  710,  636,  433,   61,  635,  297, 1153,
 /*   300 */   895,  475,  902,  585,  638,  746,  177,  130,  347,  480,
 /*   310 */   342,  479,  168,   58,   59,  773,  528,  895,   22,  442,
 /*   320 */   174,   60, 1138,  586,  424,  662,  340,  896,  269,    2,
 /*   330 */  1138,  896,  783,  777,  855, 1138,  686,  298,  540,  742,
 /*   340 */   896,  896,  864,  893,   63,  851,  874,   95,  867,   83,
 /*   350 */   895,  522,  800,  783,  807,  855,  866,  865,  864,  783,
 /*   360 */  1138,  617,  633,   86,   68,   68,   67,   67,   67,   66,
 /*   370 */    64,  276,  284, 1138,  673, 1138, 1138,   82,  862,  807,
 /*   380 */    77, 1246, 1246,  277,  717, 1138, 1302, 1138, 1138,    9,
 /*   390 */  1138,  855,  552,  634,  855,  636,  843,   12,  635,  425,
 /*   400 */   835,  863,  226,  519,  778,    4,   76,  716, 1138,  125,
 /*   410 */   548,  807, 1266,  896,   47,  735,  735, 1251,  896,   47,
 /*   420 */   443,   72,   73,  544,  296, 1246, 1246,  847,  847,   70,
 /*   430 */    70,   71,   71,   71,   71,  896,   69,   69,   69,   69,
 /*   440 */    68,   68,   67,   67,   67,   66,   64,  276,  364,  896,
 /*   450 */   896,  894,  893,  896,  896,  894,  893,  550,  173,   43,
 /*   460 */   143,  465,  895,  812,  854,  418, 1246, 1246,  859,  850,
 /*   470 */   713,   72,   73,  544,  296,  895,   49,  847,  847,   70,
 /*   480 */    70,   71,   71,   71,   71,  712,   69,   69,   69,   69,
 /*   490 */    68,   68,   67,   67,   67,   66,   64,  276,  515,  166,
 /*   500 */   854,  785,  474,  471,  470,  765,   72,   73,  544,  296,
 /*   510 */  1246, 1246,  847,  847,   70,   70,   71,   71,   71,   71,
 /*   520 */   469,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*   530 */    66,   64,  276,  825,  290,  896,  896,  894,  893,  892,
 /*   540 */   896,  896,  894,  893,   23,  824,  890,   48,  871,  305,
 /*   550 */   167,  573,  307,  524,  891,  695,  686,  896,  896,  894,
 /*   560 */   893,  368,  828, 1246, 1246,  142,  672,   95,  338,  625,
 /*   570 */   895,  574,  573,  118,  626, 1251,   92, 1251,   71,   71,
 /*   580 */    71,   71,   44,   69,   69,   69,   69,   68,   68,   67,
 /*   590 */    67,   67,   66,   64,  276,  613,   81,  308,  206,  613,
 /*   600 */   437,  573, 1252,   72,   73,  544,  296, 1246, 1246,  847,
 /*   610 */   847,   70,   70,   71,   71,   71,   71,  856,   69,   69,
 /*   620 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*   630 */   851,  377, 1362,   63,  896,  377, 1361, 1362,  467,  868,
 /*   640 */   686, 1361,  869,  118, 1246, 1246,  542,  840,  839,  896,
 /*   650 */   562,   95,  851,  851,  895,  391,   72,   73,  544,  296,
 /*   660 */   158,  160,  847,  847,   70,   70,   71,   71,   71,   71,
 /*   670 */   306,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*   680 */    66,   64,  276,  524,   72,   73,  544,  296, 1246, 1246,
 /*   690 */   847,  847,   70,   70,   71,   71,   71,   71,  770,   69,
 /*   700 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*   710 */   276,  896,  895,  851,  900,  264,  263,  262,  175,  556,
 /*   720 */    66,   64,  276,  543,  835,  267,   72,   73,  544,  296,
 /*   730 */   662,  896,  847,  847,   70,   70,   71,   71,   71,   71,
 /*   740 */   897,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*   750 */    66,   64,  276,   28,  850,  167,  896,  896,  894,  893,
 /*   760 */  1252,  546, 1252,  123,   94,  570,  849,  595,   86,  412,
 /*   770 */  1260,  896,  896,  894,  893,  851,  850,  850,   83,  851,
 /*   780 */   563,  268,  738,  845,  493,  862,  570,  862,  821,   61,
 /*   790 */   363, 1260,  676,  846,  896,  706,  466, 1260,  594,  552,
 /*   800 */   593,  552,  677,  592,  895,   62,   58,   59,  863,  243,
 /*   810 */   863,  127,  896,  453,   60,  570,  450,  548,  174,  548,
 /*   820 */   158,  157,    2, 1258,    8,  304,  173,  855,  896,  559,
 /*   830 */   719,  540,  718,  896,  896,  864,  893,  850,  896,  895,
 /*   840 */   543,  867,  783,  513, 1260,  525,  549,  655,  855,  866,
 /*   850 */   865,  864, 1260,  896,  896,  894,  893, 1260,  896,  518,
 /*   860 */   391,  523,  862,  783, 1370, 1370,  340,  139,  655,  783,
 /*   870 */   386,   83,  812,  765,  896,  146,  552,  610,  546,  627,
 /*   880 */   628,  439, 1260,  826,  855,  863,  226,  855,  364,  843,
 /*   890 */    12,  512,  896,  752,  548, 1260,  896, 1260, 1260,  850,
 /*   900 */   845,  171,  895,  850,  543,  831,   61, 1260,    6, 1260,
 /*   910 */  1260,  692, 1260,  376,  611,  685,  896,  896,  894,  893,
 /*   920 */   591,   24,  166,   58,   59,  474,  471,  470,  896,  841,
 /*   930 */  1260,   60,  896,  444,  896,  896,  894,  893,  727,    2,
 /*   940 */   751,  747,  546,  469,  855,  158,  156,  812,  540,   75,
 /*   950 */   896,  896,  864,  893,  753,  188,  446,  830,  867,   83,
 /*   960 */   896,  896,  894,  893,  845,  855,  866,  865,  864,  895,
 /*   970 */    61,  744,  348,  729,  602,  754,  832,  541,  274,  509,
 /*   980 */   896,  896,  894,  893,  351,  788,  644,   58,   59,  726,
 /*   990 */   753,  295,  294,  837,  836,   60,  896,  896,  894,  893,
 /*  1000 */   534,  855,  815,    2,  855,  208,  843,   12,  855,  829,
 /*  1010 */   602,  854,  540,  896,  896,  896,  864,  893,  896,  896,
 /*  1020 */   894,  893,  867,  348,  729,  582,  817,  490,  796,  855,
 /*  1030 */   866,  865,  864,  485,  837,  836, 1317,  120,  584,    1,
 /*  1040 */   583,   57,  783,   55,  861, 1370, 1370,  854,  579,  796,
 /*  1050 */   896,  896,  894,  893,  896,  896,  894,  893, 1413,  198,
 /*  1060 */   557,    3,  896,  783,  139,  855,  877,  521,  855,  783,
 /*  1070 */   843,   12,  486,  778,    4,  880,   72,   73,  544,  296,
 /*  1080 */   895,  895,  847,  847,   70,   70,   71,   71,   71,   71,
 /*  1090 */   207,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1100 */    66,   64,  276,   72,   73,  544,  296,  535,   82,  847,
 /*  1110 */   847,   70,   70,   71,   71,   71,   71,  579,   69,   69,
 /*  1120 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*  1130 */   896, 1317,  873,  456,  451,  896,  896,  894,  893,  174,
 /*  1140 */   694,  477,  543,   23,  766,  126,   72,   73,  544,  296,
 /*  1150 */   169,  896,  847,  847,   70,   70,   71,   71,   71,   71,
 /*  1160 */   816,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1170 */    66,   64,  276,  767,  807,  132,  316,  302,  664,  278,
 /*  1180 */   546,   47,  810,  799,  896,  896,  894,  893,  783,  301,
 /*  1190 */   516,  759,  373,  363,  896,  295,  294,  392,  862,  807,
 /*  1200 */    27,  857,  845,  551,  526,  511,  491,  895,   61,  783,
 /*  1210 */   877,  896,  552,  664,  517,  783, 1255,  553,  136,  875,
 /*  1220 */   506,  863,  243,  370,  895,   58,   59,  896,  372,  180,
 /*  1230 */   548,  807,  415,   60,  112,  403,  790,   83,  837,  836,
 /*  1240 */   131,    2, 1258,  311,  126,  813,  855,  671,   47,  895,
 /*  1250 */   540,  896,  896,  896,  864,  893,  666,  862,  525,  492,
 /*  1260 */   867,  734,   79,  543,  394,  260,  513,  855,  866,  865,
 /*  1270 */   864,  552,  811,  896,  896,  894,  893,  374,  461,  194,
 /*  1280 */   863,  127,  333,  386,  504,  126,  819,  436,  770,  548,
 /*  1290 */   770,  350,  895,  529,  126,  348,  729, 1258,  862,  502,
 /*  1300 */    52,  546,  895,  855,  895,  895,  855,  201,  843,   12,
 /*  1310 */   623,  357,  552,  356,  512,  896,  896,  896,  894,  893,
 /*  1320 */   387,  863,  243,  845,  896,  510,  609,  609,  505,   61,
 /*  1330 */   548,  193,  318,  896,  896,  894,  893,  126,  291,  496,
 /*  1340 */   896, 1253,  812,  791,  903,    3,   58,   59,  615,  896,
 /*  1350 */   896,  894,  893,  378,   60,  501,  381,  896,  423,  401,
 /*  1360 */   722,  400,    2,  770,  576,  770,   51,  855,  350,  870,
 /*  1370 */   126,  540,  896,  896,  896,  864,  893,  895,  350,  895,
 /*  1380 */   623,  867,  895,  532,  543,  402,  361,  513,  855,  866,
 /*  1390 */   865,  864,  895,  576,  809,   72,   73,  544,  296,  895,
 /*  1400 */    63,  847,  847,   70,   70,   71,   71,   71,   71,  808,
 /*  1410 */    69,   69,   69,   69,   68,   68,   67,   67,   67,   66,
 /*  1420 */    64,  276,  546, 1021,  855,  420,  178,  855,  674,  843,
 /*  1430 */    12,  618,  776,  381,  281,  514,  438,  896,  896,  894,
 /*  1440 */   893,  269,  764,  287,  845,  763,  896,  896,  894,  893,
 /*  1450 */    61,  328,  797,    4,  763,  668,  668,  200,  399,  363,
 /*  1460 */   578,  572,  896,  896,  894,  893,  896,   58,   59,  782,
 /*  1470 */     4,  455,  895,  895,  763,   60,  876,  691,  690,  896,
 /*  1480 */   896,  894,  893,    2,   21,  781,    4,   47,  855,  430,
 /*  1490 */   572,  119,  540,  608,  896,  896,  864,  893,  283,  618,
 /*  1500 */   449,  896,  867,  895,  902,  174,  766,  452,  766,  855,
 /*  1510 */   866,  865,  864,   80,  779,    4,   72,   73,  544,  296,
 /*  1520 */   520,  895,  847,  847,   70,   70,   71,   71,   71,   71,
 /*  1530 */   319,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1540 */    66,   64,  276,  780,    4,  855,  364,  431,  855,  798,
 /*  1550 */   843,   12,  819,  756,   20,  755,   72,   73,  544,  296,
 /*  1560 */   895,  895,  847,  847,   70,   70,   71,   71,   71,   71,
 /*  1570 */   354,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1580 */    66,   64,  276,  428,  878,  792,  282,  604,  896,  896,
 /*  1590 */   894,  893,  733,   72,   73,  544,  296,  895,  896,  847,
 /*  1600 */   847,   70,   70,   71,   71,   71,   71,  885,   69,   69,
 /*  1610 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*  1620 */   654,   53,  718,  896,  896,  894,  893,    5,  793,  728,
 /*  1630 */   269,   72,   73,  544,  296,  787,  786,  847,  847,   70,
 /*  1640 */    70,   71,   71,   71,   71,  766,   69,   69,   69,   69,
 /*  1650 */    68,   68,   67,   67,   67,   66,   64,  276,  538,  784,
 /*  1660 */   815,   19,   72,   73,  544,  296,   18,  725,  847,  847,
 /*  1670 */    70,   70,   71,   71,   71,   71,  561,   69,   69,   69,
 /*  1680 */    69,   68,   68,   67,   67,   67,   66,   64,  276,  117,
 /*  1690 */   895,  353,  202,   72,   73,  544,  296,   17,  708,  847,
 /*  1700 */   847,   70,   70,   71,   71,   71,   71,   11,   69,   69,
 /*  1710 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*  1720 */   896,  896,  894,  893,   72,   73,  544,  296,  172,  195,
 /*  1730 */   847,  847,   70,   70,   71,   71,   71,   71,  898,   69,
 /*  1740 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*  1750 */   276,  269,  895,  896,  760,   72,   73,  544,  296,  191,
 /*  1760 */   337,  847,  847,   70,   70,   71,   71,   71,   71,  190,
 /*  1770 */    69,   69,   69,   69,   68,   68,   67,   67,   67,   66,
 /*  1780 */    64,  276,  621, 1281,   72,   73,  544,  296,  189,  748,
 /*  1790 */   847,  847,   70,   70,   71,   71,   71,   71,  886,   69,
 /*  1800 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*  1810 */   276,  743,  895,   83,  896,  133,   72,   73,  544,  296,
 /*  1820 */   497,   31,  847,  847,   70,   70,   71,   71,   71,   71,
 /*  1830 */   896,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1840 */    66,   64,  276,   16, 1332,   72,   73,  544,  296,  896,
 /*  1850 */   631,  847,  847,   70,   70,   71,   71,   71,   71,  883,
 /*  1860 */    69,   69,   69,   69,   68,   68,   67,   67,   67,   66,
 /*  1870 */    64,  276,  896, 1330,  485,  896,  896,  894,  893,  741,
 /*  1880 */    72,   73,  544,  296,  543,  737,  847,  847,   70,   70,
 /*  1890 */    71,   71,   71,   71,  736,   69,   69,   69,   69,   68,
 /*  1900 */    68,   67,   67,   67,   66,   64,  276,  489,   72,   42,
 /*  1910 */   544,  296,  488,   41,  847,  847,   70,   70,   71,   71,
 /*  1920 */    71,   71,  546,   69,   69,   69,   69,   68,   68,   67,
 /*  1930 */    67,   67,   66,   64,  276,  487,  896,  896,  894,  893,
 /*  1940 */   731,  115,  884,  427,  845,  426,  363,  600,  484,  597,
 /*  1950 */    61,   40,  896,  896,  894,  893,  895,  895,   15,  895,
 /*  1960 */   895,  186,  363,  452,  882,  649,  422,   58,   59,  124,
 /*  1970 */   388,  896,  896,  894,  893,   60,  895,  895,  895,  286,
 /*  1980 */   895,   26,   39,    2,  862,  405,  649,  853,  855,  476,
 /*  1990 */   879,  169,  540,  896,  896,  896,  864,  893,  552,  698,
 /*  2000 */   689,  404,  867,  650,  895,  543,  473,  863,  243,  855,
 /*  2010 */   866,  865,  864,   73,  544,  296,  548,   89,  847,  847,
 /*  2020 */    70,   70,   71,   71,   71,   71,  896,   69,   69,   69,
 /*  2030 */    69,   68,   68,   67,   67,   67,   66,   64,  276,  819,
 /*  2040 */   862,  339,  280,  546,  289,  855,  872,  860,  855,  527,
 /*  2050 */   843,   12,  852,   88,  552,  819,   25,  468,  165,  862,
 /*  2060 */   895,  895,  862,  863,  243,  845,  895,  531,   87,  386,
 /*  2070 */   772,   61,  548,  552,  667,  345,  552,  896,  768,  164,
 /*  2080 */   463,  762,  863,  243,  895,  863,  246,  205,   58,   59,
 /*  2090 */   159,  548,  895,   83,  548,  895,   60,  862,  896,  163,
 /*  2100 */   525,  503,  108,  161,    2,  126,   10,  777,   38,  855,
 /*  2110 */   106,  552,   37,  540,  896,  896,  896,  864,  893,  417,
 /*  2120 */   863,  243,  862,  867,  896,  386,  543,  170,   36,  548,
 /*  2130 */   855,  866,  865,  864,   35, 1249,  552,   75, 1088,  500,
 /*  2140 */   105,  895,  753,  396,  386,  863,  226,  812,  896,  896,
 /*  2150 */   894,  893,  398,  895,  548,  104,  774,  525,  410,  643,
 /*  2160 */   730,  341,  637,  754,  546,  315,  855,  632,  440,  855,
 /*  2170 */   705,  843,   12,  862,  895,  895,  896,  683,  753, 1370,
 /*  2180 */  1370,  335,  386,  630,  895,  113,  845,  552,  174,  669,
 /*  2190 */   624,  895,   61,  641,  154,  895,  863,  243,  896,  896,
 /*  2200 */   896,  894,  893,  895,  881,  548,   13,  812,  313,   58,
 /*  2210 */    59,  310,  184,  330,  641,  896,  209,   60,  457,  605,
 /*  2220 */   896,  896,  894,  893,  152,    2,  707,  895,   90,  151,
 /*  2230 */   855,  896,  895,  288,  540,  896,  896,  896,  894,  893,
 /*  2240 */   596,  144,  352,  543,  867,  785,  896,  896,  894,  893,
 /*  2250 */   150,  855,  866,  865,  864,  544,  296,  149,  386,  847,
 /*  2260 */   847,   70,   70,   71,   71,   71,   71,  581,   69,   69,
 /*  2270 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*  2280 */   580,  546,  661,  658,  147,   99,  419,  855,  434,  558,
 /*  2290 */   855,  814,  843,   12,  568,  896,  895,  895,  896,  896,
 /*  2300 */   894,  893,  895,  845,  896,   97,  269,  543,  895,   61,
 /*  2310 */   421,  596,  265,  285,  606,  121,  261,  390,  899,  389,
 /*  2320 */   896,  896,  894,  893,  895,  182,   58,   59,  896,  887,
 /*  2330 */   566,  599,  367,  896,   60,  606,  547,  896,  896,  894,
 /*  2340 */   893,  889,    2,  336,  895,  546,  895,  855,  888,  555,
 /*  2350 */   895,  540,  181,  896,  896,  864,  893,  896,  896,  894,
 /*  2360 */   893,  867,  862,  331,  111,  179,  896,  845,  855,  866,
 /*  2370 */   865,  864,  464,   61,  554,  454,  552,  895,  543,  312,
 /*  2380 */    78,  599,  309,  303,  276,  863,  127,  299,  300,  895,
 /*  2390 */    58,   59,  858,  895,  548,  896,  895,  895,   60,  176,
 /*  2400 */   362,  895,  895,   91,  855,  273,    2,  855,  771,  843,
 /*  2410 */    12,  855,  896,  414,  293,  540,  546,  896,  896,  864,
 /*  2420 */   893,  536,  292,   24,   54,  867,  896,  896,  894,  893,
 /*  2430 */   896,   46,  855,  866,  865,  864,  192,  508,  845,  359,
 /*  2440 */   203,  358,  543,   50,   61,  524,  355,  812,  806,  805,
 /*  2450 */   896,  896,  894,  893,  413,  896,  896,  894,  893,  795,
 /*  2460 */   266,   58,   59,  187,  789,  141,  496,  896,  855,   60,
 /*  2470 */   761,  855,  804,  843,   12, 1256,  801,    2, 1258,  495,
 /*  2480 */   546,  732,  855,  720,  169,  481,  540,  715,  896,  896,
 /*  2490 */   864,  893,  750,  407,  714,  711,  867,  749,  862,  710,
 /*  2500 */   343,  896,  845,  855,  866,  865,  864,  709,   61,  380,
 /*  2510 */   681,  560,  552,  543,  680,  688,  679,  896,  896,  894,
 /*  2520 */   893,  863,  243,   75,  678,   58,   59,  109,  753,  140,
 /*  2530 */   548,  896,  560,   60,  896,  896,  894,  893,  379,  855,
 /*  2540 */   896,    2,  855,  462,  843,   12,  855,  271,  862,  754,
 /*  2550 */   540,  546,  896,  896,  864,  893,  162,  329,  411,  896,
 /*  2560 */   867,  862,  552,  896,  753,  441,  459,  855,  866,  865,
 /*  2570 */   864,  863,  127,  845,   34,  552, 1095, 1095,  210,   61,
 /*  2580 */   548,  327,  896,  386,  863,  127,  326,  862,  896,  896,
 /*  2590 */   896,  894,  893,  548,  896,  325,   58,   59,  656,  107,
 /*  2600 */   185,  552,  321,  855,   60,  322,  855,  320,  843,   12,
 /*  2610 */   863,  127,    2,  704,  896,  199,  652,  855,  896,  548,
 /*  2620 */   114,  540,  409,  896,  896,  894,  893,  896,  317,  448,
 /*  2630 */   646,  867,  896,  812,  447,  397,  862,  896,  855,  866,
 /*  2640 */   865,  864,  642,  896,  640,  138,  812,  435,  896,  155,
 /*  2650 */   552,  620,  137,  896,  896,  894,  893,  432,  153,  863,
 /*  2660 */   243,  395,  896,  896,  894,  893,  682,  896,  548,  103,
 /*  2670 */   429,  896,  812,  102,  855,  393,  896,  855,  101,  843,
 /*  2680 */    12,  896,  896,  894,  893,  896,  896,  894,  893,  896,
 /*  2690 */   100,  665,   33,  896,  590,  148,  507,  670,   32,  577,
 /*  2700 */   675,  575,   29,  135,  896,  896,  894,  893,  571,  896,
 /*  2710 */   896,  896,  894,  893,  896,  134,  896,  896,  894,  893,
 /*  2720 */    85,  386,  896,  183,  563,  629,  896,   65,  211,  823,
 /*  2730 */   896,  659,  838,  360,  834,  896,  896,  896,  894,  893,
 /*  2740 */   896,  896,  894,  893,  533,  663,  896,  197,  196,  896,
 /*  2750 */   896,  894,  893,  775,  896,  896,  894,  893,  257,  896,
 /*  2760 */   896,  894,  893,  616,  653,  896,  896,  894,  893,  648,
 /*  2770 */   896,  896,  894,  893,  660,  344,  706,  472,  657,  323,
 /*  2780 */   619,  647,  645,  896,  145,  375,    7,  848,  833,  896,
 /*  2790 */   896,  894,  893,  896,  896,  894,  893,  896,  896,  896,
 /*  2800 */   894,  893,  822,  601,  607,  270,  204,  693,  460,   45,
 /*  2810 */   545,  896,  896,  894,  893,  896,  896,  894,  893,  794,
 /*  2820 */    98,  614,  703,  603,  567,   83,  697,  696,  724,  723,
 /*  2830 */   569,  896,  896,  894,  893,  684,  896,  896,  894,  893,
 /*  2840 */  1414, 1414, 1414,  565,  896,  896,  894,  893,  896,  896,
 /*  2850 */   894,  893,  896,  896,  894,  893, 1414,  896,  896,  894,
 /*  2860 */   893,  814,  862,  598, 1414,  862, 1414, 1414,  896,  896,
 /*  2870 */   894,  893, 1414, 1414,  589, 1414,  552, 1414,  862,  552,
 /*  2880 */  1414, 1414, 1414, 1414, 1414,  863,  244,  564,  863,  254,
 /*  2890 */  1414, 1414,  552, 1414,  548, 1414, 1414,  548, 1414,  820,
 /*  2900 */  1414,  863,  253,  769,  685,  896,  896,  894,  893,   33,
 /*  2910 */   548,  862, 1414,  862, 1414, 1414,  862, 1414, 1414,  896,
 /*  2920 */   896,  894,  893, 1414, 1414,  552, 1414,  552,  862, 1414,
 /*  2930 */   552, 1414,  862, 1414,  863,  255,  863,  256, 1414,  863,
 /*  2940 */   275, 1414,  552,  548,  862,  548,  552,  812,  548, 1414,
 /*  2950 */   812,  863,  366, 1414, 1414,  863,  252,  862,  552, 1414,
 /*  2960 */   548,  862, 1414,  812,  548, 1414, 1414,  863,  365, 1414,
 /*  2970 */  1414,  552, 1414, 1414, 1414,  552,  548, 1414, 1414, 1414,
 /*  2980 */   863,  222, 1414, 1414,  863,  240,  862, 1414, 1414,  548,
 /*  2990 */  1414, 1414, 1414,  548, 1414, 1414,  812, 1414,  812, 1414,
 /*  3000 */   552,  812,  862, 1414, 1414, 1414, 1414,  862, 1414,  863,
 /*  3010 */   245, 1414, 1414,  812, 1414, 1414,  552,  812,  548, 1414,
 /*  3020 */  1414,  552, 1414, 1414,  862,  863,  384, 1414, 1414,  812,
 /*  3030 */   863,  383, 1414, 1414,  548, 1414,  862, 1414,  552,  548,
 /*  3040 */   862, 1414,  812,  862, 1414, 1414,  812,  863,  382, 1414,
 /*  3050 */   552, 1414, 1414, 1414,  552, 1414,  548,  552, 1414,  863,
 /*  3060 */   239, 1414, 1414,  863,  224,  862,  863,  238,  548, 1414,
 /*  3070 */  1414,  812,  548, 1414, 1414,  548,  862, 1414, 1414,  552,
 /*  3080 */   862, 1414,  862, 1414, 1414, 1414, 1414,  812,  863,  237,
 /*  3090 */   552, 1414,  812, 1414,  552, 1414,  552,  548, 1414,  863,
 /*  3100 */   223, 1414, 1414,  863,  251,  863,  250, 1414,  548,  812,
 /*  3110 */   862, 1414,  548,  862,  548,  862, 1414,  862, 1414, 1414,
 /*  3120 */  1414,  812, 1414, 1414,  552,  812, 1414,  552,  812,  552,
 /*  3130 */  1414,  552, 1414,  863,  212, 1414,  863,  221,  863,  220,
 /*  3140 */   863,  128,  548, 1414, 1414,  548,  862,  548,  862,  548,
 /*  3150 */   812, 1414,  862, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3160 */   552,  812,  552, 1414, 1414,  812,  552,  812, 1414,  863,
 /*  3170 */   219,  863,  247,  862, 1414,  863,  249, 1414,  548, 1414,
 /*  3180 */   548, 1414, 1414, 1414,  548, 1414, 1414,  552, 1414, 1414,
 /*  3190 */   862, 1414,  862, 1414, 1414,  812,  863,  242,  812, 1414,
 /*  3200 */   812, 1414,  812, 1414,  552,  548,  552, 1414, 1414, 1414,
 /*  3210 */  1414, 1414, 1414,  863,  248,  863,  236, 1414, 1414, 1414,
 /*  3220 */  1414, 1414,  548, 1414,  548, 1414, 1414,  862, 1414, 1414,
 /*  3230 */   862,  812,  862,  812, 1414, 1414, 1414,  812, 1414, 1414,
 /*  3240 */  1414,  552, 1414, 1414,  552, 1414,  552, 1414, 1414,  862,
 /*  3250 */   863,  235, 1414,  863,  232,  863,  216, 1414,  812,  548,
 /*  3260 */   862, 1414,  548,  552,  548,  862, 1414, 1414, 1414, 1414,
 /*  3270 */  1414,  862,  863,  215,  552,  812, 1414,  812, 1414,  552,
 /*  3280 */  1414,  548,  862,  863,  214,  552,  862, 1414,  863,  213,
 /*  3290 */  1414, 1414,  548, 1414,  863,  225,  552,  548, 1414, 1414,
 /*  3300 */   552, 1414, 1414,  548, 1414,  863,  230, 1414, 1414,  863,
 /*  3310 */   229, 1414,  812, 1414,  548,  812,  862,  812,  548,  862,
 /*  3320 */  1414, 1414, 1414,  862, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3330 */   552, 1414, 1414,  552,  812, 1414, 1414,  552, 1414,  863,
 /*  3340 */   129, 1414,  863,  228, 1414,  812,  863,  227,  548, 1414,
 /*  3350 */   812,  548,  862, 1414,  862,  548,  812, 1414,  862, 1414,
 /*  3360 */  1414, 1414, 1414, 1414, 1414, 1414,  552,  812,  552, 1414,
 /*  3370 */  1414,  812,  552,  862, 1414,  863,  241,  863,  217,  862,
 /*  3380 */  1414,  863,  233, 1414,  548, 1414,  548,  552, 1414, 1414,
 /*  3390 */   548, 1414, 1414,  552, 1414, 1414,  863,  231,  862, 1414,
 /*  3400 */  1414,  812,  863,  218,  812,  548, 1414, 1414,  812, 1414,
 /*  3410 */  1414,  548,  552, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3420 */  1414,  863,   96, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3430 */   499, 1414, 1414, 1414, 1414, 1414, 1414,  812, 1414,  812,
 /*  3440 */  1414, 1414, 1414,  812, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3450 */  1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,  812, 1414,
 /*  3460 */  1414, 1414, 1414, 1414,  812, 1414, 1414, 1414, 1414, 1414,
 /*  3470 */  1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
 /*  3480 */  1414, 1414, 1414,  812,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  217,    4,  213,   48,  221,  222,  223,   80,   81,
 /*    10 */    82,   83,   16,  116,   86,   87,   88,   89,   90,   91,
 /*    20 */    92,   93,  108,   95,   96,   97,   98,   99,  100,  101,
 /*    30 */   102,  103,  104,  105,  106,  116,   80,   81,   82,   83,
 /*    40 */   121,  251,   86,   87,   88,   89,   90,   91,   92,   93,
 /*    50 */    54,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*    60 */   104,  105,  106,    4,  108,   24,   15,  121,  171,    4,
 /*    70 */   252,  253,   76,  255,   90,   91,   92,   93,   82,   95,
 /*    80 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*    90 */   106,   79,    4,  116,   43,   99,  100,  101,  121,  224,
 /*   100 */   225,  226,  112,  107,  108,  159,   31,  161,  162,    4,
 /*   110 */    59,  115,  116,  185,   39,  117,  120,  121,    4,  116,
 /*   120 */   124,   16,  126,  127,  128,  129,  128,  115,  116,   24,
 /*   130 */   134,  101,  102,  103,  104,  105,  106,  141,  142,  143,
 /*   140 */   144,   76,  146,   95,   96,   97,   98,   99,  100,  101,
 /*   150 */   102,  103,  104,  105,  106,  159,  115,  161,  162,   54,
 /*   160 */    42,  165,  164,   66,   99,  100,   69,  171,  172,  173,
 /*   170 */   174,  175,  176,  177,  205,  205,  180,  302,  182,  183,
 /*   180 */   115,   76,  133,  134,   58,  126,  127,   82,  219,  219,
 /*   190 */   194,  126,  127,  128,    0,  225,  226,  228,  229,  134,
 /*   200 */    82,  101,  151,  115,   99,  100,  237,  142,  143,  144,
 /*   210 */   134,  114,  107,  108,  126,  127,  128,  129,    4,   75,
 /*   220 */   115,  116,  116,   29,  213,  120,  121,  121,  152,  124,
 /*   230 */    16,  126,  127,  128,  129,   82,  205,  121,  128,  134,
 /*   240 */   126,  127,  128,  129,  134,   10,  141,  142,  143,  144,
 /*   250 */   219,  146,  142,  143,  144,  141,   82,   22,  221,  290,
 /*   260 */   160,  250,  251,  163,  159,  177,  161,  162,   54,  121,
 /*   270 */   156,  301,  302,  147,  148,  149,  171,  172,  173,  174,
 /*   280 */   106,  176,  177,  157,  158,  180,  205,  182,  183,   64,
 /*   290 */    76,  117,  281,  145,  283,   70,   82,  286,  154,  194,
 /*   300 */   219,  127,  108,  205,   26,  268,  132,  133,  134,  135,
 /*   310 */   136,  137,  138,   99,  100,  116,  163,  219,  307,  308,
 /*   320 */   121,  107,  108,  225,  226,  213,  152,    4,  291,  115,
 /*   330 */   116,    4,   34,  121,  120,  121,  205,  193,  124,  116,
 /*   340 */   126,  127,  128,  129,  121,    4,  215,  216,  134,   71,
 /*   350 */   219,  320,  321,   55,    5,  141,  142,  143,  144,   61,
 /*   360 */   146,  136,  250,  251,   99,  100,  101,  102,  103,  104,
 /*   370 */   105,  106,  241,  159,  243,  161,  162,  165,  205,   30,
 /*   380 */    89,   40,   41,  115,   35,  171,  108,  173,  174,  115,
 /*   390 */   176,  177,  219,  281,  180,  283,  182,  183,  286,  301,
 /*   400 */   302,  228,  229,  322,  323,  324,  115,   58,  194,  116,
 /*   410 */   237,   62,  187,    4,  121,   40,   41,   26,    4,  121,
 /*   420 */   308,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   430 */    89,   90,   91,   92,   93,    4,   95,   96,   97,   98,
 /*   440 */    99,  100,  101,  102,  103,  104,  105,  106,  205,  126,
 /*   450 */   127,  128,  129,  126,  127,  128,  129,  121,  117,   84,
 /*   460 */    85,  205,  219,  290,  141,  209,   40,   41,  141,  128,
 /*   470 */    21,   80,   81,   82,   83,  219,   50,   86,   87,   88,
 /*   480 */    89,   90,   91,   92,   93,   36,   95,   96,   97,   98,
 /*   490 */    99,  100,  101,  102,  103,  104,  105,  106,  325,  132,
 /*   500 */   177,  328,  135,  136,  137,  164,   80,   81,   82,   83,
 /*   510 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   520 */   153,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   530 */   104,  105,  106,   10,  257,  126,  127,  128,  129,   21,
 /*   540 */   126,  127,  128,  129,  267,   22,   28,  121,  139,   66,
 /*   550 */    41,  120,   69,  171,   36,  141,  205,  126,  127,  128,
 /*   560 */   129,  210,  319,   40,   41,  118,  215,  216,  116,    7,
 /*   570 */   219,  140,  141,  121,   12,  184,  194,  186,   90,   91,
 /*   580 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   590 */   102,  103,  104,  105,  106,   79,  115,  114,  117,   79,
 /*   600 */    38,  170,   26,   80,   81,   82,   83,   84,   85,   86,
 /*   610 */    87,   88,   89,   90,   91,   92,   93,  116,   95,   96,
 /*   620 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   630 */     4,  115,  116,  121,    4,  115,  116,  121,  116,  160,
 /*   640 */   205,  121,  163,  121,   40,   41,  224,  225,  226,    4,
 /*   650 */   215,  216,    4,    4,  219,  146,   80,   81,   82,   83,
 /*   660 */   117,  118,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   670 */   187,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   680 */   104,  105,  106,  171,   80,   81,   82,   83,   84,   85,
 /*   690 */    86,   87,   88,   89,   90,   91,   92,   93,  205,   95,
 /*   700 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   710 */   106,    4,  219,    4,  197,  147,  148,  149,  118,  202,
 /*   720 */   104,  105,  106,   16,  302,  115,   80,   81,   82,   83,
 /*   730 */   213,    4,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   740 */   110,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   750 */   104,  105,  106,  121,  128,   41,  126,  127,  128,  129,
 /*   760 */   184,   54,  186,  117,  115,  120,  140,  250,  251,  276,
 /*   770 */    34,  126,  127,  128,  129,    4,  128,  128,   71,    4,
 /*   780 */    17,  252,  253,   76,  255,  205,  141,  205,  140,   82,
 /*   790 */   205,   55,  235,  134,    4,  238,   82,   61,  281,  219,
 /*   800 */   283,  219,  245,  286,  219,  115,   99,  100,  228,  229,
 /*   810 */   228,  229,    4,  116,  107,  170,  287,  237,  121,  237,
 /*   820 */   117,  118,  115,  116,  115,  205,  117,  120,    4,  312,
 /*   830 */   246,  124,  248,  126,  127,  128,  129,  128,    4,  219,
 /*   840 */    16,  134,   34,   19,  108,  265,  266,  120,  141,  142,
 /*   850 */   143,  144,  116,  126,  127,  128,  129,  121,    4,   51,
 /*   860 */   146,  279,  205,   55,  157,  158,  152,  121,  141,   61,
 /*   870 */   290,   71,  290,  164,    4,  112,  219,   79,   54,  147,
 /*   880 */   148,  149,  146,  298,  177,  228,  229,  180,  205,  182,
 /*   890 */   183,   67,    4,  121,  237,  159,    4,  161,  162,  128,
 /*   900 */    76,  129,  219,  128,   16,  130,   82,  171,   84,  173,
 /*   910 */   174,  140,  176,  115,  116,  125,  126,  127,  128,  129,
 /*   920 */   300,  175,  132,   99,  100,  135,  136,  137,    4,  116,
 /*   930 */   194,  107,    4,  133,  126,  127,  128,  129,  296,  115,
 /*   940 */   168,  169,   54,  153,  120,  117,  118,  290,  124,  115,
 /*   950 */   126,  127,  128,  129,  120,  205,  149,  116,  134,   71,
 /*   960 */   126,  127,  128,  129,   76,  141,  142,  143,  144,  219,
 /*   970 */    82,  101,  330,  331,  120,  141,  221,  222,  223,  171,
 /*   980 */   126,  127,  128,  129,  327,  328,  179,   99,  100,  296,
 /*   990 */   156,   99,  100,  142,  143,  107,  126,  127,  128,  129,
 /*  1000 */   317,  177,  319,  115,  180,  115,  182,  183,  120,  116,
 /*  1010 */   156,  141,  124,    4,  126,  127,  128,  129,  126,  127,
 /*  1020 */   128,  129,  134,  330,  331,  133,   42,   72,   32,  141,
 /*  1030 */   142,  143,  144,   78,  142,  143,   13,  121,  146,  115,
 /*  1040 */   148,  184,   34,  186,  120,  157,  158,  177,  120,   53,
 /*  1050 */   126,  127,  128,  129,  126,  127,  128,  129,  198,  199,
 /*  1060 */   200,  201,    4,   55,  121,  177,  205,  205,  180,   61,
 /*  1070 */   182,  183,  322,  323,  324,  214,   80,   81,   82,   83,
 /*  1080 */   219,  219,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1090 */   115,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1100 */   104,  105,  106,   80,   81,   82,   83,  213,  165,   86,
 /*  1110 */    87,   88,   89,   90,   91,   92,   93,  189,   95,   96,
 /*  1120 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1130 */     4,  108,  227,  257,  116,  126,  127,  128,  129,  121,
 /*  1140 */   235,  236,   16,  267,  221,  251,   80,   81,   82,   83,
 /*  1150 */   195,    4,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1160 */   116,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1170 */   104,  105,  106,  164,    5,    9,  116,   11,  120,   13,
 /*  1180 */    54,  121,  116,  321,  126,  127,  128,  129,   34,   23,
 /*  1190 */    19,  268,   26,  205,    4,   99,  100,  207,  205,   30,
 /*  1200 */   146,  253,   76,  255,   35,   51,  213,  219,   82,   55,
 /*  1210 */   205,    4,  219,  155,   43,   61,  184,  212,   52,  214,
 /*  1220 */   166,  228,  229,   57,  219,   99,  100,    4,   62,   63,
 /*  1230 */   237,   62,  244,  107,   68,  205,   65,   71,  142,  143,
 /*  1240 */    74,  115,  116,  116,  251,   26,  120,  213,  121,  219,
 /*  1250 */   124,    4,  126,  127,  128,  129,  213,  205,  265,  266,
 /*  1260 */   134,  296,  115,   16,  313,  314,   19,  141,  142,  143,
 /*  1270 */   144,  219,  116,  126,  127,  128,  129,  111,  205,  113,
 /*  1280 */   228,  229,  209,  290,   82,  251,  298,  297,  205,  237,
 /*  1290 */   205,  205,  219,  163,  251,  330,  331,  171,  205,  213,
 /*  1300 */   165,   54,  219,  177,  219,  219,  180,  277,  182,  183,
 /*  1310 */   120,  262,  219,  264,   67,    4,  126,  127,  128,  129,
 /*  1320 */   154,  228,  229,   76,    4,  171,  119,  120,  126,   82,
 /*  1330 */   237,  279,  213,  126,  127,  128,  129,  251,  157,  158,
 /*  1340 */     4,   26,  290,  172,  200,  201,   99,  100,  116,  126,
 /*  1350 */   127,  128,  129,  121,  107,  269,  270,    4,  192,  276,
 /*  1360 */   219,  276,  115,  205,  141,  205,  165,  120,  205,  228,
 /*  1370 */   251,  124,    4,  126,  127,  128,  129,  219,  205,  219,
 /*  1380 */   190,  134,  219,  290,   16,  205,  293,   19,  141,  142,
 /*  1390 */   143,  144,  219,  170,  116,   80,   81,   82,   83,  219,
 /*  1400 */   121,   86,   87,   88,   89,   90,   91,   92,   93,  116,
 /*  1410 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1420 */   105,  106,   54,  116,  177,   29,   73,  180,  121,  182,
 /*  1430 */   183,  120,  269,  270,  276,   67,  276,  126,  127,  128,
 /*  1440 */   129,  291,  275,  270,   76,  278,  126,  127,  128,  129,
 /*  1450 */    82,  275,  323,  324,  278,  119,  120,  277,  205,  205,
 /*  1460 */   310,  141,  126,  127,  128,  129,    4,   99,  100,  323,
 /*  1470 */   324,  275,  219,  219,  278,  107,  123,  219,  220,  126,
 /*  1480 */   127,  128,  129,  115,   14,  323,  324,  121,  120,  205,
 /*  1490 */   170,  121,  124,  209,  126,  127,  128,  129,  244,  188,
 /*  1500 */   116,    4,  134,  219,  108,  121,  221,  205,  221,  141,
 /*  1510 */   142,  143,  144,  115,  323,  324,   80,   81,   82,   83,
 /*  1520 */   117,  219,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1530 */   277,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1540 */   104,  105,  106,  323,  324,  177,  205,  205,  180,  116,
 /*  1550 */   182,  183,  298,  268,   14,  268,   80,   81,   82,   83,
 /*  1560 */   219,  219,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1570 */   231,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1580 */   104,  105,  106,  205,  122,   60,  284,  209,  126,  127,
 /*  1590 */   128,  129,  116,   80,   81,   82,   83,  219,    4,   86,
 /*  1600 */    87,   88,   89,   90,   91,   92,   93,  110,   95,   96,
 /*  1610 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1620 */   246,  185,  248,  126,  127,  128,  129,   81,   45,  116,
 /*  1630 */   291,   80,   81,   82,   83,   32,   60,   86,   87,   88,
 /*  1640 */    89,   90,   91,   92,   93,  221,   95,   96,   97,   98,
 /*  1650 */    99,  100,  101,  102,  103,  104,  105,  106,  317,   53,
 /*  1660 */   319,   14,   80,   81,   82,   83,   14,  116,   86,   87,
 /*  1670 */    88,   89,   90,   91,   92,   93,  205,   95,   96,   97,
 /*  1680 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  115,
 /*  1690 */   219,  231,  268,   80,   81,   82,   83,   14,  116,   86,
 /*  1700 */    87,   88,   89,   90,   91,   92,   93,   14,   95,   96,
 /*  1710 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1720 */   126,  127,  128,  129,   80,   81,   82,   83,   14,  116,
 /*  1730 */    86,   87,   88,   89,   90,   91,   92,   93,  205,   95,
 /*  1740 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1750 */   106,  291,  219,    4,  126,   80,   81,   82,   83,  116,
 /*  1760 */   116,   86,   87,   88,   89,   90,   91,   92,   93,  116,
 /*  1770 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1780 */   105,  106,  188,  108,   80,   81,   82,   83,  116,  168,
 /*  1790 */    86,   87,   88,   89,   90,   91,   92,   93,  205,   95,
 /*  1800 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1810 */   106,  101,  219,   71,    4,  118,   80,   81,   82,   83,
 /*  1820 */   118,  117,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1830 */     4,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1840 */   104,  105,  106,  115,  108,   80,   81,   82,   83,    4,
 /*  1850 */   108,   86,   87,   88,   89,   90,   91,   92,   93,  110,
 /*  1860 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1870 */   105,  106,    4,  108,   78,  126,  127,  128,  129,  160,
 /*  1880 */    80,   81,   82,   83,   16,  116,   86,   87,   88,   89,
 /*  1890 */    90,   91,   92,   93,  116,   95,   96,   97,   98,   99,
 /*  1900 */   100,  101,  102,  103,  104,  105,  106,  172,   80,   81,
 /*  1910 */    82,   83,  115,   14,   86,   87,   88,   89,   90,   91,
 /*  1920 */    92,   93,   54,   95,   96,   97,   98,   99,  100,  101,
 /*  1930 */   102,  103,  104,  105,  106,  171,  126,  127,  128,  129,
 /*  1940 */   116,  115,  205,  205,   76,  205,  205,  209,  115,  209,
 /*  1950 */    82,  175,  126,  127,  128,  129,  219,  219,   14,  219,
 /*  1960 */   219,   18,  205,  205,  205,  120,  205,   99,  100,  116,
 /*  1970 */   209,  126,  127,  128,  129,  107,  219,  219,  219,   48,
 /*  1980 */   219,  115,  115,  115,  205,  244,  141,  177,  120,  117,
 /*  1990 */   205,  195,  124,    4,  126,  127,  128,  129,  219,    6,
 /*  2000 */     8,  244,  134,  177,  219,   16,   48,  228,  229,  141,
 /*  2010 */   142,  143,  144,   81,   82,   83,  237,  115,   86,   87,
 /*  2020 */    88,   89,   90,   91,   92,   93,    4,   95,   96,   97,
 /*  2030 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  298,
 /*  2040 */   205,  116,  284,   54,  265,  177,  205,  205,  180,  181,
 /*  2050 */   182,  183,  205,  115,  219,  298,  115,   48,  138,  205,
 /*  2060 */   219,  219,  205,  228,  229,   76,  219,  213,  115,  290,
 /*  2070 */   205,   82,  237,  219,  124,  152,  219,    4,  205,  118,
 /*  2080 */    82,  205,  228,  229,  219,  228,  229,  117,   99,  100,
 /*  2090 */   117,  237,  219,   71,  237,  219,  107,  205,    4,  118,
 /*  2100 */   265,  266,  165,  146,  115,  251,   13,  121,   89,  120,
 /*  2110 */   151,  219,   89,  124,    4,  126,  127,  128,  129,  265,
 /*  2120 */   228,  229,  205,  134,    4,  290,   16,  205,   89,  237,
 /*  2130 */   141,  142,  143,  144,   89,  108,  219,  115,  116,  205,
 /*  2140 */   178,  219,  120,   24,  290,  228,  229,  290,  126,  127,
 /*  2150 */   128,  129,   18,  219,  237,  151,  167,  265,  266,  179,
 /*  2160 */   205,  205,  108,  141,   54,  158,  177,  108,   25,  180,
 /*  2170 */   205,  182,  183,  205,  219,  219,    4,  205,  156,  157,
 /*  2180 */   158,  205,  290,   60,  219,   49,   76,  219,  121,  205,
 /*  2190 */    49,  219,   82,  120,  146,  219,  228,  229,    4,  126,
 /*  2200 */   127,  128,  129,  219,  110,  237,  115,  290,  187,   99,
 /*  2210 */   100,  114,  166,  205,  141,    4,  115,  107,  205,  124,
 /*  2220 */   126,  127,  128,  129,  118,  115,  116,  219,   56,  118,
 /*  2230 */   120,    4,  219,  265,  124,    4,  126,  127,  128,  129,
 /*  2240 */   120,  112,  325,   16,  134,  328,  126,  127,  128,  129,
 /*  2250 */   118,  141,  142,  143,  144,   82,   83,  118,  290,   86,
 /*  2260 */    87,   88,   89,   90,   91,   92,   93,  116,   95,   96,
 /*  2270 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  2280 */   116,   54,  205,  205,  118,  114,   47,  177,  205,   46,
 /*  2290 */   180,  119,  182,  183,  205,    4,  219,  219,  126,  127,
 /*  2300 */   128,  129,  219,   76,    4,  218,  291,   16,  219,   82,
 /*  2310 */   205,  191,  271,  234,  120,  234,  314,  316,  204,  316,
 /*  2320 */   126,  127,  128,  129,  219,  109,   99,  100,    4,   63,
 /*  2330 */   205,  120,  205,    4,  107,  141,  205,  126,  127,  128,
 /*  2340 */   129,  204,  115,  116,  219,   54,  219,  120,  204,  204,
 /*  2350 */   219,  124,  206,  126,  127,  128,  129,  126,  127,  128,
 /*  2360 */   129,  134,  205,  205,  208,  206,    4,   76,  141,  142,
 /*  2370 */   143,  144,   77,   82,  211,  205,  219,  219,   16,  205,
 /*  2380 */   121,  170,  205,  205,  106,  228,  229,  205,  205,  219,
 /*  2390 */    99,  100,  274,  219,  237,    4,  219,  219,  107,  118,
 /*  2400 */   233,  219,  219,  115,  177,  106,  115,  180,  177,  182,
 /*  2410 */   183,  120,    4,  117,  299,  124,   54,  126,  127,  128,
 /*  2420 */   129,  318,  294,  175,  184,  134,  126,  127,  128,  129,
 /*  2430 */     4,  173,  141,  142,  143,  144,  279,  172,   76,  259,
 /*  2440 */   261,  260,   16,  174,   82,  171,  262,  290,  263,  263,
 /*  2450 */   126,  127,  128,  129,   44,  126,  127,  128,  129,  326,
 /*  2460 */    27,   99,  100,  274,  326,  118,  158,    4,  177,  107,
 /*  2470 */   170,  180,  280,  182,  183,  184,  280,  115,  116,  255,
 /*  2480 */    54,  331,  120,  230,  195,  146,  124,  230,  126,  127,
 /*  2490 */   128,  129,  168,   37,  240,  232,  134,  168,  205,  145,
 /*  2500 */   230,    4,   76,  141,  142,  143,  144,  230,   82,  233,
 /*  2510 */   230,  120,  219,   16,  230,  240,  230,  126,  127,  128,
 /*  2520 */   129,  228,  229,  115,  230,   99,  100,  208,  120,  208,
 /*  2530 */   237,    4,  141,  107,  126,  127,  128,  129,  233,  177,
 /*  2540 */     4,  115,  180,  233,  182,  183,  120,  274,  205,  141,
 /*  2550 */   124,   54,  126,  127,  128,  129,  118,  305,  265,    4,
 /*  2560 */   134,  205,  219,    4,  156,   33,  306,  141,  142,  143,
 /*  2570 */   144,  228,  229,   76,  184,  219,  168,  169,  176,   82,
 /*  2580 */   237,  259,    4,  290,  228,  229,  282,  205,    4,  126,
 /*  2590 */   127,  128,  129,  237,    4,  262,   99,  100,  263,  247,
 /*  2600 */    80,  219,  282,  177,  107,  259,  180,  262,  182,  183,
 /*  2610 */   228,  229,  115,  150,    4,  285,  263,  120,    4,  237,
 /*  2620 */   115,  124,  279,  126,  127,  128,  129,    4,  288,  146,
 /*  2630 */   282,  134,    4,  290,  259,  279,  205,    4,  141,  142,
 /*  2640 */   143,  144,  282,    4,  247,  208,  290,  274,    4,  118,
 /*  2650 */   219,  259,  208,  126,  127,  128,  129,  274,  118,  228,
 /*  2660 */   229,  279,  126,  127,  128,  129,  139,    4,  237,  249,
 /*  2670 */    77,    4,  290,  249,  177,  274,    4,  180,  249,  182,
 /*  2680 */   183,  126,  127,  128,  129,  126,  127,  128,  129,    4,
 /*  2690 */   249,  155,  178,    4,  300,  118,  265,  119,  309,   20,
 /*  2700 */   141,  274,  309,  118,  126,  127,  128,  129,  274,    4,
 /*  2710 */   126,  127,  128,  129,    4,  118,  126,  127,  128,  129,
 /*  2720 */   311,  290,    4,  311,   17,  141,    4,  291,  256,  231,
 /*  2730 */     4,  141,  302,  258,  302,    4,  126,  127,  128,  129,
 /*  2740 */   126,  127,  128,  129,  295,  190,    4,  262,  262,  126,
 /*  2750 */   127,  128,  129,  273,  126,  127,  128,  129,  242,  126,
 /*  2760 */   127,  128,  129,  119,  141,  126,  127,  128,  129,  141,
 /*  2770 */   126,  127,  128,  129,  164,  231,  238,  232,  164,  258,
 /*  2780 */   141,  289,  259,    4,  311,  203,  256,  221,  221,  126,
 /*  2790 */   127,  128,  129,  126,  127,  128,  129,    4,  126,  127,
 /*  2800 */   128,  129,  221,  170,  141,  303,  254,  221,  304,  292,
 /*  2810 */   248,  126,  127,  128,  129,  126,  127,  128,  129,  329,
 /*  2820 */   272,  315,  239,  156,  119,   71,  239,  239,  228,  228,
 /*  2830 */   141,  126,  127,  128,  129,  243,  126,  127,  128,  129,
 /*  2840 */   332,  332,  332,  125,  126,  127,  128,  129,  126,  127,
 /*  2850 */   128,  129,  126,  127,  128,  129,  332,  126,  127,  128,
 /*  2860 */   129,  119,  205,  191,  332,  205,  332,  332,  126,  127,
 /*  2870 */   128,  129,  332,  332,  189,  332,  219,  332,  205,  219,
 /*  2880 */   332,  332,  332,  332,  332,  228,  229,  177,  228,  229,
 /*  2890 */   332,  332,  219,  332,  237,  332,  332,  237,  332,  177,
 /*  2900 */   332,  228,  229,  177,  125,  126,  127,  128,  129,  178,
 /*  2910 */   237,  205,  332,  205,  332,  332,  205,  332,  332,  126,
 /*  2920 */   127,  128,  129,  332,  332,  219,  332,  219,  205,  332,
 /*  2930 */   219,  332,  205,  332,  228,  229,  228,  229,  332,  228,
 /*  2940 */   229,  332,  219,  237,  205,  237,  219,  290,  237,  332,
 /*  2950 */   290,  228,  229,  332,  332,  228,  229,  205,  219,  332,
 /*  2960 */   237,  205,  332,  290,  237,  332,  332,  228,  229,  332,
 /*  2970 */   332,  219,  332,  332,  332,  219,  237,  332,  332,  332,
 /*  2980 */   228,  229,  332,  332,  228,  229,  205,  332,  332,  237,
 /*  2990 */   332,  332,  332,  237,  332,  332,  290,  332,  290,  332,
 /*  3000 */   219,  290,  205,  332,  332,  332,  332,  205,  332,  228,
 /*  3010 */   229,  332,  332,  290,  332,  332,  219,  290,  237,  332,
 /*  3020 */   332,  219,  332,  332,  205,  228,  229,  332,  332,  290,
 /*  3030 */   228,  229,  332,  332,  237,  332,  205,  332,  219,  237,
 /*  3040 */   205,  332,  290,  205,  332,  332,  290,  228,  229,  332,
 /*  3050 */   219,  332,  332,  332,  219,  332,  237,  219,  332,  228,
 /*  3060 */   229,  332,  332,  228,  229,  205,  228,  229,  237,  332,
 /*  3070 */   332,  290,  237,  332,  332,  237,  205,  332,  332,  219,
 /*  3080 */   205,  332,  205,  332,  332,  332,  332,  290,  228,  229,
 /*  3090 */   219,  332,  290,  332,  219,  332,  219,  237,  332,  228,
 /*  3100 */   229,  332,  332,  228,  229,  228,  229,  332,  237,  290,
 /*  3110 */   205,  332,  237,  205,  237,  205,  332,  205,  332,  332,
 /*  3120 */   332,  290,  332,  332,  219,  290,  332,  219,  290,  219,
 /*  3130 */   332,  219,  332,  228,  229,  332,  228,  229,  228,  229,
 /*  3140 */   228,  229,  237,  332,  332,  237,  205,  237,  205,  237,
 /*  3150 */   290,  332,  205,  332,  332,  332,  332,  332,  332,  332,
 /*  3160 */   219,  290,  219,  332,  332,  290,  219,  290,  332,  228,
 /*  3170 */   229,  228,  229,  205,  332,  228,  229,  332,  237,  332,
 /*  3180 */   237,  332,  332,  332,  237,  332,  332,  219,  332,  332,
 /*  3190 */   205,  332,  205,  332,  332,  290,  228,  229,  290,  332,
 /*  3200 */   290,  332,  290,  332,  219,  237,  219,  332,  332,  332,
 /*  3210 */   332,  332,  332,  228,  229,  228,  229,  332,  332,  332,
 /*  3220 */   332,  332,  237,  332,  237,  332,  332,  205,  332,  332,
 /*  3230 */   205,  290,  205,  290,  332,  332,  332,  290,  332,  332,
 /*  3240 */   332,  219,  332,  332,  219,  332,  219,  332,  332,  205,
 /*  3250 */   228,  229,  332,  228,  229,  228,  229,  332,  290,  237,
 /*  3260 */   205,  332,  237,  219,  237,  205,  332,  332,  332,  332,
 /*  3270 */   332,  205,  228,  229,  219,  290,  332,  290,  332,  219,
 /*  3280 */   332,  237,  205,  228,  229,  219,  205,  332,  228,  229,
 /*  3290 */   332,  332,  237,  332,  228,  229,  219,  237,  332,  332,
 /*  3300 */   219,  332,  332,  237,  332,  228,  229,  332,  332,  228,
 /*  3310 */   229,  332,  290,  332,  237,  290,  205,  290,  237,  205,
 /*  3320 */   332,  332,  332,  205,  332,  332,  332,  332,  332,  332,
 /*  3330 */   219,  332,  332,  219,  290,  332,  332,  219,  332,  228,
 /*  3340 */   229,  332,  228,  229,  332,  290,  228,  229,  237,  332,
 /*  3350 */   290,  237,  205,  332,  205,  237,  290,  332,  205,  332,
 /*  3360 */   332,  332,  332,  332,  332,  332,  219,  290,  219,  332,
 /*  3370 */   332,  290,  219,  205,  332,  228,  229,  228,  229,  205,
 /*  3380 */   332,  228,  229,  332,  237,  332,  237,  219,  332,  332,
 /*  3390 */   237,  332,  332,  219,  332,  332,  228,  229,  205,  332,
 /*  3400 */   332,  290,  228,  229,  290,  237,  332,  332,  290,  332,
 /*  3410 */   332,  237,  219,  332,  332,  332,  332,  332,  332,  332,
 /*  3420 */   332,  228,  229,  332,  332,  332,  332,  332,  332,  332,
 /*  3430 */   237,  332,  332,  332,  332,  332,  332,  290,  332,  290,
 /*  3440 */   332,  332,  332,  290,  332,  332,  332,  332,  332,  332,
 /*  3450 */   332,  332,  332,  332,  332,  332,  332,  332,  290,  332,
 /*  3460 */   332,  332,  332,  332,  290,  332,  332,  332,  332,  332,
 /*  3470 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3480 */   332,  332,  332,  290,
};
#define YY_SHIFT_USE_DFLT (-104)
#define YY_SHIFT_COUNT (556)
#define YY_SHIFT_MIN   (-103)
#define YY_SHIFT_MAX   (2793)
static const short yy_shift_ofst[] = {
 /*     0 */  1396,  707,  888, 1166,  824, 1368, 1247, 1126, 2362, 2362,
 /*    10 */  1742,  214, 2291, 2426, 2426, 2426, 2426, 2426, 2426, 2426,
 /*    20 */  2426, 2426,  278,   -4,  105, 2227, 2110, 1989, 1868, 2426,
 /*    30 */  2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2497,
 /*    40 */  2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426,
 /*    50 */  2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426,
 /*    60 */  2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426, 2426,
 /*    70 */  2426, 2426, 2426, 2426, 2426, 2022,  892,  892,  790,  808,
 /*    80 */   808, 2779, 2408, 2172, 1353, 2779,  126, 2722, 2722, 2722,
 /*    90 */  2742, 2722, 2793, 1096, 1096,  775,  341,  174,  834, 2391,
 /*   100 */  2120, 2211,  854, 2194, 1826, 2073, 1826, 1845,  727, 1058,
 /*   110 */  1353, 1336, 2731, 2726, 2726, 2726, 2726, 2726, 2722, 2793,
 /*   120 */  2793,  714,  955,  775, 1796, 1796, 1181,  523,  523,  -44,
 /*   130 */    65,  431,  645,  870, 1320, 1223,  928, 1207, 1311,   88,
 /*   140 */  1190,  114,  323,  924, 2718, 2710, 2705, 2689, 2685, 2672,
 /*   150 */  2633, 2667, 2663, 2644, 2639, 1594, 2628, 2623, 2614, 2610,
 /*   160 */  2590, 2584, 2555, 2536, 2578, 2559, 2527, 2463,  414, 1147,
 /*   170 */  2329, 2324, 2300, 1009, 2231, 1810,  327,  409, 1462, 2094,
 /*   180 */  1749, 1497,  630, 2793, 2793,  349,  349,  709, 1154,   -2,
 /*   190 */    -2,   -2,  298,  298,  225,   59, 1008, 1008,  194,  800,
 /*   200 */  1202, 1202, 1202,  382, 1181, 2754, 2754, 2754, 2754, -104,
 /*   210 */  -104, -104,  426,  604,  604,  604,  604,  604,  604,  604,
 /*   220 */   604,  604,  604,  576,  391, 1023,  996, 1765, 1736, 1704,
 /*   230 */  1675, 1644, 1613, 1582, 1551, 1513, 1476, 1436, 1315,  -72,
 /*   240 */   646, 1066, 1828, 1800, 1932, 2173, 2173,  488,  -16,  -16,
 /*   250 */   -16,  -16,  -16,  -16,   48,  265,   30,  367,  110,  110,
 /*   260 */   520,  516,   51,   51,   51,  772, 1171, 1169,  -54,  375,
 /*   270 */   732,  562,  771,  648,  649,  616,  626,  100,  518,  763,
 /*   280 */   746, 1384,  943,  148, 1307,  509,  235, 1054,  512,  512,
 /*   290 */   212,  479,  857,  235,  851,  851,  153, 2707, 2707, 2597,
 /*   300 */  2585, 2679, 2679, 2577, 2514, 2593, 2593, 2593, 2593, 2540,
 /*   310 */  2295, 2248, 2531, 2295, 2520, 2402, 2248, 2402, 2483, 2505,
 /*   320 */  2269, 2274, 2402, 2248, 2520, 2269, 2274, 2402, 2248, 2390,
 /*   330 */  2532, 2438, 2295, 2288, 2295, 2288, 2339, 2339, 2339, 2339,
 /*   340 */  2456, 2288, 2339, 2354, 2339, 2456, 2339, 2339, 2289, 2308,
 /*   350 */  2347, 2433, 2433, 2410, 2410, 2269, 2274, 2269, 2258, 2265,
 /*   360 */  2248, 2240, 2296, 2299, 2288, 2278, 2278, 2281, 2259, 2295,
 /*   370 */  2266, 2266, 2216, 2216, 2216, 2216, -104, -104, -104, -104,
 /*   380 */  -104, -104, -104, -104, -104, -104,  736,  483,  144,  798,
 /*   390 */    12,  568,   97,  291, 1232, 1127,  807, 1060,   41,  828,
 /*   400 */  1018,  697,  703,  543,  522,  452,   49,  449,   76,  293,
 /*   410 */  -103,  223,  199,   75,  118,  106,  -23,  -81,  481, 2243,
 /*   420 */  2239, 2129, 2166, 2171, 2164, 2151, 2139, 2132, 2111, 2095,
 /*   430 */  2106, 2101, 2046, 2097, 2091, 2048, 2021, 2141, 2067, 2136,
 /*   440 */  2123, 2143, 2059, 2054, 2007, 1980, 2004, 2119, 2134, 2027,
 /*   450 */  1962, 2045, 2039, 2023, 2019, 1959, 1986, 1973, 1937, 2093,
 /*   460 */  1957, 1981, 1970, 1950, 1998, 1961, 1923, 1920, 1953, 2009,
 /*   470 */  1941, 1938, 1925, 1902, 1958, 1992, 1867, 1872, 1993, 1866,
 /*   480 */  1931, 1943, 1853, 1944, 1776, 1833, 1824, 1899, 1764, 1797,
 /*   490 */  1735, 1778, 1769,  336, 1719,  336, 1728, 1710, 1702, 1697,
 /*   500 */  1621, 1672, 1653, 1643, 1628, 1714, 1574, 1279, 1693, 1683,
 /*   510 */  1652, 1647, 1606, 1576, 1603, 1546, 1525, 1583, 1540, 1433,
 /*   520 */  1398, 1403, 1370, 1366, 1470, 1279, 1293, 1278, 1201, 1135,
 /*   530 */  1130, 1156, 1032, 1219,  916, 1044,  975,  984,  916,  893,
 /*   540 */   890,  841,  813,  690,  659,  632,  610,  600,  447,  501,
 /*   550 */   274,  336,  268,  116,    3,  -10,  -86,
};
#define YY_REDUCE_USE_DFLT (-217)
#define YY_REDUCE_COUNT (385)
#define YY_REDUCE_MIN   (-216)
#define YY_REDUCE_MAX   (3193)
static const short yy_reduce_ofst[] = {
 /*     0 */   860,  993, 1854,  517, 1917,  657,  173, 1892, 1835,  580,
 /*    10 */    11, 2431, 1093, 2382, 2356, 2343, 2293, 2157, 1052, 1968,
 /*    20 */  1779,  582,  112, 3193, 3174, 3168, 3153, 3149, 3147, 3118,
 /*    30 */  3114, 3111, 3081, 3077, 3066, 3060, 3055, 3044, 3027, 3025,
 /*    40 */  3022, 2987, 2985, 2968, 2947, 2943, 2941, 2912, 2910, 2908,
 /*    50 */  2905, 2877, 2875, 2871, 2860, 2838, 2835, 2831, 2819, 2802,
 /*    60 */  2797, 2781, 2756, 2752, 2739, 2727, 2723, 2711, 2708, 2706,
 /*    70 */  2673, 2660, 2657, 1857,  -31, 1086,   98,  -30,  131,  750,
 /*    80 */    81,  351, 1163, 1341, 1005,  435,  529, 1757, 1741, 1254,
 /*    90 */   683,  988,   31,  422, -125, -216,   37,  905, 1173, 1761,
 /*   100 */  1740, 1738, 1378, 1284, 1758, 1253, 1302, 1180, 1030, 1073,
 /*   110 */   861,  256,  620, 1160, 1158, 1085, 1083,  493,  585,  862,
 /*   120 */   243,  557,  965,  755,  693,  642, -182, 1460, 1339, 1150,
 /*   130 */  1141, 2183, 2182, 2131, 1842, 1842, 2178, 2177, 2174, 2170,
 /*   140 */  2158, 1842, 2131, 2127, 2125, 2105, 2089, 1984, 1842, 1984,
 /*   150 */  1984, 1984, 1984, 1842, 2083, 1842, 2013, 2013, 2078, 2077,
 /*   160 */  2013, 2008, 1842, 1984, 1984, 1976, 1972, 1965, 1956, 1955,
 /*   170 */  1934, 1922, 1876, 1873, 1865, 1847, 1842, 1841, 1785, 1759,
 /*   180 */  1737, 1593, 1533, 1471, 1342, 1374,  584, 1424, 1220, 1287,
 /*   190 */  1285,  923, 1191, 1162,  990, 1258, 1146, 1129, 1144, 1119,
 /*   200 */  1196, 1176, 1167, 1049,  948, 1043, 1034,  894, -210,  951,
 /*   210 */   876,  277, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
 /*   220 */  2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
 /*   230 */  2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
 /*   240 */  2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
 /*   250 */  2015, 2015, 2015, 2015, 2015, 2015, 2015, 2592, 2601, 2600,
 /*   260 */  2506, 2506, 2588, 2587, 2583, 2548, 2490, 2562, 2552, 2517,
 /*   270 */  2504, 2502, 2586, 2581, 2567, 2015, 2566, 2530, 2582, 2473,
 /*   280 */  2523, 2492, 2521, 2545, 2516, 2538, 2544, 2480, 2486, 2485,
 /*   290 */  2475, 2472, 2449, 2498, 2432, 2430, 2436, 2412, 2409, 2434,
 /*   300 */  2427, 2393, 2389, 2401, 2394, 2441, 2429, 2424, 2420, 2383,
 /*   310 */  2444, 2392, 2373, 2437, 2397, 2360, 2375, 2348, 2340, 2330,
 /*   320 */  2353, 2345, 2320, 2346, 2352, 2335, 2333, 2304, 2322, 2260,
 /*   330 */  2252, 2273, 2321, 2310, 2319, 2305, 2294, 2286, 2284, 2280,
 /*   340 */  2275, 2276, 2277, 2263, 2270, 2254, 2257, 2253, 2150, 2224,
 /*   350 */  2189, 2138, 2133, 2196, 2192, 2186, 2184, 2185, 2179, 2181,
 /*   360 */  2180, 2128, 2103, 2115, 2167, 2015, 2015, 2118, 2163, 2156,
 /*   370 */  2159, 2146, 2145, 2144, 2137, 2114, 2003, 2001, 2002, 2081,
 /*   380 */  2079, 2041, 2015, 2015, 2015, 2087,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   909, 1244, 1244, 1370, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    10 */  1370, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    20 */  1244, 1244, 1370, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    30 */  1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    40 */  1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    50 */  1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    60 */  1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*    70 */  1244, 1244, 1244, 1244, 1244, 1095, 1412, 1412, 1412, 1389,
 /*    80 */  1389, 1412, 1088, 1412,  937, 1412, 1412, 1412, 1412, 1412,
 /*    90 */  1412, 1412, 1412, 1412, 1412,  961, 1084,  950, 1095, 1412,
 /*   100 */  1412, 1412, 1412, 1412, 1166, 1181, 1166, 1158, 1147, 1412,
 /*   110 */  1412, 1412, 1282, 1174, 1174, 1174, 1174, 1174, 1412, 1412,
 /*   120 */  1412, 1034, 1208, 1412, 1210, 1209, 1412, 1132, 1132, 1246,
 /*   130 */  1412, 1335, 1340, 1202, 1412, 1412, 1412, 1412, 1412, 1167,
 /*   140 */  1412, 1096, 1202, 1412, 1412, 1350, 1412, 1412, 1412, 1412,
 /*   150 */  1412, 1412, 1412, 1412, 1412, 1412, 1182, 1159, 1412, 1412,
 /*   160 */  1148, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*   170 */  1412, 1412, 1412, 1412, 1412, 1204, 1412, 1412, 1412, 1412,
 /*   180 */  1412, 1412,  915, 1412, 1412, 1412, 1412, 1084, 1389, 1084,
 /*   190 */  1084, 1084, 1389, 1389,  947,  955, 1389, 1389,  909, 1370,
 /*   200 */  1121, 1121, 1121, 1126, 1412, 1370, 1370, 1370, 1370, 1363,
 /*   210 */  1074, 1074, 1142, 1165, 1164, 1163, 1162, 1101, 1152, 1140,
 /*   220 */  1144, 1143, 1259, 1246, 1246, 1246, 1246, 1246, 1246, 1246,
 /*   230 */  1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246,
 /*   240 */  1246, 1246, 1246, 1246, 1212, 1226, 1211, 1219, 1231, 1220,
 /*   250 */  1225, 1224, 1223, 1214, 1213, 1215, 1216, 1412, 1412, 1412,
 /*   260 */  1412, 1412, 1412, 1412, 1412, 1087, 1412, 1412, 1056, 1412,
 /*   270 */  1412, 1309, 1412, 1412,  963, 1217, 1412, 1072,  918, 1354,
 /*   280 */  1151, 1248, 1085, 1001, 1025,  985, 1132, 1103, 1126, 1126,
 /*   290 */  1085, 1072, 1254, 1132, 1412, 1412, 1246, 1354, 1354, 1105,
 /*   300 */  1105, 1334, 1334, 1105, 1282, 1047, 1047, 1047, 1047, 1105,
 /*   310 */   944, 1151, 1105,  944, 1038, 1154, 1151, 1154, 1187, 1170,
 /*   320 */  1141, 1126, 1154, 1151, 1038, 1141, 1126, 1154, 1151, 1316,
 /*   330 */  1314, 1105,  944, 1267,  944, 1267, 1036, 1036, 1036, 1036,
 /*   340 */  1017, 1267, 1036, 1001, 1036, 1017, 1036, 1036, 1408, 1412,
 /*   350 */  1105, 1399, 1399, 1135, 1135, 1141, 1126, 1141, 1139, 1136,
 /*   360 */  1151, 1412, 1412, 1273, 1267, 1230, 1218, 1105, 1020,  944,
 /*   370 */   926,  926,  914,  914,  914,  914, 1367, 1367, 1363, 1003,
 /*   380 */  1003, 1090, 1229, 1228, 1227,  972, 1245, 1412, 1412, 1412,
 /*   390 */  1412, 1412, 1412, 1283, 1412, 1412, 1412, 1412, 1412, 1109,
 /*   400 */  1412, 1412, 1109, 1109, 1412, 1412, 1412, 1412, 1412, 1412,
 /*   410 */  1412, 1412, 1412, 1412, 1373, 1412, 1412, 1412, 1412, 1412,
 /*   420 */   910, 1412, 1107, 1412, 1412, 1412, 1107, 1107, 1107, 1412,
 /*   430 */  1107, 1357, 1412, 1412, 1412, 1412, 1412, 1412, 1313, 1312,
 /*   440 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1171,
 /*   450 */  1412, 1412, 1412, 1412, 1412, 1412, 1155, 1110, 1412, 1301,
 /*   460 */  1412, 1107, 1412, 1412, 1412, 1107, 1412, 1412, 1412, 1412,
 /*   470 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*   480 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*   490 */  1412, 1412, 1412, 1060, 1066, 1061, 1412, 1412, 1412, 1200,
 /*   500 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1137, 1412, 1412,
 /*   510 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*   520 */  1412, 1412, 1405, 1127, 1412, 1257, 1412, 1412, 1412, 1412,
 /*   530 */  1247, 1412, 1245, 1412, 1372, 1412, 1412, 1412, 1371, 1412,
 /*   540 */  1412, 1412, 1412, 1412, 1247, 1412, 1412, 1201, 1200, 1412,
 /*   550 */  1412, 1059,  958,  933, 1412,  924, 1412,  906,  911, 1356,
 /*   560 */  1353, 1346, 1345, 1355, 1349, 1351, 1347, 1348, 1344, 1352,
 /*   570 */  1343, 1341, 1342, 1339, 1337, 1336, 1338, 1333, 1329, 1289,
 /*   580 */  1287, 1285, 1294, 1293, 1292, 1291, 1290, 1286, 1284, 1288,
 /*   590 */  1280, 1279, 1177, 1156, 1145, 1054, 1328, 1326, 1327, 1278,
 /*   600 */  1276, 1277, 1053, 1052, 1051, 1046, 1045, 1044, 1043, 1360,
 /*   610 */  1369, 1368, 1366, 1365, 1364, 1358, 1359, 1265, 1264, 1262,
 /*   620 */  1261, 1263,  946, 1305, 1308, 1307, 1306, 1311, 1310, 1303,
 /*   630 */  1315, 1320, 1319, 1324, 1323, 1322, 1321, 1318, 1300, 1186,
 /*   640 */  1185, 1183, 1179, 1190, 1189, 1188, 1178, 1180, 1184, 1161,
 /*   650 */  1169, 1168, 1157, 1160, 1039, 1150, 1146, 1114, 1112, 1149,
 /*   660 */  1113, 1111, 1055, 1304, 1050, 1049, 1048,  945,  936, 1108,
 /*   670 */   935,  934,  949, 1023, 1024, 1032, 1035, 1030, 1033, 1029,
 /*   680 */  1028, 1027, 1031, 1026, 1022,  952,  951,  962, 1016,  999,
 /*   690 */   988,  954,  990,  987,  986,  991, 1008, 1007, 1014, 1013,
 /*   700 */  1012, 1011, 1010, 1006, 1009, 1005, 1004,  992,  984,  983,
 /*   710 */  1002,  982, 1019, 1018, 1015,  981, 1042, 1041, 1040, 1037,
 /*   720 */   980,  979,  978,  977,  976,  975, 1242, 1241, 1411, 1407,
 /*   730 */  1410, 1409, 1406, 1243, 1240, 1250, 1234, 1232, 1057, 1069,
 /*   740 */  1068, 1067, 1064, 1079, 1077, 1076, 1075, 1120, 1119, 1118,
 /*   750 */  1117, 1116, 1115, 1100, 1098, 1093, 1092, 1099, 1097, 1094,
 /*   760 */  1124, 1125, 1123, 1122, 1091, 1083, 1081, 1082, 1080, 1176,
 /*   770 */  1173, 1175, 1172, 1102, 1104, 1089, 1086, 1073, 1387, 1385,
 /*   780 */  1388, 1386, 1384, 1392, 1394, 1393, 1398, 1396, 1395, 1391,
 /*   790 */  1404, 1403, 1402, 1401, 1400, 1390, 1397, 1383, 1382, 1381,
 /*   800 */  1380, 1129, 1134, 1133, 1128, 1063, 1062, 1325, 1238, 1197,
 /*   810 */  1239, 1233, 1245, 1237, 1378, 1376, 1379, 1375, 1374, 1270,
 /*   820 */  1272, 1275, 1274, 1271, 1131, 1130, 1269, 1268, 1377, 1236,
 /*   830 */  1207,  968,  966,  967, 1297, 1296, 1299, 1298, 1295,  970,
 /*   840 */   969,  965,  964, 1205, 1199, 1198, 1222, 1221, 1206, 1196,
 /*   850 */   957,  956, 1203, 1195, 1194, 1193, 1065, 1058, 1235, 1192,
 /*   860 */  1106, 1191,  998,  997,  996,  995,  994,  993, 1071, 1070,
 /*   870 */   974,  989,  973,  971,  948,  938,  943,  941,  942,  940,
 /*   880 */   939,  931,  928,  930,  927,  932,  929,  925,  923,  922,
 /*   890 */   921,  920,  919,  960,  959,  958,  953,  917,  916,  913,
 /*   900 */   912,  908,  907,  905,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /* MATERIALIZED => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*     WITHIN => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
    4,  /*     FILTER => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GROUPS",        "IGNORE",      
  "IMMEDIATE",     "INITIALLY",     "INSTEAD",       "LAST",        
  "LIKE_KW",       "MATCH",         "MATERIALIZED",  "NO",          
  "NULLS",         "OTHERS",        "PLAN",          "QUERY",       
  "KEY",           "OF",            "OFFSET",        "PARTITION",   
  "PRAGMA",        "PRECEDING",     "RAISE",         "RANGE",       
  "RECURSIVE",     "RELEASE",       "REPLACE",       "RESTRICT",    
  "ROW",           "ROWS",          "ROLLBACK",      "SAVEPOINT",   
  "TEMP",          "TIES",          "TRIGGER",       "UNBOUNDED",   
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHIN",        "WITHOUT",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "IF",            "FILTER",        "ANY",         
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "PTR",           "COLLATE",       "BITNOT",      
  "SEMI",          "TRANSACTION",   "ID_TRANS",      "COMMIT",      
  "TO",            "CREATE",        "TABLE",         "LP",          
  "RP",            "AS",            "DOT",           "ID_TAB_NEW",  
  "ID_DB",         "COMMA",         "CTX_ROWID_KW",  "CTX_STRICT_KW",
  "EXISTS",        "ID_COL_NEW",    "INDEXED",       "GENERATED",   
  "STRING",        "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC", 
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "ID_CONSTR",   
  "ID_COLLATE",    "ID_TAB",        "INTEGER",       "FLOAT",       
  "BLOB",          "AUTOINCR",      "ON",            "INSERT",      
  "DELETE",        "UPDATE",        "ID_FK_MATCH",   "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "ID_VIEW_NEW", 
  "ID_VIEW",       "SELECT",        "VALUES",        "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "DISTINCT",    
  "ID_ALIAS",      "FROM",          "USING",         "CTX_JOIN_EXPR",
  "JOIN",          "ID_JOIN_OPTS",  "ID_IDX",        "ORDER",       
  "GROUP",         "HAVING",        "LIMIT",         "WHERE",       
  "RETURNING",     "ID_COL",        "INTO",          "NOTHING",     
  "ID_FN",         "ID_ERR_MSG",    "VARIABLE",      "CASE",        
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "ID_IDX_NEW",    "ID_PRAGMA",     "ID_TRIG_NEW",   "ID_TRIG",     
  "ALTER",         "ADD",           "WINDOW",        "OVER",        
  "error",         "cmd",           "input",         "cmdlist",     
  "ecmd",          "explain",       "cmdx",          "transtype",   
  "trans_opt",     "nm",            "savepoint_opt",  "temp",        
  "ifnotexists",   "fullname",      "columnlist",    "conslist_opt",
  "table_options",  "select",        "table_option",  "column",      
  "columnid",      "type",          "carglist",      "id",          
  "id_opt",        "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "gen_always",    "tnm",           "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tconscomma",    "tcons",       
  "idxlist",       "defer_subclause_opt",  "resolvetype",   "orconf",      
  "raisetype",     "ifexists",      "select_stmt",   "with",        
  "selectnowith",  "oneselect",     "multiselect_op",  "values",      
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "window_clause",  "nexprlist",     "exprlist",      "sclp",        
  "as",            "joinsrc",       "singlesrc",     "seltablist",  
  "joinop",        "joinconstr_opt",  "dbnm",          "indexed_opt", 
  "idlist",        "xfullname",     "indexed_by",    "sortlist",    
  "nulls",         "delete_stmt",   "returning",     "update_stmt", 
  "setlist",       "idlist_opt",    "insert_stmt",   "insert_cmd",  
  "upsert",        "rp_opt",        "exprx",         "not_opt",     
  "likeop",        "case_operand",  "case_exprlist",  "case_else",   
  "filter_over",   "uniqueflag",    "idxlist_single",  "collate",     
  "vinto",         "nmnum",         "number",        "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd_list",
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "kwcolumn_opt",
  "create_vtab",   "vtabarglist",   "vtabarg",       "vtabargtoken",
  "anylist",       "wqlist",        "wqas",          "wqcte",       
  "windowdefn_list",  "windowdefn",    "window",        "frame_opt",   
  "range_or_rows",  "frame_bound_s",  "frame_exclude_opt",  "frame_bound_e",
  "frame_bound",   "frame_exclude",  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= table_option",
 /*  35 */ "table_options ::= table_options COMMA table_option",
 /*  36 */ "table_option ::= WITHOUT nm",
 /*  37 */ "table_option ::= nm",
 /*  38 */ "table_option ::= WITHOUT CTX_ROWID_KW",
 /*  39 */ "table_option ::= CTX_STRICT_KW",
 /*  40 */ "ifnotexists ::=",
 /*  41 */ "ifnotexists ::= IF NOT EXISTS",
 /*  42 */ "temp ::= TEMP",
 /*  43 */ "temp ::=",
 /*  44 */ "columnlist ::= columnlist COMMA column",
 /*  45 */ "columnlist ::= column",
 /*  46 */ "column ::= columnid type carglist",
 /*  47 */ "columnid ::= nm",
 /*  48 */ "columnid ::= ID_COL_NEW",
 /*  49 */ "id ::= ID|INDEXED|GENERATED",
 /*  50 */ "id_opt ::= id",
 /*  51 */ "id_opt ::=",
 /*  52 */ "ids ::= ID",
 /*  53 */ "ids ::= STRING",
 /*  54 */ "nm ::= id",
 /*  55 */ "nm ::= STRING",
 /*  56 */ "nm ::= JOIN_KW",
 /*  57 */ "type ::=",
 /*  58 */ "type ::= typetoken",
 /*  59 */ "typetoken ::= typename",
 /*  60 */ "typetoken ::= typename LP signed RP",
 /*  61 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  62 */ "typename ::= ids",
 /*  63 */ "typename ::= typename ids",
 /*  64 */ "typename ::= ID_COL_TYPE",
 /*  65 */ "signed ::= plus_num",
 /*  66 */ "signed ::= minus_num",
 /*  67 */ "carglist ::= carglist ccons",
 /*  68 */ "carglist ::=",
 /*  69 */ "ccons ::= CONSTRAINT nm",
 /*  70 */ "ccons ::= DEFAULT term",
 /*  71 */ "ccons ::= DEFAULT LP expr RP",
 /*  72 */ "ccons ::= DEFAULT PLUS term",
 /*  73 */ "ccons ::= DEFAULT MINUS term",
 /*  74 */ "ccons ::= DEFAULT id",
 /*  75 */ "ccons ::= DEFAULT CTIME_KW",
 /*  76 */ "ccons ::= NULL onconf",
 /*  77 */ "ccons ::= NOT NULL onconf",
 /*  78 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  79 */ "ccons ::= UNIQUE onconf",
 /*  80 */ "ccons ::= CHECK LP expr RP",
 /*  81 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  82 */ "ccons ::= defer_subclause",
 /*  83 */ "ccons ::= COLLATE ids",
 /*  84 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  85 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  86 */ "ccons ::= COLLATE ID_COLLATE",
 /*  87 */ "ccons ::= REFERENCES ID_TAB",
 /*  88 */ "ccons ::= CHECK LP RP",
 /*  89 */ "term ::= NULL",
 /*  90 */ "term ::= INTEGER",
 /*  91 */ "term ::= FLOAT",
 /*  92 */ "term ::= STRING|BLOB",
 /*  93 */ "tnm ::= term",
 /*  94 */ "tnm ::= nm",
 /*  95 */ "gen_always ::= GENERATED ALWAYS",
 /*  96 */ "gen_always ::=",
 /*  97 */ "autoinc ::=",
 /*  98 */ "autoinc ::= AUTOINCR",
 /*  99 */ "refargs ::=",
 /* 100 */ "refargs ::= refargs refarg",
 /* 101 */ "refarg ::= MATCH nm",
 /* 102 */ "refarg ::= ON INSERT refact",
 /* 103 */ "refarg ::= ON DELETE refact",
 /* 104 */ "refarg ::= ON UPDATE refact",
 /* 105 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 106 */ "refact ::= SET NULL",
 /* 107 */ "refact ::= SET DEFAULT",
 /* 108 */ "refact ::= CASCADE",
 /* 109 */ "refact ::= RESTRICT",
 /* 110 */ "refact ::= NO ACTION",
 /* 111 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 112 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 113 */ "init_deferred_pred_opt ::=",
 /* 114 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 115 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 116 */ "conslist_opt ::=",
 /* 117 */ "conslist_opt ::= COMMA conslist",
 /* 118 */ "conslist ::= conslist tconscomma tcons",
 /* 119 */ "conslist ::= tcons",
 /* 120 */ "tconscomma ::= COMMA",
 /* 121 */ "tconscomma ::=",
 /* 122 */ "tcons ::= CONSTRAINT nm",
 /* 123 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 124 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 125 */ "tcons ::= CHECK LP expr RP onconf",
 /* 126 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 127 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 128 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 129 */ "tcons ::= CHECK LP RP onconf",
 /* 130 */ "defer_subclause_opt ::=",
 /* 131 */ "defer_subclause_opt ::= defer_subclause",
 /* 132 */ "onconf ::=",
 /* 133 */ "onconf ::= ON CONFLICT resolvetype",
 /* 134 */ "orconf ::=",
 /* 135 */ "orconf ::= OR resolvetype",
 /* 136 */ "resolvetype ::= raisetype",
 /* 137 */ "resolvetype ::= IGNORE",
 /* 138 */ "resolvetype ::= REPLACE",
 /* 139 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 140 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 141 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 142 */ "ifexists ::= IF EXISTS",
 /* 143 */ "ifexists ::=",
 /* 144 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 145 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 146 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 147 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 148 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 149 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 150 */ "cmd ::= select_stmt",
 /* 151 */ "select_stmt ::= select",
 /* 152 */ "select ::= with selectnowith",
 /* 153 */ "selectnowith ::= oneselect",
 /* 154 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 155 */ "selectnowith ::= selectnowith multiselect_op values",
 /* 156 */ "selectnowith ::= values",
 /* 157 */ "selectnowith ::= selectnowith COMMA values",
 /* 158 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 159 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 160 */ "values ::= VALUES LP nexprlist RP",
 /* 161 */ "values ::= values COMMA LP exprlist RP",
 /* 162 */ "multiselect_op ::= UNION",
 /* 163 */ "multiselect_op ::= UNION ALL",
 /* 164 */ "multiselect_op ::= EXCEPT",
 /* 165 */ "multiselect_op ::= INTERSECT",
 /* 166 */ "distinct ::= DISTINCT",
 /* 167 */ "distinct ::= ALL",
 /* 168 */ "distinct ::=",
 /* 169 */ "sclp ::= selcollist COMMA",
 /* 170 */ "sclp ::=",
 /* 171 */ "selcollist ::= sclp expr as",
 /* 172 */ "selcollist ::= sclp STAR",
 /* 173 */ "selcollist ::= sclp tnm DOT STAR",
 /* 174 */ "selcollist ::= sclp",
 /* 175 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 176 */ "as ::= AS nm",
 /* 177 */ "as ::= ids",
 /* 178 */ "as ::= AS ID_ALIAS",
 /* 179 */ "as ::= ID_ALIAS",
 /* 180 */ "as ::=",
 /* 181 */ "from ::=",
 /* 182 */ "from ::= FROM joinsrc",
 /* 183 */ "joinsrc ::= singlesrc seltablist",
 /* 184 */ "joinsrc ::=",
 /* 185 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 186 */ "seltablist ::=",
 /* 187 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 188 */ "singlesrc ::= LP select RP as",
 /* 189 */ "singlesrc ::= LP joinsrc RP as",
 /* 190 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 191 */ "singlesrc ::=",
 /* 192 */ "singlesrc ::= nm DOT",
 /* 193 */ "singlesrc ::= nm DOT ID_TAB",
 /* 194 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 195 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 196 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 197 */ "joinconstr_opt ::= ON expr",
 /* 198 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 199 */ "joinconstr_opt ::=",
 /* 200 */ "joinconstr_opt ::= ON CTX_JOIN_EXPR",
 /* 201 */ "dbnm ::=",
 /* 202 */ "dbnm ::= DOT nm",
 /* 203 */ "fullname ::= nm",
 /* 204 */ "fullname ::= nm DOT nm",
 /* 205 */ "xfullname ::= nm",
 /* 206 */ "xfullname ::= nm DOT nm",
 /* 207 */ "xfullname ::= nm DOT nm AS nm",
 /* 208 */ "xfullname ::= nm AS nm",
 /* 209 */ "xfullname ::= nm DOT nm AS ID_ALIAS",
 /* 210 */ "xfullname ::= nm AS ID_ALIAS",
 /* 211 */ "joinop ::= COMMA",
 /* 212 */ "joinop ::= JOIN",
 /* 213 */ "joinop ::= JOIN_KW JOIN",
 /* 214 */ "joinop ::= JOIN_KW nm JOIN",
 /* 215 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 216 */ "joinop ::= ID_JOIN_OPTS",
 /* 217 */ "indexed_opt ::=",
 /* 218 */ "indexed_opt ::= indexed_by",
 /* 219 */ "indexed_by ::= INDEXED BY nm",
 /* 220 */ "indexed_by ::= NOT INDEXED",
 /* 221 */ "indexed_by ::= INDEXED BY ID_IDX",
 /* 222 */ "orderby_opt ::=",
 /* 223 */ "orderby_opt ::= ORDER BY sortlist",
 /* 224 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 225 */ "sortlist ::= expr sortorder nulls",
 /* 226 */ "sortorder ::= ASC",
 /* 227 */ "sortorder ::= DESC",
 /* 228 */ "sortorder ::=",
 /* 229 */ "nulls ::= NULLS FIRST",
 /* 230 */ "nulls ::= NULLS LAST",
 /* 231 */ "nulls ::=",
 /* 232 */ "groupby_opt ::=",
 /* 233 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 234 */ "groupby_opt ::= GROUP BY",
 /* 235 */ "having_opt ::=",
 /* 236 */ "having_opt ::= HAVING expr",
 /* 237 */ "limit_opt ::=",
 /* 238 */ "limit_opt ::= LIMIT expr",
 /* 239 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 240 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 241 */ "cmd ::= delete_stmt",
 /* 242 */ "delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt",
 /* 243 */ "delete_stmt ::= with DELETE FROM",
 /* 244 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 245 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 246 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 247 */ "where_opt ::=",
 /* 248 */ "where_opt ::= WHERE expr",
 /* 249 */ "where_opt ::= WHERE",
 /* 250 */ "returning ::=",
 /* 251 */ "returning ::= RETURNING selcollist",
 /* 252 */ "cmd ::= update_stmt",
 /* 253 */ "update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt",
 /* 254 */ "update_stmt ::= with UPDATE orconf",
 /* 255 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 256 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 257 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 258 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 259 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 260 */ "setlist ::= nm EQ expr",
 /* 261 */ "setlist ::= LP idlist RP EQ expr",
 /* 262 */ "setlist ::=",
 /* 263 */ "setlist ::= setlist COMMA",
 /* 264 */ "setlist ::= setlist COMMA ID_COL",
 /* 265 */ "setlist ::= ID_COL",
 /* 266 */ "idlist_opt ::=",
 /* 267 */ "idlist_opt ::= LP idlist RP",
 /* 268 */ "idlist ::= idlist COMMA nm",
 /* 269 */ "idlist ::= nm",
 /* 270 */ "idlist ::=",
 /* 271 */ "idlist ::= idlist COMMA ID_COL",
 /* 272 */ "idlist ::= ID_COL",
 /* 273 */ "cmd ::= insert_stmt",
 /* 274 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning",
 /* 275 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning",
 /* 276 */ "insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt",
 /* 277 */ "insert_stmt ::= with insert_cmd INTO",
 /* 278 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 279 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 280 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 281 */ "insert_cmd ::= INSERT orconf",
 /* 282 */ "insert_cmd ::= REPLACE",
 /* 283 */ "upsert ::=",
 /* 284 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 285 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 286 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 287 */ "exprx ::= expr not_opt IN ID_DB",
 /* 288 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 289 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 290 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 291 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 292 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 293 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 294 */ "exprx ::= CTIME_KW",
 /* 295 */ "exprx ::= LP nexprlist RP",
 /* 296 */ "exprx ::= tnm",
 /* 297 */ "exprx ::= tnm DOT nm",
 /* 298 */ "exprx ::= tnm DOT",
 /* 299 */ "exprx ::= tnm DOT nm DOT nm",
 /* 300 */ "exprx ::= tnm DOT nm DOT",
 /* 301 */ "exprx ::= VARIABLE",
 /* 302 */ "exprx ::= expr COLLATE ids",
 /* 303 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 304 */ "exprx ::= id LP distinct exprlist RP",
 /* 305 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP",
 /* 306 */ "exprx ::= id LP STAR RP",
 /* 307 */ "exprx ::= expr AND expr",
 /* 308 */ "exprx ::= expr OR expr",
 /* 309 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 310 */ "exprx ::= expr EQ|NE expr",
 /* 311 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 312 */ "exprx ::= expr PLUS|MINUS expr",
 /* 313 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 314 */ "exprx ::= expr CONCAT expr",
 /* 315 */ "exprx ::= expr not_opt likeop expr",
 /* 316 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 317 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 318 */ "exprx ::= expr NOT NULL",
 /* 319 */ "exprx ::= expr IS not_opt expr",
 /* 320 */ "exprx ::= expr IS NOT DISTINCT FROM expr",
 /* 321 */ "exprx ::= expr IS DISTINCT FROM expr",
 /* 322 */ "exprx ::= NOT expr",
 /* 323 */ "exprx ::= BITNOT expr",
 /* 324 */ "exprx ::= MINUS expr",
 /* 325 */ "exprx ::= PLUS expr",
 /* 326 */ "exprx ::= expr PTR expr",
 /* 327 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 328 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 329 */ "exprx ::= LP select RP",
 /* 330 */ "exprx ::= expr not_opt IN LP select RP",
 /* 331 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 332 */ "exprx ::= EXISTS LP select RP",
 /* 333 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 334 */ "exprx ::= RAISE LP IGNORE RP",
 /* 335 */ "exprx ::= RAISE LP raisetype COMMA expr RP",
 /* 336 */ "exprx ::= id LP distinct exprlist RP filter_over",
 /* 337 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over",
 /* 338 */ "exprx ::= id LP STAR RP filter_over",
 /* 339 */ "exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP",
 /* 340 */ "expr ::=",
 /* 341 */ "expr ::= exprx",
 /* 342 */ "not_opt ::=",
 /* 343 */ "not_opt ::= NOT",
 /* 344 */ "rp_opt ::=",
 /* 345 */ "rp_opt ::= RP",
 /* 346 */ "likeop ::= LIKE_KW|MATCH",
 /* 347 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 348 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 349 */ "case_else ::= ELSE expr",
 /* 350 */ "case_else ::=",
 /* 351 */ "case_operand ::= exprx",
 /* 352 */ "case_operand ::=",
 /* 353 */ "exprlist ::= nexprlist",
 /* 354 */ "exprlist ::=",
 /* 355 */ "nexprlist ::= nexprlist COMMA expr",
 /* 356 */ "nexprlist ::= exprx",
 /* 357 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 358 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 359 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 360 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 361 */ "uniqueflag ::= UNIQUE",
 /* 362 */ "uniqueflag ::=",
 /* 363 */ "idxlist_opt ::=",
 /* 364 */ "idxlist_opt ::= LP idxlist RP",
 /* 365 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 366 */ "idxlist ::= idxlist_single",
 /* 367 */ "idxlist_single ::= nm collate sortorder",
 /* 368 */ "idxlist_single ::= ID_COL",
 /* 369 */ "collate ::=",
 /* 370 */ "collate ::= COLLATE ids",
 /* 371 */ "collate ::= COLLATE ID_COLLATE",
 /* 372 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 373 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 374 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 375 */ "cmd ::= VACUUM vinto",
 /* 376 */ "cmd ::= VACUUM nm vinto",
 /* 377 */ "vinto ::= INTO expr",
 /* 378 */ "vinto ::=",
 /* 379 */ "cmd ::= PRAGMA nm dbnm",
 /* 380 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 381 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 382 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 383 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 384 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 385 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 386 */ "nmnum ::= plus_num",
 /* 387 */ "nmnum ::= nm",
 /* 388 */ "nmnum ::= ON",
 /* 389 */ "nmnum ::= DELETE",
 /* 390 */ "nmnum ::= DEFAULT",
 /* 391 */ "plus_num ::= PLUS number",
 /* 392 */ "plus_num ::= number",
 /* 393 */ "minus_num ::= MINUS number",
 /* 394 */ "number ::= INTEGER",
 /* 395 */ "number ::= FLOAT",
 /* 396 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 397 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 398 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 399 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 400 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 401 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 402 */ "trigger_time ::= BEFORE",
 /* 403 */ "trigger_time ::= AFTER",
 /* 404 */ "trigger_time ::= INSTEAD OF",
 /* 405 */ "trigger_time ::=",
 /* 406 */ "trigger_event ::= DELETE",
 /* 407 */ "trigger_event ::= INSERT",
 /* 408 */ "trigger_event ::= UPDATE",
 /* 409 */ "trigger_event ::= UPDATE OF idlist",
 /* 410 */ "foreach_clause ::=",
 /* 411 */ "foreach_clause ::= FOR EACH ROW",
 /* 412 */ "when_clause ::=",
 /* 413 */ "when_clause ::= WHEN expr",
 /* 414 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 415 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 416 */ "trigger_cmd_list ::= SEMI",
 /* 417 */ "trigger_cmd ::= update_stmt",
 /* 418 */ "trigger_cmd ::= insert_stmt",
 /* 419 */ "trigger_cmd ::= delete_stmt",
 /* 420 */ "trigger_cmd ::= select_stmt",
 /* 421 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 422 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 423 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 424 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 425 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 426 */ "cmd ::= DETACH database_kw_opt expr",
 /* 427 */ "key_opt ::=",
 /* 428 */ "key_opt ::= KEY expr",
 /* 429 */ "database_kw_opt ::= DATABASE",
 /* 430 */ "database_kw_opt ::=",
 /* 431 */ "cmd ::= REINDEX",
 /* 432 */ "cmd ::= REINDEX nm dbnm",
 /* 433 */ "cmd ::= REINDEX ID_COLLATE",
 /* 434 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 435 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 436 */ "cmd ::= ANALYZE",
 /* 437 */ "cmd ::= ANALYZE nm dbnm",
 /* 438 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 439 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 440 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 441 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 442 */ "cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm",
 /* 443 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO nm",
 /* 444 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 445 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt ID_COL",
 /* 446 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt",
 /* 447 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO ID_COL_NEW",
 /* 448 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 449 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 450 */ "kwcolumn_opt ::=",
 /* 451 */ "kwcolumn_opt ::= COLUMNKW",
 /* 452 */ "cmd ::= create_vtab",
 /* 453 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 454 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 455 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 456 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 457 */ "vtabarglist ::= vtabarg",
 /* 458 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 459 */ "vtabarg ::=",
 /* 460 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 461 */ "vtabargtoken ::= ANY",
 /* 462 */ "vtabargtoken ::= LP anylist RP",
 /* 463 */ "anylist ::=",
 /* 464 */ "anylist ::= anylist LP anylist RP",
 /* 465 */ "anylist ::= anylist ANY",
 /* 466 */ "with ::=",
 /* 467 */ "with ::= WITH wqlist",
 /* 468 */ "with ::= WITH RECURSIVE wqlist",
 /* 469 */ "wqas ::= AS",
 /* 470 */ "wqas ::= AS MATERIALIZED",
 /* 471 */ "wqas ::= AS NOT MATERIALIZED",
 /* 472 */ "wqlist ::= wqcte",
 /* 473 */ "wqlist ::= wqlist COMMA wqcte",
 /* 474 */ "wqlist ::= ID_TAB_NEW",
 /* 475 */ "wqcte ::= nm idxlist_opt wqas LP select RP",
 /* 476 */ "windowdefn_list ::= windowdefn",
 /* 477 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 478 */ "windowdefn ::= nm AS LP window RP",
 /* 479 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 480 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 481 */ "window ::= ORDER BY sortlist frame_opt",
 /* 482 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 483 */ "window ::= frame_opt",
 /* 484 */ "window ::= nm frame_opt",
 /* 485 */ "frame_opt ::=",
 /* 486 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 487 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 488 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 489 */ "frame_bound_s ::= frame_bound",
 /* 490 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 491 */ "frame_bound_e ::= frame_bound",
 /* 492 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 493 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 494 */ "frame_bound ::= CURRENT ROW",
 /* 495 */ "frame_exclude_opt ::=",
 /* 496 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 497 */ "frame_exclude ::= NO OTHERS",
 /* 498 */ "frame_exclude ::= CURRENT ROW",
 /* 499 */ "frame_exclude ::= GROUP",
 /* 500 */ "frame_exclude ::= TIES",
 /* 501 */ "window_clause ::= WINDOW windowdefn_list",
 /* 502 */ "filter_over ::= filter_clause over_clause",
 /* 503 */ "filter_over ::= over_clause",
 /* 504 */ "filter_over ::= filter_clause",
 /* 505 */ "over_clause ::= OVER LP window RP",
 /* 506 */ "over_clause ::= OVER nm",
 /* 507 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 197: /* cmd */
    case 200: /* ecmd */
    case 202: /* cmdx */
    case 250: /* select_stmt */
    case 281: /* delete_stmt */
    case 283: /* update_stmt */
    case 286: /* insert_stmt */
    case 308: /* trigger_cmd */
    case 312: /* create_vtab */
{
parser_safe_delete((yypminor->yy147));
}
      break;
    case 201: /* explain */
{
parser_safe_delete((yypminor->yy643));
}
      break;
    case 203: /* transtype */
    case 204: /* trans_opt */
{
parser_safe_delete((yypminor->yy284));
}
      break;
    case 205: /* nm */
    case 216: /* columnid */
    case 219: /* id */
    case 220: /* id_opt */
    case 221: /* ids */
    case 223: /* typename */
    case 274: /* dbnm */
    case 299: /* collate */
    case 314: /* vtabarg */
    case 315: /* vtabargtoken */
    case 316: /* anylist */
{
parser_safe_delete((yypminor->yy239));
}
      break;
    case 206: /* savepoint_opt */
    case 208: /* ifnotexists */
    case 232: /* autoinc */
    case 236: /* gen_always */
    case 242: /* tconscomma */
    case 249: /* ifexists */
    case 289: /* rp_opt */
    case 291: /* not_opt */
    case 297: /* uniqueflag */
    case 309: /* database_kw_opt */
    case 311: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy515));
}
      break;
    case 207: /* temp */
    case 256: /* distinct */
{
parser_safe_delete((yypminor->yy642));
}
      break;
    case 209: /* fullname */
{
parser_safe_delete((yypminor->yy648));
}
      break;
    case 210: /* columnlist */
{
parser_safe_delete((yypminor->yy426));
}
      break;
    case 211: /* conslist_opt */
    case 241: /* conslist */
{
parser_safe_delete((yypminor->yy645));
}
      break;
    case 212: /* table_options */
{
parser_safe_delete((yypminor->yy497));
}
      break;
    case 213: /* select */
    case 252: /* selectnowith */
{
parser_safe_delete((yypminor->yy113));
}
      break;
    case 214: /* table_option */
{
parser_safe_delete((yypminor->yy303));
}
      break;
    case 215: /* column */
{
parser_safe_delete((yypminor->yy123));
}
      break;
    case 217: /* type */
    case 222: /* typetoken */
{
parser_safe_delete((yypminor->yy1));
}
      break;
    case 218: /* carglist */
{
parser_safe_delete((yypminor->yy11));
}
      break;
    case 224: /* signed */
    case 225: /* plus_num */
    case 226: /* minus_num */
    case 228: /* term */
    case 301: /* nmnum */
    case 302: /* number */
{
parser_safe_delete((yypminor->yy13));
}
      break;
    case 227: /* ccons */
{
parser_safe_delete((yypminor->yy552));
}
      break;
    case 229: /* expr */
    case 259: /* where_opt */
    case 261: /* having_opt */
    case 290: /* exprx */
    case 293: /* case_operand */
    case 295: /* case_else */
    case 300: /* vinto */
    case 306: /* when_clause */
    case 310: /* key_opt */
{
parser_safe_delete((yypminor->yy456));
}
      break;
    case 230: /* onconf */
    case 246: /* resolvetype */
    case 247: /* orconf */
{
parser_safe_delete((yypminor->yy194));
}
      break;
    case 231: /* sortorder */
{
parser_safe_delete((yypminor->yy509));
}
      break;
    case 233: /* idxlist_opt */
    case 244: /* idxlist */
{
parser_safe_delete((yypminor->yy240));
}
      break;
    case 234: /* refargs */
{
parser_safe_delete((yypminor->yy184));
}
      break;
    case 235: /* defer_subclause */
    case 245: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy265));
}
      break;
    case 237: /* tnm */
{
parser_safe_delete((yypminor->yy14));
}
      break;
    case 238: /* refarg */
{
parser_safe_delete((yypminor->yy475));
}
      break;
    case 239: /* refact */
{
parser_safe_delete((yypminor->yy160));
}
      break;
    case 240: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy136));
}
      break;
    case 243: /* tcons */
{
parser_safe_delete((yypminor->yy15));
}
      break;
    case 251: /* with */
{
parser_safe_delete((yypminor->yy137));
}
      break;
    case 253: /* oneselect */
{
parser_safe_delete((yypminor->yy182));
}
      break;
    case 254: /* multiselect_op */
{
parser_safe_delete((yypminor->yy646));
}
      break;
    case 255: /* values */
{
parser_safe_delete((yypminor->yy294));
}
      break;
    case 257: /* selcollist */
    case 267: /* sclp */
    case 282: /* returning */
{
parser_safe_delete((yypminor->yy373));
}
      break;
    case 258: /* from */
    case 269: /* joinsrc */
{
parser_safe_delete((yypminor->yy455));
}
      break;
    case 260: /* groupby_opt */
    case 265: /* nexprlist */
    case 266: /* exprlist */
    case 294: /* case_exprlist */
{
parser_safe_delete((yypminor->yy143));
}
      break;
    case 262: /* orderby_opt */
    case 279: /* sortlist */
{
parser_safe_delete((yypminor->yy459));
}
      break;
    case 263: /* limit_opt */
{
parser_safe_delete((yypminor->yy44));
}
      break;
    case 264: /* window_clause */
    case 320: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy339));
}
      break;
    case 268: /* as */
{
parser_safe_delete((yypminor->yy457));
}
      break;
    case 270: /* singlesrc */
{
parser_safe_delete((yypminor->yy257));
}
      break;
    case 271: /* seltablist */
{
parser_safe_delete((yypminor->yy659));
}
      break;
    case 272: /* joinop */
{
parser_safe_delete((yypminor->yy85));
}
      break;
    case 273: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy191));
}
      break;
    case 275: /* indexed_opt */
    case 278: /* indexed_by */
{
parser_safe_delete((yypminor->yy504));
}
      break;
    case 276: /* idlist */
    case 285: /* idlist_opt */
    case 313: /* vtabarglist */
{
parser_safe_delete((yypminor->yy159));
}
      break;
    case 277: /* xfullname */
{
parser_safe_delete((yypminor->yy148));
}
      break;
    case 280: /* nulls */
{
parser_safe_delete((yypminor->yy331));
}
      break;
    case 284: /* setlist */
{
parser_safe_delete((yypminor->yy177));
}
      break;
    case 287: /* insert_cmd */
{
parser_safe_delete((yypminor->yy368));
}
      break;
    case 288: /* upsert */
{
parser_safe_delete((yypminor->yy16));
}
      break;
    case 292: /* likeop */
{
parser_safe_delete((yypminor->yy232));
}
      break;
    case 296: /* filter_over */
{
parser_safe_delete((yypminor->yy567));
}
      break;
    case 298: /* idxlist_single */
{
parser_safe_delete((yypminor->yy460));
}
      break;
    case 303: /* trigger_time */
{
parser_safe_delete((yypminor->yy500));
}
      break;
    case 304: /* trigger_event */
{
parser_safe_delete((yypminor->yy87));
}
      break;
    case 305: /* foreach_clause */
{
parser_safe_delete((yypminor->yy115));
}
      break;
    case 307: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy198));
}
      break;
    case 317: /* wqlist */
{
parser_safe_delete((yypminor->yy512));
}
      break;
    case 318: /* wqas */
{
parser_safe_delete((yypminor->yy407));
}
      break;
    case 319: /* wqcte */
{
parser_safe_delete((yypminor->yy158));
}
      break;
    case 321: /* windowdefn */
{
parser_safe_delete((yypminor->yy522));
}
      break;
    case 322: /* window */
{
parser_safe_delete((yypminor->yy199));
}
      break;
    case 323: /* frame_opt */
{
parser_safe_delete((yypminor->yy89));
}
      break;
    case 324: /* range_or_rows */
{
parser_safe_delete((yypminor->yy282));
}
      break;
    case 325: /* frame_bound_s */
    case 327: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy169));
}
      break;
    case 328: /* frame_bound */
{
parser_safe_delete((yypminor->yy169));parser_safe_delete((yypminor->yy169));parser_safe_delete((yypminor->yy169));
}
      break;
    case 330: /* filter_clause */
{
parser_safe_delete((yypminor->yy341));
}
      break;
    case 331: /* over_clause */
{
parser_safe_delete((yypminor->yy663));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 198, 1 },
  { 199, 2 },
  { 199, 1 },
  { 200, 1 },
  { 200, 3 },
  { 201, 0 },
  { 201, 1 },
  { 201, 3 },
  { 202, 1 },
  { 197, 3 },
  { 204, 0 },
  { 204, 1 },
  { 204, 2 },
  { 204, 2 },
  { 203, 0 },
  { 203, 1 },
  { 203, 1 },
  { 203, 1 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 206, 1 },
  { 206, 0 },
  { 197, 2 },
  { 197, 3 },
  { 197, 5 },
  { 197, 2 },
  { 197, 3 },
  { 197, 5 },
  { 197, 10 },
  { 197, 7 },
  { 197, 7 },
  { 197, 5 },
  { 212, 0 },
  { 212, 1 },
  { 212, 3 },
  { 214, 2 },
  { 214, 1 },
  { 214, 2 },
  { 214, 1 },
  { 208, 0 },
  { 208, 3 },
  { 207, 1 },
  { 207, 0 },
  { 210, 3 },
  { 210, 1 },
  { 215, 3 },
  { 216, 1 },
  { 216, 1 },
  { 219, 1 },
  { 220, 1 },
  { 220, 0 },
  { 221, 1 },
  { 221, 1 },
  { 205, 1 },
  { 205, 1 },
  { 205, 1 },
  { 217, 0 },
  { 217, 1 },
  { 222, 1 },
  { 222, 4 },
  { 222, 6 },
  { 223, 1 },
  { 223, 2 },
  { 223, 1 },
  { 224, 1 },
  { 224, 1 },
  { 218, 2 },
  { 218, 0 },
  { 227, 2 },
  { 227, 2 },
  { 227, 4 },
  { 227, 3 },
  { 227, 3 },
  { 227, 2 },
  { 227, 2 },
  { 227, 2 },
  { 227, 3 },
  { 227, 5 },
  { 227, 2 },
  { 227, 4 },
  { 227, 4 },
  { 227, 1 },
  { 227, 2 },
  { 227, 6 },
  { 227, 2 },
  { 227, 2 },
  { 227, 2 },
  { 227, 3 },
  { 228, 1 },
  { 228, 1 },
  { 228, 1 },
  { 228, 1 },
  { 237, 1 },
  { 237, 1 },
  { 236, 2 },
  { 236, 0 },
  { 232, 0 },
  { 232, 1 },
  { 234, 0 },
  { 234, 2 },
  { 238, 2 },
  { 238, 3 },
  { 238, 3 },
  { 238, 3 },
  { 238, 2 },
  { 239, 2 },
  { 239, 2 },
  { 239, 1 },
  { 239, 1 },
  { 239, 2 },
  { 235, 3 },
  { 235, 2 },
  { 240, 0 },
  { 240, 2 },
  { 240, 2 },
  { 211, 0 },
  { 211, 2 },
  { 241, 3 },
  { 241, 1 },
  { 242, 1 },
  { 242, 0 },
  { 243, 2 },
  { 243, 7 },
  { 243, 5 },
  { 243, 5 },
  { 243, 10 },
  { 243, 2 },
  { 243, 7 },
  { 243, 4 },
  { 245, 0 },
  { 245, 1 },
  { 230, 0 },
  { 230, 3 },
  { 247, 0 },
  { 247, 2 },
  { 246, 1 },
  { 246, 1 },
  { 246, 1 },
  { 197, 4 },
  { 197, 6 },
  { 197, 4 },
  { 249, 2 },
  { 249, 0 },
  { 197, 8 },
  { 197, 7 },
  { 197, 5 },
  { 197, 4 },
  { 197, 6 },
  { 197, 4 },
  { 197, 1 },
  { 250, 1 },
  { 213, 2 },
  { 252, 1 },
  { 252, 3 },
  { 252, 3 },
  { 252, 1 },
  { 252, 3 },
  { 253, 9 },
  { 253, 10 },
  { 255, 4 },
  { 255, 5 },
  { 254, 1 },
  { 254, 2 },
  { 254, 1 },
  { 254, 1 },
  { 256, 1 },
  { 256, 1 },
  { 256, 0 },
  { 267, 2 },
  { 267, 0 },
  { 257, 3 },
  { 257, 2 },
  { 257, 4 },
  { 257, 1 },
  { 257, 4 },
  { 268, 2 },
  { 268, 1 },
  { 268, 2 },
  { 268, 1 },
  { 268, 0 },
  { 258, 0 },
  { 258, 2 },
  { 269, 2 },
  { 269, 0 },
  { 271, 4 },
  { 271, 0 },
  { 270, 4 },
  { 270, 4 },
  { 270, 4 },
  { 270, 6 },
  { 270, 0 },
  { 270, 2 },
  { 270, 3 },
  { 270, 1 },
  { 270, 3 },
  { 270, 1 },
  { 273, 2 },
  { 273, 4 },
  { 273, 0 },
  { 273, 2 },
  { 274, 0 },
  { 274, 2 },
  { 209, 1 },
  { 209, 3 },
  { 277, 1 },
  { 277, 3 },
  { 277, 5 },
  { 277, 3 },
  { 277, 5 },
  { 277, 3 },
  { 272, 1 },
  { 272, 1 },
  { 272, 2 },
  { 272, 3 },
  { 272, 4 },
  { 272, 1 },
  { 275, 0 },
  { 275, 1 },
  { 278, 3 },
  { 278, 2 },
  { 278, 3 },
  { 262, 0 },
  { 262, 3 },
  { 279, 5 },
  { 279, 3 },
  { 231, 1 },
  { 231, 1 },
  { 231, 0 },
  { 280, 2 },
  { 280, 2 },
  { 280, 0 },
  { 260, 0 },
  { 260, 3 },
  { 260, 2 },
  { 261, 0 },
  { 261, 2 },
  { 263, 0 },
  { 263, 2 },
  { 263, 4 },
  { 263, 4 },
  { 197, 1 },
  { 281, 9 },
  { 281, 3 },
  { 281, 5 },
  { 281, 6 },
  { 281, 4 },
  { 259, 0 },
  { 259, 2 },
  { 259, 1 },
  { 282, 0 },
  { 282, 2 },
  { 197, 1 },
  { 283, 12 },
  { 283, 3 },
  { 283, 5 },
  { 283, 6 },
  { 283, 4 },
  { 284, 5 },
  { 284, 7 },
  { 284, 3 },
  { 284, 5 },
  { 284, 0 },
  { 284, 2 },
  { 284, 3 },
  { 284, 1 },
  { 285, 0 },
  { 285, 3 },
  { 276, 3 },
  { 276, 1 },
  { 276, 0 },
  { 276, 3 },
  { 276, 1 },
  { 197, 1 },
  { 286, 8 },
  { 286, 8 },
  { 286, 7 },
  { 286, 3 },
  { 286, 5 },
  { 286, 4 },
  { 286, 6 },
  { 287, 2 },
  { 287, 1 },
  { 288, 0 },
  { 288, 11 },
  { 288, 8 },
  { 288, 4 },
  { 290, 4 },
  { 290, 6 },
  { 290, 1 },
  { 290, 3 },
  { 290, 5 },
  { 290, 3 },
  { 290, 6 },
  { 290, 1 },
  { 290, 3 },
  { 290, 1 },
  { 290, 3 },
  { 290, 2 },
  { 290, 5 },
  { 290, 4 },
  { 290, 1 },
  { 290, 3 },
  { 290, 6 },
  { 290, 5 },
  { 290, 8 },
  { 290, 4 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 3 },
  { 290, 4 },
  { 290, 6 },
  { 290, 2 },
  { 290, 3 },
  { 290, 4 },
  { 290, 6 },
  { 290, 5 },
  { 290, 2 },
  { 290, 2 },
  { 290, 2 },
  { 290, 2 },
  { 290, 3 },
  { 290, 6 },
  { 290, 6 },
  { 290, 3 },
  { 290, 6 },
  { 290, 5 },
  { 290, 4 },
  { 290, 5 },
  { 290, 4 },
  { 290, 6 },
  { 290, 6 },
  { 290, 9 },
  { 290, 5 },
  { 290, 12 },
  { 229, 0 },
  { 229, 1 },
  { 291, 0 },
  { 291, 1 },
  { 289, 0 },
  { 289, 1 },
  { 292, 1 },
  { 294, 5 },
  { 294, 4 },
  { 295, 2 },
  { 295, 0 },
  { 293, 1 },
  { 293, 0 },
  { 266, 1 },
  { 266, 0 },
  { 265, 3 },
  { 265, 1 },
  { 197, 12 },
  { 197, 8 },
  { 197, 7 },
  { 197, 5 },
  { 297, 1 },
  { 297, 0 },
  { 233, 0 },
  { 233, 3 },
  { 244, 3 },
  { 244, 1 },
  { 298, 3 },
  { 298, 1 },
  { 299, 0 },
  { 299, 2 },
  { 299, 2 },
  { 197, 4 },
  { 197, 6 },
  { 197, 4 },
  { 197, 2 },
  { 197, 3 },
  { 300, 2 },
  { 300, 0 },
  { 197, 3 },
  { 197, 5 },
  { 197, 6 },
  { 197, 5 },
  { 197, 6 },
  { 197, 4 },
  { 197, 2 },
  { 301, 1 },
  { 301, 1 },
  { 301, 1 },
  { 301, 1 },
  { 301, 1 },
  { 225, 2 },
  { 225, 1 },
  { 226, 2 },
  { 302, 1 },
  { 302, 1 },
  { 197, 15 },
  { 197, 12 },
  { 197, 14 },
  { 197, 10 },
  { 197, 7 },
  { 197, 5 },
  { 303, 1 },
  { 303, 1 },
  { 303, 2 },
  { 303, 0 },
  { 304, 1 },
  { 304, 1 },
  { 304, 1 },
  { 304, 3 },
  { 305, 0 },
  { 305, 3 },
  { 306, 0 },
  { 306, 2 },
  { 307, 3 },
  { 307, 2 },
  { 307, 1 },
  { 308, 1 },
  { 308, 1 },
  { 308, 1 },
  { 308, 1 },
  { 248, 1 },
  { 197, 4 },
  { 197, 6 },
  { 197, 4 },
  { 197, 6 },
  { 197, 3 },
  { 310, 0 },
  { 310, 2 },
  { 309, 1 },
  { 309, 0 },
  { 197, 1 },
  { 197, 3 },
  { 197, 2 },
  { 197, 4 },
  { 197, 2 },
  { 197, 1 },
  { 197, 3 },
  { 197, 4 },
  { 197, 2 },
  { 197, 6 },
  { 197, 6 },
  { 197, 6 },
  { 197, 8 },
  { 197, 6 },
  { 197, 6 },
  { 197, 5 },
  { 197, 8 },
  { 197, 5 },
  { 197, 3 },
  { 311, 0 },
  { 311, 1 },
  { 197, 1 },
  { 312, 8 },
  { 312, 11 },
  { 312, 7 },
  { 312, 5 },
  { 313, 1 },
  { 313, 3 },
  { 314, 0 },
  { 314, 2 },
  { 315, 1 },
  { 315, 3 },
  { 316, 0 },
  { 316, 4 },
  { 316, 2 },
  { 251, 0 },
  { 251, 2 },
  { 251, 3 },
  { 318, 1 },
  { 318, 2 },
  { 318, 3 },
  { 317, 1 },
  { 317, 3 },
  { 317, 1 },
  { 319, 6 },
  { 320, 1 },
  { 320, 3 },
  { 321, 5 },
  { 322, 5 },
  { 322, 6 },
  { 322, 4 },
  { 322, 5 },
  { 322, 1 },
  { 322, 2 },
  { 323, 0 },
  { 323, 3 },
  { 323, 6 },
  { 324, 1 },
  { 325, 1 },
  { 325, 2 },
  { 327, 1 },
  { 327, 2 },
  { 328, 2 },
  { 328, 2 },
  { 326, 0 },
  { 326, 2 },
  { 329, 2 },
  { 329, 2 },
  { 329, 1 },
  { 329, 1 },
  { 264, 2 },
  { 296, 2 },
  { 296, 1 },
  { 296, 1 },
  { 331, 4 },
  { 331, 2 },
  { 330, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy147); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy147);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy147 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy147 = yymsp[-1].minor.yy147;
                                                yygotominor.yy147->explain = yymsp[-2].minor.yy643->explain;
                                                yygotominor.yy147->queryPlan = yymsp[-2].minor.yy643->queryPlan;
                                                delete yymsp[-2].minor.yy643;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy643 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy643 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy643 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 417: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==417);
      case 418: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==418);
      case 419: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==419);
      case 420: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==420);
      case 452: /* cmd ::= create_vtab */ yytestcase(yyruleno==452);
{yygotominor.yy147 = yymsp[0].minor.yy147;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy147 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy284->type,
                                                        yymsp[0].minor.yy284->transactionKw,
                                                        yymsp[0].minor.yy284->name
                                                    );
                                                delete yymsp[0].minor.yy284;
                                                delete yymsp[-1].minor.yy284;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy284 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy284 = new ParserStubTransDetails();
                                                yygotominor.yy284->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy284 = new ParserStubTransDetails();
                                                yygotominor.yy284->transactionKw = true;
                                                yygotominor.yy284->name = *(yymsp[0].minor.yy239);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy284 = new ParserStubTransDetails();
                                                yygotominor.yy284->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy284 = new ParserStubTransDetails();
                                                yygotominor.yy284->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy284 = new ParserStubTransDetails();
                                                yygotominor.yy284->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy147 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy284->transactionKw,
                                                        yymsp[0].minor.yy284->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy284;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy147 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy284->transactionKw,
                                                        yymsp[0].minor.yy284->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy284;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy147 = new SqliteRollback(
                                                        yymsp[0].minor.yy284->transactionKw,
                                                        yymsp[0].minor.yy284->name
                                                    );
                                                delete yymsp[0].minor.yy284;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 41: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==41);
      case 95: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==95);
      case 98: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==98);
      case 120: /* tconscomma ::= COMMA */ yytestcase(yyruleno==120);
      case 142: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==142);
      case 343: /* not_opt ::= NOT */ yytestcase(yyruleno==343);
      case 345: /* rp_opt ::= RP */ yytestcase(yyruleno==345);
      case 361: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==361);
      case 429: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==429);
      case 451: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==451);
{yygotominor.yy515 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 40: /* ifnotexists ::= */ yytestcase(yyruleno==40);
      case 96: /* gen_always ::= */ yytestcase(yyruleno==96);
      case 97: /* autoinc ::= */ yytestcase(yyruleno==97);
      case 121: /* tconscomma ::= */ yytestcase(yyruleno==121);
      case 143: /* ifexists ::= */ yytestcase(yyruleno==143);
      case 342: /* not_opt ::= */ yytestcase(yyruleno==342);
      case 344: /* rp_opt ::= */ yytestcase(yyruleno==344);
      case 362: /* uniqueflag ::= */ yytestcase(yyruleno==362);
      case 430: /* database_kw_opt ::= */ yytestcase(yyruleno==430);
      case 450: /* kwcolumn_opt ::= */ yytestcase(yyruleno==450);
{yygotominor.yy515 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy147 = new SqliteSavepoint(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy147 = new SqliteRelease(*(yymsp[-1].minor.yy515), *(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy147 = new SqliteRollback(
                                                        yymsp[-3].minor.yy284->transactionKw,
                                                        *(yymsp[-1].minor.yy515),
                                                        *(yymsp[0].minor.yy239)
                                                    );
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[-3].minor.yy284;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,206,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy147 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy515),
                                                        *(yymsp[-8].minor.yy642),
                                                        yymsp[-5].minor.yy648->name1,
                                                        yymsp[-5].minor.yy648->name2,
                                                        *(yymsp[-3].minor.yy426),
                                                        *(yymsp[-2].minor.yy645),
                                                        *(yymsp[0].minor.yy497)
                                                    );
                                                delete yymsp[-6].minor.yy515;
                                                delete yymsp[-8].minor.yy642;
                                                delete yymsp[-3].minor.yy426;
                                                delete yymsp[-2].minor.yy645;
                                                delete yymsp[-5].minor.yy648;
                                                delete yymsp[0].minor.yy497;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy147 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy515),
                                                        *(yymsp[-5].minor.yy642),
                                                        yymsp[-2].minor.yy648->name1,
                                                        yymsp[-2].minor.yy648->name2,
                                                        yymsp[0].minor.yy113
                                                    );
                                                delete yymsp[-3].minor.yy515;
                                                delete yymsp[-5].minor.yy642;
                                                delete yymsp[-2].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 145: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==145);
      case 400: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==400);
{  yy_destructor(yypParser,207,&yymsp[-5].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 146: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==146);
      case 401: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==401);
{  yy_destructor(yypParser,207,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
{yygotominor.yy497 = new ParserCreateTableOptionList();}
        break;
      case 34: /* table_options ::= table_option */
{
                                                yygotominor.yy497 = new ParserCreateTableOptionList();
                                                yygotominor.yy497->append(yymsp[0].minor.yy303);
                                            }
        break;
      case 35: /* table_options ::= table_options COMMA table_option */
{
                                                yymsp[-2].minor.yy497->append(yymsp[0].minor.yy303);
                                                yygotominor.yy497 = yymsp[-2].minor.yy497;
                                                DONT_INHERIT_TOKENS("table_options");
                                            }
        break;
      case 36: /* table_option ::= WITHOUT nm */
{
                                                if (yymsp[0].minor.yy239->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy239)));

                                                yygotominor.yy303 = new ParserStubCreateTableOption(ParserStubCreateTableOption::WITHOUT_ROWID);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 37: /* table_option ::= nm */
      case 38: /* table_option ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==38);
      case 39: /* table_option ::= CTX_STRICT_KW */ yytestcase(yyruleno==39);
{
                                                if (yymsp[0].minor.yy239->toLower() != "strict")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy239)));

                                                yygotominor.yy303 = new ParserStubCreateTableOption(ParserStubCreateTableOption::STRICT);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 42: /* temp ::= TEMP */
{yygotominor.yy642 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 43: /* temp ::= */
      case 168: /* distinct ::= */ yytestcase(yyruleno==168);
{yygotominor.yy642 = new int(0);}
        break;
      case 44: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy426->append(yymsp[0].minor.yy123);
                                                yygotominor.yy426 = yymsp[-2].minor.yy426;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 45: /* columnlist ::= column */
{
                                                yygotominor.yy426 = new ParserCreateTableColumnList();
                                                yygotominor.yy426->append(yymsp[0].minor.yy123);
                                            }
        break;
      case 46: /* column ::= columnid type carglist */
{
                                                yygotominor.yy123 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy239), yymsp[-1].minor.yy1, *(yymsp[0].minor.yy11));
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy11;
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 47: /* columnid ::= nm */
      case 48: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==48);
      case 54: /* nm ::= id */ yytestcase(yyruleno==54);
      case 62: /* typename ::= ids */ yytestcase(yyruleno==62);
      case 202: /* dbnm ::= DOT nm */ yytestcase(yyruleno==202);
      case 370: /* collate ::= COLLATE ids */ yytestcase(yyruleno==370);
      case 371: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==371);
{yygotominor.yy239 = yymsp[0].minor.yy239;}
        break;
      case 49: /* id ::= ID|INDEXED|GENERATED */
{
                                                yygotominor.yy239 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 50: /* id_opt ::= id */
{
                                                yygotominor.yy239 = yymsp[0].minor.yy239;
                                            }
        break;
      case 51: /* id_opt ::= */
{
                                                yygotominor.yy239 = new QString();
                                            }
        break;
      case 52: /* ids ::= ID */
      case 56: /* nm ::= JOIN_KW */ yytestcase(yyruleno==56);
{yygotominor.yy239 = new QString(stripObjName(yymsp[0].minor.yy0->value));}
        break;
      case 53: /* ids ::= STRING */
      case 55: /* nm ::= STRING */ yytestcase(yyruleno==55);
{yygotominor.yy239 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 57: /* type ::= */
{yygotominor.yy1 = nullptr;}
        break;
      case 58: /* type ::= typetoken */
{yygotominor.yy1 = yymsp[0].minor.yy1;}
        break;
      case 59: /* typetoken ::= typename */
{
                                                yygotominor.yy1 = new SqliteColumnType(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy1;
                                            }
        break;
      case 60: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy1 = new SqliteColumnType(*(yymsp[-3].minor.yy239), *(yymsp[-1].minor.yy13));
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-1].minor.yy13;
                                                objectForTokens = yygotominor.yy1;
                                            }
        break;
      case 61: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy1 = new SqliteColumnType(*(yymsp[-5].minor.yy239), *(yymsp[-3].minor.yy13), *(yymsp[-1].minor.yy13));
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-3].minor.yy13;
                                                delete yymsp[-1].minor.yy13;
                                                objectForTokens = yygotominor.yy1;
                                            }
        break;
      case 63: /* typename ::= typename ids */
      case 64: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==64);
{
                                                yymsp[-1].minor.yy239->append(" " + *(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                yygotominor.yy239 = yymsp[-1].minor.yy239;
                                            }
        break;
      case 65: /* signed ::= plus_num */
      case 66: /* signed ::= minus_num */ yytestcase(yyruleno==66);
      case 386: /* nmnum ::= plus_num */ yytestcase(yyruleno==386);
      case 391: /* plus_num ::= PLUS number */ yytestcase(yyruleno==391);
      case 392: /* plus_num ::= number */ yytestcase(yyruleno==392);
{yygotominor.yy13 = yymsp[0].minor.yy13;}
        break;
      case 67: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy11->append(yymsp[0].minor.yy552);
                                                yygotominor.yy11 = yymsp[-1].minor.yy11;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 68: /* carglist ::= */
{yygotominor.yy11 = new ParserCreateTableColumnConstraintList();}
        break;
      case 69: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefNameOnly(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefTerm(*(yymsp[0].minor.yy13));
                                                delete yymsp[0].minor.yy13;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 71: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefExpr(yymsp[-1].minor.yy456);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 72: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefTerm(*(yymsp[0].minor.yy13), false);
                                                delete yymsp[0].minor.yy13;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 73: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefTerm(*(yymsp[0].minor.yy13), true);
                                                delete yymsp[0].minor.yy13;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 74: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefId(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 75: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 76: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initNull(*(yymsp[0].minor.yy194));
                                                delete yymsp[0].minor.yy194;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 77: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initNotNull(*(yymsp[0].minor.yy194));
                                                delete yymsp[0].minor.yy194;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 78: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initPk(*(yymsp[-2].minor.yy509), *(yymsp[-1].minor.yy194), *(yymsp[0].minor.yy515));
                                                delete yymsp[-2].minor.yy509;
                                                delete yymsp[0].minor.yy515;
                                                delete yymsp[-1].minor.yy194;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 79: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initUnique(*(yymsp[0].minor.yy194));
                                                delete yymsp[0].minor.yy194;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initCheck(yymsp[-1].minor.yy456);
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 81: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initFk(*(yymsp[-2].minor.yy239), *(yymsp[-1].minor.yy240), *(yymsp[0].minor.yy184));
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy184;
                                                delete yymsp[-1].minor.yy240;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 82: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initDefer(yymsp[0].minor.yy265->initially, yymsp[0].minor.yy265->deferrable);
                                                delete yymsp[0].minor.yy265;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 83: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initColl(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 84: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 85: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==85);
      case 86: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==86);
      case 87: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==87);
{
                                                if (!yymsp[0].minor.yy239->isNull() && yymsp[0].minor.yy239->toLower() != "stored" && yymsp[0].minor.yy239->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy239)));

                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initGeneratedAs(yymsp[-2].minor.yy456, *(yymsp[-5].minor.yy515), *(yymsp[0].minor.yy239));
                                                delete yymsp[-5].minor.yy515;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy552;
                                            }
        break;
      case 88: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy552 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy552->initCheck();
                                                objectForTokens = yygotominor.yy552;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 89: /* term ::= NULL */
{yygotominor.yy13 = new QVariant();}
        break;
      case 90: /* term ::= INTEGER */
      case 394: /* number ::= INTEGER */ yytestcase(yyruleno==394);
{yygotominor.yy13 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 91: /* term ::= FLOAT */
      case 395: /* number ::= FLOAT */ yytestcase(yyruleno==395);
{yygotominor.yy13 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 92: /* term ::= STRING|BLOB */
{
                                                if (yymsp[0].minor.yy0->value.length() >= 3 && yymsp[0].minor.yy0->value.startsWith("x'", Qt::CaseInsensitive))
                                                    yygotominor.yy13 = new QVariant(blobFromLiteral(yymsp[0].minor.yy0->value));
                                                else
                                                    yygotominor.yy13 = new QVariant(stripString(yymsp[0].minor.yy0->value));
                                            }
        break;
      case 93: /* tnm ::= term */
{
												yygotominor.yy14 = new ParserTermOrLiteral(*(yymsp[0].minor.yy13));
												delete yymsp[0].minor.yy13;
											}
        break;
      case 94: /* tnm ::= nm */
{
												yygotominor.yy14 = new ParserTermOrLiteral(*(yymsp[0].minor.yy239));
												delete yymsp[0].minor.yy239;
											}
        break;
      case 99: /* refargs ::= */
{yygotominor.yy184 = new ParserFkConditionList();}
        break;
      case 100: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy184->append(yymsp[0].minor.yy475);
                                                yygotominor.yy184 = yymsp[-1].minor.yy184;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 101: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy475 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 102: /* refarg ::= ON INSERT refact */
{yygotominor.yy475 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy160)); delete yymsp[0].minor.yy160;}
        break;
      case 103: /* refarg ::= ON DELETE refact */
{yygotominor.yy475 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy160)); delete yymsp[0].minor.yy160;}
        break;
      case 104: /* refarg ::= ON UPDATE refact */
      case 105: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==105);
{yygotominor.yy475 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy160)); delete yymsp[0].minor.yy160;}
        break;
      case 106: /* refact ::= SET NULL */
{yygotominor.yy160 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 107: /* refact ::= SET DEFAULT */
{yygotominor.yy160 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 108: /* refact ::= CASCADE */
{yygotominor.yy160 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 109: /* refact ::= RESTRICT */
{yygotominor.yy160 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 110: /* refact ::= NO ACTION */
{yygotominor.yy160 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 111: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy265 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                            }
        break;
      case 112: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy265 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                            }
        break;
      case 113: /* init_deferred_pred_opt ::= */
{yygotominor.yy136 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 114: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy136 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 115: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy136 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 116: /* conslist_opt ::= */
{yygotominor.yy645 = new ParserCreateTableConstraintList();}
        break;
      case 117: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy645 = yymsp[0].minor.yy645;}
        break;
      case 118: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy15->afterComma = *(yymsp[-1].minor.yy515);
                                                yymsp[-2].minor.yy645->append(yymsp[0].minor.yy15);
                                                yygotominor.yy645 = yymsp[-2].minor.yy645;
                                                delete yymsp[-1].minor.yy515;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 119: /* conslist ::= tcons */
{
                                                yygotominor.yy645 = new ParserCreateTableConstraintList();
                                                yygotominor.yy645->append(yymsp[0].minor.yy15);
                                            }
        break;
      case 122: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initNameOnly(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy15;
                                            }
        break;
      case 123: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initPk(*(yymsp[-3].minor.yy240), *(yymsp[-2].minor.yy515), *(yymsp[0].minor.yy194));
                                                delete yymsp[-2].minor.yy515;
                                                delete yymsp[0].minor.yy194;
                                                delete yymsp[-3].minor.yy240;
                                                objectForTokens = yygotominor.yy15;
                                            }
        break;
      case 124: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initUnique(*(yymsp[-2].minor.yy240), *(yymsp[0].minor.yy194));
                                                delete yymsp[0].minor.yy194;
                                                delete yymsp[-2].minor.yy240;
                                                objectForTokens = yygotominor.yy15;
                                            }
        break;
      case 125: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initCheck(yymsp[-2].minor.yy456, *(yymsp[0].minor.yy194));
                                                objectForTokens = yygotominor.yy15;
                                            }
        break;
      case 126: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 127: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==127);
      case 128: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==128);
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initFk(
                                                    *(yymsp[-6].minor.yy240),
                                                    *(yymsp[-3].minor.yy239),
                                                    *(yymsp[-2].minor.yy240),
                                                    *(yymsp[-1].minor.yy184),
                                                    yymsp[0].minor.yy265->initially,
                                                    yymsp[0].minor.yy265->deferrable
                                                );
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-1].minor.yy184;
                                                delete yymsp[0].minor.yy265;
                                                delete yymsp[-2].minor.yy240;
                                                delete yymsp[-6].minor.yy240;
                                                objectForTokens = yygotominor.yy15;
                                            }
        break;
      case 129: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy15 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy15->initCheck();
                                                objectForTokens = yygotominor.yy15;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,230,&yymsp[0].minor);
}
        break;
      case 130: /* defer_subclause_opt ::= */
{yygotominor.yy265 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 131: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy265 = yymsp[0].minor.yy265;}
        break;
      case 132: /* onconf ::= */
      case 134: /* orconf ::= */ yytestcase(yyruleno==134);
{yygotominor.yy194 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 133: /* onconf ::= ON CONFLICT resolvetype */
      case 135: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==135);
{yygotominor.yy194 = yymsp[0].minor.yy194;}
        break;
      case 136: /* resolvetype ::= raisetype */
      case 137: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==137);
      case 138: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==138);
{yygotominor.yy194 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 139: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy147 = new SqliteDropTable(*(yymsp[-1].minor.yy515), yymsp[0].minor.yy648->name1, yymsp[0].minor.yy648->name2);
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[0].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 140: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 141: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==141);
      case 148: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==148);
      case 149: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==149);
      case 193: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==193);
      case 194: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==194);
      case 195: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==195);
      case 196: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==196);
      case 359: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==359);
      case 360: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==360);
      case 373: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==373);
      case 374: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==374);
      case 384: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==384);
      case 385: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==385);
      case 423: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==423);
      case 424: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==424);
      case 434: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==434);
      case 435: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==435);
      case 438: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==438);
      case 439: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==439);
      case 448: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==448);
      case 449: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==449);
      case 455: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==455);
      case 456: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==456);
{  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 144: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy147 = new SqliteCreateView(*(yymsp[-6].minor.yy642), *(yymsp[-4].minor.yy515), yymsp[-3].minor.yy648->name1, yymsp[-3].minor.yy648->name2, yymsp[0].minor.yy113, *(yymsp[-2].minor.yy240));
                                                delete yymsp[-6].minor.yy642;
                                                delete yymsp[-4].minor.yy515;
                                                delete yymsp[-3].minor.yy648;
                                                delete yymsp[-2].minor.yy240;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 147: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy147 = new SqliteDropView(*(yymsp[-1].minor.yy515), yymsp[0].minor.yy648->name1, yymsp[0].minor.yy648->name2);
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[0].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 150: /* cmd ::= select_stmt */
      case 241: /* cmd ::= delete_stmt */ yytestcase(yyruleno==241);
      case 252: /* cmd ::= update_stmt */ yytestcase(yyruleno==252);
      case 273: /* cmd ::= insert_stmt */ yytestcase(yyruleno==273);
{
                                                yygotominor.yy147 = yymsp[0].minor.yy147;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 151: /* select_stmt ::= select */
{
                                                yygotominor.yy147 = yymsp[0].minor.yy113;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 152: /* select ::= with selectnowith */
{
                                                yygotominor.yy113 = yymsp[0].minor.yy113;
                                                yymsp[0].minor.yy113->setWith(yymsp[-1].minor.yy137);
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 153: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy113 = SqliteSelect::append(yymsp[0].minor.yy182);
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 154: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy113 = SqliteSelect::append(yymsp[-2].minor.yy113, *(yymsp[-1].minor.yy646), yymsp[0].minor.yy182);
                                                delete yymsp[-1].minor.yy646;
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 155: /* selectnowith ::= selectnowith multiselect_op values */
{
                                                yygotominor.yy113 = SqliteSelect::append(yymsp[-2].minor.yy113, *(yymsp[-1].minor.yy646), *(yymsp[0].minor.yy294));
                                                delete yymsp[-1].minor.yy646;
                                                delete yymsp[0].minor.yy294;
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 156: /* selectnowith ::= values */
{
                                                yygotominor.yy113 = SqliteSelect::append(*(yymsp[0].minor.yy294));
                                                delete yymsp[0].minor.yy294;
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 157: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy113 = SqliteSelect::append(yymsp[-2].minor.yy113, SqliteSelect::CompoundOperator::COMMA, *(yymsp[0].minor.yy294));
                                                delete yymsp[0].minor.yy294;
                                                objectForTokens = yygotominor.yy113;
                                            }
        break;
      case 158: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy182 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy642),
                                                        *(yymsp[-6].minor.yy373),
                                                        yymsp[-5].minor.yy455,
                                                        yymsp[-4].minor.yy456,
                                                        *(yymsp[-3].minor.yy143),
                                                        yymsp[-2].minor.yy456,
                                                        *(yymsp[-1].minor.yy459),
                                                        yymsp[0].minor.yy44
                                                    );
                                                delete yymsp[-6].minor.yy373;
                                                delete yymsp[-7].minor.yy642;
                                                delete yymsp[-3].minor.yy143;
                                                delete yymsp[-1].minor.yy459;
                                                objectForTokens = yygotominor.yy182;
                                            }
        break;
      case 159: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy182 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy642),
                                                        *(yymsp[-7].minor.yy373),
                                                        yymsp[-6].minor.yy455,
                                                        yymsp[-5].minor.yy456,
                                                        *(yymsp[-4].minor.yy143),
                                                        yymsp[-3].minor.yy456,
                                                        *(yymsp[-2].minor.yy339),
                                                        *(yymsp[-1].minor.yy459),
                                                        yymsp[0].minor.yy44
                                                    );
                                                delete yymsp[-7].minor.yy373;
                                                delete yymsp[-8].minor.yy642;
                                                delete yymsp[-4].minor.yy143;
                                                delete yymsp[-1].minor.yy459;
                                                delete yymsp[-2].minor.yy339;
                                                objectForTokens = yygotominor.yy182;
                                            }
        break;
      case 160: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy294 = new ParserExprNestedList();
                                                yygotominor.yy294->append(*(yymsp[-1].minor.yy143));
                                                delete yymsp[-1].minor.yy143;
                                            }
        break;
      case 161: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy294->append(*(yymsp[-1].minor.yy143));
                                                yygotominor.yy294 = yymsp[-4].minor.yy294;
                                                delete yymsp[-1].minor.yy143;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 162: /* multiselect_op ::= UNION */
{yygotominor.yy646 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 163: /* multiselect_op ::= UNION ALL */
{yygotominor.yy646 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 164: /* multiselect_op ::= EXCEPT */
{yygotominor.yy646 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 165: /* multiselect_op ::= INTERSECT */
{yygotominor.yy646 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 166: /* distinct ::= DISTINCT */
{yygotominor.yy642 = new int(1);}
        break;
      case 167: /* distinct ::= ALL */
{yygotominor.yy642 = new int(2);}
        break;
      case 169: /* sclp ::= selcollist COMMA */
{yygotominor.yy373 = yymsp[-1].minor.yy373;}
        break;
      case 170: /* sclp ::= */
      case 250: /* returning ::= */ yytestcase(yyruleno==250);
{yygotominor.yy373 = new ParserResultColumnList();}
        break;
      case 171: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy456,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->asKw : false,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->name : QString()
                                                    );

                                                yymsp[-2].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-2].minor.yy373;
                                                delete yymsp[0].minor.yy457;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 172: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-1].minor.yy373;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 173: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy14->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy14->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy373->append(obj);
                                                yygotominor.yy373 = yymsp[-3].minor.yy373;
                                                delete yymsp[-2].minor.yy14;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 174: /* selcollist ::= sclp */
      case 175: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==175);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy373 = yymsp[0].minor.yy373;
                                            }
        break;
      case 176: /* as ::= AS nm */
{
                                                yygotominor.yy457 = new ParserStubAlias(*(yymsp[0].minor.yy239), true);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 177: /* as ::= ids */
      case 178: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==178);
      case 179: /* as ::= ID_ALIAS */ yytestcase(yyruleno==179);
{
                                                yygotominor.yy457 = new ParserStubAlias(*(yymsp[0].minor.yy239), false);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 180: /* as ::= */
{yygotominor.yy457 = nullptr;}
        break;
      case 181: /* from ::= */
{yygotominor.yy455 = nullptr;}
        break;
      case 182: /* from ::= FROM joinsrc */
{yygotominor.yy455 = yymsp[0].minor.yy455;}
        break;
      case 183: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy455 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy257,
                                                        *(yymsp[0].minor.yy659)
                                                    );
                                                delete yymsp[0].minor.yy659;
                                                objectForTokens = yygotominor.yy455;
                                            }
        break;
      case 184: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy455 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy455;
                                            }
        break;
      case 185: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy85, yymsp[-1].minor.yy257, yymsp[0].minor.yy191);

                                                yymsp[-3].minor.yy659->append(src);
                                                yygotominor.yy659 = yymsp[-3].minor.yy659;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 186: /* seltablist ::= */
{
                                                yygotominor.yy659 = new ParserOtherSourceList();
                                            }
        break;
      case 187: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy239),
                                                        *(yymsp[-2].minor.yy239),
                                                        yymsp[-1].minor.yy457 ? yymsp[-1].minor.yy457->asKw : false,
                                                        yymsp[-1].minor.yy457 ? yymsp[-1].minor.yy457->name : QString(),
                                                        yymsp[0].minor.yy504 ? yymsp[0].minor.yy504->notIndexedKw : false,
                                                        yymsp[0].minor.yy504 ? yymsp[0].minor.yy504->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[-1].minor.yy457;
                                                if (yymsp[0].minor.yy504)
                                                    delete yymsp[0].minor.yy504;
                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 188: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy113,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->asKw : false,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy457;
                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 189: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy455,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->asKw : false,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy457;
                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 190: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy239),
                                                        *(yymsp[-4].minor.yy239),
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->asKw : false,
                                                        yymsp[0].minor.yy457 ? yymsp[0].minor.yy457->name : QString(),
                                                        *(yymsp[-2].minor.yy143)
                                                    );
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[0].minor.yy457;
                                                if (yymsp[-2].minor.yy143)
                                                    delete yymsp[-2].minor.yy143;

                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 191: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 192: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy257 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy257->database = *(yymsp[-1].minor.yy239);
                                                delete yymsp[-1].minor.yy239;
                                                objectForTokens = yygotominor.yy257;
                                            }
        break;
      case 197: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy191 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy191;
                                            }
        break;
      case 198: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy191 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy159));
                                                delete yymsp[-1].minor.yy159;
                                                objectForTokens = yygotominor.yy191;
                                            }
        break;
      case 199: /* joinconstr_opt ::= */
{yygotominor.yy191 = nullptr;}
        break;
      case 200: /* joinconstr_opt ::= ON CTX_JOIN_EXPR */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy191 = new SqliteSelect::Core::JoinConstraint();
                                                objectForTokens = yygotominor.yy191;
                                            }
        break;
      case 201: /* dbnm ::= */
      case 369: /* collate ::= */ yytestcase(yyruleno==369);
      case 459: /* vtabarg ::= */ yytestcase(yyruleno==459);
      case 463: /* anylist ::= */ yytestcase(yyruleno==463);
{yygotominor.yy239 = new QString();}
        break;
      case 203: /* fullname ::= nm */
{
                                                yygotominor.yy648 = new ParserFullName();
                                                yygotominor.yy648->name1 = *(yymsp[0].minor.yy239);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 204: /* fullname ::= nm DOT nm */
{
                                                yygotominor.yy648 = new ParserFullName();
                                                yygotominor.yy648->name1 = *(yymsp[-2].minor.yy239);
                                                yygotominor.yy648->name2 = *(yymsp[0].minor.yy239);
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 205: /* xfullname ::= nm */
{
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[0].minor.yy239);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 206: /* xfullname ::= nm DOT nm */
{
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[-2].minor.yy239);
                                                yygotominor.yy148->name2 = *(yymsp[0].minor.yy239);
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 207: /* xfullname ::= nm DOT nm AS nm */
{
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[-4].minor.yy239);
                                                yygotominor.yy148->name2 = *(yymsp[-2].minor.yy239);
                                                yygotominor.yy148->alias = *(yymsp[0].minor.yy239);
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 208: /* xfullname ::= nm AS nm */
{
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[-2].minor.yy239);
                                                yygotominor.yy148->alias = *(yymsp[0].minor.yy239);
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 209: /* xfullname ::= nm DOT nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[-4].minor.yy239);
                                                yygotominor.yy148->name2 = *(yymsp[-2].minor.yy239);
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                            }
        break;
      case 210: /* xfullname ::= nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy148 = new ParserXFullName();
                                                yygotominor.yy148->name1 = *(yymsp[-2].minor.yy239);
                                                delete yymsp[-2].minor.yy239;
                                            }
        break;
      case 211: /* joinop ::= COMMA */
{
                                                yygotominor.yy85 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy85;
                                            }
        break;
      case 212: /* joinop ::= JOIN */
{
                                                yygotominor.yy85 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy85;
                                            }
        break;
      case 213: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy85 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy85;
                                            }
        break;
      case 214: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy85 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy239));
                                                delete yymsp[-1].minor.yy239;
                                                objectForTokens = yygotominor.yy85;
                                            }
        break;
      case 215: /* joinop ::= JOIN_KW nm nm JOIN */
      case 216: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==216);
{
                                                yygotominor.yy85 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy239), *(yymsp[-1].minor.yy239));
                                                delete yymsp[-2].minor.yy239;
                                                objectForTokens = yygotominor.yy85;
                                            }
        break;
      case 217: /* indexed_opt ::= */
{yygotominor.yy504 = nullptr;}
        break;
      case 218: /* indexed_opt ::= indexed_by */
{yygotominor.yy504 = yymsp[0].minor.yy504;}
        break;
      case 219: /* indexed_by ::= INDEXED BY nm */
{
                                                yygotominor.yy504 = new ParserIndexedBy(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 220: /* indexed_by ::= NOT INDEXED */
{yygotominor.yy504 = new ParserIndexedBy(true);}
        break;
      case 221: /* indexed_by ::= INDEXED BY ID_IDX */
{parserContext->minorErrorBeforeNextToken("Syntax error");}
        break;
      case 222: /* orderby_opt ::= */
{yygotominor.yy459 = new ParserOrderByList();}
        break;
      case 223: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy459 = yymsp[0].minor.yy459;}
        break;
      case 224: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy456, *(yymsp[-1].minor.yy509), *(yymsp[0].minor.yy331));
                                                yymsp[-4].minor.yy459->append(obj);
                                                yygotominor.yy459 = yymsp[-4].minor.yy459;
                                                delete yymsp[-1].minor.yy509;
												delete yymsp[0].minor.yy331;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 225: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy456, *(yymsp[-1].minor.yy509), *(yymsp[0].minor.yy331));
                                                yygotominor.yy459 = new ParserOrderByList();
                                                yygotominor.yy459->append(obj);
                                                delete yymsp[-1].minor.yy509;
												delete yymsp[0].minor.yy331;
                                                objectForTokens = obj;
                                            }
        break;
      case 226: /* sortorder ::= ASC */
{yygotominor.yy509 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 227: /* sortorder ::= DESC */
{yygotominor.yy509 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 228: /* sortorder ::= */
{yygotominor.yy509 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 229: /* nulls ::= NULLS FIRST */
{yygotominor.yy331 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 230: /* nulls ::= NULLS LAST */
{yygotominor.yy331 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 231: /* nulls ::= */
{yygotominor.yy331 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 232: /* groupby_opt ::= */
      case 354: /* exprlist ::= */ yytestcase(yyruleno==354);
{yygotominor.yy143 = new ParserExprList();}
        break;
      case 233: /* groupby_opt ::= GROUP BY nexprlist */
      case 353: /* exprlist ::= nexprlist */ yytestcase(yyruleno==353);
{yygotominor.yy143 = yymsp[0].minor.yy143;}
        break;
      case 234: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy143 = new ParserExprList();
                                            }
        break;
      case 235: /* having_opt ::= */
      case 247: /* where_opt ::= */ yytestcase(yyruleno==247);
      case 350: /* case_else ::= */ yytestcase(yyruleno==350);
      case 352: /* case_operand ::= */ yytestcase(yyruleno==352);
      case 378: /* vinto ::= */ yytestcase(yyruleno==378);
      case 412: /* when_clause ::= */ yytestcase(yyruleno==412);
      case 427: /* key_opt ::= */ yytestcase(yyruleno==427);
{yygotominor.yy456 = nullptr;}
        break;
      case 236: /* having_opt ::= HAVING expr */
      case 248: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==248);
      case 341: /* expr ::= exprx */ yytestcase(yyruleno==341);
      case 349: /* case_else ::= ELSE expr */ yytestcase(yyruleno==349);
      case 351: /* case_operand ::= exprx */ yytestcase(yyruleno==351);
      case 377: /* vinto ::= INTO expr */ yytestcase(yyruleno==377);
      case 413: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==413);
      case 428: /* key_opt ::= KEY expr */ yytestcase(yyruleno==428);
{yygotominor.yy456 = yymsp[0].minor.yy456;}
        break;
      case 237: /* limit_opt ::= */
{yygotominor.yy44 = nullptr;}
        break;
      case 238: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy44 = new SqliteLimit(yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy44;
                                            }
        break;
      case 239: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy44 = new SqliteLimit(yymsp[-2].minor.yy456, yymsp[0].minor.yy456, true);
                                                objectForTokens = yygotominor.yy44;
                                            }
        break;
      case 240: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy44 = new SqliteLimit(yymsp[-2].minor.yy456, yymsp[0].minor.yy456, false);
                                                objectForTokens = yygotominor.yy44;
                                            }
        break;
      case 242: /* delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt */
{
                                                if (yymsp[-4].minor.yy504)
                                                {
                                                    if (!yymsp[-4].minor.yy504->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy147 = new SqliteDelete(
                                                                yymsp[-5].minor.yy148->name1,
                                                                yymsp[-5].minor.yy148->name2,
                                                                yymsp[-5].minor.yy148->alias,
                                                                yymsp[-4].minor.yy504->indexedBy,
                                                                yymsp[-3].minor.yy456,
                                                                yymsp[-8].minor.yy137,
                                                                *(yymsp[-2].minor.yy373),
                                                                *(yymsp[-1].minor.yy459),
                                                                yymsp[0].minor.yy44
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy147 = new SqliteDelete(
                                                                yymsp[-5].minor.yy148->name1,
                                                                yymsp[-5].minor.yy148->name2,
                                                                yymsp[-5].minor.yy148->alias,
                                                                yymsp[-4].minor.yy504->notIndexedKw,
                                                                yymsp[-3].minor.yy456,
                                                                yymsp[-8].minor.yy137,
                                                                *(yymsp[-2].minor.yy373),
                                                                *(yymsp[-1].minor.yy459),
                                                                yymsp[0].minor.yy44
                                                            );
                                                    }
                                                    delete yymsp[-4].minor.yy504;
                                                }
                                                else
                                                {
                                                    yygotominor.yy147 = new SqliteDelete(
                                                            yymsp[-5].minor.yy148->name1,
                                                            yymsp[-5].minor.yy148->name2,
                                                            yymsp[-5].minor.yy148->alias,
                                                            false,
                                                            yymsp[-3].minor.yy456,
                                                            yymsp[-8].minor.yy137,
                                                            *(yymsp[-2].minor.yy373),
                                                            *(yymsp[-1].minor.yy459),
                                                            yymsp[0].minor.yy44
                                                        );
                                                }
                                                delete yymsp[-5].minor.yy148;
                                                delete yymsp[-2].minor.yy373;
                                                delete yymsp[-1].minor.yy459;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 243: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy137;
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 244: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy137;
                                                q->database = *(yymsp[-1].minor.yy239);
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[-1].minor.yy239;
                                            }
        break;
      case 245: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 256: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==256);
{  yy_destructor(yypParser,251,&yymsp[-5].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 246: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 257: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==257);
{  yy_destructor(yypParser,251,&yymsp[-3].minor);
}
        break;
      case 249: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy456 = new SqliteExpr();
                                            }
        break;
      case 251: /* returning ::= RETURNING selcollist */
{yygotominor.yy373 = yymsp[0].minor.yy373;}
        break;
      case 253: /* update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt */
{
                                                yygotominor.yy147 = new SqliteUpdate(
                                                        *(yymsp[-9].minor.yy194),
                                                        yymsp[-8].minor.yy148->name1,
                                                        yymsp[-8].minor.yy148->name2,
                                                        yymsp[-8].minor.yy148->alias,
                                                        yymsp[-7].minor.yy504 ? yymsp[-7].minor.yy504->notIndexedKw : false,
                                                        yymsp[-7].minor.yy504 ? yymsp[-7].minor.yy504->indexedBy : QString(),
                                                        *(yymsp[-5].minor.yy177),
                                                        yymsp[-4].minor.yy455,
                                                        yymsp[-3].minor.yy456,
                                                        yymsp[-11].minor.yy137,
                                                        *(yymsp[-2].minor.yy373),
                                                        *(yymsp[-1].minor.yy459),
                                                        yymsp[0].minor.yy44
                                                    );
                                                delete yymsp[-9].minor.yy194;
                                                delete yymsp[-8].minor.yy148;
                                                delete yymsp[-5].minor.yy177;
                                                delete yymsp[-2].minor.yy373;
                                                delete yymsp[-1].minor.yy459;
                                                if (yymsp[-7].minor.yy504)
                                                    delete yymsp[-7].minor.yy504;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 254: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy137;
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[0].minor.yy194;
                                            }
        break;
      case 255: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy137;
                                                q->database = *(yymsp[-1].minor.yy239);
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[-2].minor.yy194;
                                                delete yymsp[-1].minor.yy239;
                                            }
        break;
      case 258: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy177->append(ParserSetValue(*(yymsp[-2].minor.yy239), yymsp[0].minor.yy456));
                                                yygotominor.yy177 = yymsp[-4].minor.yy177;
                                                delete yymsp[-2].minor.yy239;
                                            }
        break;
      case 259: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy177->append(ParserSetValue(*(yymsp[-3].minor.yy159), yymsp[0].minor.yy456));
                                                yygotominor.yy177 = yymsp[-6].minor.yy177;
                                                delete yymsp[-3].minor.yy159;
                                            }
        break;
      case 260: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy177 = new ParserSetValueList();
                                                yygotominor.yy177->append(ParserSetValue(*(yymsp[-2].minor.yy239), yymsp[0].minor.yy456));
                                                delete yymsp[-2].minor.yy239;
                                            }
        break;
      case 261: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy177 = new ParserSetValueList();
                                                yygotominor.yy177->append(ParserSetValue(*(yymsp[-3].minor.yy159), yymsp[0].minor.yy456));
                                                delete yymsp[-3].minor.yy159;
                                            }
        break;
      case 262: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy177 = new ParserSetValueList();
                                            }
        break;
      case 263: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy177 = yymsp[-1].minor.yy177;
                                            }
        break;
      case 264: /* setlist ::= setlist COMMA ID_COL */
      case 265: /* setlist ::= ID_COL */ yytestcase(yyruleno==265);
{  yy_destructor(yypParser,284,&yymsp[-2].minor);
}
        break;
      case 266: /* idlist_opt ::= */
{yygotominor.yy159 = new QStringList();}
        break;
      case 267: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy159 = yymsp[-1].minor.yy159;}
        break;
      case 268: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy159 = yymsp[-2].minor.yy159;
                                                *(yygotominor.yy159) << *(yymsp[0].minor.yy239);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 269: /* idlist ::= nm */
{
                                                yygotominor.yy159 = new QStringList();
                                                *(yygotominor.yy159) << *(yymsp[0].minor.yy239);
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 270: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy159 = new QStringList();
                                            }
        break;
      case 271: /* idlist ::= idlist COMMA ID_COL */
      case 272: /* idlist ::= ID_COL */ yytestcase(yyruleno==272);
{  yy_destructor(yypParser,276,&yymsp[-2].minor);
}
        break;
      case 274: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning */
{
                                                yygotominor.yy147 = new SqliteInsert(
                                                        yymsp[-6].minor.yy368->replace,
                                                        yymsp[-6].minor.yy368->orConflict,
                                                        yymsp[-4].minor.yy148->name1,
                                                        yymsp[-4].minor.yy148->name2,
                                                        yymsp[-4].minor.yy148->alias,
                                                        *(yymsp[-3].minor.yy159),
                                                        yymsp[-2].minor.yy113,
                                                        yymsp[-7].minor.yy137,
                                                        yymsp[-1].minor.yy16,
                                                        *(yymsp[0].minor.yy373)
                                                    );
                                                delete yymsp[-4].minor.yy148;
                                                delete yymsp[-6].minor.yy368;
                                                delete yymsp[-3].minor.yy159;
                                                delete yymsp[0].minor.yy373;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 275: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning */
{
                                                yygotominor.yy147 = new SqliteInsert(
                                                        yymsp[-6].minor.yy368->replace,
                                                        yymsp[-6].minor.yy368->orConflict,
                                                        yymsp[-4].minor.yy148->name1,
                                                        yymsp[-4].minor.yy148->name2,
                                                        yymsp[-4].minor.yy148->alias,
                                                        *(yymsp[-3].minor.yy159),
                                                        yymsp[-7].minor.yy137,
                                                        *(yymsp[0].minor.yy373)
                                                    );
                                                delete yymsp[-4].minor.yy148;
                                                delete yymsp[-6].minor.yy368;
                                                delete yymsp[-3].minor.yy159;
                                                delete yymsp[0].minor.yy373;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 276: /* insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy147 = new SqliteInsert(
                                                        yymsp[-5].minor.yy368->replace,
                                                        yymsp[-5].minor.yy368->orConflict,
                                                        yymsp[-3].minor.yy148->name1,
                                                        yymsp[-3].minor.yy148->name2,
                                                        yymsp[-3].minor.yy148->alias,
                                                        *(yymsp[-1].minor.yy159),
                                                        yymsp[-6].minor.yy137,
                                                        QList<SqliteResultColumn*>()
                                                    );
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[-3].minor.yy148;
                                                delete yymsp[-1].minor.yy159;
                                                delete yymsp[-5].minor.yy368;
                                                delete yymsp[0].minor.yy515;
                                            }
        break;
      case 277: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy368->replace;
                                                q->onConflict = yymsp[-1].minor.yy368->orConflict;
                                                q->with = yymsp[-2].minor.yy137;
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[-1].minor.yy368;
                                            }
        break;
      case 278: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy368->replace;
                                                q->onConflict = yymsp[-3].minor.yy368->orConflict;
                                                q->with = yymsp[-4].minor.yy137;
                                                q->database = *(yymsp[-1].minor.yy239);
                                                yygotominor.yy147 = q;
                                                objectForTokens = yygotominor.yy147;
                                                delete yymsp[-3].minor.yy368;
                                                delete yymsp[-1].minor.yy239;
                                            }
        break;
      case 279: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,251,&yymsp[-3].minor);
  yy_destructor(yypParser,287,&yymsp[-2].minor);
}
        break;
      case 280: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,251,&yymsp[-5].minor);
  yy_destructor(yypParser,287,&yymsp[-4].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 281: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy368 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy194));
                                                delete yymsp[0].minor.yy194;
                                            }
        break;
      case 282: /* insert_cmd ::= REPLACE */
{yygotominor.yy368 = new ParserStubInsertOrReplace(true);}
        break;
      case 283: /* upsert ::= */
{
                                                yygotominor.yy16 = nullptr;
                                            }
        break;
      case 284: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy16 = new SqliteUpsert(*(yymsp[-7].minor.yy459), yymsp[-5].minor.yy456, *(yymsp[-1].minor.yy177), yymsp[0].minor.yy456);
                                                delete yymsp[-7].minor.yy459;
                                                delete yymsp[-1].minor.yy177;
                                                objectForTokens = yygotominor.yy16;
                                            }
        break;
      case 285: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy16 = new SqliteUpsert(*(yymsp[-4].minor.yy459), yymsp[-2].minor.yy456);
                                                delete yymsp[-4].minor.yy459;
                                                objectForTokens = yygotominor.yy16;
                                            }
        break;
      case 286: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy16 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy16;
                                            }
        break;
      case 287: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,229,&yymsp[-3].minor);
}
        break;
      case 288: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 289: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==289);
{  yy_destructor(yypParser,229,&yymsp[-5].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 290: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,237,&yymsp[-2].minor);
}
        break;
      case 291: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,237,&yymsp[-4].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 292: /* exprx ::= expr COLLATE ID_COLLATE */
      case 293: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==293);
{  yy_destructor(yypParser,229,&yymsp[-2].minor);
}
        break;
      case 294: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 295: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initRowValue(*(yymsp[-1].minor.yy143));
                                                delete yymsp[-1].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 296: /* exprx ::= tnm */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                if (yymsp[0].minor.yy14->isLiteral())
                                                    yygotominor.yy456->initLiteral(yymsp[0].minor.yy14->toLiteral());
                                                else
                                                    yygotominor.yy456->initId(yymsp[0].minor.yy14->toName());
                                                    //parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy14;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 297: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                if (yymsp[-2].minor.yy14->isName())
                                                    yygotominor.yy456->initId(yymsp[-2].minor.yy14->toName(), *(yymsp[0].minor.yy239));
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy14;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 298: /* exprx ::= tnm DOT */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy456;
                                                if (yymsp[-1].minor.yy14->isName())
                                                {
                                                    yygotominor.yy456->initId(yymsp[-1].minor.yy14->toName(), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-1].minor.yy14;
                                            }
        break;
      case 299: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy456 = new SqliteExpr();
												if (yymsp[-4].minor.yy14->isName())
													yygotominor.yy456->initId(yymsp[-4].minor.yy14->toName(), *(yymsp[-2].minor.yy239), *(yymsp[0].minor.yy239));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy14;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 300: /* exprx ::= tnm DOT nm DOT */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy456;
                                                if (yymsp[-3].minor.yy14->isName())
                                                {
                                                    yygotominor.yy456->initId(yymsp[-3].minor.yy14->toName(), *(yymsp[-1].minor.yy239), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-3].minor.yy14;
                                                delete yymsp[-1].minor.yy239;
                                            }
        break;
      case 301: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 302: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initCollate(yymsp[-2].minor.yy456, *(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 303: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initCast(yymsp[-3].minor.yy456, yymsp[-1].minor.yy1);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 304: /* exprx ::= id LP distinct exprlist RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initFunction(stripObjName(*(yymsp[-4].minor.yy239)), *(yymsp[-2].minor.yy642), *(yymsp[-1].minor.yy143));
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-2].minor.yy642;
                                                delete yymsp[-1].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 305: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initFunction(stripObjName(*(yymsp[-7].minor.yy239)), *(yymsp[-5].minor.yy642), *(yymsp[-4].minor.yy143), *(yymsp[-1].minor.yy459));
                                                delete yymsp[-7].minor.yy239;
                                                delete yymsp[-5].minor.yy642;
                                                delete yymsp[-4].minor.yy143;
                                                delete yymsp[-1].minor.yy459;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 306: /* exprx ::= id LP STAR RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initFunction(stripObjName(*(yymsp[-3].minor.yy239)), true);
                                                delete yymsp[-3].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 307: /* exprx ::= expr AND expr */
      case 308: /* exprx ::= expr OR expr */ yytestcase(yyruleno==308);
      case 309: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==309);
      case 310: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==310);
      case 311: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==311);
      case 312: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==312);
      case 313: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==313);
      case 314: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==314);
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initBinOp(yymsp[-2].minor.yy456, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 315: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initLike(yymsp[-3].minor.yy456, *(yymsp[-2].minor.yy515), *(yymsp[-1].minor.yy232), yymsp[0].minor.yy456);
                                                delete yymsp[-2].minor.yy515;
                                                delete yymsp[-1].minor.yy232;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 316: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initLike(yymsp[-5].minor.yy456, *(yymsp[-4].minor.yy515), *(yymsp[-3].minor.yy232), yymsp[-2].minor.yy456, yymsp[0].minor.yy456);
                                                delete yymsp[-4].minor.yy515;
                                                delete yymsp[-3].minor.yy232;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 317: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initNull(yymsp[-1].minor.yy456, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 318: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initNull(yymsp[-2].minor.yy456, "NOT NULL");
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 319: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initIs(yymsp[-3].minor.yy456, *(yymsp[-1].minor.yy515), yymsp[0].minor.yy456);
                                                delete yymsp[-1].minor.yy515;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 320: /* exprx ::= expr IS NOT DISTINCT FROM expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initDistinct(yymsp[-5].minor.yy456, true, yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 321: /* exprx ::= expr IS DISTINCT FROM expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initDistinct(yymsp[-4].minor.yy456, false, yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 322: /* exprx ::= NOT expr */
      case 323: /* exprx ::= BITNOT expr */ yytestcase(yyruleno==323);
      case 325: /* exprx ::= PLUS expr */ yytestcase(yyruleno==325);
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initUnaryOp(yymsp[0].minor.yy456, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 324: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                if (yymsp[0].minor.yy456->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy456->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy456->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy456;
                                                }
                                                else
                                                {
                                                    yygotominor.yy456->initUnaryOp(yymsp[0].minor.yy456, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 326: /* exprx ::= expr PTR expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initPtrOp(yymsp[-2].minor.yy456, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 327: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initBetween(yymsp[-5].minor.yy456, *(yymsp[-4].minor.yy515), yymsp[-2].minor.yy456, yymsp[0].minor.yy456);
                                                delete yymsp[-4].minor.yy515;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 328: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initIn(yymsp[-5].minor.yy456, *(yymsp[-4].minor.yy515), *(yymsp[-1].minor.yy143));
                                                delete yymsp[-4].minor.yy515;
                                                delete yymsp[-1].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 329: /* exprx ::= LP select RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initSubSelect(yymsp[-1].minor.yy113);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 330: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initIn(yymsp[-5].minor.yy456, *(yymsp[-4].minor.yy515), yymsp[-1].minor.yy113);
                                                delete yymsp[-4].minor.yy515;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 331: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initIn(yymsp[-4].minor.yy456, *(yymsp[-3].minor.yy515), *(yymsp[-1].minor.yy239), *(yymsp[0].minor.yy239));
                                                delete yymsp[-3].minor.yy515;
                                                delete yymsp[-1].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 332: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initExists(yymsp[-1].minor.yy113);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 333: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initCase(yymsp[-3].minor.yy456, *(yymsp[-2].minor.yy143), yymsp[-1].minor.yy456);
                                                delete yymsp[-2].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 334: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 335: /* exprx ::= RAISE LP raisetype COMMA expr RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initRaise(yymsp[-3].minor.yy0->value, yymsp[-1].minor.yy456);
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 336: /* exprx ::= id LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initWindowFunction(stripObjName(*(yymsp[-5].minor.yy239)), *(yymsp[-3].minor.yy642), *(yymsp[-2].minor.yy143), yymsp[0].minor.yy567);
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-3].minor.yy642;
                                                delete yymsp[-2].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 337: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initWindowFunction(stripObjName(*(yymsp[-8].minor.yy239)), *(yymsp[-6].minor.yy642), *(yymsp[-5].minor.yy143), *(yymsp[-2].minor.yy459), yymsp[0].minor.yy567);
                                                delete yymsp[-8].minor.yy239;
                                                delete yymsp[-6].minor.yy642;
                                                delete yymsp[-5].minor.yy143;
                                                delete yymsp[-2].minor.yy459;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 338: /* exprx ::= id LP STAR RP filter_over */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initWindowFunction(stripObjName(*(yymsp[-4].minor.yy239)), yymsp[0].minor.yy567);
                                                delete yymsp[-4].minor.yy239;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 339: /* exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                yygotominor.yy456->initOrderedSetAggregate(stripObjName(*(yymsp[-11].minor.yy239)), *(yymsp[-9].minor.yy642), *(yymsp[-8].minor.yy143), yymsp[-1].minor.yy456);
                                                delete yymsp[-11].minor.yy239;
                                                delete yymsp[-9].minor.yy642;
                                                delete yymsp[-8].minor.yy143;
                                                objectForTokens = yygotominor.yy456;
                                            }
        break;
      case 340: /* expr ::= */
{
                                                yygotominor.yy456 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy456;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 346: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy232 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 347: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy143->append(yymsp[-2].minor.yy456);
                                                yymsp[-4].minor.yy143->append(yymsp[0].minor.yy456);
                                                yygotominor.yy143 = yymsp[-4].minor.yy143;
                                            }
        break;
      case 348: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy143 = new ParserExprList();
                                                yygotominor.yy143->append(yymsp[-2].minor.yy456);
                                                yygotominor.yy143->append(yymsp[0].minor.yy456);
                                            }
        break;
      case 355: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy143->append(yymsp[0].minor.yy456);
                                                yygotominor.yy143 = yymsp[-2].minor.yy143;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 356: /* nexprlist ::= exprx */
{
                                                yygotominor.yy143 = new ParserExprList();
                                                yygotominor.yy143->append(yymsp[0].minor.yy456);
                                            }
        break;
      case 357: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy147 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy515),
                                                        *(yymsp[-8].minor.yy515),
                                                        *(yymsp[-7].minor.yy239),
                                                        *(yymsp[-6].minor.yy239),
                                                        *(yymsp[-4].minor.yy239),
                                                        *(yymsp[-2].minor.yy459),
                                                        yymsp[0].minor.yy456
                                                    );
                                                delete yymsp[-8].minor.yy515;
                                                delete yymsp[-10].minor.yy515;
                                                delete yymsp[-7].minor.yy239;
                                                delete yymsp[-6].minor.yy239;
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-2].minor.yy459;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 358: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,205,&yymsp[-3].minor);
}
        break;
      case 363: /* idxlist_opt ::= */
{yygotominor.yy240 = new ParserIndexedColumnList();}
        break;
      case 364: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
        break;
      case 365: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy240->append(yymsp[0].minor.yy460);
                                                yygotominor.yy240 = yymsp[-2].minor.yy240;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 366: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy240 = new ParserIndexedColumnList();
                                                yygotominor.yy240->append(yymsp[0].minor.yy460);
                                            }
        break;
      case 367: /* idxlist_single ::= nm collate sortorder */
      case 368: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==368);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy239),
                                                        *(yymsp[-1].minor.yy239),
                                                        *(yymsp[0].minor.yy509)
                                                    );
                                                yygotominor.yy460 = obj;
                                                delete yymsp[0].minor.yy509;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[-1].minor.yy239;
                                                objectForTokens = yygotominor.yy460;
                                            }
        break;
      case 372: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy147 = new SqliteDropIndex(*(yymsp[-1].minor.yy515), yymsp[0].minor.yy648->name1, yymsp[0].minor.yy648->name2);
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[0].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 375: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy147 = new SqliteVacuum(yymsp[0].minor.yy456);
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 376: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy147 = new SqliteVacuum(*(yymsp[-1].minor.yy239), yymsp[0].minor.yy456);
                                                delete yymsp[-1].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 379: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy147 = new SqlitePragma(*(yymsp[-1].minor.yy239), *(yymsp[0].minor.yy239));
                                                delete yymsp[-1].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 380: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 382: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==382);
{
                                                yygotominor.yy147 = new SqlitePragma(*(yymsp[-3].minor.yy239), *(yymsp[-2].minor.yy239), *(yymsp[0].minor.yy13), true);
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy13;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 381: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 383: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==383);
{
                                                yygotominor.yy147 = new SqlitePragma(*(yymsp[-4].minor.yy239), *(yymsp[-3].minor.yy239), *(yymsp[-1].minor.yy13), false);
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-1].minor.yy13;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 387: /* nmnum ::= nm */
{
                                                yygotominor.yy13 = new QVariant(*(yymsp[0].minor.yy239));
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 388: /* nmnum ::= ON */
      case 389: /* nmnum ::= DELETE */ yytestcase(yyruleno==389);
      case 390: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==390);
{yygotominor.yy13 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 393: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy13->userType() == QMetaType::Double)
                                                    *(yymsp[0].minor.yy13) = -(yymsp[0].minor.yy13->toDouble());
                                                else if (yymsp[0].minor.yy13->userType() == QMetaType::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy13) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy13) = -(yymsp[0].minor.yy13->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy13 = yymsp[0].minor.yy13;
                                            }
        break;
      case 396: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy147 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy642),
                                                        *(yymsp[-11].minor.yy515),
                                                        *(yymsp[-10].minor.yy239),
                                                        *(yymsp[-9].minor.yy239),
                                                        *(yymsp[-5].minor.yy239),
                                                        *(yymsp[-8].minor.yy500),
                                                        yymsp[-7].minor.yy87,
                                                        *(yymsp[-4].minor.yy115),
                                                        yymsp[-3].minor.yy456,
                                                        *(yymsp[-1].minor.yy198),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy515;
                                                delete yymsp[-13].minor.yy642;
                                                delete yymsp[-8].minor.yy500;
                                                delete yymsp[-4].minor.yy115;
                                                delete yymsp[-10].minor.yy239;
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-9].minor.yy239;
                                                delete yymsp[-1].minor.yy198;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 397: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy147 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy642),
                                                        *(yymsp[-8].minor.yy515),
                                                        *(yymsp[-7].minor.yy239),
                                                        *(yymsp[-6].minor.yy239),
                                                        *(yymsp[-2].minor.yy239),
                                                        *(yymsp[-5].minor.yy500),
                                                        yymsp[-4].minor.yy87,
                                                        *(yymsp[-1].minor.yy115),
                                                        yymsp[0].minor.yy456,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy515;
                                                delete yymsp[-10].minor.yy642;
                                                delete yymsp[-5].minor.yy500;
                                                delete yymsp[-1].minor.yy115;
                                                delete yymsp[-7].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[-6].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 398: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy147 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy642),
													*(yymsp[-10].minor.yy515),
													*(yymsp[-9].minor.yy239),
													*(yymsp[-8].minor.yy239),
													*(yymsp[-4].minor.yy239),
													*(yymsp[-7].minor.yy500),
													yymsp[-6].minor.yy87,
													*(yymsp[-3].minor.yy115),
													yymsp[-2].minor.yy456,
													*(yymsp[0].minor.yy198),
													3
                                                );
                                                delete yymsp[-10].minor.yy515;
                                                delete yymsp[-12].minor.yy642;
                                                delete yymsp[-7].minor.yy500;
                                                delete yymsp[-3].minor.yy115;
                                                delete yymsp[-9].minor.yy239;
                                                delete yymsp[-4].minor.yy239;
                                                delete yymsp[-8].minor.yy239;
                                                delete yymsp[0].minor.yy198;
                                                objectForTokens = yygotominor.yy147;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 399: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,207,&yymsp[-8].minor);
  yy_destructor(yypParser,205,&yymsp[-5].minor);
  yy_destructor(yypParser,303,&yymsp[-3].minor);
  yy_destructor(yypParser,304,&yymsp[-2].minor);
}
        break;
      case 402: /* trigger_time ::= BEFORE */
{yygotominor.yy500 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 403: /* trigger_time ::= AFTER */
{yygotominor.yy500 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 404: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy500 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 405: /* trigger_time ::= */
{yygotominor.yy500 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 406: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy87 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy87;
                                            }
        break;
      case 407: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy87 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy87;
                                            }
        break;
      case 408: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy87 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy87;
                                            }
        break;
      case 409: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy87 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy159));
                                                delete yymsp[0].minor.yy159;
                                                objectForTokens = yygotominor.yy87;
                                            }
        break;
      case 410: /* foreach_clause ::= */
{yygotominor.yy115 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 411: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy115 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 414: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy198->append(yymsp[-1].minor.yy147);
                                                yygotominor.yy198 = yymsp[-2].minor.yy198;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 415: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy198 = new ParserQueryList();
                                                yygotominor.yy198->append(yymsp[-1].minor.yy147);
                                            }
        break;
      case 416: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy198 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 421: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 422: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy147 = new SqliteDropTrigger(*(yymsp[-1].minor.yy515), yymsp[0].minor.yy648->name1, yymsp[0].minor.yy648->name2);
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[0].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 425: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy147 = new SqliteAttach(*(yymsp[-4].minor.yy515), yymsp[-3].minor.yy456, yymsp[-1].minor.yy456, yymsp[0].minor.yy456);
                                                delete yymsp[-4].minor.yy515;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 426: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy147 = new SqliteDetach(*(yymsp[-1].minor.yy515), yymsp[0].minor.yy456);
                                                delete yymsp[-1].minor.yy515;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 431: /* cmd ::= REINDEX */
{yygotominor.yy147 = new SqliteReindex();}
        break;
      case 432: /* cmd ::= REINDEX nm dbnm */
      case 433: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==433);
{
                                                yygotominor.yy147 = new SqliteReindex(*(yymsp[-1].minor.yy239), *(yymsp[0].minor.yy239));
                                                delete yymsp[-1].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 436: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy147 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 437: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy147 = new SqliteAnalyze(*(yymsp[-1].minor.yy239), *(yymsp[0].minor.yy239));
                                                delete yymsp[-1].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 440: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy147 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy648->name1,
                                                        yymsp[-3].minor.yy648->name2,
                                                        *(yymsp[0].minor.yy239)
                                                    );
                                                delete yymsp[0].minor.yy239;
                                                delete yymsp[-3].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 441: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy147 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy648->name1,
                                                        yymsp[-3].minor.yy648->name2,
                                                        *(yymsp[-1].minor.yy515),
                                                        yymsp[0].minor.yy123
                                                    );
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[-3].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 442: /* cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm */
{
                                                yygotominor.yy147 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy648->name1,
                                                        yymsp[-3].minor.yy648->name2,
                                                        *(yymsp[-1].minor.yy515),
                                                        *(yymsp[0].minor.yy239)
                                                    );
                                                delete yymsp[-1].minor.yy515;
                                                delete yymsp[-3].minor.yy648;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 443: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO nm */
{
                                               yygotominor.yy147 = new SqliteAlterTable(
                                                       yymsp[-5].minor.yy648->name1,
                                                       yymsp[-5].minor.yy648->name2,
                                                       *(yymsp[-3].minor.yy515),
                                                       *(yymsp[-2].minor.yy239),
                                                       *(yymsp[0].minor.yy239)
                                                   );
                                               delete yymsp[-3].minor.yy515;
                                               delete yymsp[-5].minor.yy648;
                                               delete yymsp[-2].minor.yy239;
                                               delete yymsp[0].minor.yy239;
                                               objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 444: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
      case 445: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt ID_COL */ yytestcase(yyruleno==445);
{  yy_destructor(yypParser,209,&yymsp[-3].minor);
}
        break;
      case 446: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy147 = new SqliteAlterTable(
                                                        yymsp[-2].minor.yy648->name1,
                                                        yymsp[-2].minor.yy648->name2,
                                                        *(yymsp[0].minor.yy515),
                                                        QString(),
                                                        QString()
                                                    );
                                                delete yymsp[0].minor.yy515;
                                                delete yymsp[-2].minor.yy648;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 447: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO ID_COL_NEW */
{  yy_destructor(yypParser,209,&yymsp[-5].minor);
  yy_destructor(yypParser,205,&yymsp[-2].minor);
}
        break;
      case 453: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy147 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy515),
                                                        *(yymsp[-3].minor.yy239),
                                                        *(yymsp[-2].minor.yy239),
                                                        *(yymsp[0].minor.yy239)
                                                    );
                                                delete yymsp[-4].minor.yy515;
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-2].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 454: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy147 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy515),
                                                        *(yymsp[-6].minor.yy239),
                                                        *(yymsp[-5].minor.yy239),
                                                        *(yymsp[-3].minor.yy239),
                                                        *(yymsp[-1].minor.yy159)
                                                    );
                                                delete yymsp[-6].minor.yy239;
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-3].minor.yy239;
                                                delete yymsp[-7].minor.yy515;
                                                delete yymsp[-1].minor.yy159;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 457: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy159 = new QStringList();
                                                yygotominor.yy159->append((yymsp[0].minor.yy239)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 458: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy159->append((yymsp[0].minor.yy239)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy159 = yymsp[-2].minor.yy159;
                                                delete yymsp[0].minor.yy239;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 460: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy239->append(" "+ *(yymsp[0].minor.yy239));
                                                yygotominor.yy239 = yymsp[-1].minor.yy239;
                                                delete yymsp[0].minor.yy239;
                                            }
        break;
      case 461: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy239 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 462: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy239 = new QString("(");
                                                yygotominor.yy239->append(*(yymsp[-1].minor.yy239));
                                                yygotominor.yy239->append(")");
                                                delete yymsp[-1].minor.yy239;
                                            }
        break;
      case 464: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy239 = yymsp[-3].minor.yy239;
                                                yygotominor.yy239->append("(");
                                                yygotominor.yy239->append(*(yymsp[-1].minor.yy239));
                                                yygotominor.yy239->append(")");
                                                delete yymsp[-1].minor.yy239;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 465: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy239 = yymsp[-1].minor.yy239;
                                                yygotominor.yy239->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 466: /* with ::= */
{yygotominor.yy137 = nullptr;}
        break;
      case 467: /* with ::= WITH wqlist */
{
                                                yygotominor.yy137 = new SqliteWith(*(yymsp[0].minor.yy512));
                                                delete yymsp[0].minor.yy512;
                                                objectForTokens = yygotominor.yy137;
                                            }
        break;
      case 468: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy137 = new SqliteWith(*(yymsp[0].minor.yy512));
                                                yygotominor.yy137->recursive = true;
                                                delete yymsp[0].minor.yy512;
                                                objectForTokens = yygotominor.yy137;
                                            }
        break;
      case 469: /* wqas ::= AS */
{yygotominor.yy407 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::ANY);}
        break;
      case 470: /* wqas ::= AS MATERIALIZED */
{yygotominor.yy407 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::MATERIALIZED);}
        break;
      case 471: /* wqas ::= AS NOT MATERIALIZED */
{yygotominor.yy407 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::NOT_MATERIALIZED);}
        break;
      case 472: /* wqlist ::= wqcte */
{
                                                yygotominor.yy512 = new ParserCteList();
                                                yygotominor.yy512->append(yymsp[0].minor.yy158);
                                            }
        break;
      case 473: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy512 = yymsp[-2].minor.yy512;
                                                yygotominor.yy512->append(yymsp[0].minor.yy158);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 474: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 475: /* wqcte ::= nm idxlist_opt wqas LP select RP */
{
                                                yygotominor.yy158 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy239), *(yymsp[-4].minor.yy240), yymsp[-1].minor.yy113, *(yymsp[-3].minor.yy407));
                                                delete yymsp[-5].minor.yy239;
                                                delete yymsp[-4].minor.yy240;
                                                delete yymsp[-3].minor.yy407;
                                                objectForTokens = yygotominor.yy158;
                                            }
        break;
      case 476: /* windowdefn_list ::= windowdefn */
{
                                                    yygotominor.yy339 = new ParserWindowDefList();
                                                    yygotominor.yy339->append(yymsp[0].minor.yy522);
                                                }
        break;
      case 477: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy339->append(yymsp[0].minor.yy522);
												yygotominor.yy339 = yymsp[-2].minor.yy339;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 478: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy522 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy239), yymsp[-1].minor.yy199);
												delete yymsp[-4].minor.yy239;
												objectForTokens = yygotominor.yy522;
											}
        break;
      case 479: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->initPartitionBy(QString(), *(yymsp[-2].minor.yy143), *(yymsp[-1].minor.yy459), yymsp[0].minor.yy89);
												delete yymsp[-2].minor.yy143;
												delete yymsp[-1].minor.yy459;
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 480: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->initPartitionBy(*(yymsp[-5].minor.yy239), *(yymsp[-2].minor.yy143), *(yymsp[-1].minor.yy459), yymsp[0].minor.yy89);
												delete yymsp[-2].minor.yy143;
												delete yymsp[-5].minor.yy239;
												delete yymsp[-1].minor.yy459;
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 481: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->initOrderBy(QString(), *(yymsp[-1].minor.yy459), yymsp[0].minor.yy89);
												delete yymsp[-1].minor.yy459;
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 482: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->initOrderBy(*(yymsp[-4].minor.yy239), *(yymsp[-1].minor.yy459), yymsp[0].minor.yy89);
												delete yymsp[-1].minor.yy459;
												delete yymsp[-4].minor.yy239;
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 483: /* window ::= frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->init(QString(), yymsp[0].minor.yy89);
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 484: /* window ::= nm frame_opt */
{
												yygotominor.yy199 = new SqliteWindowDefinition::Window();
												yygotominor.yy199->init(QString(), yymsp[0].minor.yy89);
												delete yymsp[-1].minor.yy239;
												objectForTokens = yygotominor.yy199;
											}
        break;
      case 485: /* frame_opt ::= */
{yygotominor.yy89 = nullptr;}
        break;
      case 486: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy89 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy282), yymsp[-1].minor.yy169, nullptr, *(yymsp[0].minor.yy271));
												delete yymsp[-2].minor.yy282;
												delete yymsp[0].minor.yy271;
												objectForTokens = yygotominor.yy89;
											}
        break;
      case 487: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy89 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy282), yymsp[-3].minor.yy169, yymsp[-1].minor.yy169, *(yymsp[0].minor.yy271));
												delete yymsp[-5].minor.yy282;
												delete yymsp[0].minor.yy271;
												objectForTokens = yygotominor.yy89;
											}
        break;
      case 488: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy282 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 489: /* frame_bound_s ::= frame_bound */
      case 491: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==491);
{
												yygotominor.yy169 = yymsp[0].minor.yy169;
												objectForTokens = yygotominor.yy169;
											}
        break;
      case 490: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 492: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==492);
      case 494: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==494);
{
												yygotominor.yy169 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy169;
											}
        break;
      case 493: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy169 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy456, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy169;
											}
        break;
      case 495: /* frame_exclude_opt ::= */
{
												yygotominor.yy271 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 496: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy271 = yymsp[0].minor.yy271;
											}
        break;
      case 497: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy271 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 498: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy271 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 499: /* frame_exclude ::= GROUP */
{
												yygotominor.yy271 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 500: /* frame_exclude ::= TIES */
{
												yygotominor.yy271 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 501: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy339 = yymsp[0].minor.yy339;
											}
        break;
      case 502: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy567 = new SqliteFilterOver(yymsp[-1].minor.yy341, yymsp[0].minor.yy663);
												objectForTokens = yygotominor.yy567;
											}
        break;
      case 503: /* filter_over ::= over_clause */
{
												yygotominor.yy567 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy663);
												objectForTokens = yygotominor.yy567;
											}
        break;
      case 504: /* filter_over ::= filter_clause */
{
												yygotominor.yy567 = new SqliteFilterOver(yymsp[0].minor.yy341, nullptr);
												objectForTokens = yygotominor.yy567;
											}
        break;
      case 505: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy663 = new SqliteFilterOver::Over(yymsp[-1].minor.yy199);
												objectForTokens = yygotominor.yy663;
											}
        break;
      case 506: /* over_clause ::= OVER nm */
{
												yygotominor.yy663 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy239));
												delete yymsp[0].minor.yy239;
												objectForTokens = yygotominor.yy663;
											}
        break;
      case 507: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy341 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy456);
												objectForTokens = yygotominor.yy341;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens && yypParser->yyidx >= 0)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

int sqlite3ParserFallback(int iToken) {
    return yyFallback[iToken];
}
