/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.Collections;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseLine
extends AbstractComponent {
    private final HColor color;
    private final boolean continueLine;
    private final UStroke stroke;
    private final Display stringsToDisplay;

    public ComponentRoseLine(Style style, boolean continueLine, HColorSet set, Display stringsToDisplay) {
        super(style);
        this.color = style.value(PName.LineColor).asColor(set);
        this.stroke = style.getStroke();
        this.continueLine = continueLine;
        this.stringsToDisplay = stringsToDisplay == null ? Display.NULL : stringsToDisplay;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(this.color);
        ug = ug.apply(this.stroke);
        ug.startGroup(Collections.singletonMap(UGroupType.TITLE, this.stringsToDisplay.toTooltipText()));
        this.drawTitleHoverTargetRect(ug, dimensionToUse);
        int x = (int)(dimensionToUse.getWidth() / 2.0);
        ug.apply(UTranslate.dx(x)).draw(ULine.vline(dimensionToUse.getHeight()));
        ug.closeGroup();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }

    private void drawTitleHoverTargetRect(UGraphic ug, XDimension2D dimensionToUse) {
        double hoverTargetWidth = 8.0;
        ug = ug.apply(UStroke.withThickness(0.0));
        ug = ug.apply(HColors.transparent());
        ug = ug.apply(UTranslate.dx((dimensionToUse.getWidth() - 8.0) / 2.0));
        ug.draw(URectangle.build(8.0, dimensionToUse.getHeight()));
    }
}

