/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/GetPromiseWithResolvers.ts":
/*!****************************************!*\
  !*** ./src/GetPromiseWithResolvers.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetPromiseWithResolvers = GetPromiseWithResolvers;
// from: typescript/lib/lib.es2024.promise.d.ts
// interface PromiseConstructor {
//     /**
//      * Creates a new Promise and returns it in an object, along with its resolve and reject functions.
//      * @returns An object with the properties `promise`, `resolve`, and `reject`.
//      *
//      * ```ts
//      * const { promise, resolve, reject } = Promise.withResolvers<T>();
//      * ```
//      */
//     withResolvers<T>(): PromiseWithResolvers<T>;
// }
class Defer {
    constructor() {
        this.promise = new Promise((res, rej) => {
            this.resolve = res;
            this.reject = rej;
        });
    }
}
function GetPromiseWithResolvers() {
    if ('withResolvers' in Promise) {
        return Promise['withResolvers']();
    }
    return new Defer();
}


/***/ }),

/***/ "./src/I18N.ts":
/*!*********************!*\
  !*** ./src/I18N.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModI18N = void 0;
exports.sleep = sleep;
const json_1 = __webpack_require__(/*! @streamparser/json */ "./node_modules/@streamparser/json/dist/cjs/index.js");
const TypeB_1 = __webpack_require__(/*! ./TypeB */ "./src/TypeB.ts");
const tsafe_1 = __webpack_require__(/*! tsafe */ "./node_modules/tsafe/index.js");
const GetPromiseWithResolvers_1 = __webpack_require__(/*! ./GetPromiseWithResolvers */ "./src/GetPromiseWithResolvers.ts");
function sleep(ms = 0) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
class ModI18N {
    constructor() {
        this.modUtils = window.modUtils;
        this.modSC2DataManager = window.modSC2DataManager;
        this._ = window.modUtils.getLodash();
        this.logger = this.modUtils.getLogger();
        this.idbRef = this.modUtils.getIdbRef();
        this.idbKeyValRef = this.modUtils.getIdbKeyValRef();
    }
    checkItem(t) {
        let c = t
            && this._.isString(this._.get(t, 'f'))
            && this._.isString(this._.get(t, 't'))
            && this._.isNumber(this._.get(t, 'pos'));
        if (t.passageName) {
            c = c && this._.isString(t.passageName);
        }
        if (this._.has(t, 'pN')) {
            c = c && this._.isString(this._.get(t, 'pN'));
        }
        if (t.css || t.js) {
            c = c && this._.isString(t.fileName);
        }
        // console.log('checkItem', [c, [
        //     this._.isString(this._.get(t, 'f')),
        //     this._.isString(this._.get(t, 't')),
        //     this._.isNumber(this._.get(t, 'pos')),
        //     t.passageName ? this._.isString(t.passageName) : true,
        //     this._.has(t, 'pN') ? this._.isString(this._.get(t, 'pN')) : true,
        //     t.css || t.js ? this._.isString(t.fileName) : true,
        // ]]);
        return c;
    }
    checkAndProcessData(T) {
        if (T && T.typeB && T.typeB.TypeBOutputText && T.typeB.TypeBInputStoryScript) {
            const cacheTypeBOutputText = T.typeB.TypeBOutputText.map((T) => {
                if (!this.checkItem(T)) {
                    console.error('I18NMod checkAndProcessData TypeBOutputText (!this.checkItem(T))', T);
                }
                return Object.assign(T, {
                    from: T.f,
                    to: T.t,
                });
            });
            const cacheTypeBInputStoryScript = T.typeB.TypeBInputStoryScript.map((T) => {
                if (!this.checkItem(T)) {
                    console.error('I18NMod checkAndProcessData TypeBInputStoryScript (!this.checkItem(T))', T);
                }
                return Object.assign(T, {
                    from: T.f,
                    to: T.t,
                    passageName: T.pN,
                });
            });
            return [cacheTypeBOutputText, cacheTypeBInputStoryScript];
        }
        return undefined;
    }
    patchVersionString() {
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
    }
    async readZipStream() {
        var _a;
        this.logger.log('patching i18n mod...');
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
        if (!selfZip) {
            this.logger.log('ModI18N zip not found');
            return;
        }
        const regex = /"([vV]\d+(?:\.\w+)+)"/;
        const str = (_a = this.modSC2DataManager.getSC2DataInfoCache().passageDataItems.map.get('Version')) === null || _a === void 0 ? void 0 : _a.content;
        const match = str ? str.match(regex) : null;
        if (match) {
            const version = match[1];
            const modI18N = this.modSC2DataManager.getModLoader().getModByNameOne('ModI18N');
            if (modI18N && modI18N.mod.version.indexOf(version) === -1) {
                if (window.modSweetAlert2Mod) {
                    window.modSweetAlert2Mod.fire({
                        title: '当前汉化与游戏版本不匹配！',
                        text: "当前汉化适应" + modI18N.mod.version.split('-')[0] + "。当前游戏版本" + version + "！请重新加载正确的汉化或游戏版本。",
                        icon: 'error',
                        confirmButtonText: '我知道了'
                    });
                }
                return;
            }
        }
        // 获取mod的hash用于版本校验
        const currentHash = selfZip.modZipReaderHash;
        const cachedData = await this.I18NGetFromIDB(currentHash);
        if (cachedData) {
            this.logger.log('Using cached i18n data');
            this.typeB = new TypeB_1.ModI18NTypeB(cachedData.resultB, cachedData.resultBInput);
        }
        else {
            await this.I18NCleanCache();
            // 缓存未命中,使用原始解析方法
            this.logger.log('Cache miss, parsing i18n data...');
            const { resultB, resultBInput } = await this.parseOriginalZip(selfZip);
            await this.I18NSaveToIDB({
                hash: currentHash.toString(),
                resultB,
                resultBInput
            });
            this.typeB = new TypeB_1.ModI18NTypeB(resultB, resultBInput);
        }
        this.logger.log('Starting replace...');
        await sleep(10);
        await this.startReplace();
        this.modSC2DataManager.getLanguageManager().mainLanguage = 'zh';
        this.logger.log('[i18n] caching image');
        for (const img of selfZip.modInfo.imgs) {
            // force load banner and other image , to avoid read error after release zip file
            await img.getter.forceCache();
        }
        // 释放zip
        selfZip.gcReleaseZip();
        this.typeB.destroy();
        this.typeB = undefined;
        this.logger.log('GC complete');
        this.logger.log('I18n patch complete');
        await sleep(10);
    }
    // 原始zip解析方法
    async parseOriginalZip(selfZip) {
        var _a;
        const parser = new json_1.JSONParser({
            stringBufferSize: 1024,
            keepStack: false,
            paths: ['$.typeB.TypeBOutputText.*', '$.typeB.TypeBInputStoryScript.*']
        });
        let resultB = [];
        let resultBInput = [];
        var maxusage = 0;
        parser.onValue = ({ value, key, parent, stack }) => {
            if (stack.length < 2)
                return;
            if (stack[2].key === 'TypeBOutputText') {
                if (this.checkItem(value)) {
                    resultB.push({
                        from: value.f,
                        to: value.t,
                        pos: value.pos,
                        fileName: value.fileName,
                        js: value.js,
                    });
                }
            }
            else if (stack[2].key === 'TypeBInputStoryScript') {
                if (this.checkItem(value)) {
                    (0, tsafe_1.assert)(!!value.pN, 'pN must exist if it is TypeBInputStoryScript.');
                    resultBInput.push({
                        from: value.f,
                        to: value.t,
                        pos: value.pos,
                        fileName: value.fileName,
                        passageName: value.pN,
                    });
                }
            }
            if (parent !== undefined) {
                //console.log(parent.length);
                //const used = process.memoryUsage().heapUsed / 1024 / 1024;
                //if (used > maxusage)
                //    maxusage = used;
                parent.length = 0;
            }
        };
        //internalStream 在ts注解里面不存在，但是实际上是有这个方法的
        const logger = this.logger;
        let previousPercent = 0;
        if (selfZip.zip.is_JeremieModLoader_ModPack) {
            // get the underlying ModPackFileReader API , to direct get file byte from ModPack in-memory buffer.
            const fileDataRef = await selfZip.zip.getFile('i18n.json');
            if (!fileDataRef) {
                console.error('i18n.json not found in ModI18N zip');
                this.logger.error('i18n.json not found in ModI18N zip');
                throw new Error('i18n.json not found in ModI18N zip');
            }
            // use TextDecoderStream to decode UInt8Array to string with stream.
            // in some case , this will be a zero-copy operation.
            // and, the Uint8Array be inplace reading when ModPack file not encrypt.
            // so , we will get a very low memory usage reading way.
            const ts = new TextDecoderStream();
            const writer = ts.writable.getWriter();
            const reader = ts.readable.getReader();
            const readDefer = (0, GetPromiseWithResolvers_1.GetPromiseWithResolvers)();
            const readThr = async () => {
                try {
                    while (true) {
                        const { value, done } = await reader.read();
                        if (done)
                            break;
                        parser.write(value);
                    }
                    readDefer.resolve();
                }
                catch (e) {
                    console.error('ModI18N readThr error', e);
                    readDefer.reject(e);
                }
            };
            const writeThr = async () => {
                try {
                    for (let i = 0; i < fileDataRef.length;) {
                        await writer.ready;
                        const start = i;
                        const end = Math.min(i + 1024, fileDataRef.length);
                        const chunk = fileDataRef.slice(start, end);
                        await writer.write(chunk);
                        i = end;
                        const floorValue = Math.floor((i / fileDataRef.length) * 100);
                        if (previousPercent !== floorValue) {
                            previousPercent = floorValue;
                            if ((previousPercent % 10) === 0) {
                                logger.log('[i18n] Loading...... ' + floorValue);
                            }
                        }
                    }
                    // must call again to ensure last chunk is flushed
                    await writer.ready;
                    await writer.close();
                }
                catch (e) {
                    console.error('ModI18N writeThr error', e);
                    await writer.close();
                }
            };
            readThr().catch(E => {
                console.error('ModI18N readThr outer error', E);
            });
            writeThr().catch(E => {
                console.error('ModI18N writeThr outer error', E);
            });
            await readDefer.promise;
        }
        else {
            // selfZip.zip.file("i18n.json")!.async('string');
            // use the underlying stream method to avoid load all file to memory
            const stream = (_a = selfZip.zip.file("i18n.json")) === null || _a === void 0 ? void 0 : _a.internalStream("string");
            const promise = new Promise(function (resolve, reject) {
                stream
                    .on('data', function (dataChunk, metadata) {
                    const floorValue = Math.floor(metadata.percent);
                    if (previousPercent !== floorValue) {
                        previousPercent = floorValue;
                        if ((previousPercent % 10) === 0) {
                            logger.log('[i18n] Loading...... ' + floorValue);
                        }
                    }
                    parser.write(dataChunk);
                })
                    .on("error", function (err) {
                    reject(err);
                })
                    .on("end", function () {
                    try {
                        resolve(0);
                    }
                    catch (e) {
                        reject(e);
                    }
                })
                    .resume();
            });
            await promise;
        }
        return { resultB, resultBInput };
    }
    // IndexedDB操作方法
    async I18NGetFromIDB(hash) {
        const hashKey = hash.toString();
        const db = await this.idbRef.idb_openDB('i18n-cache', 1, {
            upgrade(db) {
                db.createObjectStore('translations', { keyPath: 'hash' });
            },
        });
        const cached = await db.get('translations', hashKey);
        db.close();
        return cached;
    }
    async I18NSaveToIDB(data) {
        const db = await this.idbRef.idb_openDB('i18n-cache', 1);
        await db.put('translations', data);
        db.close();
    }
    async I18NCleanCache() {
        const db = await this.idbRef.idb_openDB('i18n-cache', 1);
        await db.clear('translations');
        db.close();
    }
    async startReplace() {
        if (this.typeB === undefined)
            return;
        // start replace
        const sc2DataCache = this.modSC2DataManager.getSC2DataInfoAfterPatch();
        // console.log('i18nJson sc2DataCache', sc2DataCache);
        const sc2Data = sc2DataCache.cloneSC2DataInfo();
        // console.log('i18nJson sc2Data', sc2Data);
        this.logger.log('[i18n] replace style ... ');
        await sleep(10);
        for (const styleItem of sc2Data.styleFileItems.items) {
            const name = sc2Data.scriptFileItems.getNoPathNameFromString(styleItem.name);
            styleItem.content = this.typeB.replaceCss(styleItem.content, name);
        }
        this.logger.log('[i18n] replace script ... ');
        await sleep(10);
        for (const scriptItem of sc2Data.scriptFileItems.items) {
            const name = sc2Data.scriptFileItems.getNoPathNameFromString(scriptItem.name);
            scriptItem.content = this.typeB.replaceJs(scriptItem.content, name);
        }
        this.logger.log('[i18n] replace passage ... ');
        await sleep(10);
        for (const pd of sc2Data.passageDataItems.items) {
            pd.content = this.typeB.replaceInputStoryScript(pd.content, pd.name);
        }
        this.logger.log('[i18n] rebuilding ... ');
        await sleep(10);
        console.log('sc2DataCache', sc2DataCache);
        console.log('sc2Data', sc2Data);
        sc2Data.styleFileItems.fillMap();
        sc2Data.scriptFileItems.fillMap();
        sc2Data.passageDataItems.fillMap();
        this.modUtils.replaceFollowSC2DataInfo(sc2Data, sc2DataCache);
    }
    async readZipSelf() {
        var _a;
        this.logger.log('patching i18n mod ........');
        const selfZip = this.modSC2DataManager.getModLoader().getModZip('ModI18N');
        if (selfZip) {
            // load i18n.json from mod zip file
            const i18nJsonS = await ((_a = selfZip.zip.file('i18n.json')) === null || _a === void 0 ? void 0 : _a.async('string').catch((err) => {
                console.error(err);
                return undefined;
            }));
            if (i18nJsonS) {
                let i18nJson;
                try {
                    i18nJson = JSON.parse(i18nJsonS);
                }
                catch (e) {
                    console.error(e);
                }
                console.log('i18nJson', i18nJson);
                const cc = this.checkAndProcessData(i18nJson);
                if (!cc) {
                    console.error('I18NMod checkAndProcessData (!cc)');
                    return;
                }
                this.typeB = new TypeB_1.ModI18NTypeB(cc[0], cc[1]);
                await this.startReplace();
                this.modSC2DataManager.getLanguageManager().mainLanguage = 'zh';
            }
        }
        else {
            console.error('I18NMod cannot read zip self');
            this.logger.error('I18NMod cannot read zip self');
        }
    }
}
exports.ModI18N = ModI18N;


/***/ }),

/***/ "./src/TypeB.ts":
/*!**********************!*\
  !*** ./src/TypeB.ts ***!
  \**********************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModI18NTypeB = void 0;
// come from GPT-4
function ModI18NTypeB_normalizeSearchPattern(pattern) {
    return new RegExp(ModI18NTypeB_normalizeSearchString(pattern), 'g');
}
// come from GPT-4
function ModI18NTypeB_escapedPatternString(pattern) {
    return pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
// come from GPT-4
function ModI18NTypeB_normalizeSearchString(pattern) {
    // 转义正则表达式中的特殊字符
    const escapedPattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    const p = `[^a-zA-Z0-9_$\{\}\`\"\'\|]${escapedPattern}[^a-zA-Z0-9_$\{\}\`\"\'\|]`;
    // console.log('p:', [p]);
    return p;
}
// come from GPT-4
function ModI18NTypeB_ignoreSpaceString(pattern) {
    // 转义正则表达式中的特殊字符
    const escapedPattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    // 转换空格
    // return escapedPattern.replace(/\s+/g, '\\s*');
    // return escapedPattern.split('').map(c => c.trim() ? c + '\\s*' : '').join('');
    const cc = escapedPattern.split('');
    for (let i = 0; i < cc.length; i++) {
        const ct = cc[i].trim();
        if (ct === '') {
            cc[i] = '';
        }
        else if (ct !== '\\') {
            cc[i] = cc[i] + '\\s*';
        }
        else {
            cc[i] = cc[i];
        }
    }
    return ['\\s*', ...cc, '\\s*'].join('');
}
// GPT-4
function fuzzyMatchManual(strA, strB, startIndex = 0) {
    let j = startIndex;
    // 去除字符串B中的空白字符
    const b = strB.replace(/\s+/g, '');
    for (let i = 0; i < b.length; i++) {
        // 跳过字符串A中的空白字符
        while (j < strA.length && /\s/.test(strA[j])) {
            j++;
        }
        // 如果字符串A已经结束，但字符串B还没有，返回-1
        if (j >= strA.length)
            return -1;
        // 比较两个字符，如果不同，返回-1
        if (strA[j] !== b[i])
            return -1;
        j++;
    }
    return j;
}
// class ModI18NTypeB_OutputTextMatcher
class ModI18NTypeB_PassageMatcher {
    constructor(mt) {
        this.mt = mt;
        console.log('ModI18NTypeB_PassageMatcher constructor', [mt]);
        this.passagebuffer = new Map();
        mt.forEach((v) => {
            // console.log('ModI18NTypeB_PassageMatcher constructor', [v.from], rs);
            if (this.passagebuffer.has(v.passageName)) {
                this.passagebuffer.get(v.passageName).push(v);
            }
            else {
                this.passagebuffer.set(v.passageName, [v]);
            }
        });
        for (const [k, v] of this.passagebuffer) {
            this.passagebuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
    }
    getByPassage(passageName) {
        if (passageName) {
            const pp = this.passagebuffer.get(passageName);
            if (pp) {
                return pp;
            }
            // console.log('cannot find passage:', passageName);
        }
        return undefined;
    }
    replacePassageContent(passageName, passageContent) {
        return this.replacePassageContentWithHintIndex(passageName, passageContent);
    }
    replacePassageContentWithHint(passageName, passageContent) {
        const pp = this.getByPassage(passageName);
        if (pp) {
            let s = passageContent;
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent passageName:', passageName);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent before:', [s]);
            for (const v of pp) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, passageName);
            }
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent after:', [s]);
            return s;
        }
        return passageContent;
    }
    replacePassageContentWithHintIndex(passageName, passageContent) {
        const pp = this.getByPassage(passageName);
        if (pp) {
            let s = passageContent;
            let textArray = [];
            let laxtIndex = 0;
            pp.sort((a, b) => a.pos - b.pos);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent passageName:', passageName);
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent before:', [pp, s]);
            // console.log(s);
            for (const v of pp) {
                let d = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHintIndexComp(textArray, s, v, passageName, laxtIndex);
                if (d.isError) {
                    // error happened , skip this passage
                    // add this logic to let we can have multi i18n mod work together.
                    // like apply dol i18n in dolp then write a dolp specific i18n mod to replace it special text.
                    console.warn('ModI18NTypeB_PassageMatcher replacePassageContentWithHintIndex skip passage due to error:', [passageName, v]);
                    return passageContent;
                }
                textArray = d[0];
                laxtIndex = d[1];
            }
            textArray.push(s.substring(laxtIndex));
            const r = textArray.join('');
            // console.log('ModI18NTypeB_PassageMatcher replacePassageContent after:', [textArray, r]);
            // console.log(r);
            return r;
        }
        return passageContent;
    }
    static strcmpOffset(src, target, offset = 0) {
        // 确保偏移量在合理范围内
        if (offset < 0 || offset >= src.length) {
            return -1;
        }
        // 使用循环进行字符比较
        for (let i = offset, j = 0; i < src.length && j < target.length; i++, j++) {
            if (src[i] < target[j])
                return -1;
            if (src[i] > target[j])
                return 1;
        }
        // 处理长度不同的情况
        if ((src.length - offset) < target.length)
            return -1;
        //这里说明全部匹配了，所以是相等
        //if ((src.length - offset) > target.length) return 1;
        return 0; // 如果两个字符串相等，返回 0
    }
    static isSubstringMatch(A, C, P) {
        // Check if P is within the bounds of A and if the substring from P can be at least as long as C
        if (P < 0 || P >= A.length || P + C.length > A.length) {
            return false;
        }
        // Compare each character one by one using charCodeAt
        for (let i = 0; i < C.length; i++) {
            if (A.charCodeAt(P + i) !== C.charCodeAt(i)) {
                return false;
            }
        }
        return true;
    }
    static tryReplaceStringFuzzyWithHintIndex(textArray, s, v, passageNameOrFileName, lastIndex) {
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos) == 0) {
            textArray.push(s.substring(lastIndex, v.pos), v.to);
            lastIndex = v.pos + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 1) == 0) {
            textArray.push(s.substring(lastIndex, v.pos - 1), v.to);
            lastIndex = v.pos - 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 2) == 0) {
            textArray.push(s.substring(lastIndex, v.pos - 2), v.to);
            lastIndex = v.pos - 2 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 1) == 0) {
            textArray.push(s.substring(lastIndex, v.pos + 1), v.to);
            lastIndex = v.pos + 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 2) == 0) {
            textArray.push(s.substring(lastIndex, v.pos + 2), v.to);
            lastIndex = v.pos + 2 + v.from.length;
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    textArray.push(s.substring(lastIndex, pStart), v.to);
                    lastIndex = pStart + v.from.length;
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHintIndex cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHintIndex cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
            }
        }
        return { 0: textArray, 1: lastIndex };
    }
    static tryReplaceStringFuzzyWithHintIndexComp(textArray, s, v, passageNameOrFileName, lastIndex) {
        let isError = false;
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos)) {
            textArray.push(s.substring(lastIndex, v.pos), v.to);
            lastIndex = v.pos + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos - 1)) {
            textArray.push(s.substring(lastIndex, v.pos - 1), v.to);
            lastIndex = v.pos - 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos - 2)) {
            textArray.push(s.substring(lastIndex, v.pos - 2), v.to);
            lastIndex = v.pos - 2 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos + 1)) {
            textArray.push(s.substring(lastIndex, v.pos + 1), v.to);
            lastIndex = v.pos + 1 + v.from.length;
        }
        else if (ModI18NTypeB_PassageMatcher.isSubstringMatch(s, v.from, v.pos + 2)) {
            textArray.push(s.substring(lastIndex, v.pos + 2), v.to);
            lastIndex = v.pos + 2 + v.from.length;
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    textArray.push(s.substring(lastIndex, pStart), v.to);
                    lastIndex = pStart + v.from.length;
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHintIndexComp cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                    isError = true;
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHintIndexComp cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                isError = true;
            }
        }
        return { 0: textArray, 1: lastIndex, isError: isError };
    }
    static tryReplaceStringFuzzyWithHint(s, v, passageNameOrFileName) {
        // first , we try to match and replace with const string in +-2 , this is the fastest way
        if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos) == 0) {
            s = s.substring(0, v.pos) + v.to + s.substring(v.pos + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 1) == 0) {
            s = s.substring(0, v.pos - 1) + v.to + s.substring(v.pos - 1 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos - 2) == 0) {
            s = s.substring(0, v.pos - 2) + v.to + s.substring(v.pos - 2 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 1) == 0) {
            s = s.substring(0, v.pos + 1) + v.to + s.substring(v.pos + 1 + v.from.length);
        }
        else if (ModI18NTypeB_PassageMatcher.strcmpOffset(s, v.from, v.pos + 2) == 0) {
            s = s.substring(0, v.pos + 2) + v.to + s.substring(v.pos + 2 + v.from.length);
        }
        else {
            // otherwise , we try to match and replace with fuzzy match in [-10~+30]
            try {
                let re = new RegExp(ModI18NTypeB_escapedPatternString(v.from), '');
                // re.lastIndex = v.pos;
                const startPos = Math.max(0, v.pos - 10);
                const endPos = Math.min(s.length, v.pos + v.from.length + 30);
                const mm = re.exec(s.substring(startPos, endPos));
                if (mm) {
                    const pStart = startPos + mm.index;
                    const pEnd = pStart + v.from.length;
                    s = s.substring(0, pStart) + v.to + s.substring(pEnd);
                }
                else {
                    console.error('tryReplaceStringFuzzyWithHint cannot find: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
                }
                re = undefined;
            }
            catch (e) {
                console.error(e);
                console.error('tryReplaceStringFuzzyWithHint cannot find with error: ', [v.from], ' in ', [passageNameOrFileName], ' at ', [v.pos], ' in ', [s.substring(v.pos - 10, v.pos + v.from.length + 10)]);
            }
        }
        return s;
    }
    destroy() {
        this.passagebuffer.clear();
        this.mt = [];
    }
}
class ModI18NTypeB_JsCssMatcher {
    constructor(OutputText, InputStoryScript) {
        this.OutputText = OutputText;
        this.InputStoryScript = InputStoryScript;
        this.cssBuffer = new Map();
        this.jsBuffer = new Map();
        for (const v of OutputText) {
            if (v.fileName) {
                if (v.css) {
                    if (this.cssBuffer.has(v.fileName)) {
                        this.cssBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.cssBuffer.set(v.fileName, [v]);
                    }
                }
                if (v.js) {
                    if (this.jsBuffer.has(v.fileName)) {
                        this.jsBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.jsBuffer.set(v.fileName, [v]);
                    }
                }
            }
        }
        for (const v of InputStoryScript) {
            if (v.fileName) {
                if (v.css) {
                    if (this.cssBuffer.has(v.fileName)) {
                        this.cssBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.cssBuffer.set(v.fileName, [v]);
                    }
                }
                if (v.js) {
                    if (this.jsBuffer.has(v.fileName)) {
                        this.jsBuffer.get(v.fileName).push(v);
                    }
                    else {
                        this.jsBuffer.set(v.fileName, [v]);
                    }
                }
            }
        }
        for (const [k, v] of this.cssBuffer) {
            this.cssBuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
        for (const [k, v] of this.jsBuffer) {
            this.jsBuffer.set(k, v.sort((a, b) => {
                // big to small
                return b.pos - a.pos;
            }));
        }
    }
    replaceJs(content, fileName) {
        const rep = this.jsBuffer.get(fileName);
        if (rep) {
            let s = content;
            for (const v of rep) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, fileName);
            }
            return s;
        }
        return content;
    }
    replaceCss(content, fileName) {
        const rep = this.cssBuffer.get(fileName);
        if (rep) {
            let s = content;
            for (const v of rep) {
                s = ModI18NTypeB_PassageMatcher.tryReplaceStringFuzzyWithHint(s, v, fileName);
            }
            return s;
        }
        return content;
    }
    destroy() {
        this.cssBuffer.clear();
        this.jsBuffer.clear();
        this.OutputText = [];
        this.InputStoryScript = [];
    }
}
class ModI18NTypeB {
    constructor(OutputText, InputStoryScript) {
        this.OutputText = OutputText;
        this.InputStoryScript = InputStoryScript;
        // this.outputTextMatchBuffer = new ModI18NTypeB_OutputTextMatcher(OutputText);
        this.inputStoryMatchBuffer = new ModI18NTypeB_PassageMatcher(InputStoryScript);
        this.jsCssMatcher = new ModI18NTypeB_JsCssMatcher(OutputText, InputStoryScript);
        // monkey patch
        // console.log('TypeB constructor monkey patch document.createTextNode');
        // this.oCreateTextNode = document.createTextNode;
        // document.createTextNode = (text: string) => {
        //     return this.oCreateTextNode.call(document, this.replaceOutputText(text));
        // };
    }
    // replaceOutputText(text: string): string {
    //     if (!text.trim()) {
    //         // empty string
    //         return text;
    //     }
    //     // console.log('replaceOutputText input text ==>>', [text], text);
    //     try {
    //         return this.outputTextMatchBuffer.tryReplace(text);
    //     } catch (e) {
    //         console.error(e);
    //         return text;
    //     }
    // }
    replaceInputStoryScript(text, passageName) {
        if (!text.trim()) {
            // empty string
            return text;
        }
        if (passageName) {
            try {
                return this.inputStoryMatchBuffer.replacePassageContent(passageName, text);
            }
            catch (e) {
                console.error(e);
            }
        }
        return text;
    }
    replaceJs(text, fileName) {
        return this.jsCssMatcher.replaceJs(text, fileName);
    }
    replaceCss(text, fileName) {
        return this.jsCssMatcher.replaceCss(text, fileName);
    }
    destroy() {
        // this.outputTextMatchBuffer.destroy();
        this.inputStoryMatchBuffer.destroy();
        this.jsCssMatcher.destroy();
        this.oCreateTextNode = undefined;
        this.OutputText = [];
        this.InputStoryScript = [];
    }
}
exports.ModI18NTypeB = ModI18NTypeB;


/***/ }),

/***/ "./node_modules/tsafe/Reflect.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/Reflect.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Reflect = Reflect;
/** Always return null but pretends it returns an object of type T */
function Reflect() {
    return null;
}
//# sourceMappingURL=Reflect.js.map

/***/ }),

/***/ "./node_modules/tsafe/assert.js":
/*!**************************************!*\
  !*** ./node_modules/tsafe/assert.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AssertionError = void 0;
exports.assert = assert;
exports.is = is;
var overwriteReadonlyProp_1 = __webpack_require__(/*! ./lab/overwriteReadonlyProp */ "./node_modules/tsafe/lab/overwriteReadonlyProp.js");
/** https://docs.tsafe.dev/assert#error-thrown */
var AssertionError = /** @class */ (function (_super) {
    __extends(AssertionError, _super);
    function AssertionError(msg) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, "Wrong assertion encountered" + (!msg ? "" : ": \"".concat(msg, "\""))) || this;
        _this.originalMessage = msg;
        Object.setPrototypeOf(_this, _newTarget.prototype);
        if (!_this.stack) {
            return _this;
        }
        try {
            (0, overwriteReadonlyProp_1.overwriteReadonlyProp)(_this, "stack", _this.stack
                .split("\n")
                .filter(function () {
                var _a = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    _a[_i] = arguments[_i];
                }
                var _b = __read(_a, 2), i = _b[1];
                return i !== 1 && i !== 2;
            })
                .join("\n"));
        }
        catch (_a) { }
        return _this;
    }
    return AssertionError;
}(Error));
exports.AssertionError = AssertionError;
var refOfIs = undefined;
/** https://docs.tsafe.dev/assert */
function assert(condition, msg) {
    if (arguments.length === 0) {
        condition = true;
    }
    if (refOfIs !== undefined) {
        refOfIs = undefined;
        return;
    }
    if (!condition) {
        throw new AssertionError(typeof msg === "function" ? msg() : msg);
    }
}
var errorMessage = "Wrong usage of the `is` function refer to https://docs.tsafe.dev/is";
/** https://docs.tsafe.dev/is */
function is(value) {
    var ref = {};
    if (refOfIs !== undefined) {
        refOfIs = undefined;
        throw new Error(errorMessage);
    }
    refOfIs = ref;
    Promise.resolve().then(function () {
        if (refOfIs === ref) {
            throw new Error(errorMessage);
        }
    });
    return null;
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ "./node_modules/tsafe/capitalize.js":
/*!******************************************!*\
  !*** ./node_modules/tsafe/capitalize.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.capitalize = capitalize;
/** @see <https://docs.tsafe.dev/capitalize> */
function capitalize(str) {
    return (str.charAt(0).toUpperCase() + str.slice(1));
}
//# sourceMappingURL=capitalize.js.map

/***/ }),

/***/ "./node_modules/tsafe/exclude.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/exclude.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.exclude = exclude;
/**
 * https://docs.tsafe.dev/exclude
 *
 * Return a function to use as Array.prototype.filter argument
 * to exclude one or many primitive value element from the array.
 * Ex: ([ "a", "b", "c" ] as const).filter(exclude("a")) return ("b" | "c")[]
 * Ex: ([ "a", "b", "c", "d"] as const).filter(exclude(["a", "b"]) gives ("c" | "d")[]
 */
function exclude(target) {
    var test = target instanceof Object
        ? function (element) { return target.indexOf(element) < 0; }
        : function (element) { return element !== target; };
    return function (element) {
        return test(element);
    };
}
//# sourceMappingURL=exclude.js.map

/***/ }),

/***/ "./node_modules/tsafe/flip.js":
/*!************************************!*\
  !*** ./node_modules/tsafe/flip.js ***!
  \************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.flip = flip;
/**
 * Flip the value of a boolean without having to reference it twice
 * after running flip(x.y, "z") x.y.z !== x.y.z,
 * https://docs.tsafe.dev/flip
 */
function flip(object, prop) {
    if (object[prop] === undefined) {
        return;
    }
    return (object[prop] = !object[prop]);
}
//# sourceMappingURL=flip.js.map

/***/ }),

/***/ "./node_modules/tsafe/id.js":
/*!**********************************!*\
  !*** ./node_modules/tsafe/id.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.id = void 0;
/** https://docs.tsafe.dev/id  */
var id = function (x) { return x; };
exports.id = id;
//# sourceMappingURL=id.js.map

/***/ }),

/***/ "./node_modules/tsafe/index.js":
/*!*************************************!*\
  !*** ./node_modules/tsafe/index.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./assert */ "./node_modules/tsafe/assert.js"), exports);
__exportStar(__webpack_require__(/*! ./exclude */ "./node_modules/tsafe/exclude.js"), exports);
__exportStar(__webpack_require__(/*! ./flip */ "./node_modules/tsafe/flip.js"), exports);
__exportStar(__webpack_require__(/*! ./id */ "./node_modules/tsafe/id.js"), exports);
__exportStar(__webpack_require__(/*! ./isPromiseLike */ "./node_modules/tsafe/isPromiseLike.js"), exports);
__exportStar(__webpack_require__(/*! ./objectKeys */ "./node_modules/tsafe/objectKeys.js"), exports);
__exportStar(__webpack_require__(/*! ./typeGuard */ "./node_modules/tsafe/typeGuard.js"), exports);
__exportStar(__webpack_require__(/*! ./isAmong */ "./node_modules/tsafe/isAmong.js"), exports);
__exportStar(__webpack_require__(/*! ./objectEntries */ "./node_modules/tsafe/objectEntries.js"), exports);
__exportStar(__webpack_require__(/*! ./objectFromEntries */ "./node_modules/tsafe/objectFromEntries.js"), exports);
__exportStar(__webpack_require__(/*! ./noUndefined */ "./node_modules/tsafe/noUndefined.js"), exports);
__exportStar(__webpack_require__(/*! ./Reflect */ "./node_modules/tsafe/Reflect.js"), exports);
__exportStar(__webpack_require__(/*! ./capitalize */ "./node_modules/tsafe/capitalize.js"), exports);
__exportStar(__webpack_require__(/*! ./uncapitalize */ "./node_modules/tsafe/uncapitalize.js"), exports);
__exportStar(__webpack_require__(/*! ./symToStr */ "./node_modules/tsafe/symToStr.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/tsafe/isAmong.js":
/*!***************************************!*\
  !*** ./node_modules/tsafe/isAmong.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, exports) {


var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isAmong = isAmong;
/** https://docs.tsafe.dev/isamong */
function isAmong(names, value) {
    var e_1, _a;
    try {
        for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
            var name_1 = names_1_1.value;
            if (name_1 === value) {
                return true;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (names_1_1 && !names_1_1.done && (_a = names_1.return)) _a.call(names_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return false;
}
//# sourceMappingURL=isAmong.js.map

/***/ }),

/***/ "./node_modules/tsafe/isPromiseLike.js":
/*!*********************************************!*\
  !*** ./node_modules/tsafe/isPromiseLike.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPromiseLike = isPromiseLike;
function isPromiseLike(o) {
    return typeof o === "object" && o !== null && "then" in o && typeof o.then === "function";
}
//# sourceMappingURL=isPromiseLike.js.map

/***/ }),

/***/ "./node_modules/tsafe/lab/overwriteReadonlyProp.js":
/*!*********************************************************!*\
  !*** ./node_modules/tsafe/lab/overwriteReadonlyProp.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.overwriteReadonlyProp = void 0;
/**
 * Assign a value to a property even if the object is freezed or if the property is not writable
 * Throw if the assignation fail ( for example if the property is non configurable write: false )
 * */
var overwriteReadonlyProp = function (obj, propertyName, value) {
    try {
        obj[propertyName] = value;
    }
    catch (_a) { }
    if (obj[propertyName] === value) {
        return value;
    }
    var errorDefineProperty = undefined;
    var propertyDescriptor = Object.getOwnPropertyDescriptor(obj, propertyName) || {
        "enumerable": true,
        "configurable": true,
    };
    if (!!propertyDescriptor.get) {
        throw new Error("Probably a wrong ides to overwrite ".concat(String(propertyName), " getter"));
    }
    try {
        Object.defineProperty(obj, propertyName, __assign(__assign({}, propertyDescriptor), { value: value }));
    }
    catch (error) {
        errorDefineProperty = error;
    }
    if (obj[propertyName] !== value) {
        throw errorDefineProperty || new Error("Can't assign");
    }
    return value;
};
exports.overwriteReadonlyProp = overwriteReadonlyProp;
//# sourceMappingURL=overwriteReadonlyProp.js.map

/***/ }),

/***/ "./node_modules/tsafe/noUndefined.js":
/*!*******************************************!*\
  !*** ./node_modules/tsafe/noUndefined.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.noUndefined = noUndefined;
/**
 * Removes the enumerable properties whose values are
 * undefined.
 *
 * Example:
 * noUndefined({ "foo": undefined, "bar": 3 }) returns
 * a new object { "bar": 3 }
 */
function noUndefined(obj) {
    var out = {};
    for (var key in obj) {
        if (obj[key] === undefined) {
            continue;
        }
        out[key] = obj[key];
    }
    return out;
}
//# sourceMappingURL=noUndefined.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectEntries.js":
/*!*********************************************!*\
  !*** ./node_modules/tsafe/objectEntries.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectEntries = objectEntries;
/** https://docs.tsafe.dev/objectentries */
function objectEntries(o) {
    return Object.entries(o);
}
//# sourceMappingURL=objectEntries.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectFromEntries.js":
/*!*************************************************!*\
  !*** ./node_modules/tsafe/objectFromEntries.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectFromEntries = objectFromEntries;
/** https://docs.tsafe.dev/objectFromEntries */
function objectFromEntries(entries) {
    return Object.fromEntries(entries);
}
//# sourceMappingURL=objectFromEntries.js.map

/***/ }),

/***/ "./node_modules/tsafe/objectKeys.js":
/*!******************************************!*\
  !*** ./node_modules/tsafe/objectKeys.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.objectKeys = objectKeys;
/** https://docs.tsafe.dev/objectKeys */
function objectKeys(o) {
    return Object.keys(o);
}
//# sourceMappingURL=objectKeys.js.map

/***/ }),

/***/ "./node_modules/tsafe/symToStr.js":
/*!****************************************!*\
  !*** ./node_modules/tsafe/symToStr.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.symToStr = symToStr;
/** @see <https://docs.tsafe.dev/main/symtostr> */
function symToStr(wrap) {
    // @ts-expect-error: We know better
    return Object.keys(wrap)[0];
}
//# sourceMappingURL=symToStr.js.map

/***/ }),

/***/ "./node_modules/tsafe/typeGuard.js":
/*!*****************************************!*\
  !*** ./node_modules/tsafe/typeGuard.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.typeGuard = typeGuard;
/** https://docs.tsafe.dev/typeguard */
function typeGuard(value, isMatched) {
    return isMatched;
}
//# sourceMappingURL=typeGuard.js.map

/***/ }),

/***/ "./node_modules/tsafe/uncapitalize.js":
/*!********************************************!*\
  !*** ./node_modules/tsafe/uncapitalize.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.uncapitalize = uncapitalize;
/** @see <https://docs.tsafe.dev/capitalize#uncapitalize> */
function uncapitalize(str) {
    return (str.charAt(0).toLowerCase() + str.slice(1));
}
//# sourceMappingURL=uncapitalize.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/index.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenType = exports.TokenParserMode = exports.ParsedElementInfo = exports.ParsedTokenInfo = exports.JsonTypes = exports.utf8 = exports.TokenParserError = exports.TokenParser = exports.TokenizerError = exports.Tokenizer = exports.JSONParser = void 0;
var jsonparser_js_1 = __webpack_require__(/*! ./jsonparser.js */ "./node_modules/@streamparser/json/dist/cjs/jsonparser.js");
Object.defineProperty(exports, "JSONParser", ({ enumerable: true, get: function () { return __importDefault(jsonparser_js_1).default; } }));
var tokenizer_js_1 = __webpack_require__(/*! ./tokenizer.js */ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js");
Object.defineProperty(exports, "Tokenizer", ({ enumerable: true, get: function () { return __importDefault(tokenizer_js_1).default; } }));
Object.defineProperty(exports, "TokenizerError", ({ enumerable: true, get: function () { return tokenizer_js_1.TokenizerError; } }));
var tokenparser_js_1 = __webpack_require__(/*! ./tokenparser.js */ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js");
Object.defineProperty(exports, "TokenParser", ({ enumerable: true, get: function () { return __importDefault(tokenparser_js_1).default; } }));
Object.defineProperty(exports, "TokenParserError", ({ enumerable: true, get: function () { return tokenparser_js_1.TokenParserError; } }));
exports.utf8 = __importStar(__webpack_require__(/*! ./utils/utf-8.js */ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js"));
exports.JsonTypes = __importStar(__webpack_require__(/*! ./utils/types/jsonTypes.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js"));
exports.ParsedTokenInfo = __importStar(__webpack_require__(/*! ./utils/types/parsedTokenInfo.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js"));
exports.ParsedElementInfo = __importStar(__webpack_require__(/*! ./utils/types/parsedElementInfo.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js"));
var stackElement_js_1 = __webpack_require__(/*! ./utils/types/stackElement.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js");
Object.defineProperty(exports, "TokenParserMode", ({ enumerable: true, get: function () { return stackElement_js_1.TokenParserMode; } }));
var tokenType_js_1 = __webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js");
Object.defineProperty(exports, "TokenType", ({ enumerable: true, get: function () { return __importDefault(tokenType_js_1).default; } }));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/jsonparser.js":
/*!****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/jsonparser.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tokenizer_js_1 = __importDefault(__webpack_require__(/*! ./tokenizer.js */ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js"));
const tokenparser_js_1 = __importDefault(__webpack_require__(/*! ./tokenparser.js */ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js"));
class JSONParser {
    constructor(opts = {}) {
        this.tokenizer = new tokenizer_js_1.default(opts);
        this.tokenParser = new tokenparser_js_1.default(opts);
        this.tokenizer.onToken = this.tokenParser.write.bind(this.tokenParser);
        this.tokenizer.onEnd = () => {
            if (!this.tokenParser.isEnded)
                this.tokenParser.end();
        };
        this.tokenParser.onError = this.tokenizer.error.bind(this.tokenizer);
        this.tokenParser.onEnd = () => {
            if (!this.tokenizer.isEnded)
                this.tokenizer.end();
        };
    }
    get isEnded() {
        return this.tokenizer.isEnded && this.tokenParser.isEnded;
    }
    write(input) {
        this.tokenizer.write(input);
    }
    end() {
        this.tokenizer.end();
    }
    set onToken(cb) {
        this.tokenizer.onToken = (parsedToken) => {
            cb(parsedToken);
            this.tokenParser.write(parsedToken);
        };
    }
    set onValue(cb) {
        this.tokenParser.onValue = cb;
    }
    set onError(cb) {
        this.tokenizer.onError = cb;
    }
    set onEnd(cb) {
        this.tokenParser.onEnd = () => {
            if (!this.tokenizer.isEnded)
                this.tokenizer.end();
            cb.call(this.tokenParser);
        };
    }
}
exports["default"] = JSONParser;
//# sourceMappingURL=jsonparser.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/tokenizer.js":
/*!***************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/tokenizer.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenizerError = void 0;
const utf_8_js_1 = __webpack_require__(/*! ./utils/utf-8.js */ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js");
const bufferedString_js_1 = __webpack_require__(/*! ./utils/bufferedString.js */ "./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js");
const tokenType_js_1 = __importDefault(__webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js"));
// Tokenizer States
var TokenizerStates;
(function (TokenizerStates) {
    TokenizerStates[TokenizerStates["START"] = 0] = "START";
    TokenizerStates[TokenizerStates["ENDED"] = 1] = "ENDED";
    TokenizerStates[TokenizerStates["ERROR"] = 2] = "ERROR";
    TokenizerStates[TokenizerStates["TRUE1"] = 3] = "TRUE1";
    TokenizerStates[TokenizerStates["TRUE2"] = 4] = "TRUE2";
    TokenizerStates[TokenizerStates["TRUE3"] = 5] = "TRUE3";
    TokenizerStates[TokenizerStates["FALSE1"] = 6] = "FALSE1";
    TokenizerStates[TokenizerStates["FALSE2"] = 7] = "FALSE2";
    TokenizerStates[TokenizerStates["FALSE3"] = 8] = "FALSE3";
    TokenizerStates[TokenizerStates["FALSE4"] = 9] = "FALSE4";
    TokenizerStates[TokenizerStates["NULL1"] = 10] = "NULL1";
    TokenizerStates[TokenizerStates["NULL2"] = 11] = "NULL2";
    TokenizerStates[TokenizerStates["NULL3"] = 12] = "NULL3";
    TokenizerStates[TokenizerStates["STRING_DEFAULT"] = 13] = "STRING_DEFAULT";
    TokenizerStates[TokenizerStates["STRING_AFTER_BACKSLASH"] = 14] = "STRING_AFTER_BACKSLASH";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_1"] = 15] = "STRING_UNICODE_DIGIT_1";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_2"] = 16] = "STRING_UNICODE_DIGIT_2";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_3"] = 17] = "STRING_UNICODE_DIGIT_3";
    TokenizerStates[TokenizerStates["STRING_UNICODE_DIGIT_4"] = 18] = "STRING_UNICODE_DIGIT_4";
    TokenizerStates[TokenizerStates["STRING_INCOMPLETE_CHAR"] = 19] = "STRING_INCOMPLETE_CHAR";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_MINUS"] = 20] = "NUMBER_AFTER_INITIAL_MINUS";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_ZERO"] = 21] = "NUMBER_AFTER_INITIAL_ZERO";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_INITIAL_NON_ZERO"] = 22] = "NUMBER_AFTER_INITIAL_NON_ZERO";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_FULL_STOP"] = 23] = "NUMBER_AFTER_FULL_STOP";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_DECIMAL"] = 24] = "NUMBER_AFTER_DECIMAL";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E"] = 25] = "NUMBER_AFTER_E";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E_AND_SIGN"] = 26] = "NUMBER_AFTER_E_AND_SIGN";
    TokenizerStates[TokenizerStates["NUMBER_AFTER_E_AND_DIGIT"] = 27] = "NUMBER_AFTER_E_AND_DIGIT";
    TokenizerStates[TokenizerStates["SEPARATOR"] = 28] = "SEPARATOR";
})(TokenizerStates || (TokenizerStates = {}));
function TokenizerStateToString(tokenizerState) {
    return [
        "START",
        "ENDED",
        "ERROR",
        "TRUE1",
        "TRUE2",
        "TRUE3",
        "FALSE1",
        "FALSE2",
        "FALSE3",
        "FALSE4",
        "NULL1",
        "NULL2",
        "NULL3",
        "STRING_DEFAULT",
        "STRING_AFTER_BACKSLASH",
        "STRING_UNICODE_DIGIT_1",
        "STRING_UNICODE_DIGIT_2",
        "STRING_UNICODE_DIGIT_3",
        "STRING_UNICODE_DIGIT_4",
        "STRING_INCOMPLETE_CHAR",
        "NUMBER_AFTER_INITIAL_MINUS",
        "NUMBER_AFTER_INITIAL_ZERO",
        "NUMBER_AFTER_INITIAL_NON_ZERO",
        "NUMBER_AFTER_FULL_STOP",
        "NUMBER_AFTER_DECIMAL",
        "NUMBER_AFTER_E",
        "NUMBER_AFTER_E_AND_SIGN",
        "NUMBER_AFTER_E_AND_DIGIT",
        "SEPARATOR",
    ][tokenizerState];
}
const defaultOpts = {
    stringBufferSize: 0,
    numberBufferSize: 0,
    separator: undefined,
};
class TokenizerError extends Error {
    constructor(message) {
        super(message);
        // Typescript is broken. This is a workaround
        Object.setPrototypeOf(this, TokenizerError.prototype);
    }
}
exports.TokenizerError = TokenizerError;
class Tokenizer {
    constructor(opts) {
        this.state = 0 /* TokenizerStates.START */;
        this.separatorIndex = 0;
        this.bytes_remaining = 0; // number of bytes remaining in multi byte utf8 char to read after split boundary
        this.bytes_in_sequence = 0; // bytes in multi byte utf8 char to read
        this.char_split_buffer = new Uint8Array(4); // for rebuilding chars split before boundary is reached
        this.encoder = new TextEncoder();
        this.offset = -1;
        opts = Object.assign(Object.assign({}, defaultOpts), opts);
        this.bufferedString =
            opts.stringBufferSize && opts.stringBufferSize > 4
                ? new bufferedString_js_1.BufferedString(opts.stringBufferSize)
                : new bufferedString_js_1.NonBufferedString();
        this.bufferedNumber =
            opts.numberBufferSize && opts.numberBufferSize > 0
                ? new bufferedString_js_1.BufferedString(opts.numberBufferSize)
                : new bufferedString_js_1.NonBufferedString();
        this.separator = opts.separator;
        this.separatorBytes = opts.separator
            ? this.encoder.encode(opts.separator)
            : undefined;
    }
    get isEnded() {
        return this.state === 1 /* TokenizerStates.ENDED */;
    }
    write(input) {
        try {
            let buffer;
            if (input instanceof Uint8Array) {
                buffer = input;
            }
            else if (typeof input === "string") {
                buffer = this.encoder.encode(input);
            }
            else if ((typeof input === "object" && "buffer" in input) ||
                Array.isArray(input)) {
                buffer = Uint8Array.from(input);
            }
            else {
                throw new TypeError("Unexpected type. The `write` function only accepts Arrays, TypedArrays and Strings.");
            }
            for (let i = 0; i < buffer.length; i += 1) {
                const n = buffer[i]; // get current byte from buffer
                switch (this.state) {
                    case 0 /* TokenizerStates.START */:
                        this.offset += 1;
                        if (this.separatorBytes && n === this.separatorBytes[0]) {
                            if (this.separatorBytes.length === 1) {
                                this.state = 0 /* TokenizerStates.START */;
                                this.onToken({
                                    token: tokenType_js_1.default.SEPARATOR,
                                    value: this.separator,
                                    offset: this.offset + this.separatorBytes.length - 1,
                                });
                                continue;
                            }
                            this.state = 28 /* TokenizerStates.SEPARATOR */;
                            continue;
                        }
                        if (n === 32 /* charset.SPACE */ ||
                            n === 10 /* charset.NEWLINE */ ||
                            n === 13 /* charset.CARRIAGE_RETURN */ ||
                            n === 9 /* charset.TAB */) {
                            // whitespace
                            continue;
                        }
                        if (n === 123 /* charset.LEFT_CURLY_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.LEFT_BRACE,
                                value: "{",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 125 /* charset.RIGHT_CURLY_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.RIGHT_BRACE,
                                value: "}",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 91 /* charset.LEFT_SQUARE_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.LEFT_BRACKET,
                                value: "[",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 93 /* charset.RIGHT_SQUARE_BRACKET */) {
                            this.onToken({
                                token: tokenType_js_1.default.RIGHT_BRACKET,
                                value: "]",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 58 /* charset.COLON */) {
                            this.onToken({
                                token: tokenType_js_1.default.COLON,
                                value: ":",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 44 /* charset.COMMA */) {
                            this.onToken({
                                token: tokenType_js_1.default.COMMA,
                                value: ",",
                                offset: this.offset,
                            });
                            continue;
                        }
                        if (n === 116 /* charset.LATIN_SMALL_LETTER_T */) {
                            this.state = 3 /* TokenizerStates.TRUE1 */;
                            continue;
                        }
                        if (n === 102 /* charset.LATIN_SMALL_LETTER_F */) {
                            this.state = 6 /* TokenizerStates.FALSE1 */;
                            continue;
                        }
                        if (n === 110 /* charset.LATIN_SMALL_LETTER_N */) {
                            this.state = 10 /* TokenizerStates.NULL1 */;
                            continue;
                        }
                        if (n === 34 /* charset.QUOTATION_MARK */) {
                            this.bufferedString.reset();
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        if (n >= 49 /* charset.DIGIT_ONE */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */;
                            continue;
                        }
                        if (n === 48 /* charset.DIGIT_ZERO */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */;
                            continue;
                        }
                        if (n === 45 /* charset.HYPHEN_MINUS */) {
                            this.bufferedNumber.reset();
                            this.bufferedNumber.appendChar(n);
                            this.state = 20 /* TokenizerStates.NUMBER_AFTER_INITIAL_MINUS */;
                            continue;
                        }
                        break;
                    // STRING
                    case 13 /* TokenizerStates.STRING_DEFAULT */:
                        if (n === 34 /* charset.QUOTATION_MARK */) {
                            const string = this.bufferedString.toString();
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.STRING,
                                value: string,
                                offset: this.offset,
                            });
                            this.offset += this.bufferedString.byteLength + 1;
                            continue;
                        }
                        if (n === 92 /* charset.REVERSE_SOLIDUS */) {
                            this.state = 14 /* TokenizerStates.STRING_AFTER_BACKSLASH */;
                            continue;
                        }
                        if (n >= 128) {
                            // Parse multi byte (>=128) chars one at a time
                            if (n >= 194 && n <= 223) {
                                this.bytes_in_sequence = 2;
                            }
                            else if (n <= 239) {
                                this.bytes_in_sequence = 3;
                            }
                            else {
                                this.bytes_in_sequence = 4;
                            }
                            if (this.bytes_in_sequence <= buffer.length - i) {
                                // if bytes needed to complete char fall outside buffer length, we have a boundary split
                                this.bufferedString.appendBuf(buffer, i, i + this.bytes_in_sequence);
                                i += this.bytes_in_sequence - 1;
                                continue;
                            }
                            this.bytes_remaining = i + this.bytes_in_sequence - buffer.length;
                            this.char_split_buffer.set(buffer.subarray(i));
                            i = buffer.length - 1;
                            this.state = 19 /* TokenizerStates.STRING_INCOMPLETE_CHAR */;
                            continue;
                        }
                        if (n >= 32 /* charset.SPACE */) {
                            this.bufferedString.appendChar(n);
                            continue;
                        }
                        break;
                    case 19 /* TokenizerStates.STRING_INCOMPLETE_CHAR */:
                        // check for carry over of a multi byte char split between data chunks
                        // & fill temp buffer it with start of this data chunk up to the boundary limit set in the last iteration
                        this.char_split_buffer.set(buffer.subarray(i, i + this.bytes_remaining), this.bytes_in_sequence - this.bytes_remaining);
                        this.bufferedString.appendBuf(this.char_split_buffer, 0, this.bytes_in_sequence);
                        i = this.bytes_remaining - 1;
                        this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                        continue;
                    case 14 /* TokenizerStates.STRING_AFTER_BACKSLASH */:
                        const controlChar = utf_8_js_1.escapedSequences[n];
                        if (controlChar) {
                            this.bufferedString.appendChar(controlChar);
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.unicode = "";
                            this.state = 15 /* TokenizerStates.STRING_UNICODE_DIGIT_1 */;
                            continue;
                        }
                        break;
                    case 15 /* TokenizerStates.STRING_UNICODE_DIGIT_1 */:
                    case 16 /* TokenizerStates.STRING_UNICODE_DIGIT_2 */:
                    case 17 /* TokenizerStates.STRING_UNICODE_DIGIT_3 */:
                        if ((n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) ||
                            (n >= 65 /* charset.LATIN_CAPITAL_LETTER_A */ &&
                                n <= 70 /* charset.LATIN_CAPITAL_LETTER_F */) ||
                            (n >= 97 /* charset.LATIN_SMALL_LETTER_A */ &&
                                n <= 102 /* charset.LATIN_SMALL_LETTER_F */)) {
                            this.unicode += String.fromCharCode(n);
                            this.state += 1;
                            continue;
                        }
                        break;
                    case 18 /* TokenizerStates.STRING_UNICODE_DIGIT_4 */:
                        if ((n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) ||
                            (n >= 65 /* charset.LATIN_CAPITAL_LETTER_A */ &&
                                n <= 70 /* charset.LATIN_CAPITAL_LETTER_F */) ||
                            (n >= 97 /* charset.LATIN_SMALL_LETTER_A */ &&
                                n <= 102 /* charset.LATIN_SMALL_LETTER_F */)) {
                            const intVal = parseInt(this.unicode + String.fromCharCode(n), 16);
                            if (this.highSurrogate === undefined) {
                                if (intVal >= 0xd800 && intVal <= 0xdbff) {
                                    //<55296,56319> - highSurrogate
                                    this.highSurrogate = intVal;
                                }
                                else {
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(intVal)));
                                }
                            }
                            else {
                                if (intVal >= 0xdc00 && intVal <= 0xdfff) {
                                    //<56320,57343> - lowSurrogate
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(this.highSurrogate, intVal)));
                                }
                                else {
                                    this.bufferedString.appendBuf(this.encoder.encode(String.fromCharCode(this.highSurrogate)));
                                }
                                this.highSurrogate = undefined;
                            }
                            this.state = 13 /* TokenizerStates.STRING_DEFAULT */;
                            continue;
                        }
                        break;
                    // Number
                    case 20 /* TokenizerStates.NUMBER_AFTER_INITIAL_MINUS */:
                        if (n === 48 /* charset.DIGIT_ZERO */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */;
                            continue;
                        }
                        if (n >= 49 /* charset.DIGIT_ONE */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */;
                            continue;
                        }
                        break;
                    case 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */:
                        if (n === 46 /* charset.FULL_STOP */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */;
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    case 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        if (n === 46 /* charset.FULL_STOP */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */;
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    case 23 /* TokenizerStates.NUMBER_AFTER_FULL_STOP */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */;
                            continue;
                        }
                        break;
                    case 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */ ||
                            n === 69 /* charset.LATIN_CAPITAL_LETTER_E */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 25 /* TokenizerStates.NUMBER_AFTER_E */;
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    // @ts-ignore fall through case
                    case 25 /* TokenizerStates.NUMBER_AFTER_E */:
                        if (n === 43 /* charset.PLUS_SIGN */ || n === 45 /* charset.HYPHEN_MINUS */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 26 /* TokenizerStates.NUMBER_AFTER_E_AND_SIGN */;
                            continue;
                        }
                    // Allow cascading
                    case 26 /* TokenizerStates.NUMBER_AFTER_E_AND_SIGN */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            this.state = 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */;
                            continue;
                        }
                        break;
                    case 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */:
                        if (n >= 48 /* charset.DIGIT_ZERO */ && n <= 57 /* charset.DIGIT_NINE */) {
                            this.bufferedNumber.appendChar(n);
                            continue;
                        }
                        i -= 1;
                        this.state = 0 /* TokenizerStates.START */;
                        this.emitNumber();
                        continue;
                    // TRUE
                    case 3 /* TokenizerStates.TRUE1 */:
                        if (n === 114 /* charset.LATIN_SMALL_LETTER_R */) {
                            this.state = 4 /* TokenizerStates.TRUE2 */;
                            continue;
                        }
                        break;
                    case 4 /* TokenizerStates.TRUE2 */:
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.state = 5 /* TokenizerStates.TRUE3 */;
                            continue;
                        }
                        break;
                    case 5 /* TokenizerStates.TRUE3 */:
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.TRUE,
                                value: true,
                                offset: this.offset,
                            });
                            this.offset += 3;
                            continue;
                        }
                        break;
                    // FALSE
                    case 6 /* TokenizerStates.FALSE1 */:
                        if (n === 97 /* charset.LATIN_SMALL_LETTER_A */) {
                            this.state = 7 /* TokenizerStates.FALSE2 */;
                            continue;
                        }
                        break;
                    case 7 /* TokenizerStates.FALSE2 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 8 /* TokenizerStates.FALSE3 */;
                            continue;
                        }
                        break;
                    case 8 /* TokenizerStates.FALSE3 */:
                        if (n === 115 /* charset.LATIN_SMALL_LETTER_S */) {
                            this.state = 9 /* TokenizerStates.FALSE4 */;
                            continue;
                        }
                        break;
                    case 9 /* TokenizerStates.FALSE4 */:
                        if (n === 101 /* charset.LATIN_SMALL_LETTER_E */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.FALSE,
                                value: false,
                                offset: this.offset,
                            });
                            this.offset += 4;
                            continue;
                        }
                        break;
                    // NULL
                    case 10 /* TokenizerStates.NULL1 */:
                        if (n === 117 /* charset.LATIN_SMALL_LETTER_U */) {
                            this.state = 11 /* TokenizerStates.NULL2 */;
                            continue;
                        }
                        break;
                    case 11 /* TokenizerStates.NULL2 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 12 /* TokenizerStates.NULL3 */;
                            continue;
                        }
                        break;
                    case 12 /* TokenizerStates.NULL3 */:
                        if (n === 108 /* charset.LATIN_SMALL_LETTER_L */) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.NULL,
                                value: null,
                                offset: this.offset,
                            });
                            this.offset += 3;
                            continue;
                        }
                        break;
                    case 28 /* TokenizerStates.SEPARATOR */:
                        this.separatorIndex += 1;
                        if (!this.separatorBytes ||
                            n !== this.separatorBytes[this.separatorIndex]) {
                            break;
                        }
                        if (this.separatorIndex === this.separatorBytes.length - 1) {
                            this.state = 0 /* TokenizerStates.START */;
                            this.onToken({
                                token: tokenType_js_1.default.SEPARATOR,
                                value: this.separator,
                                offset: this.offset + this.separatorIndex,
                            });
                            this.separatorIndex = 0;
                        }
                        continue;
                    case 1 /* TokenizerStates.ENDED */:
                        if (n === 32 /* charset.SPACE */ ||
                            n === 10 /* charset.NEWLINE */ ||
                            n === 13 /* charset.CARRIAGE_RETURN */ ||
                            n === 9 /* charset.TAB */) {
                            // whitespace
                            continue;
                        }
                }
                throw new TokenizerError(`Unexpected "${String.fromCharCode(n)}" at position "${i}" in state ${TokenizerStateToString(this.state)}`);
            }
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (err) {
            this.error(err);
        }
    }
    emitNumber() {
        this.onToken({
            token: tokenType_js_1.default.NUMBER,
            value: this.parseNumber(this.bufferedNumber.toString()),
            offset: this.offset,
        });
        this.offset += this.bufferedNumber.byteLength - 1;
    }
    parseNumber(numberStr) {
        return Number(numberStr);
    }
    error(err) {
        if (this.state !== 1 /* TokenizerStates.ENDED */) {
            this.state = 2 /* TokenizerStates.ERROR */;
        }
        this.onError(err);
    }
    end() {
        switch (this.state) {
            case 21 /* TokenizerStates.NUMBER_AFTER_INITIAL_ZERO */:
            case 22 /* TokenizerStates.NUMBER_AFTER_INITIAL_NON_ZERO */:
            case 24 /* TokenizerStates.NUMBER_AFTER_DECIMAL */:
            case 27 /* TokenizerStates.NUMBER_AFTER_E_AND_DIGIT */:
                this.state = 1 /* TokenizerStates.ENDED */;
                this.emitNumber();
                this.onEnd();
                break;
            case 0 /* TokenizerStates.START */:
            case 2 /* TokenizerStates.ERROR */:
            case 28 /* TokenizerStates.SEPARATOR */:
                this.state = 1 /* TokenizerStates.ENDED */;
                this.onEnd();
                break;
            default:
                this.error(new TokenizerError(`Tokenizer ended in the middle of a token (state: ${TokenizerStateToString(this.state)}). Either not all the data was received or the data was invalid.`));
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToken(parsedToken) {
        // Override me
        throw new TokenizerError('Can\'t emit tokens before the "onToken" callback has been set up.');
    }
    onError(err) {
        // Override me
        throw err;
    }
    onEnd() {
        // Override me
    }
}
exports["default"] = Tokenizer;
//# sourceMappingURL=tokenizer.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/tokenparser.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/tokenparser.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenParserError = void 0;
const tokenType_js_1 = __importDefault(__webpack_require__(/*! ./utils/types/tokenType.js */ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js"));
// Parser States
var TokenParserState;
(function (TokenParserState) {
    TokenParserState[TokenParserState["VALUE"] = 0] = "VALUE";
    TokenParserState[TokenParserState["KEY"] = 1] = "KEY";
    TokenParserState[TokenParserState["COLON"] = 2] = "COLON";
    TokenParserState[TokenParserState["COMMA"] = 3] = "COMMA";
    TokenParserState[TokenParserState["ENDED"] = 4] = "ENDED";
    TokenParserState[TokenParserState["ERROR"] = 5] = "ERROR";
    TokenParserState[TokenParserState["SEPARATOR"] = 6] = "SEPARATOR";
})(TokenParserState || (TokenParserState = {}));
function TokenParserStateToString(state) {
    return ["VALUE", "KEY", "COLON", "COMMA", "ENDED", "ERROR", "SEPARATOR"][state];
}
const defaultOpts = {
    paths: undefined,
    keepStack: true,
    separator: undefined,
};
class TokenParserError extends Error {
    constructor(message) {
        super(message);
        // Typescript is broken. This is a workaround
        Object.setPrototypeOf(this, TokenParserError.prototype);
    }
}
exports.TokenParserError = TokenParserError;
class TokenParser {
    constructor(opts) {
        this.state = 0 /* TokenParserState.VALUE */;
        this.mode = undefined;
        this.key = undefined;
        this.value = undefined;
        this.stack = [];
        opts = Object.assign(Object.assign({}, defaultOpts), opts);
        if (opts.paths) {
            this.paths = opts.paths.map((path) => {
                if (path === undefined || path === "$*")
                    return undefined;
                if (!path.startsWith("$"))
                    throw new TokenParserError(`Invalid selector "${path}". Should start with "$".`);
                const pathParts = path.split(".").slice(1);
                if (pathParts.includes(""))
                    throw new TokenParserError(`Invalid selector "${path}". ".." syntax not supported.`);
                return pathParts;
            });
        }
        this.keepStack = opts.keepStack || false;
        this.separator = opts.separator;
    }
    shouldEmit() {
        if (!this.paths)
            return true;
        return this.paths.some((path) => {
            var _a;
            if (path === undefined)
                return true;
            if (path.length !== this.stack.length)
                return false;
            for (let i = 0; i < path.length - 1; i++) {
                const selector = path[i];
                const key = this.stack[i + 1].key;
                if (selector === "*")
                    continue;
                if (selector !== key)
                    return false;
            }
            const selector = path[path.length - 1];
            if (selector === "*")
                return true;
            return selector === ((_a = this.key) === null || _a === void 0 ? void 0 : _a.toString());
        });
    }
    push() {
        this.stack.push({
            key: this.key,
            value: this.value,
            mode: this.mode,
            emit: this.shouldEmit(),
        });
    }
    pop() {
        const value = this.value;
        let emit;
        ({
            key: this.key,
            value: this.value,
            mode: this.mode,
            emit,
        } = this.stack.pop());
        this.state =
            this.mode !== undefined ? 3 /* TokenParserState.COMMA */ : 0 /* TokenParserState.VALUE */;
        this.emit(value, emit);
    }
    emit(value, emit) {
        if (!this.keepStack &&
            this.value &&
            this.stack.every((item) => !item.emit)) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            delete this.value[this.key];
        }
        if (emit) {
            this.onValue({
                value: value,
                key: this.key,
                parent: this.value,
                stack: this.stack,
            });
        }
        if (this.stack.length === 0) {
            if (this.separator) {
                this.state = 6 /* TokenParserState.SEPARATOR */;
            }
            else if (this.separator === undefined) {
                this.end();
            }
            // else if separator === '', expect next JSON object.
        }
    }
    get isEnded() {
        return this.state === 4 /* TokenParserState.ENDED */;
    }
    write({ token, value }) {
        try {
            if (this.state === 0 /* TokenParserState.VALUE */) {
                if (token === tokenType_js_1.default.STRING ||
                    token === tokenType_js_1.default.NUMBER ||
                    token === tokenType_js_1.default.TRUE ||
                    token === tokenType_js_1.default.FALSE ||
                    token === tokenType_js_1.default.NULL) {
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value[this.key] = value;
                        this.state = 3 /* TokenParserState.COMMA */;
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        this.value.push(value);
                        this.state = 3 /* TokenParserState.COMMA */;
                    }
                    this.emit(value, this.shouldEmit());
                    return;
                }
                if (token === tokenType_js_1.default.LEFT_BRACE) {
                    this.push();
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value = this.value[this.key] = {};
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        const val = {};
                        this.value.push(val);
                        this.value = val;
                    }
                    else {
                        this.value = {};
                    }
                    this.mode = 0 /* TokenParserMode.OBJECT */;
                    this.state = 1 /* TokenParserState.KEY */;
                    this.key = undefined;
                    return;
                }
                if (token === tokenType_js_1.default.LEFT_BRACKET) {
                    this.push();
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.value = this.value[this.key] = [];
                    }
                    else if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        const val = [];
                        this.value.push(val);
                        this.value = val;
                    }
                    else {
                        this.value = [];
                    }
                    this.mode = 1 /* TokenParserMode.ARRAY */;
                    this.state = 0 /* TokenParserState.VALUE */;
                    this.key = 0;
                    return;
                }
                if (this.mode === 1 /* TokenParserMode.ARRAY */ &&
                    token === tokenType_js_1.default.RIGHT_BRACKET &&
                    this.value.length === 0) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 1 /* TokenParserState.KEY */) {
                if (token === tokenType_js_1.default.STRING) {
                    this.key = value;
                    this.state = 2 /* TokenParserState.COLON */;
                    return;
                }
                if (token === tokenType_js_1.default.RIGHT_BRACE &&
                    Object.keys(this.value).length === 0) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 2 /* TokenParserState.COLON */) {
                if (token === tokenType_js_1.default.COLON) {
                    this.state = 0 /* TokenParserState.VALUE */;
                    return;
                }
            }
            if (this.state === 3 /* TokenParserState.COMMA */) {
                if (token === tokenType_js_1.default.COMMA) {
                    if (this.mode === 1 /* TokenParserMode.ARRAY */) {
                        this.state = 0 /* TokenParserState.VALUE */;
                        this.key += 1;
                        return;
                    }
                    /* istanbul ignore else */
                    if (this.mode === 0 /* TokenParserMode.OBJECT */) {
                        this.state = 1 /* TokenParserState.KEY */;
                        return;
                    }
                }
                if ((token === tokenType_js_1.default.RIGHT_BRACE &&
                    this.mode === 0 /* TokenParserMode.OBJECT */) ||
                    (token === tokenType_js_1.default.RIGHT_BRACKET &&
                        this.mode === 1 /* TokenParserMode.ARRAY */)) {
                    this.pop();
                    return;
                }
            }
            if (this.state === 6 /* TokenParserState.SEPARATOR */) {
                if (token === tokenType_js_1.default.SEPARATOR && value === this.separator) {
                    this.state = 0 /* TokenParserState.VALUE */;
                    return;
                }
            }
            throw new TokenParserError(`Unexpected ${tokenType_js_1.default[token]} (${JSON.stringify(value)}) in state ${TokenParserStateToString(this.state)}`);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (err) {
            this.error(err);
        }
    }
    error(err) {
        if (this.state !== 4 /* TokenParserState.ENDED */) {
            this.state = 5 /* TokenParserState.ERROR */;
        }
        this.onError(err);
    }
    end() {
        if ((this.state !== 0 /* TokenParserState.VALUE */ &&
            this.state !== 6 /* TokenParserState.SEPARATOR */) ||
            this.stack.length > 0) {
            this.error(new Error(`Parser ended in mid-parsing (state: ${TokenParserStateToString(this.state)}). Either not all the data was received or the data was invalid.`));
        }
        else {
            this.state = 4 /* TokenParserState.ENDED */;
            this.onEnd();
        }
    }
    /* eslint-disable-next-line @typescript-eslint/no-unused-vars */
    onValue(parsedElementInfo) {
        // Override me
        throw new TokenParserError('Can\'t emit data before the "onValue" callback has been set up.');
    }
    onError(err) {
        // Override me
        throw err;
    }
    onEnd() {
        // Override me
    }
}
exports["default"] = TokenParser;
//# sourceMappingURL=tokenparser.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/bufferedString.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BufferedString = exports.NonBufferedString = void 0;
class NonBufferedString {
    constructor() {
        this.decoder = new TextDecoder("utf-8");
        this.strings = [];
        this.byteLength = 0;
    }
    appendChar(char) {
        this.strings.push(String.fromCharCode(char));
        this.byteLength += 1;
    }
    appendBuf(buf, start = 0, end = buf.length) {
        this.strings.push(this.decoder.decode(buf.subarray(start, end)));
        this.byteLength += end - start;
    }
    reset() {
        this.strings = [];
        this.byteLength = 0;
    }
    toString() {
        return this.strings.join("");
    }
}
exports.NonBufferedString = NonBufferedString;
class BufferedString {
    constructor(bufferSize) {
        this.decoder = new TextDecoder("utf-8");
        this.bufferOffset = 0;
        this.string = "";
        this.byteLength = 0;
        this.buffer = new Uint8Array(bufferSize);
    }
    appendChar(char) {
        if (this.bufferOffset >= this.buffer.length)
            this.flushStringBuffer();
        this.buffer[this.bufferOffset++] = char;
        this.byteLength += 1;
    }
    appendBuf(buf, start = 0, end = buf.length) {
        const size = end - start;
        if (this.bufferOffset + size > this.buffer.length)
            this.flushStringBuffer();
        this.buffer.set(buf.subarray(start, end), this.bufferOffset);
        this.bufferOffset += size;
        this.byteLength += size;
    }
    flushStringBuffer() {
        this.string += this.decoder.decode(this.buffer.subarray(0, this.bufferOffset));
        this.bufferOffset = 0;
    }
    reset() {
        this.string = "";
        this.bufferOffset = 0;
        this.byteLength = 0;
    }
    toString() {
        this.flushStringBuffer();
        return this.string;
    }
}
exports.BufferedString = BufferedString;
//# sourceMappingURL=bufferedString.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/jsonTypes.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=jsonTypes.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/parsedElementInfo.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=parsedElementInfo.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/parsedTokenInfo.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=parsedTokenInfo.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/stackElement.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenParserMode = void 0;
var TokenParserMode;
(function (TokenParserMode) {
    TokenParserMode[TokenParserMode["OBJECT"] = 0] = "OBJECT";
    TokenParserMode[TokenParserMode["ARRAY"] = 1] = "ARRAY";
})(TokenParserMode || (exports.TokenParserMode = TokenParserMode = {}));
//# sourceMappingURL=stackElement.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/types/tokenType.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenTypeToString = void 0;
var TokenType;
(function (TokenType) {
    TokenType[TokenType["LEFT_BRACE"] = 0] = "LEFT_BRACE";
    TokenType[TokenType["RIGHT_BRACE"] = 1] = "RIGHT_BRACE";
    TokenType[TokenType["LEFT_BRACKET"] = 2] = "LEFT_BRACKET";
    TokenType[TokenType["RIGHT_BRACKET"] = 3] = "RIGHT_BRACKET";
    TokenType[TokenType["COLON"] = 4] = "COLON";
    TokenType[TokenType["COMMA"] = 5] = "COMMA";
    TokenType[TokenType["TRUE"] = 6] = "TRUE";
    TokenType[TokenType["FALSE"] = 7] = "FALSE";
    TokenType[TokenType["NULL"] = 8] = "NULL";
    TokenType[TokenType["STRING"] = 9] = "STRING";
    TokenType[TokenType["NUMBER"] = 10] = "NUMBER";
    TokenType[TokenType["SEPARATOR"] = 11] = "SEPARATOR";
})(TokenType || (TokenType = {}));
function TokenTypeToString(tokenType) {
    return [
        "LEFT_BRACE",
        "RIGHT_BRACE",
        "LEFT_BRACKET",
        "RIGHT_BRACKET",
        "COLON",
        "COMMA",
        "TRUE",
        "FALSE",
        "NULL",
        "STRING",
        "NUMBER",
        "SEPARATOR",
    ][tokenType];
}
exports.TokenTypeToString = TokenTypeToString;
exports["default"] = TokenType;
//# sourceMappingURL=tokenType.js.map

/***/ }),

/***/ "./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@streamparser/json/dist/cjs/utils/utf-8.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.escapedSequences = exports.charset = void 0;
var charset;
(function (charset) {
    charset[charset["BACKSPACE"] = 8] = "BACKSPACE";
    charset[charset["FORM_FEED"] = 12] = "FORM_FEED";
    charset[charset["NEWLINE"] = 10] = "NEWLINE";
    charset[charset["CARRIAGE_RETURN"] = 13] = "CARRIAGE_RETURN";
    charset[charset["TAB"] = 9] = "TAB";
    charset[charset["SPACE"] = 32] = "SPACE";
    charset[charset["EXCLAMATION_MARK"] = 33] = "EXCLAMATION_MARK";
    charset[charset["QUOTATION_MARK"] = 34] = "QUOTATION_MARK";
    charset[charset["NUMBER_SIGN"] = 35] = "NUMBER_SIGN";
    charset[charset["DOLLAR_SIGN"] = 36] = "DOLLAR_SIGN";
    charset[charset["PERCENT_SIGN"] = 37] = "PERCENT_SIGN";
    charset[charset["AMPERSAND"] = 38] = "AMPERSAND";
    charset[charset["APOSTROPHE"] = 39] = "APOSTROPHE";
    charset[charset["LEFT_PARENTHESIS"] = 40] = "LEFT_PARENTHESIS";
    charset[charset["RIGHT_PARENTHESIS"] = 41] = "RIGHT_PARENTHESIS";
    charset[charset["ASTERISK"] = 42] = "ASTERISK";
    charset[charset["PLUS_SIGN"] = 43] = "PLUS_SIGN";
    charset[charset["COMMA"] = 44] = "COMMA";
    charset[charset["HYPHEN_MINUS"] = 45] = "HYPHEN_MINUS";
    charset[charset["FULL_STOP"] = 46] = "FULL_STOP";
    charset[charset["SOLIDUS"] = 47] = "SOLIDUS";
    charset[charset["DIGIT_ZERO"] = 48] = "DIGIT_ZERO";
    charset[charset["DIGIT_ONE"] = 49] = "DIGIT_ONE";
    charset[charset["DIGIT_TWO"] = 50] = "DIGIT_TWO";
    charset[charset["DIGIT_THREE"] = 51] = "DIGIT_THREE";
    charset[charset["DIGIT_FOUR"] = 52] = "DIGIT_FOUR";
    charset[charset["DIGIT_FIVE"] = 53] = "DIGIT_FIVE";
    charset[charset["DIGIT_SIX"] = 54] = "DIGIT_SIX";
    charset[charset["DIGIT_SEVEN"] = 55] = "DIGIT_SEVEN";
    charset[charset["DIGIT_EIGHT"] = 56] = "DIGIT_EIGHT";
    charset[charset["DIGIT_NINE"] = 57] = "DIGIT_NINE";
    charset[charset["COLON"] = 58] = "COLON";
    charset[charset["SEMICOLON"] = 59] = "SEMICOLON";
    charset[charset["LESS_THAN_SIGN"] = 60] = "LESS_THAN_SIGN";
    charset[charset["EQUALS_SIGN"] = 61] = "EQUALS_SIGN";
    charset[charset["GREATER_THAN_SIGN"] = 62] = "GREATER_THAN_SIGN";
    charset[charset["QUESTION_MARK"] = 63] = "QUESTION_MARK";
    charset[charset["COMMERCIAL_AT"] = 64] = "COMMERCIAL_AT";
    charset[charset["LATIN_CAPITAL_LETTER_A"] = 65] = "LATIN_CAPITAL_LETTER_A";
    charset[charset["LATIN_CAPITAL_LETTER_B"] = 66] = "LATIN_CAPITAL_LETTER_B";
    charset[charset["LATIN_CAPITAL_LETTER_C"] = 67] = "LATIN_CAPITAL_LETTER_C";
    charset[charset["LATIN_CAPITAL_LETTER_D"] = 68] = "LATIN_CAPITAL_LETTER_D";
    charset[charset["LATIN_CAPITAL_LETTER_E"] = 69] = "LATIN_CAPITAL_LETTER_E";
    charset[charset["LATIN_CAPITAL_LETTER_F"] = 70] = "LATIN_CAPITAL_LETTER_F";
    charset[charset["LATIN_CAPITAL_LETTER_G"] = 71] = "LATIN_CAPITAL_LETTER_G";
    charset[charset["LATIN_CAPITAL_LETTER_H"] = 72] = "LATIN_CAPITAL_LETTER_H";
    charset[charset["LATIN_CAPITAL_LETTER_I"] = 73] = "LATIN_CAPITAL_LETTER_I";
    charset[charset["LATIN_CAPITAL_LETTER_J"] = 74] = "LATIN_CAPITAL_LETTER_J";
    charset[charset["LATIN_CAPITAL_LETTER_K"] = 75] = "LATIN_CAPITAL_LETTER_K";
    charset[charset["LATIN_CAPITAL_LETTER_L"] = 76] = "LATIN_CAPITAL_LETTER_L";
    charset[charset["LATIN_CAPITAL_LETTER_M"] = 77] = "LATIN_CAPITAL_LETTER_M";
    charset[charset["LATIN_CAPITAL_LETTER_N"] = 78] = "LATIN_CAPITAL_LETTER_N";
    charset[charset["LATIN_CAPITAL_LETTER_O"] = 79] = "LATIN_CAPITAL_LETTER_O";
    charset[charset["LATIN_CAPITAL_LETTER_P"] = 80] = "LATIN_CAPITAL_LETTER_P";
    charset[charset["LATIN_CAPITAL_LETTER_Q"] = 81] = "LATIN_CAPITAL_LETTER_Q";
    charset[charset["LATIN_CAPITAL_LETTER_R"] = 82] = "LATIN_CAPITAL_LETTER_R";
    charset[charset["LATIN_CAPITAL_LETTER_S"] = 83] = "LATIN_CAPITAL_LETTER_S";
    charset[charset["LATIN_CAPITAL_LETTER_T"] = 84] = "LATIN_CAPITAL_LETTER_T";
    charset[charset["LATIN_CAPITAL_LETTER_U"] = 85] = "LATIN_CAPITAL_LETTER_U";
    charset[charset["LATIN_CAPITAL_LETTER_V"] = 86] = "LATIN_CAPITAL_LETTER_V";
    charset[charset["LATIN_CAPITAL_LETTER_W"] = 87] = "LATIN_CAPITAL_LETTER_W";
    charset[charset["LATIN_CAPITAL_LETTER_X"] = 88] = "LATIN_CAPITAL_LETTER_X";
    charset[charset["LATIN_CAPITAL_LETTER_Y"] = 89] = "LATIN_CAPITAL_LETTER_Y";
    charset[charset["LATIN_CAPITAL_LETTER_Z"] = 90] = "LATIN_CAPITAL_LETTER_Z";
    charset[charset["LEFT_SQUARE_BRACKET"] = 91] = "LEFT_SQUARE_BRACKET";
    charset[charset["REVERSE_SOLIDUS"] = 92] = "REVERSE_SOLIDUS";
    charset[charset["RIGHT_SQUARE_BRACKET"] = 93] = "RIGHT_SQUARE_BRACKET";
    charset[charset["CIRCUMFLEX_ACCENT"] = 94] = "CIRCUMFLEX_ACCENT";
    charset[charset["LOW_LINE"] = 95] = "LOW_LINE";
    charset[charset["GRAVE_ACCENT"] = 96] = "GRAVE_ACCENT";
    charset[charset["LATIN_SMALL_LETTER_A"] = 97] = "LATIN_SMALL_LETTER_A";
    charset[charset["LATIN_SMALL_LETTER_B"] = 98] = "LATIN_SMALL_LETTER_B";
    charset[charset["LATIN_SMALL_LETTER_C"] = 99] = "LATIN_SMALL_LETTER_C";
    charset[charset["LATIN_SMALL_LETTER_D"] = 100] = "LATIN_SMALL_LETTER_D";
    charset[charset["LATIN_SMALL_LETTER_E"] = 101] = "LATIN_SMALL_LETTER_E";
    charset[charset["LATIN_SMALL_LETTER_F"] = 102] = "LATIN_SMALL_LETTER_F";
    charset[charset["LATIN_SMALL_LETTER_G"] = 103] = "LATIN_SMALL_LETTER_G";
    charset[charset["LATIN_SMALL_LETTER_H"] = 104] = "LATIN_SMALL_LETTER_H";
    charset[charset["LATIN_SMALL_LETTER_I"] = 105] = "LATIN_SMALL_LETTER_I";
    charset[charset["LATIN_SMALL_LETTER_J"] = 106] = "LATIN_SMALL_LETTER_J";
    charset[charset["LATIN_SMALL_LETTER_K"] = 107] = "LATIN_SMALL_LETTER_K";
    charset[charset["LATIN_SMALL_LETTER_L"] = 108] = "LATIN_SMALL_LETTER_L";
    charset[charset["LATIN_SMALL_LETTER_M"] = 109] = "LATIN_SMALL_LETTER_M";
    charset[charset["LATIN_SMALL_LETTER_N"] = 110] = "LATIN_SMALL_LETTER_N";
    charset[charset["LATIN_SMALL_LETTER_O"] = 111] = "LATIN_SMALL_LETTER_O";
    charset[charset["LATIN_SMALL_LETTER_P"] = 112] = "LATIN_SMALL_LETTER_P";
    charset[charset["LATIN_SMALL_LETTER_Q"] = 113] = "LATIN_SMALL_LETTER_Q";
    charset[charset["LATIN_SMALL_LETTER_R"] = 114] = "LATIN_SMALL_LETTER_R";
    charset[charset["LATIN_SMALL_LETTER_S"] = 115] = "LATIN_SMALL_LETTER_S";
    charset[charset["LATIN_SMALL_LETTER_T"] = 116] = "LATIN_SMALL_LETTER_T";
    charset[charset["LATIN_SMALL_LETTER_U"] = 117] = "LATIN_SMALL_LETTER_U";
    charset[charset["LATIN_SMALL_LETTER_V"] = 118] = "LATIN_SMALL_LETTER_V";
    charset[charset["LATIN_SMALL_LETTER_W"] = 119] = "LATIN_SMALL_LETTER_W";
    charset[charset["LATIN_SMALL_LETTER_X"] = 120] = "LATIN_SMALL_LETTER_X";
    charset[charset["LATIN_SMALL_LETTER_Y"] = 121] = "LATIN_SMALL_LETTER_Y";
    charset[charset["LATIN_SMALL_LETTER_Z"] = 122] = "LATIN_SMALL_LETTER_Z";
    charset[charset["LEFT_CURLY_BRACKET"] = 123] = "LEFT_CURLY_BRACKET";
    charset[charset["VERTICAL_LINE"] = 124] = "VERTICAL_LINE";
    charset[charset["RIGHT_CURLY_BRACKET"] = 125] = "RIGHT_CURLY_BRACKET";
    charset[charset["TILDE"] = 126] = "TILDE";
})(charset || (exports.charset = charset = {}));
exports.escapedSequences = {
    [34 /* charset.QUOTATION_MARK */]: 34 /* charset.QUOTATION_MARK */,
    [92 /* charset.REVERSE_SOLIDUS */]: 92 /* charset.REVERSE_SOLIDUS */,
    [47 /* charset.SOLIDUS */]: 47 /* charset.SOLIDUS */,
    [98 /* charset.LATIN_SMALL_LETTER_B */]: 8 /* charset.BACKSPACE */,
    [102 /* charset.LATIN_SMALL_LETTER_F */]: 12 /* charset.FORM_FEED */,
    [110 /* charset.LATIN_SMALL_LETTER_N */]: 10 /* charset.NEWLINE */,
    [114 /* charset.LATIN_SMALL_LETTER_R */]: 13 /* charset.CARRIAGE_RETURN */,
    [116 /* charset.LATIN_SMALL_LETTER_T */]: 9 /* charset.TAB */,
};
//# sourceMappingURL=utf-8.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;
/*!*********************!*\
  !*** ./src/init.ts ***!
  \*********************/

Object.defineProperty(exports, "__esModule", ({ value: true }));
const I18N_1 = __webpack_require__(/*! ./I18N */ "./src/I18N.ts");
window.modI18N = new I18N_1.ModI18N();

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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