/**
* Copyright (c) 2020 Bosch Sensortec GmbH. All rights reserved.
*
* BSD-3-Clause
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* 3. Neither the name of the copyright holder nor the names of its
*    contributors may be used to endorse or promote products derived from
*    this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
* COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*
* @file       bmi270_hc.c
* @date       2020-11-04
* @version    v2.63.1
*
*/

/***************************************************************************/

/*!             Header files
 ****************************************************************************/
#include "bmi270_hc.h"

/***************************************************************************/

/*!              Global Variable
 ****************************************************************************/

/*! @name  Global array that stores the configuration file of BMI270_huawei_context */
const uint8_t bmi270_hc_config_file[] = {
    0xc8, 0x2e, 0x00, 0x2e, 0x80, 0x2e, 0x00, 0xb0, 0xc8, 0x2e, 0x00, 0x2e, 0xc8, 0x2e, 0x00, 0x2e, 0x80, 0x2e, 0xa8,
    0x03, 0x80, 0x2e, 0x91, 0x03, 0xc8, 0x2e, 0x00, 0x2e, 0x80, 0x2e, 0x7d, 0xb0, 0x50, 0x30, 0x21, 0x2e, 0x59, 0xf5,
    0x10, 0x30, 0x21, 0x2e, 0x6a, 0xf5, 0x80, 0x2e, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x39, 0x01, 0x00, 0x22,
    0x00, 0x76, 0x00, 0x00, 0x10, 0x00, 0x10, 0xd1, 0x00, 0x72, 0xb3, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0xfd, 0x2d, 0xd0, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x00, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x24, 0x22, 0x00, 0x80, 0x2e, 0x48, 0x02, 0x01, 0x2e, 0x49, 0xf1, 0x0b,
    0xbc, 0x10, 0x50, 0x0f, 0xb8, 0x00, 0x90, 0xfb, 0x7f, 0x07, 0x2f, 0x03, 0x2e, 0x21, 0xf2, 0x02, 0x31, 0x4a, 0x0a,
    0x23, 0x2e, 0x21, 0xf2, 0x09, 0x2c, 0x00, 0x30, 0x98, 0x2e, 0x0e, 0xc7, 0x03, 0x2e, 0x21, 0xf2, 0xf2, 0x3e, 0x4a,
    0x08, 0x23, 0x2e, 0x21, 0xf2, 0xfb, 0x6f, 0xf0, 0x5f, 0xb8, 0x2e, 0x13, 0x52, 0x00, 0x2e, 0x60, 0x40, 0x41, 0x40,
    0x0d, 0xbc, 0x98, 0xbc, 0xc0, 0x2e, 0x01, 0x0a, 0x0f, 0xb8, 0x43, 0x86, 0x25, 0x40, 0x04, 0x40, 0xd8, 0xbe, 0x2c,
    0x0b, 0x22, 0x11, 0x54, 0x42, 0x03, 0x80, 0x4b, 0x0e, 0xf6, 0x2f, 0xb8, 0x2e, 0x15, 0x50, 0x10, 0x50, 0x17, 0x52,
    0x05, 0x2e, 0x7e, 0x00, 0xfb, 0x7f, 0x00, 0x2e, 0x13, 0x40, 0x93, 0x42, 0x41, 0x0e, 0xfb, 0x2f, 0x98, 0x2e, 0xe0,
    0x03, 0x98, 0x2e, 0x87, 0xcf, 0x01, 0x2e, 0x8b, 0x00, 0x00, 0xb2, 0x08, 0x2f, 0x01, 0x2e, 0x69, 0xf7, 0xb1, 0x3f,
    0x01, 0x08, 0x01, 0x30, 0x23, 0x2e, 0x8b, 0x00, 0x21, 0x2e, 0x69, 0xf7, 0xfb, 0x6f, 0xf0, 0x5f, 0xb8, 0x2e, 0x98,
    0x00, 0xff, 0x3f, 0x00, 0x0c, 0xff, 0x0f, 0x00, 0x04, 0xc0, 0x00, 0x5b, 0xf5, 0x8f, 0x00, 0x1e, 0xf2, 0xfd, 0xf5,
    0x8d, 0x00, 0x95, 0x00, 0x95, 0x00, 0xe0, 0x00, 0x19, 0xf4, 0x66, 0xf5, 0x00, 0x18, 0xff, 0x00, 0x64, 0xf5, 0x9c,
    0x00, 0x81, 0x00, 0x83, 0x00, 0x7f, 0x00, 0xff, 0xfb, 0x21, 0x02, 0x00, 0x10, 0x00, 0x40, 0x3a, 0x0f, 0xeb, 0x00,
    0x7f, 0xff, 0xc2, 0xf5, 0x68, 0xf7, 0x34, 0x0f, 0x28, 0x0f, 0x2e, 0x0f, 0x80, 0x00, 0x4d, 0x0f, 0x58, 0xf7, 0x5b,
    0xf7, 0x50, 0x0f, 0x00, 0x80, 0xff, 0x7f, 0x86, 0x00, 0x3f, 0x0f, 0x52, 0x0f, 0xb3, 0xf1, 0x4c, 0x0f, 0x6c, 0xf7,
    0xb9, 0xf1, 0xc6, 0xf1, 0x00, 0xe0, 0x00, 0xff, 0xd1, 0xf5, 0x54, 0x0f, 0x57, 0x0f, 0xff, 0x03, 0x00, 0xfc, 0xf0,
    0x3f, 0xb9, 0x00, 0x2d, 0xf5, 0xca, 0xf5, 0x6d, 0x03, 0xf0, 0x07, 0xc3, 0x11, 0x1d, 0x08, 0x12, 0x08, 0xb7, 0x15,
    0x9c, 0x01, 0xed, 0x14, 0xc2, 0x53, 0xca, 0x10, 0xa2, 0x00, 0x74, 0x01, 0xba, 0x17, 0xb4, 0x56, 0xe8, 0x16, 0x9f,
    0x00, 0xd7, 0x13, 0x2f, 0x52, 0x8a, 0x51, 0x64, 0x01, 0xc6, 0x53, 0xf4, 0x0b, 0x06, 0x08, 0xfc, 0x57, 0xe3, 0x44,
    0xad, 0x55, 0x4c, 0x01, 0x62, 0x01, 0x0b, 0x08, 0xa0, 0x18, 0x39, 0x59, 0x56, 0x2b, 0x14, 0x01, 0x2a, 0x58, 0x5e,
    0x0c, 0xc1, 0x47, 0x16, 0x5a, 0xd2, 0x07, 0x2b, 0x21, 0x7f, 0x53, 0x03, 0x08, 0xca, 0x59, 0x1a, 0x0b, 0x5f, 0x57,
    0x36, 0x47, 0xa6, 0x17, 0x02, 0x01, 0x33, 0x49, 0xdd, 0x58, 0x71, 0x0c, 0x32, 0x08, 0xc6, 0x59, 0xd4, 0x42, 0x65,
    0x54, 0x15, 0x59, 0x64, 0x08, 0x0c, 0x08, 0x8c, 0x01, 0x98, 0x00, 0x0f, 0x48, 0x02, 0x58, 0x96, 0x0c, 0x1c, 0x43,
    0x77, 0x48, 0xe9, 0x00, 0x1e, 0x0c, 0xf5, 0x41, 0xf6, 0x46, 0x64, 0x51, 0x98, 0x41, 0xcc, 0x01, 0x66, 0x58, 0x70,
    0x45, 0x28, 0x21, 0xe7, 0x59, 0x22, 0x30, 0x00, 0x08, 0x71, 0x7d, 0x49, 0x01, 0x92, 0x02, 0xf5, 0xd6, 0xe8, 0x63,
    0x7a, 0xfa, 0x87, 0x05, 0x0f, 0xcb, 0xa3, 0x72, 0x37, 0xfc, 0xca, 0x03, 0x95, 0xc7, 0x2e, 0x6d, 0x39, 0xc4, 0xc8,
    0x3b, 0x91, 0x37, 0x29, 0x02, 0x9e, 0x01, 0x00, 0xf0, 0x33, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x2e, 0xd5, 0xb5, 0x80, 0x2e, 0x00, 0xc1, 0xfd, 0x2d, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x01, 0xd4, 0x7b, 0x3b,
    0x01, 0xdb, 0x7a, 0x04, 0x00, 0x3f, 0x7b, 0xcd, 0x6c, 0xc3, 0x04, 0x85, 0x09, 0xc3, 0x04, 0xec, 0xe6, 0x0c, 0x46,
    0x01, 0x00, 0x27, 0x00, 0x19, 0x00, 0x96, 0x00, 0xa0, 0x00, 0x01, 0x00, 0x0c, 0x00, 0xf0, 0x3c, 0x00, 0x01, 0x01,
    0x00, 0x03, 0x00, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xe1, 0x06, 0x66, 0x0a, 0x0a, 0x00, 0x0a, 0x00, 0x5a, 0x8d, 0x33,
    0x73, 0xcd, 0x8c, 0x9a, 0x99, 0x71, 0x7d, 0xcd, 0x8c, 0xcd, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x50, 0x98, 0x2e, 0xbd, 0x0e, 0x50, 0x32, 0x98, 0x2e,
    0x48, 0x03, 0x10, 0x30, 0x21, 0x2e, 0x21, 0xf2, 0x00, 0x30, 0x00, 0x2e, 0x00, 0x2e, 0xd0, 0x2e, 0x00, 0x2e, 0x01,
    0x80, 0x06, 0xa2, 0xfb, 0x2f, 0x01, 0x2e, 0x9b, 0x00, 0x00, 0xb2, 0x10, 0x2f, 0x01, 0x2e, 0x18, 0x00, 0x00, 0xb2,
    0x0c, 0x2f, 0x01, 0x54, 0x03, 0x52, 0x01, 0x50, 0x98, 0x2e, 0xc2, 0xc0, 0x98, 0x2e, 0x0e, 0xb1, 0x01, 0x50, 0x98,
    0x2e, 0xdd, 0xb5, 0x10, 0x30, 0x21, 0x2e, 0x19, 0x00, 0x01, 0x2e, 0x86, 0x00, 0x04, 0xae, 0x0b, 0x2f, 0x01, 0x2e,
    0x9b, 0x00, 0x00, 0xb2, 0x07, 0x2f, 0x01, 0x52, 0x98, 0x2e, 0x74, 0x0e, 0x00, 0xb2, 0x02, 0x2f, 0x10, 0x30, 0x21,
    0x2e, 0x79, 0x00, 0x01, 0x2e, 0x79, 0x00, 0x00, 0x90, 0x90, 0x2e, 0x14, 0x03, 0x01, 0x2e, 0x89, 0x00, 0x00, 0xb2,
    0x04, 0x2f, 0x98, 0x2e, 0x15, 0x0e, 0x00, 0x30, 0x21, 0x2e, 0x7c, 0x00, 0x01, 0x2e, 0x7c, 0x00, 0x00, 0xb2, 0x12,
    0x2f, 0x01, 0x2e, 0x86, 0x00, 0x00, 0x90, 0x02, 0x2f, 0x98, 0x2e, 0x05, 0x0e, 0x09, 0x2d, 0x98, 0x2e, 0x5d, 0x0d,
    0x01, 0x2e, 0x86, 0x00, 0x04, 0x90, 0x02, 0x2f, 0x50, 0x32, 0x98, 0x2e, 0x48, 0x03, 0x00, 0x30, 0x21, 0x2e, 0x7c,
    0x00, 0x01, 0x2e, 0x78, 0x00, 0x00, 0xb2, 0x90, 0x2e, 0x2c, 0x03, 0x01, 0x2e, 0x78, 0x00, 0x81, 0x30, 0x01, 0x08,
    0x00, 0xb2, 0x61, 0x2f, 0x03, 0x2e, 0x24, 0x02, 0x01, 0x2e, 0x86, 0x00, 0x98, 0xbc, 0x98, 0xb8, 0x05, 0xb2, 0x0d,
    0x58, 0x23, 0x2f, 0x07, 0x90, 0x07, 0x54, 0x00, 0x30, 0x37, 0x2f, 0x15, 0x41, 0x04, 0x41, 0xdc, 0xbe, 0x44, 0xbe,
    0xdc, 0xba, 0x2c, 0x01, 0x61, 0x00, 0x0d, 0x56, 0x4a, 0x0f, 0x0c, 0x2f, 0xd1, 0x42, 0x94, 0xb8, 0xc1, 0x42, 0x11,
    0x30, 0x05, 0x2e, 0x6a, 0xf7, 0x2c, 0xbd, 0x2f, 0xb9, 0x80, 0xb2, 0x08, 0x22, 0x98, 0x2e, 0xa4, 0xb1, 0x21, 0x2d,
    0x61, 0x30, 0x23, 0x2e, 0x86, 0x00, 0x98, 0x2e, 0xa4, 0xb1, 0x00, 0x30, 0x21, 0x2e, 0x5a, 0xf5, 0x18, 0x2d, 0xf1,
    0x7f, 0x50, 0x30, 0x98, 0x2e, 0x48, 0x03, 0x0d, 0x52, 0x05, 0x50, 0x50, 0x42, 0x70, 0x30, 0x0b, 0x54, 0x42, 0x42,
    0x7e, 0x82, 0xf2, 0x6f, 0x80, 0xb2, 0x42, 0x42, 0x05, 0x2f, 0x21, 0x2e, 0x86, 0x00, 0x10, 0x30, 0x98, 0x2e, 0xa4,
    0xb1, 0x03, 0x2d, 0x60, 0x30, 0x21, 0x2e, 0x86, 0x00, 0x01, 0x2e, 0x86, 0x00, 0x06, 0x90, 0x18, 0x2f, 0x01, 0x2e,
    0x77, 0x00, 0x09, 0x54, 0x05, 0x52, 0xf0, 0x7f, 0x98, 0x2e, 0x7a, 0xc1, 0xf1, 0x6f, 0x08, 0x1a, 0x40, 0x30, 0x08,
    0x2f, 0x21, 0x2e, 0x86, 0x00, 0x20, 0x30, 0x98, 0x2e, 0xea, 0x03, 0x50, 0x32, 0x98, 0x2e, 0x48, 0x03, 0x05, 0x2d,
    0x98, 0x2e, 0x1e, 0x0e, 0x00, 0x30, 0x21, 0x2e, 0x86, 0x00, 0x00, 0x30, 0x21, 0x2e, 0x78, 0x00, 0x18, 0x2d, 0x01,
    0x2e, 0x86, 0x00, 0x03, 0xaa, 0x01, 0x2f, 0x98, 0x2e, 0x2b, 0x0e, 0x01, 0x2e, 0x86, 0x00, 0x3f, 0x80, 0x03, 0xa2,
    0x01, 0x2f, 0x00, 0x2e, 0x02, 0x2d, 0x98, 0x2e, 0x41, 0x0e, 0x30, 0x30, 0x98, 0x2e, 0xaf, 0xb1, 0x00, 0x30, 0x21,
    0x2e, 0x79, 0x00, 0x50, 0x32, 0x98, 0x2e, 0x48, 0x03, 0x01, 0x2e, 0x19, 0x00, 0x00, 0xb2, 0x10, 0x2f, 0x01, 0x2e,
    0x87, 0x00, 0x21, 0x2e, 0x8f, 0x00, 0x0f, 0x52, 0x7e, 0x82, 0x11, 0x50, 0x41, 0x40, 0x18, 0xb9, 0x11, 0x42, 0x02,
    0x42, 0x02, 0x80, 0x00, 0x2e, 0x01, 0x40, 0x01, 0x42, 0x98, 0x2e, 0xe1, 0x00, 0x00, 0x30, 0x21, 0x2e, 0x19, 0x00,
    0x21, 0x2e, 0x9b, 0x00, 0x80, 0x2e, 0x52, 0x02, 0x21, 0x2e, 0x59, 0xf5, 0x10, 0x30, 0xc0, 0x2e, 0x21, 0x2e, 0x4a,
    0xf1, 0x80, 0x2e, 0x00, 0xc1, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0x01,
    0x34, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x50, 0xe7, 0x7f, 0xf6, 0x7f, 0x46, 0x30, 0x0f, 0x2e, 0xa4, 0xf1, 0xbe, 0x09, 0x80, 0xb3, 0x06,
    0x2f, 0x0d, 0x2e, 0x86, 0x00, 0x84, 0xaf, 0x02, 0x2f, 0x16, 0x30, 0x2d, 0x2e, 0x7c, 0x00, 0x86, 0x30, 0x2d, 0x2e,
    0x60, 0xf5, 0xf6, 0x6f, 0xe7, 0x6f, 0xe0, 0x5f, 0xc8, 0x2e, 0xa0, 0x50, 0x80, 0x7f, 0xe7, 0x7f, 0xd5, 0x7f, 0xc4,
    0x7f, 0xb3, 0x7f, 0xa2, 0x7f, 0x91, 0x7f, 0xf6, 0x7f, 0x7b, 0x7f, 0x00, 0x2e, 0x01, 0x2e, 0x60, 0xf5, 0x60, 0x7f,
    0x98, 0x2e, 0xcd, 0x00, 0x62, 0x6f, 0x01, 0x32, 0x91, 0x08, 0x80, 0xb2, 0x0d, 0x2f, 0x00, 0xb2, 0x03, 0x2f, 0x05,
    0x2e, 0x18, 0x00, 0x80, 0x90, 0x05, 0x2f, 0x25, 0x56, 0x02, 0x30, 0xc1, 0x42, 0xc2, 0x86, 0x00, 0x2e, 0xc2, 0x42,
    0x23, 0x2e, 0x60, 0xf5, 0x00, 0x90, 0x00, 0x30, 0x06, 0x2f, 0x21, 0x2e, 0x7a, 0x00, 0x23, 0x50, 0x21, 0x2e, 0x5a,
    0xf2, 0x98, 0x2e, 0xfb, 0x01, 0xf6, 0x6f, 0x80, 0x6f, 0x91, 0x6f, 0xa2, 0x6f, 0xb3, 0x6f, 0xc4, 0x6f, 0xd5, 0x6f,
    0xe7, 0x6f, 0x7b, 0x6f, 0x60, 0x5f, 0xc8, 0x2e, 0x03, 0x2e, 0x7e, 0x00, 0x16, 0xb8, 0x02, 0x34, 0x4a, 0x0c, 0x21,
    0x2e, 0x2d, 0xf5, 0xc0, 0x2e, 0x23, 0x2e, 0x7e, 0x00, 0x03, 0xbc, 0x21, 0x2e, 0x87, 0x00, 0x03, 0x2e, 0x87, 0x00,
    0x40, 0xb2, 0x10, 0x30, 0x21, 0x2e, 0x19, 0x00, 0x01, 0x30, 0x05, 0x2f, 0x05, 0x2e, 0x8a, 0x00, 0x80, 0x90, 0x01,
    0x2f, 0x23, 0x2e, 0x6f, 0xf5, 0xc0, 0x2e, 0x21, 0x2e, 0x8b, 0x00, 0x80, 0x2e, 0x00, 0xc1, 0xc0, 0x50, 0xe7, 0x7f,
    0xf6, 0x7f, 0x26, 0x30, 0x0f, 0x2e, 0x61, 0xf5, 0x2f, 0x2e, 0x78, 0x00, 0x0f, 0x2e, 0x78, 0x00, 0xbe, 0x09, 0xa2,
    0x7f, 0x91, 0x7f, 0x80, 0x7f, 0x80, 0xb3, 0xd5, 0x7f, 0xc4, 0x7f, 0xb3, 0x7f, 0x7b, 0x7f, 0x11, 0x2f, 0x19, 0x50,
    0x1a, 0x25, 0x12, 0x40, 0x42, 0x7f, 0x74, 0x82, 0x12, 0x40, 0x52, 0x7f, 0x00, 0x2e, 0x00, 0x40, 0x60, 0x7f, 0x98,
    0x2e, 0x6a, 0xd6, 0x01, 0x2e, 0x61, 0xf7, 0x01, 0x31, 0x01, 0x0a, 0x21, 0x2e, 0x61, 0xf7, 0x80, 0x30, 0x03, 0x2e,
    0x78, 0x00, 0x08, 0x08, 0x00, 0xb2, 0x42, 0x2f, 0x03, 0x2e, 0x24, 0x02, 0x01, 0x2e, 0x24, 0x02, 0x97, 0xbc, 0x06,
    0xbc, 0x9f, 0xb8, 0x0f, 0xb8, 0x00, 0x90, 0x23, 0x2e, 0x8a, 0x00, 0x10, 0x30, 0x01, 0x30, 0x2a, 0x2f, 0x03, 0x2e,
    0x86, 0x00, 0x44, 0xb2, 0x05, 0x2f, 0x47, 0xb2, 0x00, 0x30, 0x2d, 0x2f, 0x21, 0x2e, 0x78, 0x00, 0x2b, 0x2d, 0x03,
    0x2e, 0xfd, 0xf5, 0x9e, 0xbc, 0x9f, 0xb8, 0x40, 0x90, 0x14, 0x2f, 0x03, 0x2e, 0xfc, 0xf5, 0x99, 0xbc, 0x9f, 0xb8,
    0x40, 0x90, 0x0e, 0x2f, 0x03, 0x2e, 0x49, 0xf1, 0x1b, 0x54, 0x4a, 0x08, 0x40, 0x90, 0x08, 0x2f, 0x98, 0x2e, 0xcd,
    0x00, 0x00, 0xb2, 0x10, 0x30, 0x03, 0x2f, 0x50, 0x30, 0x21, 0x2e, 0x86, 0x00, 0x10, 0x2d, 0x98, 0x2e, 0xea, 0x03,
    0x00, 0x30, 0x21, 0x2e, 0x78, 0x00, 0x0a, 0x2d, 0x05, 0x2e, 0x69, 0xf7, 0x2d, 0xbd, 0x2f, 0xb9, 0x80, 0xb2, 0x01,
    0x2f, 0x21, 0x2e, 0x79, 0x00, 0x23, 0x2e, 0x78, 0x00, 0xe0, 0x31, 0x21, 0x2e, 0x61, 0xf5, 0xf6, 0x6f, 0xe7, 0x6f,
    0x80, 0x6f, 0xa2, 0x6f, 0xb3, 0x6f, 0xc4, 0x6f, 0xd5, 0x6f, 0x7b, 0x6f, 0x91, 0x6f, 0x40, 0x5f, 0xc8, 0x2e, 0x90,
    0x50, 0xf7, 0x7f, 0xe6, 0x7f, 0xd5, 0x7f, 0xc4, 0x7f, 0xb3, 0x7f, 0xa1, 0x7f, 0x90, 0x7f, 0x82, 0x7f, 0x7b, 0x7f,
    0x98, 0x2e, 0xcd, 0x00, 0x00, 0xb2, 0x12, 0x30, 0x5c, 0x2f, 0x01, 0x2e, 0x21, 0x02, 0x03, 0x2e, 0x28, 0x02, 0x9f,
    0xbc, 0x9f, 0xb8, 0x21, 0x56, 0x8a, 0x08, 0x03, 0x08, 0x82, 0x0a, 0x25, 0x2e, 0x18, 0x00, 0x05, 0x2e, 0xc1, 0xf5,
    0x2e, 0xbc, 0x05, 0x2e, 0x86, 0x00, 0x84, 0xa2, 0x0e, 0xb8, 0x31, 0x30, 0x88, 0x04, 0x07, 0x2f, 0x01, 0x2e, 0x18,
    0x00, 0x00, 0x90, 0x03, 0x2f, 0x01, 0x2e, 0x7b, 0x00, 0x00, 0xb2, 0x19, 0x2f, 0x1d, 0x50, 0x01, 0x52, 0x98, 0x2e,
    0xd6, 0x00, 0x05, 0x2e, 0x7a, 0x00, 0x25, 0x2e, 0x9b, 0x00, 0x05, 0x2e, 0x7a, 0x00, 0x80, 0x90, 0x02, 0x2f, 0x12,
    0x30, 0x25, 0x2e, 0x7a, 0x00, 0x01, 0x2e, 0x7b, 0x00, 0x00, 0xb2, 0x05, 0x2e, 0x18, 0x00, 0x02, 0x2f, 0x10, 0x30,
    0x21, 0x2e, 0x18, 0x00, 0x25, 0x2e, 0x7b, 0x00, 0x05, 0x2e, 0x18, 0x00, 0x80, 0xb2, 0x20, 0x2f, 0x01, 0x2e, 0xc0,
    0xf5, 0xf2, 0x30, 0x02, 0x08, 0x07, 0xaa, 0x73, 0x30, 0x03, 0x2e, 0x7d, 0x00, 0x18, 0x22, 0x41, 0x1a, 0x05, 0x2f,
    0x03, 0x2e, 0x66, 0xf5, 0x9f, 0xbc, 0x9f, 0xb8, 0x40, 0x90, 0x0c, 0x2f, 0x1f, 0x52, 0x03, 0x30, 0x53, 0x42, 0x2b,
    0x30, 0x90, 0x04, 0x5b, 0x42, 0x21, 0x2e, 0x7d, 0x00, 0x24, 0xbd, 0x7e, 0x80, 0x81, 0x84, 0x43, 0x42, 0x02, 0x42,
    0x02, 0x32, 0x25, 0x2e, 0x62, 0xf5, 0x05, 0x2e, 0x88, 0x00, 0x81, 0x84, 0x25, 0x2e, 0x88, 0x00, 0x02, 0x31, 0x25,
    0x2e, 0x60, 0xf5, 0x05, 0x2e, 0x25, 0x02, 0x10, 0x30, 0x90, 0x08, 0x80, 0xb2, 0x0b, 0x2f, 0x05, 0x2e, 0xca, 0xf5,
    0xf0, 0x3e, 0x90, 0x08, 0x25, 0x2e, 0xca, 0xf5, 0x05, 0x2e, 0x59, 0xf5, 0xe0, 0x3f, 0x90, 0x08, 0x25, 0x2e, 0x59,
    0xf5, 0x90, 0x6f, 0xa1, 0x6f, 0xb3, 0x6f, 0xc4, 0x6f, 0xd5, 0x6f, 0xe6, 0x6f, 0xf7, 0x6f, 0x7b, 0x6f, 0x82, 0x6f,
    0x70, 0x5f, 0xc8, 0x2e, 0x31, 0x50, 0xe0, 0x50, 0x12, 0x40, 0x06, 0x40, 0x1a, 0x25, 0x77, 0x88, 0x75, 0x8a, 0x21,
    0x56, 0x6c, 0xbf, 0x00, 0x30, 0xd3, 0x08, 0x6c, 0xbb, 0x60, 0x7f, 0x00, 0x43, 0x40, 0x43, 0xc0, 0xb2, 0xd6, 0x7f,
    0xe5, 0x7f, 0xf4, 0x7f, 0xc3, 0x7f, 0xbb, 0x7f, 0x74, 0x2f, 0x01, 0x2e, 0x85, 0x00, 0x00, 0xb2, 0x0b, 0x2f, 0x27,
    0x52, 0x01, 0x2e, 0x80, 0x00, 0xa2, 0x7f, 0x98, 0x2e, 0xbb, 0xcc, 0x01, 0x30, 0x23, 0x2e, 0x85, 0x00, 0xa2, 0x6f,
    0xc3, 0x6f, 0x1a, 0x25, 0x26, 0xbc, 0x86, 0xba, 0x25, 0xbc, 0x0f, 0xb8, 0x54, 0xb1, 0x00, 0xb2, 0xa6, 0x7f, 0x0c,
    0x2f, 0x29, 0x50, 0x2b, 0x54, 0x0b, 0x30, 0x0b, 0x2e, 0x21, 0x02, 0x2f, 0x58, 0x1b, 0x42, 0x9b, 0x42, 0x6c, 0x09,
    0x0b, 0x42, 0x2b, 0x2e, 0x21, 0x02, 0x8b, 0x42, 0x72, 0x84, 0x33, 0x50, 0x58, 0x09, 0x03, 0x52, 0x01, 0x50, 0x92,
    0x7f, 0x85, 0x7f, 0x98, 0x2e, 0xc2, 0xc0, 0x01, 0x2e, 0x80, 0x00, 0xf5, 0x6f, 0xe4, 0x6f, 0x83, 0x6f, 0x92, 0x6f,
    0x27, 0x52, 0x2d, 0x5c, 0x98, 0x2e, 0x06, 0xcd, 0xc3, 0x6f, 0x29, 0x50, 0x72, 0x6f, 0xb4, 0xbc, 0x14, 0x40, 0x80,
    0xb2, 0x9f, 0xba, 0x02, 0x40, 0x01, 0x30, 0xf0, 0x7f, 0x05, 0x2f, 0x40, 0xb3, 0x03, 0x2f, 0x2b, 0x5c, 0x11, 0x30,
    0x94, 0x43, 0x82, 0x43, 0xb3, 0xbd, 0xbf, 0xb9, 0xc0, 0xb2, 0x1c, 0x2f, 0x53, 0x6f, 0x23, 0x01, 0x63, 0x6f, 0x93,
    0x02, 0x02, 0x42, 0x40, 0x91, 0x29, 0x2e, 0x81, 0x00, 0x2b, 0x50, 0x12, 0x2f, 0x2b, 0x56, 0x00, 0x2e, 0xd5, 0x40,
    0xc3, 0x40, 0x65, 0x05, 0xd3, 0x06, 0xc0, 0xaa, 0x04, 0x2f, 0xc0, 0x90, 0x08, 0x2f, 0xa3, 0x6f, 0x5d, 0x0f, 0x05,
    0x2f, 0xa5, 0x6f, 0x40, 0xb3, 0x02, 0x2f, 0x14, 0x42, 0x02, 0x42, 0x11, 0x30, 0xd0, 0x6f, 0x98, 0x2e, 0x95, 0xcf,
    0xf2, 0x6f, 0x15, 0x52, 0x01, 0x2e, 0x81, 0x00, 0x82, 0x40, 0x50, 0x42, 0x08, 0x2c, 0x42, 0x42, 0x11, 0x30, 0x23,
    0x2e, 0x85, 0x00, 0x01, 0x30, 0xd0, 0x6f, 0x98, 0x2e, 0x95, 0xcf, 0x00, 0x2e, 0xbb, 0x6f, 0x20, 0x5f, 0xb8, 0x2e,
    0x11, 0x30, 0x81, 0x08, 0x01, 0x2e, 0x6a, 0xf7, 0x71, 0x3f, 0x23, 0xbd, 0x01, 0x08, 0x02, 0x0a, 0xc0, 0x2e, 0x21,
    0x2e, 0x6a, 0xf7, 0x30, 0x25, 0x00, 0x30, 0x21, 0x2e, 0x5a, 0xf5, 0x10, 0x50, 0x21, 0x2e, 0x7c, 0x00, 0x21, 0x2e,
    0x78, 0x00, 0xfb, 0x7f, 0x98, 0x2e, 0xa4, 0xb1, 0x40, 0x30, 0x21, 0x2e, 0x86, 0x00, 0xfb, 0x6f, 0xf0, 0x5f, 0x03,
    0x25, 0x80, 0x2e, 0xea, 0x03, 0x51, 0x56, 0x05, 0x40, 0x69, 0x18, 0x0d, 0x17, 0xe1, 0x18, 0x19, 0x05, 0x16, 0x25,
    0x37, 0x25, 0x4a, 0x17, 0x54, 0x18, 0xec, 0x18, 0x04, 0x30, 0x64, 0x07, 0xea, 0x18, 0x8e, 0x00, 0x5f, 0x02, 0x35,
    0x56, 0x93, 0x00, 0x4c, 0x02, 0x2f, 0xb9, 0x91, 0xbc, 0x91, 0x0a, 0x02, 0x42, 0xb8, 0x2e, 0x0b, 0x00, 0x40, 0xb3,
    0x94, 0x02, 0x0b, 0x2f, 0x50, 0xa1, 0x03, 0x2f, 0x70, 0x8b, 0x85, 0x14, 0x07, 0x2c, 0x00, 0x30, 0x04, 0x31, 0x25,
    0x05, 0x04, 0x13, 0x95, 0x14, 0x05, 0x14, 0x94, 0x0a, 0x47, 0x5a, 0x45, 0x01, 0x04, 0x30, 0x94, 0x02, 0xd8, 0xba,
    0xc0, 0x2e, 0x28, 0xbd, 0x2a, 0x0a, 0x4a, 0x18, 0x00, 0x30, 0xc1, 0x18, 0x6f, 0xb8, 0xc0, 0x2e, 0xf1, 0xbc, 0x01,
    0x0a, 0x4e, 0x86, 0x80, 0x40, 0x70, 0x50, 0xd1, 0x40, 0x86, 0x84, 0xf0, 0x7f, 0x84, 0x30, 0xce, 0x8a, 0xe2, 0x7f,
    0x20, 0x04, 0x54, 0x41, 0xc2, 0x40, 0x4c, 0x04, 0x43, 0x41, 0x93, 0x06, 0x49, 0x18, 0x03, 0x31, 0xd8, 0x04, 0x30,
    0x88, 0xd1, 0x18, 0xd4, 0x7f, 0x00, 0xb2, 0x72, 0x8b, 0xd1, 0x18, 0xc3, 0x7f, 0xbb, 0x7f, 0x0a, 0x2f, 0x10, 0xa0,
    0x03, 0x2f, 0xd1, 0x6f, 0xb9, 0x13, 0x06, 0x2c, 0x07, 0x30, 0xc1, 0x6f, 0x79, 0x14, 0xb0, 0x12, 0xf8, 0x13, 0x91,
    0x0b, 0x51, 0x41, 0x4e, 0x85, 0x00, 0xb2, 0x94, 0x40, 0xb2, 0x86, 0x82, 0x40, 0x26, 0x01, 0xa3, 0x7f, 0x97, 0x02,
    0x43, 0x41, 0x4c, 0x00, 0x9a, 0x02, 0x0a, 0x2f, 0x10, 0xa0, 0x03, 0x2f, 0xd1, 0x6f, 0x51, 0x12, 0x06, 0x2c, 0x02,
    0x30, 0xc3, 0x6f, 0xd3, 0x14, 0x48, 0x12, 0x90, 0x12, 0x4b, 0x0a, 0x98, 0x2e, 0x79, 0xc0, 0xa1, 0x6f, 0x4f, 0x8a,
    0x72, 0x8d, 0x43, 0x41, 0x42, 0x40, 0xf5, 0x6f, 0xab, 0xbc, 0x35, 0xba, 0x25, 0xb9, 0xbb, 0xbd, 0xf0, 0x7f, 0x75,
    0x25, 0x98, 0x2e, 0xdb, 0xb1, 0xd0, 0x7f, 0x57, 0x25, 0x91, 0x41, 0x8e, 0x81, 0x82, 0x41, 0x13, 0x40, 0x04, 0x40,
    0x32, 0x8c, 0x98, 0x2e, 0xdb, 0xb1, 0xc0, 0x7f, 0x57, 0x25, 0x91, 0x41, 0x8e, 0x81, 0x82, 0x41, 0x13, 0x40, 0x04,
    0x40, 0x32, 0x8c, 0x98, 0x2e, 0xdb, 0xb1, 0xa0, 0x7f, 0x57, 0x25, 0x91, 0x41, 0x8e, 0x81, 0x82, 0x41, 0x13, 0x40,
    0x04, 0x40, 0x32, 0x8c, 0x98, 0x2e, 0xdb, 0xb1, 0x90, 0x7f, 0x57, 0x25, 0x91, 0x41, 0x8e, 0x81, 0x82, 0x41, 0x13,
    0x40, 0x04, 0x40, 0x32, 0x8c, 0x98, 0x2e, 0xdb, 0xb1, 0x57, 0x25, 0x91, 0x41, 0x8e, 0x89, 0xe7, 0x6f, 0x13, 0x41,
    0x82, 0x41, 0x04, 0x41, 0xe0, 0x7f, 0x98, 0x2e, 0xdb, 0xb1, 0x57, 0x25, 0xf1, 0x6f, 0x52, 0x41, 0xf0, 0x7f, 0x98,
    0x2e, 0xf3, 0xb1, 0xd1, 0x6f, 0x52, 0x41, 0x30, 0x25, 0x98, 0x2e, 0xf3, 0xb1, 0xc1, 0x6f, 0x52, 0x41, 0xd0, 0x7f,
    0x98, 0x2e, 0xf3, 0xb1, 0xa1, 0x6f, 0x52, 0x41, 0xc0, 0x7f, 0x98, 0x2e, 0xf3, 0xb1, 0x91, 0x6f, 0x52, 0x41, 0xa0,
    0x7f, 0x98, 0x2e, 0xf3, 0xb1, 0xe1, 0x6f, 0x52, 0x41, 0x40, 0x25, 0x98, 0x2e, 0xf3, 0xb1, 0x70, 0x25, 0x42, 0x41,
    0xf1, 0x6f, 0x57, 0x25, 0x98, 0x2e, 0xf3, 0xb1, 0x7b, 0x52, 0xd9, 0x0f, 0x90, 0x2e, 0x70, 0xb3, 0x81, 0x32, 0x69,
    0x0e, 0x06, 0x2f, 0x01, 0x32, 0x41, 0x0e, 0x0d, 0x53, 0x0f, 0x55, 0x0a, 0x22, 0x80, 0x2e, 0x71, 0xb3, 0x51, 0x34,
    0x59, 0x0e, 0xd1, 0x6f, 0xc2, 0x6f, 0x90, 0x2e, 0x4f, 0xb3, 0x99, 0x5e, 0x57, 0x0e, 0x7c, 0x2f, 0xaf, 0x5e, 0x4f,
    0x0e, 0x4d, 0x2f, 0x02, 0xa2, 0x2f, 0x2f, 0xe9, 0x50, 0x60, 0x0e, 0x06, 0x2f, 0x07, 0x55, 0x4a, 0x0e, 0x09, 0x53,
    0x0b, 0x55, 0x0a, 0x22, 0x80, 0x2e, 0x71, 0xb3, 0xeb, 0x50, 0x60, 0x0e, 0x10, 0x2f, 0xfb, 0x52, 0xd1, 0x0f, 0x0a,
    0x2f, 0x45, 0xa3, 0x01, 0x53, 0x03, 0x55, 0x4a, 0x22, 0xa2, 0x6f, 0xfd, 0x50, 0x50, 0x0e, 0xff, 0x54, 0x11, 0x22,
    0x80, 0x2e, 0x71, 0xb3, 0x05, 0x51, 0x80, 0x2e, 0x71, 0xb3, 0xed, 0x54, 0x4a, 0x0e, 0x07, 0x2f, 0xa1, 0x6f, 0xf5,
    0x54, 0x4a, 0x0e, 0xf7, 0x52, 0xf9, 0x54, 0x0a, 0x22, 0x80, 0x2e, 0x71, 0xb3, 0xef, 0x52, 0x59, 0x0e, 0xf1, 0x52,
    0xf3, 0x54, 0x0a, 0x22, 0x80, 0x2e, 0x71, 0xb3, 0xcb, 0x52, 0x61, 0x0e, 0x0e, 0x2f, 0xa1, 0x6f, 0xdd, 0x54, 0xca,
    0x0f, 0x08, 0x2f, 0x01, 0xa2, 0xe1, 0x52, 0xe3, 0x54, 0x4a, 0x22, 0xdf, 0x54, 0x62, 0x0e, 0xe5, 0x54, 0x77, 0x2c,
    0x0a, 0x22, 0x75, 0x2c, 0xe7, 0x50, 0xd7, 0x52, 0x51, 0x0e, 0xd9, 0x52, 0xdb, 0x54, 0x4a, 0x22, 0x72, 0x35, 0x5a,
    0x0e, 0xd5, 0x54, 0x6b, 0x2c, 0x11, 0x22, 0xb1, 0x56, 0x53, 0x0e, 0x0a, 0x2f, 0xa1, 0x6f, 0xcf, 0x54, 0x4a, 0x0e,
    0xd1, 0x52, 0xd3, 0x54, 0x4a, 0x22, 0xcb, 0x54, 0x62, 0x0e, 0xcd, 0x54, 0x5d, 0x2c, 0x11, 0x22, 0x0c, 0xa2, 0x05,
    0x2f, 0xc5, 0x52, 0x61, 0x0e, 0xc7, 0x52, 0xc9, 0x54, 0x55, 0x2c, 0x0a, 0x22, 0xb3, 0x54, 0x62, 0x0e, 0x0a, 0x2f,
    0xa2, 0x6f, 0xbf, 0x50, 0x50, 0x0e, 0xc1, 0x54, 0xc3, 0x50, 0x90, 0x22, 0xbb, 0x50, 0x48, 0x0e, 0xbd, 0x52, 0x47,
    0x2c, 0x0a, 0x22, 0x43, 0xa3, 0xb5, 0x52, 0xb7, 0x54, 0x4a, 0x22, 0x54, 0xa3, 0xb9, 0x54, 0x3f, 0x2c, 0x0a, 0x22,
    0x41, 0xa3, 0x14, 0x2f, 0xa0, 0x37, 0x50, 0x0e, 0x0f, 0x2f, 0xa1, 0x54, 0x4a, 0x0e, 0x0a, 0x2f, 0xa7, 0x52, 0x61,
    0x0e, 0xa9, 0x52, 0xab, 0x54, 0x4a, 0x22, 0xa2, 0x6f, 0xa5, 0x50, 0x50, 0x0e, 0xad, 0x54, 0x2c, 0x2c, 0x0a, 0x22,
    0x2a, 0x2c, 0xa3, 0x50, 0x28, 0x2c, 0x9f, 0x50, 0x01, 0xa2, 0x9b, 0x52, 0x9d, 0x54, 0x23, 0x2c, 0x0a, 0x22, 0x20,
    0x33, 0x58, 0x0e, 0x09, 0x2f, 0x91, 0x50, 0x48, 0x0e, 0x93, 0x52, 0x95, 0x50, 0x48, 0x22, 0x8f, 0x50, 0x50, 0x0e,
    0x97, 0x54, 0x16, 0x2c, 0x0a, 0x22, 0x7d, 0x54, 0x62, 0x0e, 0x0e, 0x2f, 0x81, 0x54, 0xe2, 0x0f, 0x09, 0x2f, 0x87,
    0x54, 0x4a, 0x0e, 0x89, 0x52, 0x8b, 0x54, 0x4a, 0x22, 0x83, 0x54, 0x62, 0x0e, 0x85, 0x54, 0x06, 0x2c, 0x11, 0x22,
    0x04, 0x2c, 0x8d, 0x50, 0x02, 0x2c, 0x7f, 0x50, 0x11, 0x51, 0xbb, 0x6f, 0x90, 0x5f, 0xb8, 0x2e, 0x32, 0x25, 0xb0,
    0x51, 0xc2, 0x32, 0x82, 0x00, 0xe0, 0x7f, 0xd2, 0x7f, 0x04, 0x30, 0x80, 0x40, 0x01, 0x80, 0x90, 0x42, 0xc2, 0x7f,
    0x10, 0x30, 0x85, 0x40, 0x2c, 0x03, 0x94, 0x42, 0x4a, 0x25, 0x85, 0x40, 0x28, 0x28, 0x80, 0x42, 0x25, 0x3d, 0xc3,
    0x80, 0x2b, 0x89, 0x95, 0x00, 0x81, 0x7f, 0xb2, 0x7f, 0xa4, 0x7f, 0x90, 0x7f, 0x7b, 0x7f, 0x00, 0x2e, 0xd1, 0x40,
    0x03, 0x54, 0x53, 0x7f, 0x64, 0x7f, 0x98, 0x2e, 0xd9, 0xc0, 0x64, 0x6f, 0x53, 0x6f, 0x91, 0x6f, 0x10, 0x43, 0x59,
    0x0e, 0xf3, 0x2f, 0xa1, 0x6f, 0x98, 0x2e, 0xb3, 0xc0, 0xb1, 0x6f, 0x13, 0x33, 0x40, 0x42, 0x00, 0xac, 0xcb, 0x00,
    0x02, 0x2f, 0xe1, 0x6f, 0x53, 0x54, 0x42, 0x42, 0xd1, 0x3d, 0x59, 0x00, 0xc3, 0x40, 0xcf, 0xb0, 0xce, 0x00, 0x72,
    0x80, 0xc2, 0x40, 0x11, 0x40, 0x91, 0x00, 0xd2, 0x42, 0x89, 0x16, 0xc4, 0x40, 0x22, 0x03, 0x02, 0x40, 0x05, 0x33,
    0x05, 0x00, 0xd4, 0x42, 0xb3, 0x7f, 0x90, 0x7f, 0x98, 0x2e, 0xfe, 0xc9, 0x91, 0x6f, 0xd2, 0x3d, 0xb3, 0x6f, 0x00,
    0x18, 0x8a, 0x00, 0xc0, 0x40, 0xb2, 0x88, 0x06, 0x00, 0xd0, 0x42, 0xa0, 0x35, 0xc5, 0x40, 0x6f, 0x03, 0x46, 0x40,
    0x8f, 0xb1, 0x96, 0x00, 0x20, 0x00, 0xc5, 0x42, 0x92, 0x7f, 0xb0, 0x7f, 0x02, 0x32, 0x01, 0x41, 0x33, 0x30, 0x98,
    0x2e, 0x0f, 0xca, 0xb5, 0x6f, 0x11, 0x3b, 0x63, 0x41, 0x64, 0x41, 0x44, 0x85, 0x45, 0x41, 0xa6, 0x40, 0x87, 0x40,
    0x51, 0x00, 0xf7, 0x7f, 0xb1, 0x7f, 0x20, 0x25, 0x98, 0x2e, 0x67, 0xcc, 0xb1, 0x6f, 0xb3, 0x33, 0xcb, 0x00, 0xea,
    0x82, 0xc2, 0x40, 0x1a, 0xa4, 0xe5, 0x6f, 0x04, 0x30, 0x13, 0x30, 0x01, 0x2f, 0x80, 0xa0, 0x03, 0x2f, 0x2e, 0xac,
    0x0a, 0x2f, 0x80, 0xa4, 0x08, 0x2f, 0x90, 0x6f, 0x04, 0x80, 0x77, 0x34, 0x06, 0x40, 0x6f, 0x01, 0xa2, 0x04, 0xf3,
    0x28, 0x42, 0x43, 0x03, 0x42, 0xd3, 0x3d, 0x42, 0x40, 0xcb, 0x00, 0xf2, 0x82, 0x8f, 0xb0, 0xde, 0x00, 0x43, 0x80,
    0x42, 0x40, 0xb3, 0x7f, 0x90, 0x7f, 0xb3, 0x30, 0x13, 0x53, 0x98, 0x2e, 0x5a, 0xca, 0x3a, 0x25, 0xe8, 0x82, 0xee,
    0x86, 0xe2, 0x6f, 0x82, 0x84, 0x43, 0x7f, 0x20, 0x7f, 0x51, 0x7f, 0x61, 0x7f, 0x32, 0x7f, 0x05, 0x30, 0xa4, 0x6f,
    0x83, 0x30, 0x00, 0x30, 0x11, 0x41, 0x22, 0x6f, 0x14, 0x7f, 0x00, 0x7f, 0xf5, 0x7e, 0x98, 0x2e, 0x0f, 0xca, 0x33,
    0x6f, 0x51, 0x6f, 0xc3, 0x40, 0x50, 0x42, 0x51, 0x7f, 0xe0, 0x7e, 0xc0, 0x90, 0x02, 0x2f, 0x91, 0x6f, 0x00, 0x2e,
    0x40, 0x42, 0x00, 0x2e, 0xe2, 0x6e, 0x90, 0x6f, 0x15, 0x53, 0x98, 0x2e, 0xc3, 0xb1, 0x93, 0x6f, 0xe1, 0x6e, 0xd2,
    0x40, 0x0a, 0x18, 0x01, 0x6f, 0x0e, 0x00, 0x93, 0x7f, 0x83, 0x30, 0x14, 0x6f, 0xf1, 0x6e, 0x42, 0x6f, 0x62, 0x0e,
    0x4f, 0x03, 0xd9, 0x2f, 0x35, 0x52, 0xc1, 0x00, 0x01, 0x30, 0xa9, 0x02, 0x91, 0x6f, 0x7c, 0x82, 0x21, 0xbd, 0xbf,
    0xb9, 0x1b, 0x30, 0x0a, 0x25, 0xda, 0x0a, 0x5b, 0x42, 0x25, 0x80, 0x33, 0x7f, 0x51, 0x7f, 0x20, 0x7f, 0x90, 0x7f,
    0xd3, 0x30, 0x64, 0x6f, 0x55, 0x6f, 0x10, 0x41, 0x52, 0x41, 0x31, 0x6f, 0x55, 0x7f, 0x10, 0x7f, 0x04, 0x7f, 0x98,
    0x2e, 0x0f, 0xca, 0x11, 0x6f, 0x20, 0x25, 0x98, 0x2e, 0xfe, 0xc9, 0x21, 0x6f, 0x04, 0x6f, 0x50, 0x42, 0x21, 0x7f,
    0xd3, 0x30, 0xa1, 0x6f, 0x61, 0x0e, 0xea, 0x2f, 0xb1, 0x6f, 0x45, 0x84, 0x32, 0x25, 0x90, 0x40, 0x84, 0x40, 0x91,
    0x6f, 0xb4, 0x7f, 0x92, 0x7f, 0x30, 0x7f, 0x23, 0x7f, 0x98, 0x2e, 0xb3, 0xc0, 0x53, 0x6f, 0xb1, 0x32, 0x19, 0x01,
    0x83, 0xb9, 0x31, 0x6f, 0x4b, 0x00, 0x02, 0x41, 0xb0, 0x6f, 0x03, 0x30, 0xc3, 0x02, 0x8f, 0xb0, 0xb4, 0x7f, 0xd5,
    0x3d, 0x25, 0x01, 0xa2, 0x6f, 0xa4, 0x7f, 0x26, 0x01, 0x27, 0x6f, 0x90, 0x6f, 0x07, 0x89, 0xc1, 0x43, 0x94, 0x7f,
    0x03, 0x42, 0x00, 0x2e, 0x11, 0x41, 0x31, 0x7f, 0x54, 0x7f, 0x00, 0x2e, 0x91, 0x40, 0x03, 0x41, 0x23, 0x7f, 0x12,
    0x7f, 0x98, 0x2e, 0x74, 0xc0, 0x31, 0x6f, 0xc8, 0x00, 0x90, 0x6f, 0x01, 0x30, 0x54, 0x6f, 0x22, 0x6f, 0x03, 0x42,
    0xd1, 0x02, 0x41, 0x6f, 0x12, 0x6f, 0x23, 0x43, 0x94, 0x7f, 0x51, 0x0e, 0xe7, 0x2f, 0xb1, 0x6f, 0xa3, 0x6f, 0x42,
    0x40, 0x8f, 0xb0, 0xf8, 0x82, 0xde, 0x00, 0xc9, 0x86, 0x52, 0x34, 0xb3, 0x7f, 0x8a, 0x00, 0xc6, 0x86, 0xa2, 0x7f,
    0x93, 0x7f, 0x00, 0x2e, 0xa5, 0x6f, 0xe2, 0x6f, 0x63, 0x41, 0x64, 0x41, 0x44, 0x8f, 0x82, 0x40, 0xe6, 0x41, 0xc0,
    0x41, 0xc4, 0x8f, 0x45, 0x41, 0xf0, 0x7f, 0xa7, 0x7f, 0x51, 0x7f, 0x98, 0x2e, 0x67, 0xcc, 0x00, 0x18, 0x09, 0x52,
    0x71, 0x00, 0x03, 0x30, 0xbb, 0x02, 0x1b, 0xba, 0xb3, 0x6f, 0x25, 0xbc, 0x51, 0x6f, 0xc5, 0x40, 0x42, 0x82, 0x20,
    0x0a, 0x28, 0x00, 0xd0, 0x42, 0x2b, 0xb9, 0xc0, 0x40, 0x82, 0x02, 0xd2, 0x42, 0xb3, 0x7f, 0x00, 0x2e, 0x92, 0x6f,
    0x5a, 0x0e, 0xd9, 0x2f, 0xa1, 0x6f, 0x43, 0x3d, 0x8b, 0x00, 0x9a, 0x82, 0x83, 0x6f, 0x41, 0x40, 0xc3, 0x40, 0xe0,
    0x6f, 0x14, 0x33, 0x04, 0x00, 0x82, 0x40, 0x4b, 0x12, 0x51, 0x0e, 0xb0, 0x7f, 0x90, 0x2e, 0x7a, 0xb5, 0x02, 0x40,
    0x8f, 0xb0, 0xd1, 0x3d, 0x41, 0x00, 0x72, 0x30, 0xd3, 0x04, 0x73, 0x80, 0x4e, 0x00, 0x02, 0x31, 0xd3, 0x05, 0xa0,
    0x7f, 0xf0, 0x8c, 0x04, 0x40, 0x52, 0x40, 0xc0, 0xb2, 0x50, 0x40, 0x4c, 0x17, 0x96, 0x7f, 0x57, 0x7f, 0x0a, 0x2f,
    0xd0, 0xa0, 0x03, 0x2f, 0x95, 0x6f, 0x65, 0x15, 0x06, 0x2c, 0x04, 0x30, 0x56, 0x6f, 0xa6, 0x13, 0x6b, 0x15, 0x23,
    0x15, 0x6e, 0x0b, 0x14, 0x05, 0x64, 0x18, 0x45, 0x07, 0xec, 0x18, 0xc0, 0xb2, 0xec, 0x18, 0x0a, 0x2f, 0xd0, 0xa0,
    0x03, 0x2f, 0x94, 0x6f, 0xbc, 0x13, 0x06, 0x2c, 0x07, 0x30, 0x54, 0x6f, 0x3c, 0x15, 0x73, 0x13, 0xfb, 0x13, 0xac,
    0x0b, 0x44, 0x40, 0x26, 0x05, 0x54, 0x42, 0xc0, 0xb2, 0x44, 0x40, 0x27, 0x07, 0x44, 0x42, 0x08, 0x2f, 0xd0, 0xa0,
    0x02, 0x2f, 0x91, 0x6f, 0x05, 0x2c, 0x81, 0x10, 0x51, 0x6f, 0x41, 0x14, 0xd3, 0x12, 0x99, 0x0a, 0xa1, 0x6f, 0xf3,
    0x32, 0x42, 0x42, 0x4b, 0x00, 0x13, 0x30, 0x42, 0x40, 0xd3, 0x28, 0x53, 0x42, 0xa1, 0x7f, 0xc2, 0xa2, 0x30, 0x2f,
    0x82, 0x6f, 0xe1, 0x6f, 0x98, 0x2e, 0xfa, 0xb1, 0x81, 0x6f, 0x41, 0x84, 0x00, 0x2e, 0x81, 0x40, 0x40, 0x90, 0x02,
    0x2f, 0x00, 0x2e, 0x07, 0x2c, 0x0c, 0xb8, 0x30, 0x25, 0xe1, 0x6f, 0x20, 0x33, 0x48, 0x00, 0x98, 0x2e, 0x07, 0xb6,
    0xe1, 0x6f, 0xf3, 0x32, 0x4b, 0x00, 0xe0, 0x7f, 0x00, 0x2e, 0x44, 0x40, 0x20, 0x1a, 0x15, 0x2f, 0xd3, 0x6f, 0xc1,
    0x6f, 0xc3, 0x40, 0x23, 0x5a, 0x42, 0x40, 0x83, 0x7e, 0x08, 0xbc, 0x25, 0x09, 0x92, 0x7e, 0xc4, 0x0a, 0x42, 0x82,
    0xa3, 0x7e, 0xd1, 0x7f, 0x34, 0x30, 0x63, 0x6f, 0x82, 0x30, 0x31, 0x30, 0x98, 0x2e, 0xb2, 0x00, 0xd1, 0x6f, 0xe3,
    0x6f, 0x43, 0x42, 0x00, 0x2e, 0xa1, 0x6f, 0xb2, 0x6f, 0x43, 0x40, 0xc1, 0x86, 0xc2, 0xa2, 0x43, 0x42, 0x03, 0x30,
    0x00, 0x2f, 0x83, 0x42, 0xd2, 0x3d, 0x40, 0x40, 0x0f, 0xb0, 0x0a, 0x01, 0x26, 0x00, 0x05, 0x32, 0x98, 0x2e, 0x7e,
    0xb5, 0x65, 0x00, 0x00, 0x2e, 0x43, 0x42, 0x00, 0x2e, 0x7b, 0x6f, 0x50, 0x5e, 0xb8, 0x2e, 0x0f, 0x82, 0x02, 0x30,
    0x12, 0x42, 0x41, 0x0e, 0xfc, 0x2f, 0xb8, 0x2e, 0xc1, 0x35, 0x40, 0x51, 0x01, 0x01, 0x02, 0x30, 0x1a, 0x25, 0x13,
    0x30, 0x12, 0x42, 0x44, 0x0e, 0xfc, 0x2f, 0x54, 0x3a, 0x04, 0x01, 0x1d, 0x5b, 0x05, 0x7f, 0x75, 0x34, 0x13, 0x5f,
    0x07, 0x43, 0x25, 0x01, 0x47, 0x5a, 0x05, 0x43, 0x27, 0x89, 0x67, 0x5a, 0x05, 0x43, 0x18, 0x8b, 0x19, 0x59, 0x17,
    0x51, 0xd4, 0x7e, 0x43, 0x43, 0xc0, 0x7e, 0xe0, 0x7e, 0x6c, 0x88, 0x1b, 0x5d, 0xf6, 0x7e, 0x71, 0x86, 0x42, 0x81,
    0x15, 0x41, 0x15, 0x42, 0x63, 0x0e, 0xfb, 0x2f, 0x21, 0x59, 0x1f, 0x5d, 0x25, 0x5f, 0x23, 0x5b, 0x34, 0x7f, 0x16,
    0x7f, 0x45, 0x7f, 0x57, 0x7f, 0x22, 0x7f, 0x76, 0x88, 0xd5, 0x40, 0x15, 0x42, 0x5c, 0x0e, 0xfb, 0x2f, 0x29, 0x57,
    0x27, 0x5d, 0x2d, 0x5f, 0x2b, 0x5b, 0x83, 0x7f, 0x66, 0x7f, 0x95, 0x7f, 0xa7, 0x7f, 0x72, 0x7f, 0x7b, 0x86, 0x15,
    0x41, 0x15, 0x42, 0x63, 0x0e, 0xfb, 0x2f, 0x31, 0x59, 0x33, 0x5d, 0x2f, 0x5b, 0xc5, 0x7f, 0xd4, 0x7f, 0xf6, 0x7f,
    0xb2, 0x7f, 0xe2, 0x7f, 0x40, 0x82, 0xd2, 0x40, 0x12, 0x42, 0x59, 0x0e, 0xfb, 0x2f, 0xc0, 0x5e, 0xb8, 0x2e, 0x00,
    0x30, 0xc0, 0x2e, 0x21, 0x2e, 0x8c, 0x00, 0x35, 0x51, 0xc0, 0x2e, 0x21, 0x2e, 0xad, 0x00, 0x05, 0x2e, 0x28, 0x02,
    0x2f, 0xbd, 0x2f, 0xb9, 0x20, 0x50, 0x80, 0xb2, 0x16, 0x2f, 0x20, 0x25, 0x01, 0x2e, 0x8c, 0x00, 0x00, 0x90, 0x0b,
    0x2f, 0x37, 0x51, 0xf2, 0x7f, 0xeb, 0x7f, 0x98, 0x2e, 0x84, 0xb5, 0x01, 0x2e, 0x8c, 0x00, 0x01, 0x80, 0x21, 0x2e,
    0x8c, 0x00, 0xf2, 0x6f, 0xeb, 0x6f, 0xe0, 0x5f, 0x03, 0x2e, 0xad, 0x00, 0x37, 0x51, 0x80, 0x2e, 0x74, 0xb3, 0x00,
    0x30, 0x21, 0x2e, 0x8c, 0x00, 0xe0, 0x5f, 0xb8, 0x2e, 0x02, 0x30, 0x02, 0x2c, 0x41, 0x00, 0x12, 0x42, 0x41, 0x0e,
    0xfc, 0x2f, 0xb8, 0x2e, 0x81, 0x8e, 0x39, 0x51, 0x07, 0x5c, 0x58, 0x09, 0x9e, 0x09, 0xc3, 0x41, 0x50, 0x50, 0xc3,
    0x89, 0xf3, 0x0e, 0x41, 0x80, 0xf0, 0x7f, 0xdc, 0xb9, 0xe4, 0x7f, 0x44, 0x80, 0x84, 0x8e, 0x43, 0x88, 0xd1, 0x7f,
    0x05, 0x30, 0xc2, 0x7f, 0x21, 0x2f, 0xf1, 0x6f, 0x00, 0x2e, 0x41, 0x40, 0x19, 0x1a, 0x1c, 0x2f, 0x82, 0x84, 0x00,
    0x2e, 0x82, 0x40, 0xf2, 0x0e, 0x05, 0x2f, 0x02, 0x41, 0x81, 0x84, 0x01, 0x30, 0x03, 0x30, 0x22, 0x2c, 0x02, 0x43,
    0xff, 0x84, 0x42, 0x00, 0x60, 0x25, 0x43, 0x40, 0xc1, 0x86, 0x43, 0x42, 0x11, 0x30, 0xc2, 0x41, 0x03, 0x30, 0x97,
    0x41, 0xc1, 0x86, 0xfa, 0x0f, 0x13, 0x2f, 0xc5, 0xa2, 0xf9, 0x2f, 0x03, 0x30, 0x10, 0x2c, 0x01, 0x30, 0xd2, 0x6f,
    0x00, 0x2e, 0x82, 0x40, 0x80, 0x90, 0x04, 0x2f, 0xd2, 0x6f, 0xf1, 0x6f, 0x17, 0x30, 0x87, 0x42, 0x43, 0x42, 0x00,
    0x2e, 0x3b, 0x55, 0xf2, 0x0e, 0x12, 0x30, 0x55, 0x22, 0x40, 0xb2, 0xbb, 0x7f, 0x06, 0x2f, 0x51, 0x30, 0x60, 0x25,
    0x98, 0x2e, 0x00, 0xb6, 0xbf, 0x81, 0x00, 0x2e, 0x05, 0x42, 0x00, 0x2e, 0xe2, 0x6f, 0x01, 0x41, 0x82, 0x40, 0xd0,
    0x6f, 0x13, 0x88, 0xca, 0x0f, 0x49, 0x2f, 0xf2, 0x6f, 0xc0, 0xa6, 0x87, 0x40, 0x43, 0x2f, 0xc5, 0x6f, 0x02, 0x82,
    0x43, 0x8d, 0x42, 0x40, 0x81, 0x8a, 0x86, 0x41, 0x6e, 0x0e, 0x45, 0x42, 0x47, 0x8a, 0xaa, 0x00, 0x1b, 0x30, 0x83,
    0x42, 0x09, 0x84, 0xf2, 0x7f, 0x02, 0x30, 0x03, 0x2f, 0x0b, 0x43, 0x2f, 0x89, 0x00, 0x2e, 0x02, 0x43, 0x51, 0x88,
    0x41, 0x40, 0x15, 0x41, 0x40, 0xb3, 0x4e, 0x22, 0x5f, 0x1a, 0x14, 0x80, 0x03, 0x41, 0x06, 0x2f, 0xc1, 0x84, 0xd6,
    0x0e, 0x02, 0x42, 0x22, 0x2f, 0x00, 0x2e, 0x21, 0x2c, 0x06, 0x42, 0xff, 0x80, 0x41, 0x0f, 0x91, 0xb9, 0x10, 0x22,
    0xf4, 0x6f, 0x61, 0x00, 0xc3, 0x0f, 0x12, 0x2f, 0x13, 0x30, 0x04, 0x30, 0xf6, 0x6f, 0x05, 0x30, 0x05, 0x2c, 0xe7,
    0x7f, 0x97, 0x41, 0x3c, 0x1a, 0xda, 0x23, 0x6f, 0x01, 0x71, 0x0e, 0xf9, 0x2f, 0x68, 0x0f, 0xe6, 0x6f, 0xe6, 0x23,
    0x01, 0x89, 0x28, 0x22, 0x05, 0xa7, 0xee, 0x2f, 0xf2, 0x6f, 0xb8, 0x84, 0x93, 0x82, 0x87, 0x42, 0x40, 0x42, 0x08,
    0x2c, 0x07, 0x25, 0x13, 0x30, 0x50, 0x25, 0x98, 0x2e, 0xb3, 0xb6, 0x00, 0x30, 0x43, 0x43, 0x03, 0x43, 0x00, 0x2e,
    0xbb, 0x6f, 0xb0, 0x5f, 0xb8, 0x2e, 0x15, 0x82, 0x02, 0x30, 0x12, 0x42, 0x41, 0x0e, 0xfc, 0x2f, 0xb8, 0x2e, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0xfd, 0x2d, 0x01, 0x2e, 0x5d, 0xf7, 0x08, 0xbc, 0x80, 0xac, 0x0e, 0xbb, 0x02, 0x2f,
    0x00, 0x30, 0x41, 0x04, 0x82, 0x06, 0xc0, 0xa4, 0x00, 0x30, 0x11, 0x2f, 0x40, 0xa9, 0x03, 0x2f, 0x40, 0x91, 0x0d,
    0x2f, 0x00, 0xa7, 0x0b, 0x2f, 0x80, 0xb3, 0x35, 0x58, 0x02, 0x2f, 0x90, 0xa1, 0x26, 0x13, 0x20, 0x23, 0x80, 0x90,
    0x10, 0x30, 0x01, 0x2f, 0xcc, 0x0e, 0x00, 0x2f, 0x00, 0x30, 0xb8, 0x2e, 0x3d, 0x56, 0x37, 0x54, 0xd0, 0x40, 0xc4,
    0x40, 0x0b, 0x2e, 0xfd, 0xf3, 0x3d, 0x52, 0x90, 0x42, 0x94, 0x42, 0x95, 0x42, 0x05, 0x30, 0x3f, 0x50, 0x0f, 0x88,
    0x06, 0x40, 0x04, 0x41, 0x96, 0x42, 0xc5, 0x42, 0x48, 0xbe, 0x73, 0x30, 0x0d, 0x2e, 0x8a, 0x00, 0x4f, 0xba, 0x84,
    0x42, 0x03, 0x42, 0x81, 0xb3, 0x02, 0x2f, 0x2b, 0x2e, 0x6f, 0xf5, 0x06, 0x2d, 0x05, 0x2e, 0x77, 0xf7, 0x3b, 0x56,
    0x93, 0x08, 0x25, 0x2e, 0x77, 0xf7, 0x39, 0x54, 0x25, 0x2e, 0xc2, 0xf5, 0x07, 0x2e, 0xfd, 0xf3, 0x42, 0x30, 0xb4,
    0x33, 0xda, 0x0a, 0x4c, 0x00, 0x27, 0x2e, 0xfd, 0xf3, 0x43, 0x40, 0xd4, 0x3f, 0xdc, 0x08, 0x43, 0x42, 0x00, 0x2e,
    0x00, 0x2e, 0x43, 0x40, 0x24, 0x30, 0xdc, 0x0a, 0x43, 0x42, 0x04, 0x80, 0x03, 0x2e, 0xfd, 0xf3, 0x4a, 0x0a, 0x23,
    0x2e, 0xfd, 0xf3, 0x61, 0x34, 0xc0, 0x2e, 0x01, 0x42, 0x00, 0x2e, 0xd0, 0x51, 0xfb, 0x7f, 0x98, 0x2e, 0xcf, 0x0d,
    0x5a, 0x25, 0x98, 0x2e, 0xf6, 0x0d, 0x6b, 0x87, 0x49, 0x54, 0xe1, 0x7f, 0xa3, 0x7f, 0xb3, 0x7f, 0xb2, 0x88, 0x41,
    0x52, 0xc2, 0x7f, 0x65, 0x8b, 0x43, 0x56, 0x84, 0x7f, 0x61, 0x7f, 0x75, 0x7f, 0xd0, 0x7f, 0x95, 0x7f, 0x53, 0x7f,
    0x14, 0x30, 0x45, 0x54, 0x81, 0x6f, 0x42, 0x7f, 0x00, 0x2e, 0x53, 0x40, 0x45, 0x8c, 0x42, 0x40, 0x90, 0x41, 0xbb,
    0x83, 0x86, 0x41, 0xd8, 0x04, 0x16, 0x06, 0x00, 0xac, 0x81, 0x7f, 0x02, 0x2f, 0x02, 0x30, 0xd3, 0x04, 0x10, 0x06,
    0xc1, 0x84, 0x01, 0x30, 0xc1, 0x02, 0x0b, 0x16, 0x04, 0x09, 0x14, 0x01, 0x99, 0x02, 0xc1, 0xb9, 0xaf, 0xbc, 0x59,
    0x0a, 0x64, 0x6f, 0x51, 0x43, 0xa1, 0xb4, 0x12, 0x41, 0x13, 0x41, 0x41, 0x43, 0x35, 0x7f, 0x64, 0x7f, 0x26, 0x31,
    0xe5, 0x6f, 0xd4, 0x6f, 0x98, 0x2e, 0x37, 0xca, 0x32, 0x6f, 0x75, 0x6f, 0x83, 0x40, 0x42, 0x41, 0x23, 0x7f, 0x12,
    0x7f, 0xf6, 0x30, 0x40, 0x25, 0x51, 0x25, 0x98, 0x2e, 0x37, 0xca, 0x14, 0x6f, 0x20, 0x05, 0x70, 0x6f, 0x25, 0x6f,
    0x69, 0x07, 0xa2, 0x6f, 0x31, 0x6f, 0x0b, 0x30, 0x04, 0x42, 0x9b, 0x42, 0x8b, 0x42, 0x55, 0x42, 0x32, 0x7f, 0x40,
    0xa9, 0xc3, 0x6f, 0x71, 0x7f, 0x02, 0x30, 0xd0, 0x40, 0xc3, 0x7f, 0x03, 0x2f, 0x40, 0x91, 0x15, 0x2f, 0x00, 0xa7,
    0x13, 0x2f, 0x00, 0xa4, 0x11, 0x2f, 0x84, 0xbd, 0x98, 0x2e, 0x79, 0xca, 0x55, 0x6f, 0x51, 0x54, 0x54, 0x41, 0x82,
    0x00, 0xf3, 0x3f, 0x45, 0x41, 0xcb, 0x02, 0xf6, 0x30, 0x98, 0x2e, 0x37, 0xca, 0x33, 0x6f, 0xa4, 0x6f, 0xc1, 0x42,
    0x03, 0x2c, 0x00, 0x43, 0xa4, 0x6f, 0x33, 0x6f, 0x00, 0x2e, 0x42, 0x6f, 0x55, 0x6f, 0x91, 0x40, 0x42, 0x8b, 0x00,
    0x41, 0x41, 0x00, 0x01, 0x43, 0x55, 0x7f, 0x14, 0x30, 0xc1, 0x40, 0x95, 0x40, 0x4d, 0x02, 0xc5, 0x6f, 0x4f, 0x50,
    0x68, 0x0e, 0x75, 0x6f, 0xd1, 0x42, 0xa3, 0x7f, 0x8a, 0x2f, 0x09, 0x2e, 0x8a, 0x00, 0x01, 0xb3, 0x22, 0x2f, 0x49,
    0x58, 0x90, 0x6f, 0x17, 0x30, 0x13, 0x41, 0xb6, 0x6f, 0xe4, 0x7f, 0x00, 0x2e, 0x91, 0x41, 0x14, 0x40, 0x92, 0x41,
    0x15, 0x40, 0x17, 0x2e, 0x6f, 0xf5, 0xb6, 0x7f, 0xd0, 0x7f, 0xcb, 0x7f, 0x98, 0x2e, 0x00, 0x0c, 0x07, 0x15, 0xc2,
    0x6f, 0x14, 0x0b, 0x29, 0x2e, 0x6f, 0xf5, 0xc3, 0xa3, 0xc1, 0x8f, 0xe4, 0x6f, 0xd0, 0x6f, 0xe6, 0x2f, 0x14, 0x30,
    0x05, 0x2e, 0x6f, 0xf5, 0x14, 0x0b, 0x29, 0x2e, 0x6f, 0xf5, 0x44, 0x2d, 0x4b, 0x54, 0x01, 0x32, 0x51, 0x58, 0x05,
    0x30, 0x23, 0x50, 0x83, 0x40, 0xd8, 0x08, 0x91, 0x01, 0xb8, 0xbd, 0x38, 0xb5, 0xe6, 0x7f, 0x0a, 0x16, 0xb1, 0x6f,
    0x2a, 0xbb, 0xa6, 0xbd, 0x1c, 0x01, 0x06, 0xbc, 0x52, 0x40, 0x06, 0x0a, 0x53, 0x40, 0x45, 0x03, 0xb1, 0x7f, 0xf6,
    0x30, 0x98, 0x2e, 0x37, 0xca, 0x1a, 0xbd, 0x16, 0xb6, 0x86, 0xba, 0x00, 0xa9, 0xaa, 0x0a, 0x53, 0x52, 0x0f, 0x2f,
    0x00, 0x91, 0x53, 0x52, 0x03, 0x2f, 0x53, 0x5a, 0x55, 0x0f, 0x53, 0x52, 0x08, 0x2f, 0x3f, 0xa1, 0x04, 0x2f, 0x3f,
    0x91, 0x03, 0x2f, 0x51, 0x58, 0xd4, 0x0f, 0x00, 0x2f, 0x51, 0x54, 0x12, 0x25, 0xf2, 0x33, 0x98, 0x2e, 0xd9, 0xc0,
    0xe4, 0x6f, 0xf5, 0x37, 0x45, 0x09, 0x21, 0x85, 0x05, 0x43, 0x05, 0x30, 0x4d, 0x52, 0x51, 0x0e, 0x01, 0x32, 0x51,
    0x58, 0xc5, 0x2f, 0x47, 0x54, 0x09, 0x2e, 0x77, 0xf7, 0x22, 0x0b, 0x29, 0x2e, 0x77, 0xf7, 0xfb, 0x6f, 0x30, 0x5e,
    0xb8, 0x2e, 0x10, 0x50, 0x01, 0x2e, 0x86, 0x00, 0x00, 0xb2, 0xfb, 0x7f, 0x5d, 0x2f, 0x01, 0xb2, 0x54, 0x2f, 0x02,
    0xb2, 0x4e, 0x2f, 0x03, 0x90, 0x63, 0x2f, 0x59, 0x50, 0x39, 0x82, 0x02, 0x40, 0x81, 0x88, 0x5b, 0x54, 0x41, 0x40,
    0x61, 0x56, 0x04, 0x42, 0x00, 0x2e, 0x94, 0x40, 0x95, 0x40, 0xd8, 0xbe, 0x2c, 0x0b, 0x45, 0x40, 0x6c, 0x01, 0x55,
    0x42, 0x0c, 0x17, 0x45, 0x40, 0x2c, 0x03, 0x54, 0x42, 0x53, 0x0e, 0xf2, 0x2f, 0x63, 0x56, 0x3e, 0x82, 0xe2, 0x40,
    0xc3, 0x40, 0x28, 0xbd, 0x93, 0x0a, 0x43, 0x40, 0xda, 0x00, 0x53, 0x42, 0x8a, 0x16, 0x43, 0x40, 0x9a, 0x02, 0x52,
    0x42, 0x00, 0x2e, 0x41, 0x40, 0x47, 0x54, 0x4a, 0x0e, 0x3b, 0x2f, 0x3a, 0x82, 0x00, 0x30, 0x41, 0x40, 0x21, 0x2e,
    0x52, 0x0f, 0x40, 0xb2, 0x0a, 0x2f, 0x98, 0x2e, 0x61, 0x0c, 0x98, 0x2e, 0x2b, 0x0e, 0x98, 0x2e, 0x41, 0x0e, 0xfb,
    0x6f, 0xf0, 0x5f, 0x00, 0x30, 0x80, 0x2e, 0xaf, 0xb1, 0x5f, 0x54, 0x55, 0x56, 0x83, 0x42, 0x8f, 0x86, 0x74, 0x30,
    0x5d, 0x54, 0xc4, 0x42, 0x11, 0x30, 0x23, 0x2e, 0x86, 0x00, 0xa1, 0x42, 0x23, 0x30, 0x27, 0x2e, 0x89, 0x00, 0x21,
    0x2e, 0x88, 0x00, 0xba, 0x82, 0x18, 0x2c, 0x81, 0x42, 0x30, 0x30, 0x21, 0x2e, 0x86, 0x00, 0x13, 0x2d, 0x21, 0x30,
    0x00, 0x30, 0x23, 0x2e, 0x86, 0x00, 0x21, 0x2e, 0x7b, 0xf7, 0x0c, 0x2d, 0x77, 0x30, 0x98, 0x2e, 0x1f, 0x0c, 0x57,
    0x50, 0x0c, 0x82, 0x12, 0x30, 0x40, 0x42, 0x25, 0x2e, 0x86, 0x00, 0x2f, 0x2e, 0x7b, 0xf7, 0xfb, 0x6f, 0xf0, 0x5f,
    0xb8, 0x2e, 0x70, 0x50, 0x0a, 0x25, 0x39, 0x86, 0xfb, 0x7f, 0xe1, 0x32, 0x62, 0x30, 0x98, 0x2e, 0xc2, 0xc4, 0x23,
    0x56, 0xa5, 0x6f, 0xab, 0x08, 0x91, 0x6f, 0x4b, 0x08, 0x65, 0x56, 0xc4, 0x6f, 0x23, 0x09, 0x4d, 0xba, 0x93, 0xbc,
    0x8c, 0x0b, 0xd1, 0x6f, 0x0b, 0x09, 0x49, 0x52, 0x67, 0x5e, 0x56, 0x42, 0xaf, 0x09, 0x4d, 0xba, 0x23, 0xbd, 0x94,
    0x0a, 0xe5, 0x6f, 0x68, 0xbb, 0xeb, 0x08, 0xbd, 0xb9, 0x63, 0xbe, 0xfb, 0x6f, 0x52, 0x42, 0xe3, 0x0a, 0xc0, 0x2e,
    0x43, 0x42, 0x90, 0x5f, 0x4f, 0x50, 0x03, 0x2e, 0x25, 0xf3, 0x12, 0x40, 0x00, 0x40, 0x28, 0xba, 0x9b, 0xbc, 0x88,
    0xbd, 0x93, 0xb4, 0xe3, 0x0a, 0x89, 0x16, 0x08, 0xb6, 0xc0, 0x2e, 0x19, 0x00, 0x62, 0x02, 0x10, 0x50, 0xfb, 0x7f,
    0x98, 0x2e, 0x5d, 0x0d, 0x01, 0x2e, 0x86, 0x00, 0x31, 0x30, 0x08, 0x04, 0xfb, 0x6f, 0x01, 0x30, 0xf0, 0x5f, 0x23,
    0x2e, 0x88, 0x00, 0x21, 0x2e, 0x89, 0x00, 0xb8, 0x2e, 0x01, 0x2e, 0x89, 0x00, 0x03, 0x2e, 0x88, 0x00, 0x48, 0x0e,
    0x01, 0x2f, 0x80, 0x2e, 0x05, 0x0e, 0xb8, 0x2e, 0x69, 0x50, 0x21, 0x34, 0x01, 0x42, 0x82, 0x30, 0xc1, 0x32, 0x25,
    0x2e, 0x62, 0xf5, 0x01, 0x00, 0x22, 0x30, 0x01, 0x40, 0x4a, 0x0a, 0x01, 0x42, 0xb8, 0x2e, 0x69, 0x54, 0xf0, 0x3b,
    0x83, 0x40, 0xd8, 0x08, 0x6b, 0x52, 0x83, 0x42, 0x00, 0x30, 0x83, 0x30, 0x50, 0x42, 0xc4, 0x32, 0x27, 0x2e, 0x64,
    0xf5, 0x94, 0x00, 0x50, 0x42, 0x40, 0x42, 0xd3, 0x3f, 0x84, 0x40, 0x7d, 0x82, 0xe3, 0x08, 0x40, 0x42, 0x83, 0x42,
    0xb8, 0x2e, 0x5f, 0x52, 0x00, 0x30, 0x40, 0x42, 0x7c, 0x86, 0x37, 0x52, 0x09, 0x2e, 0x3d, 0x0f, 0x3d, 0x54, 0xc4,
    0x42, 0xd3, 0x86, 0x54, 0x40, 0x55, 0x40, 0x94, 0x42, 0x85, 0x42, 0x21, 0x2e, 0x89, 0x00, 0x42, 0x40, 0x25, 0x2e,
    0xfd, 0xf3, 0xc0, 0x42, 0x7e, 0x82, 0x05, 0x2e, 0x79, 0x00, 0x80, 0xb2, 0x14, 0x2f, 0x05, 0x2e, 0x24, 0x02, 0x27,
    0xbd, 0x2f, 0xb9, 0x80, 0x90, 0x02, 0x2f, 0x21, 0x2e, 0x6f, 0xf5, 0x0c, 0x2d, 0x07, 0x2e, 0x3e, 0x0f, 0x14, 0x30,
    0x1c, 0x09, 0x05, 0x2e, 0x77, 0xf7, 0x3b, 0x56, 0x47, 0xbe, 0x93, 0x08, 0x94, 0x0a, 0x25, 0x2e, 0x77, 0xf7, 0x6d,
    0x54, 0x50, 0x42, 0x4a, 0x0e, 0xfc, 0x2f, 0xb8, 0x2e, 0x50, 0x50, 0x02, 0x30, 0x43, 0x86, 0x6b, 0x50, 0xfb, 0x7f,
    0xe3, 0x7f, 0xd2, 0x7f, 0xc0, 0x7f, 0xb1, 0x7f, 0x00, 0x2e, 0x41, 0x40, 0x00, 0x40, 0x48, 0x04, 0x98, 0x2e, 0x74,
    0xc0, 0x1e, 0xaa, 0xd3, 0x6f, 0x14, 0x30, 0xb1, 0x6f, 0xe3, 0x22, 0xc0, 0x6f, 0x52, 0x40, 0xe4, 0x6f, 0x4c, 0x0e,
    0x12, 0x42, 0xd3, 0x7f, 0xeb, 0x2f, 0x03, 0x2e, 0x53, 0x0f, 0x40, 0x90, 0x11, 0x30, 0x03, 0x2f, 0x23, 0x2e, 0x53,
    0x0f, 0x02, 0x2c, 0x00, 0x30, 0xd0, 0x6f, 0xfb, 0x6f, 0xb0, 0x5f, 0xb8, 0x2e, 0x40, 0x50, 0xf1, 0x7f, 0x0a, 0x25,
    0x3c, 0x86, 0xeb, 0x7f, 0x41, 0x33, 0x22, 0x30, 0x98, 0x2e, 0xc2, 0xc4, 0xd3, 0x6f, 0xf4, 0x30, 0xdc, 0x09, 0x71,
    0x58, 0xc2, 0x6f, 0x94, 0x09, 0x73, 0x58, 0x6a, 0xbb, 0xdc, 0x08, 0xb4, 0xb9, 0xb1, 0xbd, 0x6f, 0x5a, 0x95, 0x08,
    0x21, 0xbd, 0xf6, 0xbf, 0x77, 0x0b, 0x51, 0xbe, 0xf1, 0x6f, 0xeb, 0x6f, 0x52, 0x42, 0x54, 0x42, 0xc0, 0x2e, 0x43,
    0x42, 0xc0, 0x5f, 0x50, 0x50, 0x77, 0x52, 0x93, 0x30, 0x53, 0x42, 0xfb, 0x7f, 0x7b, 0x30, 0x4b, 0x42, 0x13, 0x30,
    0x42, 0x82, 0x20, 0x33, 0x43, 0x42, 0xc8, 0x00, 0x01, 0x2e, 0x80, 0x03, 0x05, 0x2e, 0x7e, 0x00, 0x19, 0x52, 0xe2,
    0x7f, 0xd0, 0x7f, 0xc3, 0x7f, 0x98, 0x2e, 0x9c, 0x0e, 0xd1, 0x6f, 0x48, 0x0a, 0xd1, 0x7f, 0x3a, 0x25, 0xfb, 0x86,
    0x01, 0x33, 0x12, 0x30, 0x98, 0x2e, 0xc2, 0xc4, 0xd1, 0x6f, 0x48, 0x0a, 0x40, 0xb2, 0x0d, 0x2f, 0xe0, 0x6f, 0x03,
    0x2e, 0x80, 0x03, 0x53, 0x30, 0x07, 0x80, 0x27, 0x2e, 0x21, 0xf2, 0x98, 0xbc, 0x01, 0x42, 0x98, 0x2e, 0xe0, 0x03,
    0x00, 0x2e, 0x00, 0x2e, 0xd0, 0x2e, 0xb1, 0x6f, 0x9b, 0xb8, 0x07, 0x2e, 0x1b, 0x00, 0x19, 0x1a, 0xb1, 0x7f, 0x71,
    0x30, 0x04, 0x2f, 0x23, 0x2e, 0x21, 0xf2, 0x00, 0x2e, 0x00, 0x2e, 0xd0, 0x2e, 0x98, 0x2e, 0x6d, 0xc0, 0x98, 0x2e,
    0x5d, 0xc0, 0x98, 0x2e, 0xd9, 0xb5, 0x20, 0x26, 0xc1, 0x6f, 0x02, 0x31, 0x52, 0x42, 0xab, 0x30, 0x4b, 0x42, 0x20,
    0x33, 0x79, 0x56, 0xf1, 0x37, 0xc4, 0x40, 0xa2, 0x0a, 0xc2, 0x42, 0xd8, 0x00, 0x01, 0x2e, 0x5e, 0xf7, 0x41, 0x08,
    0x23, 0x2e, 0x93, 0x00, 0xe3, 0x7f, 0x98, 0x2e, 0xe1, 0x00, 0xe1, 0x6f, 0x83, 0x30, 0x43, 0x42, 0x03, 0x30, 0xfb,
    0x6f, 0x75, 0x50, 0x02, 0x30, 0x00, 0x2e, 0x00, 0x2e, 0x81, 0x84, 0x50, 0x0e, 0xfa, 0x2f, 0x43, 0x42, 0x11, 0x30,
    0xb0, 0x5f, 0x23, 0x2e, 0x21, 0xf2, 0xb8, 0x2e, 0xc1, 0x4a, 0x00, 0x00, 0x6d, 0x57, 0x00, 0x00, 0x77, 0x8e, 0x00,
    0x00, 0xe0, 0xff, 0xff, 0xff, 0xd3, 0xff, 0xff, 0xff, 0xe5, 0xff, 0xff, 0xff, 0xee, 0xe1, 0xff, 0xff, 0x7c, 0x13,
    0x00, 0x00, 0x46, 0xe6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e,
    0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80,
    0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1,
    0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00, 0xc1, 0x80, 0x2e, 0x00,
    0xc1, 0xfd, 0x2d
};

/*! @name  Global array that stores the feature input configuration of
 * BMI270_HUAWEI_CONTEXT
 */
const struct bmi2_feature_config bmi270_hc_feat_in[BMI270_HC_MAX_FEAT_IN] = {
    { .type = BMI2_CONFIG_ID, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_CONFIG_ID_STRT_ADDR },
    { .type = BMI2_STEP_COUNTER_PARAMS, .page = BMI2_PAGE_1, .start_addr = BMI270_HC_STEP_CNT_1_STRT_ADDR },
    { .type = BMI2_STEP_DETECTOR, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_STEP_CNT_4_STRT_ADDR },
    { .type = BMI2_STEP_COUNTER, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_STEP_CNT_4_STRT_ADDR },
    { .type = BMI2_NVM_PROG_PREP, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_NVM_PROG_PREP_STRT_ADDR },
    { .type = BMI2_MAX_BURST_LEN, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_MAX_BURST_LEN_STRT_ADDR },
    { .type = BMI2_CRT_GYRO_SELF_TEST, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_CRT_GYRO_SELF_TEST_STRT_ADDR },
    { .type = BMI2_ABORT_CRT_GYRO_SELF_TEST, .page = BMI2_PAGE_4, .start_addr = BMI270_HC_ABORT_STRT_ADDR },
    { .type = BMI2_ACTIVITY_RECOGNITION_SETTINGS, .page = BMI2_PAGE_5, .start_addr = BMI270_HC_ACT_RGN_SETT_STRT_ADDR },
    { .type = BMI2_ACTIVITY_RECOGNITION, .page = BMI2_PAGE_5, .start_addr = BMI270_HC_ACT_RGN_STRT_ADDR },
};

/*! @name  Global array that stores the feature output configuration */
const struct bmi2_feature_config bmi270_hc_feat_out[BMI270_HC_MAX_FEAT_OUT] = {
    { .type = BMI2_STEP_COUNTER, .page = BMI2_PAGE_0, .start_addr = BMI270_HC_STEP_CNT_OUT_STRT_ADDR },
    { .type = BMI2_GYRO_CROSS_SENSE, .page = BMI2_PAGE_0, .start_addr = BMI270_HC_GYRO_CROSS_SENSE_STRT_ADDR },
    { .type = BMI2_GYRO_GAIN_UPDATE, .page = BMI2_PAGE_0, .start_addr = BMI270_HC_GYR_USER_GAIN_OUT_STRT_ADDR },
    { .type = BMI2_NVM_STATUS, .page = BMI2_PAGE_0, .start_addr = BMI270_HC_NVM_VFRM_OUT_STRT_ADDR },
    { .type = BMI2_VFRM_STATUS, .page = BMI2_PAGE_0, .start_addr = BMI270_HC_NVM_VFRM_OUT_STRT_ADDR }
};

/*! @name  Global array that stores the feature interrupts of BMI270_HUAWEI_CONTEXT */
struct bmi2_map_int bmi270_hc_map_int[BMI270_HC_MAX_INT_MAP] = {
    { .type = BMI2_STEP_COUNTER, .sens_map_int = BMI270_HC_INT_STEP_COUNTER_MASK },
    { .type = BMI2_STEP_DETECTOR, .sens_map_int = BMI270_HC_INT_STEP_DETECTOR_MASK },
};

/******************************************************************************/

/*!         Local Function Prototypes
 ******************************************************************************/

/*!
 * @brief This internal API is used to validate the device pointer for
 * null conditions.
 *
 * @param[in] dev : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t null_ptr_check(const struct bmi2_dev *dev);

/*!
 * @brief This internal API enables the selected sensor/features.
 *
 * @param[in]       sensor_sel    : Selects the desired sensor.
 * @param[in, out]  dev           : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t sensor_enable(uint64_t sensor_sel, struct bmi2_dev *dev);

/*!
 * @brief This internal API disables the selected sensor/features.
 *
 * @param[in]       sensor_sel    : Selects the desired sensor.
 * @param[in, out]  dev           : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t sensor_disable(uint64_t sensor_sel, struct bmi2_dev *dev);

/*!
 * @brief This internal API selects the sensors/features to be enabled or
 * disabled.
 *
 * @param[in]  sens_list    : Pointer to select the sensor.
 * @param[in]  n_sens       : Number of sensors selected.
 * @param[out] sensor_sel   : Gets the selected sensor.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t select_sensor(const uint8_t *sens_list, uint8_t n_sens, uint64_t *sensor_sel);

/*!
 * @brief This internal API is used to enable/disable step detector feature.
 *
 * @param[in] dev            : Structure instance of bmi2_dev.
 * @param[in] enable         : Enables/Disables step-detector.
 *
 * Enable       |  Description
 * -------------|---------------
 * BMI2_DISABLE | Disables step detector
 * BMI2_ENABLE  | Enables step detector
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_step_detector(uint8_t enable, struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to enable/disable step counter feature.
 *
 * @param[in] dev            : Structure instance of bmi2_dev.
 * @param[in] enable         : Enables/Disables step counter.
 *
 * Enable       |  Description
 * -------------|---------------
 * BMI2_DISABLE | Disables step counter
 * BMI2_ENABLE  | Enables step counter
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_step_counter(uint8_t enable, struct bmi2_dev *dev);

/*!
 * @brief This internal API enables/disables the activity recognition feature.
 *
 * @param[in] enable    : Enables/Disables activity recognition.
 * @param[in] dev       : Structure instance of bmi2_dev.
 *
 *  enable      |  Description
 * -------------|---------------
 * BMI2_ENABLE  | Enables activity recognition.
 * BMI2_DISABLE | Disables activity recognition.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_act_recog(uint8_t enable, struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to enable/disable gyroscope user gain
 * feature.
 *
 * @param[in] dev            : Structure instance of bmi2_dev.
 * @param[in] enable         : Enables/Disables gyroscope user gain.
 *
 * Enable       |  Description
 * -------------|---------------
 * BMI2_DISABLE | Disables gyroscope user gain
 * BMI2_ENABLE  | Enables gyroscope user gain
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_gyro_user_gain(uint8_t enable, struct bmi2_dev *dev);

/*!
 * @brief This internal API sets step counter parameter configurations.
 *
 * @param[in] step_count_params : Array that stores parameters 1 to 25.
 * @param[in] dev               : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_step_count_params_config(const uint16_t *step_count_params, struct bmi2_dev *dev);

/*!
 * @brief This internal API sets step counter/detector/activity configurations.
 *
 * @param[in] config      : Structure instance of bmi2_step_config.
 * @param[in] dev         : Structure instance of bmi2_dev.
 *
 *---------------------------------------------------------------------------
 *    bmi2_step_config      |
 *  Structure parameters    |                 Description
 *--------------------------|--------------------------------------------------
 *                          | The Step-counter will trigger output every time
 *                          | the number of steps are counted. Holds implicitly
 *  water-mark level        | a 20x factor, so the range is 0 to 10230,
 *                          | with resolution of 20 steps.
 * -------------------------|---------------------------------------------------
 *  reset counter           | Flag to reset the counted steps.
 * -------------------------|---------------------------------------------------
 * @endverbatim
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t set_step_config(const struct bmi2_step_config *config, struct bmi2_dev *dev);

/*!
 * @brief This internal API gets step counter parameter configurations.
 *
 * @param[in] step_count_params : Array that stores parameters 1 to 25.
 * @param[in] dev               : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_step_count_params_config(uint16_t *step_count_params, struct bmi2_dev *dev);

/*!
 * @brief This internal API gets step counter/detector/activity configurations.
 *
 * @param[out] config      : Structure instance of bmi2_step_config.
 * @param[in]  dev         : Structure instance of bmi2_dev.
 *
 * @verbatim
 *----------------------------------------------------------------------------
 *    bmi2_step_config      |
 *  Structure parameters    |                 Description
 *--------------------------|--------------------------------------------------
 *                          | The Step-counter will trigger output every time
 *                          | the number of steps are counted. Holds implicitly
 *  water-mark level        | a 20x factor, so the range is 0 to 10230,
 *                          | with resolution of 20 steps.
 * -------------------------|---------------------------------------------------
 *  reset counter           | Flag to reset the counted steps.
 * -------------------------|---------------------------------------------------
 * @endverbatim
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_step_config(struct bmi2_step_config *config, struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to parse and store the activity recognition
 * output from the FIFO data.
 *
 * @param[out] act_recog        : Structure to retrieve output of activity
 *                                  recognition frame.
 * @param[in] data_index        : Index of the FIFO data which contains
 *                                  activity recognition frame.
 * @param[out] fifo             : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t unpack_act_recog_output(struct bmi2_act_recog_output *act_recog,
                                      uint16_t *data_index,
                                      const struct bmi2_fifo_frame *fifo);

/*!
 * @brief This internal API gets the output values of step counter.
 *
 * @param[out] step_count       : Pointer to the stored step counter data.
 * @param[in]  dev              : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_step_counter_output(uint32_t *step_count, struct bmi2_dev *dev);

/*!
 * @brief This internal API gets the error status related to NVM.
 *
 * @param[out] nvm_err_stat     : Stores the NVM error status.
 * @param[in]  dev              : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_nvm_error_status(struct bmi2_nvm_err_status *nvm_err_stat, struct bmi2_dev *dev);

/*!
 * @brief This internal API gets the error status related to virtual frames.
 *
 * @param[out] vfrm_err_stat    : Stores the VFRM related error status.
 * @param[in]  dev              : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_vfrm_error_status(struct bmi2_vfrm_err_status *vfrm_err_stat, struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to get enable status of gyroscope user gain
 * update.
 *
 * @param[out] status         : Stores status of gyroscope user gain update.
 * @param[in]  dev            : Structure instance of bmi2_dev.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t get_user_gain_upd_status(uint8_t *status, struct bmi2_dev *dev);

/*!
 * @brief This internal API skips S4S frame in the FIFO data while getting
 * activity recognition output.
 *
 * @param[in, out] frame_header : FIFO frame header.
 * @param[in, out] data_index   : Index value of the FIFO data bytes
 *                                from which S4S frame header is to be
 *                                skipped.
 * @param[in]      fifo         : Structure instance of bmi2_fifo_frame.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t move_if_s4s_frame(const uint8_t *frame_header, uint16_t *data_index, const struct bmi2_fifo_frame *fifo);

/*!
 * @brief This internal API enables/disables compensation of the gain defined
 * in the GAIN register.
 *
 * @param[in] enable    : Enables/Disables gain compensation
 * @param[in] dev       : Structure instance of bmi2_dev.
 *
 *  enable      |  Description
 * -------------|---------------
 * BMI2_ENABLE  | Enable gain compensation.
 * BMI2_DISABLE | Disable gain compensation.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t enable_gyro_gain(uint8_t enable, struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to extract the output feature configuration
 * details like page and start address from the look-up table.
 *
 * @param[out] feat_output      : Structure that stores output feature
 *                              configurations.
 * @param[in] type              : Type of feature or sensor.
 * @param[in] dev               : Structure instance of bmi2_dev.
 *
 * @return Returns the feature found flag.
 *
 * @retval  BMI2_FALSE : Feature not found
 *          BMI2_TRUE  : Feature found
 */
static uint8_t extract_output_feat_config(struct bmi2_feature_config *feat_output,
                                          uint8_t type,
                                          const struct bmi2_dev *dev);

/*!
 * @brief This internal API is used to move the data index ahead of the
 * current frame length parameter when unnecessary FIFO data appears while
 * extracting the user specified data.
 *
 * @param[in,out] data_index           : Index of the FIFO data which is to be
 *                                       moved ahead of the current frame length
 * @param[in]     current_frame_length : Number of bytes in the current frame.
 * @param[in]     fifo                 : Structure instance of bmi2_fifo_frame.
 *
 * @return Result of API execution status
 * @retval 0 -> Success
 * @retval < 0 -> Fail
 */
static int8_t move_next_frame(uint16_t *data_index, uint8_t current_frame_length, const struct bmi2_fifo_frame *fifo);

/***************************************************************************/

/*!         User Interface Definitions
 ****************************************************************************/

/*!
 *  @brief This API:
 *  1) Updates the device structure with address of the configuration file.
 *  2) Initializes BMI270_HUAWEI_CONTEXT sensor.
 *  3) Writes the configuration file.
 *  4) Updates the feature offset parameters in the device structure.
 *  5) Updates the maximum number of pages, in the device structure.
 */
int8_t bmi270_hc_init(struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if (rslt == BMI2_OK)
    {
        /* Assign chip id of BMI270_HUAWEI_CONTEXT */
        dev->chip_id = BMI270_HC_CHIP_ID;

        /* Get the size of config array */
        dev->config_size = sizeof(bmi270_hc_config_file);

        /* Enable the variant specific features if any */
        dev->variant_feature = BMI2_CRT_RTOSK_ENABLE | BMI2_GYRO_CROSS_SENS_ENABLE;

        /* An extra dummy byte is read during SPI read */
        if (dev->intf == BMI2_SPI_INTF)
        {
            dev->dummy_byte = 1;
        }
        else
        {
            dev->dummy_byte = 0;
        }

        /* If configuration file pointer is not assigned any address */
        if (!dev->config_file_ptr)
        {
            /* Give the address of the configuration file array to
             * the device pointer
             */
            dev->config_file_ptr = bmi270_hc_config_file;
        }

        /* Initialize BMI2 sensor */
        rslt = bmi2_sec_init(dev);
        if (rslt == BMI2_OK)
        {
            /* Assign the offsets of the feature input
             * configuration to the device structure
             */
            dev->feat_config = bmi270_hc_feat_in;

            /* Assign the offsets of the feature output to
             * the device structure
             */
            dev->feat_output = bmi270_hc_feat_out;

            /* Assign the maximum number of pages to the
             * device structure
             */
            dev->page_max = BMI270_HC_MAX_PAGE_NUM;

            /* Assign maximum number of input sensors/
             * features to device structure
             */
            dev->input_sens = BMI270_HC_MAX_FEAT_IN;

            /* Assign maximum number of output sensors/
             * features to device structure
             */
            dev->out_sens = BMI270_HC_MAX_FEAT_OUT;

            /* Assign the offsets of the feature interrupt
             * to the device structure
             */
            dev->map_int = bmi270_hc_map_int;

            /* Assign maximum number of feature interrupts
             * to device structure
             */
            dev->sens_int_map = BMI270_HC_MAX_INT_MAP;
        }
    }

    return rslt;
}

/*!
 * @brief This API selects the sensors/features to be enabled.
 */
int8_t bmi270_hc_sensor_enable(const uint8_t *sens_list, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to select sensor */
    uint64_t sensor_sel = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sens_list != NULL))
    {
        /* Get the selected sensors */
        rslt = select_sensor(sens_list, n_sens, &sensor_sel);
        if (rslt == BMI2_OK)
        {
            /* Enable the selected sensors */
            rslt = sensor_enable(sensor_sel, dev);
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API selects the sensors/features to be disabled.
 */
int8_t bmi270_hc_sensor_disable(const uint8_t *sens_list, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to select sensor */
    uint64_t sensor_sel = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sens_list != NULL))
    {
        /* Get the selected sensors */
        rslt = select_sensor(sens_list, n_sens, &sensor_sel);
        if (rslt == BMI2_OK)
        {
            /* Disable the selected sensors */
            rslt = sensor_disable(sensor_sel, dev);
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API sets the sensor/feature configuration.
 */
int8_t bmi270_hc_set_sensor_config(struct bmi2_sens_config *sens_cfg, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define loop */
    uint8_t loop;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sens_cfg != NULL))
    {
        /* Get status of advance power save mode */
        aps_stat = dev->aps_status;

        for (loop = 0; loop < n_sens; loop++)
        {
            if ((sens_cfg[loop].type == BMI2_ACCEL) || (sens_cfg[loop].type == BMI2_GYRO) ||
                (sens_cfg[loop].type == BMI2_AUX) || (sens_cfg[loop].type == BMI2_GYRO_GAIN_UPDATE))
            {
                rslt = bmi2_set_sensor_config(&sens_cfg[loop], 1, dev);
            }
            else
            {
                /* Disable Advance power save if enabled for auxiliary
                 * and feature configurations
                 */
                if (aps_stat == BMI2_ENABLE)
                {
                    /* Disable advance power save if
                     * enabled
                     */
                    rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
                }

                if (rslt == BMI2_OK)
                {
                    switch (sens_cfg[loop].type)
                    {
                        /* Set the step counter parameters */
                        case BMI2_STEP_COUNTER_PARAMS:
                            rslt = set_step_count_params_config(sens_cfg[loop].cfg.step_counter_params, dev);
                            break;

                        /* Set step counter/detector/activity configuration */
                        case BMI2_STEP_DETECTOR:
                        case BMI2_STEP_COUNTER:
                            rslt = set_step_config(&sens_cfg[loop].cfg.step_counter, dev);
                            break;

                        default:
                            rslt = BMI2_E_INVALID_SENSOR;
                            break;
                    }
                }

                /* Return error if any of the set configurations fail */
                if (rslt != BMI2_OK)
                {
                    break;
                }
            }
        }

        /* Enable Advance power save if disabled while configuring and
         * not when already disabled
         */
        if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
        {
            rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API gets the sensor/feature configuration.
 */
int8_t bmi270_hc_get_sensor_config(struct bmi2_sens_config *sens_cfg, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define loop */
    uint8_t loop;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sens_cfg != NULL))
    {
        /* Get status of advance power save mode */
        aps_stat = dev->aps_status;
        for (loop = 0; loop < n_sens; loop++)
        {
            if ((sens_cfg[loop].type == BMI2_ACCEL) || (sens_cfg[loop].type == BMI2_GYRO) ||
                (sens_cfg[loop].type == BMI2_AUX) || (sens_cfg[loop].type == BMI2_GYRO_GAIN_UPDATE))
            {
                rslt = bmi2_get_sensor_config(&sens_cfg[loop], 1, dev);
            }
            else
            {
                /* Disable Advance power save if enabled for auxiliary
                 * and feature configurations
                 */
                if ((sens_cfg[loop].type >= BMI2_MAIN_SENS_MAX_NUM) || (sens_cfg[loop].type == BMI2_AUX))
                {

                    if (aps_stat == BMI2_ENABLE)
                    {
                        /* Disable advance power save if
                         * enabled
                         */
                        rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
                    }
                }

                if (rslt == BMI2_OK)
                {
                    switch (sens_cfg[loop].type)
                    {
                        /* Set the step counter parameters */
                        case BMI2_STEP_COUNTER_PARAMS:
                            rslt = get_step_count_params_config(sens_cfg[loop].cfg.step_counter_params, dev);
                            break;

                        /* Get step counter/detector/activity configuration */
                        case BMI2_STEP_DETECTOR:
                        case BMI2_STEP_COUNTER:
                            rslt = get_step_config(&sens_cfg[loop].cfg.step_counter, dev);
                            break;

                        default:
                            rslt = BMI2_E_INVALID_SENSOR;
                            break;
                    }
                }

                /* Return error if any of the get configurations fail */
                if (rslt != BMI2_OK)
                {
                    break;
                }
            }
        }

        /* Enable Advance power save if disabled while configuring and
         * not when already disabled
         */
        if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
        {
            rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API gets the sensor/feature data for accelerometer, gyroscope,
 * auxiliary sensor, step counter, high-g, gyroscope user-gain update,
 * orientation, gyroscope cross sensitivity and error status for NVM and VFRM.
 */
int8_t bmi270_hc_get_sensor_data(struct bmi2_sensor_data *sensor_data, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define loop */
    uint8_t loop;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sensor_data != NULL))
    {
        /* Get status of advance power save mode */
        aps_stat = dev->aps_status;
        for (loop = 0; loop < n_sens; loop++)
        {
            if ((sensor_data[loop].type == BMI2_ACCEL) || (sensor_data[loop].type == BMI2_GYRO) ||
                (sensor_data[loop].type == BMI2_AUX) || (sensor_data[loop].type == BMI2_GYRO_GAIN_UPDATE) ||
                (sensor_data[loop].type == BMI2_GYRO_CROSS_SENSE))
            {
                rslt = bmi2_get_sensor_data(&sensor_data[loop], 1, dev);
            }
            else
            {
                /* Disable Advance power save if enabled for feature
                 * configurations
                 */
                if (sensor_data[loop].type >= BMI2_MAIN_SENS_MAX_NUM)
                {
                    if (aps_stat == BMI2_ENABLE)
                    {
                        /* Disable advance power save if
                         * enabled
                         */
                        rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
                    }
                }

                if (rslt == BMI2_OK)
                {
                    switch (sensor_data[loop].type)
                    {
                        case BMI2_STEP_COUNTER:

                            /* Get step counter output */
                            rslt = get_step_counter_output(&sensor_data[loop].sens_data.step_counter_output, dev);
                            break;
                        case BMI2_NVM_STATUS:

                            /* Get NVM error status  */
                            rslt = get_nvm_error_status(&sensor_data[loop].sens_data.nvm_status, dev);
                            break;
                        case BMI2_VFRM_STATUS:

                            /* Get VFRM error status  */
                            rslt = get_vfrm_error_status(&sensor_data[loop].sens_data.vfrm_status, dev);
                            break;
                        default:
                            rslt = BMI2_E_INVALID_SENSOR;
                            break;
                    }

                    /* Return error if any of the get sensor data fails */
                    if (rslt != BMI2_OK)
                    {
                        break;
                    }
                }
            }

            /* Enable Advance power save if disabled while
             * configuring and not when already disabled
             */
            if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
            {
                rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
            }
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This api is used for retrieving the activity recognition settings currently set for bmi270hc.
 */
int8_t bmi270_hc_get_act_recg_sett(struct bmi2_hc_act_recg_sett *sett, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat;

    /* Variable to set flag */
    uint8_t feat_found;
    uint16_t msb_lsb;
    uint8_t lsb;
    uint8_t msb;

    /* Initialize feature configuration for activity recognition  */
    struct bmi2_feature_config bmi2_act_recg_sett = { 0, 0, 0 };

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if (rslt == BMI2_OK)
    {
        /* Search for activity recognition feature and extract its configuration details */
        feat_found = bmi2_extract_input_feat_config(&bmi2_act_recg_sett, BMI2_ACTIVITY_RECOGNITION_SETTINGS, dev);
        if (feat_found)
        {
            aps_stat = dev->aps_status;
            if (aps_stat == BMI2_ENABLE)
            {
                /* Disable advance power save if enabled */
                rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
            }

            /* Get the configuration from the page where activity recognition setting feature resides */
            if (rslt == BMI2_OK)
            {
                rslt = bmi2_get_feat_config(bmi2_act_recg_sett.page, feat_config, dev);
            }

            if (rslt == BMI2_OK)
            {
                /* Define the offset in bytes */
                idx = bmi2_act_recg_sett.start_addr;

                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;

                sett->segment_size = msb_lsb & BMI2_HC_ACT_RECG_SEGMENT_SIZE_MASK;

                /* Increment idx by 2 to point post processing enable/disable address */
                idx = 4;
                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;
                sett->pp_en = msb_lsb & BMI2_HC_ACT_RECG_PP_EN_MASK;

                /* Increment idx by 2 to point mix gdi thres addres */
                idx = 6;
                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;
                sett->min_gdi_thres = msb_lsb & BMI2_HC_ACT_RECG_MIN_GDI_THRES_MASK;

                /* Increment idx by 2 to point max gdi thres addres */
                idx = 8;
                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;
                sett->max_gdi_thres = msb_lsb & BMI2_HC_ACT_RECG_MAX_GDI_THRES_MASK;

                /* Increment idx by 2 to point to buffer size */
                idx = 10;
                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;
                sett->buf_size = msb_lsb & BMI2_HC_ACT_RECG_BUF_SIZE_MASK;

                /* Increment idx by 2 to to point to min segment confidence */
                idx = 12;
                lsb = feat_config[idx++];
                msb = feat_config[idx++];
                msb_lsb = ((uint16_t)msb << 8) | lsb;
                sett->min_seg_conf = msb_lsb & BMI2_HC_ACT_RECG_MIN_SEG_CONF_MASK;
            }

            /* Enable Advance power save if disabled while
             * configuring and not when already disabled
             */
            if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
            {
                rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
            }
        }
        else
        {
            rslt = BMI2_E_INVALID_SENSOR;
        }
    }

    return rslt;
}

/*!
 * @brief This api is used for setting the activity recognition settings for bmi270hc.
 */
int8_t bmi270_hc_set_act_recg_sett(const struct bmi2_hc_act_recg_sett *sett, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Variable to define index */
    uint8_t index = 0;

    /* Initialize feature configuration for activity recognition  */
    struct bmi2_feature_config bmi2_act_recg_sett = { 0, 0, 0 };

    /* Copy the feature configuration address to a local pointer */
    uint16_t *data_p = (uint16_t *) (void *)feat_config;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if (rslt == BMI2_OK)
    {
        /* Search for activity recognition feature and extract its configuration details */
        feat_found = bmi2_extract_input_feat_config(&bmi2_act_recg_sett, BMI2_ACTIVITY_RECOGNITION_SETTINGS, dev);
        if (feat_found)
        {
            aps_stat = dev->aps_status;
            if (aps_stat == BMI2_ENABLE)
            {
                /* Disable advance power save if enabled */
                rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
            }

            if (rslt == BMI2_OK)
            {
                /* Get the configuration from the page where activity recognition setting feature resides */
                rslt = bmi2_get_feat_config(bmi2_act_recg_sett.page, feat_config, dev);
                if (rslt == BMI2_OK)
                {
                    /* Define the offset in bytes */
                    idx = bmi2_act_recg_sett.start_addr;

                    /* Get offset in words since all the features are set in words length */
                    idx = idx / 2;

                    /* Set segment size */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx),
                                                        BMI2_HC_ACT_RECG_SEGMENT_SIZE,
                                                        sett->segment_size);

                    /* Starting address of post processing represented in word length */
                    idx = 2;

                    /* Set post processing */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx), BMI2_HC_ACT_RECG_PP_EN, sett->pp_en);

                    /* Starting address of min_gdi_thres represented in word length */
                    idx = 3;

                    /* Set minimum gdi threshold */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx),
                                                        BMI2_HC_ACT_RECG_MIN_GDI_THRES,
                                                        sett->min_gdi_thres);

                    /* Starting address of max_gdi_thres represented in word length */
                    idx = 4;

                    /* Set maximum gdi threshold */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx),
                                                        BMI2_HC_ACT_RECG_MAX_GDI_THRES,
                                                        sett->max_gdi_thres);

                    /* Starting address of buffer size represented in word length */
                    idx = 5;

                    /* Set buffer size */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx), BMI2_HC_ACT_RECG_BUF_SIZE, sett->buf_size);

                    /* Starting address of min_seg_conf represented in word length */
                    idx = 6;

                    /* Set min segment confidence */
                    *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx),
                                                        BMI2_HC_ACT_RECG_MIN_SEG_CONF,
                                                        sett->min_seg_conf);

                    /* Increment offset by 1 more word to get the total length in words */
                    idx++;

                    /* Get total length in bytes to copy from local pointer to the array */
                    idx = (uint8_t)(idx * 2) - bmi2_act_recg_sett.start_addr;

                    /* Copy the bytes to be set back to the array */
                    for (index = 0; index <= idx; index++)
                    {
                        feat_config[bmi2_act_recg_sett.start_addr +
                                    index] = *((uint8_t *) data_p + bmi2_act_recg_sett.start_addr + index);
                    }

                    rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
                }
            }

            /* Enable Advance power save if disabled while
             * configuring and not when already disabled
             */
            if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
            {
                rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
            }
        }
        else
        {
            rslt = BMI2_E_INVALID_SENSOR;
        }
    }

    return rslt;
}

/*!
 * @brief This internal API is used to parse the activity output from the
 * FIFO in header mode.
 */
int8_t bmi270_hc_get_act_recog_output(struct bmi2_act_recog_output *act_recog,
                                      uint16_t *act_frm_len,
                                      struct bmi2_fifo_frame *fifo,
                                      const struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define header frame */
    uint8_t frame_header = 0;

    /* Variable to index the data bytes */
    uint16_t data_index;

    /* Variable to index activity frames */
    uint16_t act_idx = 0;

    /* Variable to indicate activity frames read */
    uint16_t frame_to_read = 0;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (act_recog != NULL) && (act_frm_len != NULL) && (fifo != NULL))
    {

        /* Store the number of frames to be read */
        frame_to_read = *act_frm_len;
        for (data_index = fifo->act_recog_byte_start_idx; data_index < fifo->length;)
        {
            /* Get frame header byte */
            frame_header = fifo->data[data_index] & BMI2_FIFO_TAG_INTR_MASK;

            /* Skip S4S frames if S4S is enabled */
            rslt = move_if_s4s_frame(&frame_header, &data_index, fifo);

            /* Break if FIFO is empty */
            if (rslt == BMI2_W_FIFO_EMPTY)
            {
                break;
            }

            /* Index shifted to next byte where data starts */
            data_index++;
            switch (frame_header)
            {
                /* If header defines accelerometer frame */
                case BMI2_FIFO_HEADER_ACC_FRM:
                    rslt = move_next_frame(&data_index, fifo->acc_frm_len, fifo);
                    break;

                /* If header defines accelerometer and auxiliary frames */
                case BMI2_FIFO_HEADER_AUX_ACC_FRM:
                    rslt = move_next_frame(&data_index, fifo->acc_aux_frm_len, fifo);
                    break;

                /* If header defines accelerometer and gyroscope frames */
                case BMI2_FIFO_HEADER_GYR_ACC_FRM:
                    rslt = move_next_frame(&data_index, fifo->acc_gyr_frm_len, fifo);
                    break;

                /* If header defines accelerometer, auxiliary and gyroscope frames */
                case BMI2_FIFO_HEADER_ALL_FRM:
                    rslt = move_next_frame(&data_index, fifo->all_frm_len, fifo);
                    break;

                /* If header defines only gyroscope frame */
                case BMI2_FIFO_HEADER_GYR_FRM:
                    rslt = move_next_frame(&data_index, fifo->gyr_frm_len, fifo);
                    break;

                /* If header defines only auxiliary frame */
                case BMI2_FIFO_HEADER_AUX_FRM:
                    rslt = move_next_frame(&data_index, fifo->aux_frm_len, fifo);
                    break;

                /* If header defines auxiliary and gyroscope frame */
                case BMI2_FIFO_HEADER_AUX_GYR_FRM:
                    rslt = move_next_frame(&data_index, fifo->aux_gyr_frm_len, fifo);
                    break;

                /* If header defines sensor time frame */
                case BMI2_FIFO_HEADER_SENS_TIME_FRM:
                    rslt = move_next_frame(&data_index, BMI2_SENSOR_TIME_LENGTH, fifo);
                    break;

                /* If header defines skip frame */
                case BMI2_FIFO_HEADER_SKIP_FRM:
                    rslt = move_next_frame(&data_index, BMI2_FIFO_SKIP_FRM_LENGTH, fifo);
                    break;

                /* If header defines Input configuration frame */
                case BMI2_FIFO_HEADER_INPUT_CFG_FRM:
                    rslt = move_next_frame(&data_index, BMI2_FIFO_INPUT_CFG_LENGTH, fifo);
                    break;

                /* If header defines invalid frame or end of valid data */
                case BMI2_FIFO_HEAD_OVER_READ_MSB:

                    /* Move the data index to the last byte to mark completion */
                    data_index = fifo->length;

                    /* FIFO is empty */
                    rslt = BMI2_W_FIFO_EMPTY;
                    break;

                /* If header defines activity recognition frame */
                case BMI2_FIFO_VIRT_ACT_RECOG_FRM:

                    /* Get the activity output */
                    rslt = unpack_act_recog_output(&act_recog[(act_idx)], &data_index, fifo);

                    /* Update activity frame index */
                    (act_idx)++;
                    break;
                default:

                    /* Move the data index to the last byte in case of invalid values */
                    data_index = fifo->length;

                    /* FIFO is empty */
                    rslt = BMI2_W_FIFO_EMPTY;
                    break;
            }

            /* Number of frames to be read is complete or FIFO is empty */
            if ((frame_to_read == act_idx) || (rslt == BMI2_W_FIFO_EMPTY))
            {
                break;
            }
        }

        /* Update the activity frame index */
        (*act_frm_len) = act_idx;

        /* Update the activity byte index */
        fifo->act_recog_byte_start_idx = data_index;
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API updates the gyroscope user-gain.
 */
int8_t bmi270_hc_update_gyro_user_gain(const struct bmi2_gyro_user_gain_config *user_gain, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to select sensor */
    uint8_t sens_sel[2] = { BMI2_GYRO, BMI2_GYRO_GAIN_UPDATE };

    /* Structure to define sensor configurations */
    struct bmi2_sens_config sens_cfg;

    /* Variable to store status of user-gain update module */
    uint8_t status = 0;

    /* Variable to define count */
    uint8_t count = 100;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (user_gain != NULL))
    {
        /* Select type of feature */
        sens_cfg.type = BMI2_GYRO_GAIN_UPDATE;

        /* Get the user gain configurations */
        rslt = bmi270_hc_get_sensor_config(&sens_cfg, 1, dev);
        if (rslt == BMI2_OK)
        {
            /* Get the user-defined ratio */
            sens_cfg.cfg.gyro_gain_update = *user_gain;

            /* Set rate ratio for all axes */
            rslt = bmi270_hc_set_sensor_config(&sens_cfg, 1, dev);
        }

        /* Disable gyroscope */
        if (rslt == BMI2_OK)
        {
            rslt = bmi270_hc_sensor_disable(&sens_sel[0], 1, dev);
        }

        /* Enable gyroscope user-gain update module */
        if (rslt == BMI2_OK)
        {
            rslt = bmi270_hc_sensor_enable(&sens_sel[1], 1, dev);
        }

        /* Set the command to trigger the computation */
        if (rslt == BMI2_OK)
        {
            rslt = bmi2_set_command_register(BMI2_USR_GAIN_CMD, dev);
        }

        if (rslt == BMI2_OK)
        {
            /* Poll until enable bit of user-gain update is 0 */
            while (count--)
            {
                rslt = get_user_gain_upd_status(&status, dev);
                if ((rslt == BMI2_OK) && (status == 0))
                {
                    /* Enable compensation of gain defined
                     * in the GAIN register
                     */
                    rslt = enable_gyro_gain(BMI2_ENABLE, dev);

                    /* Enable gyroscope */
                    if (rslt == BMI2_OK)
                    {
                        rslt = bmi270_hc_sensor_enable(&sens_sel[0], 1, dev);
                    }

                    break;
                }

                dev->delay_us(10000, dev->intf_ptr);
            }

            /* Return error if user-gain update is failed */
            if ((rslt == BMI2_OK) && (status != 0))
            {
                rslt = BMI2_E_GYR_USER_GAIN_UPD_FAIL;
            }
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API reads the compensated gyroscope user-gain values.
 */
int8_t bmi270_hc_read_gyro_user_gain(struct bmi2_gyro_user_gain_data *gyr_usr_gain, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define register data */
    uint8_t reg_data[3] = { 0 };

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (gyr_usr_gain != NULL))
    {
        /* Get the gyroscope compensated gain values */
        rslt = bmi2_get_regs(BMI2_GYR_USR_GAIN_0_ADDR, reg_data, 3, dev);
        if (rslt == BMI2_OK)
        {
            /* Gyroscope user gain correction X-axis */
            gyr_usr_gain->x = (int8_t)BMI2_GET_BIT_POS0(reg_data[0], BMI2_GYR_USR_GAIN_X);

            /* Gyroscope user gain correction Y-axis */
            gyr_usr_gain->y = (int8_t)BMI2_GET_BIT_POS0(reg_data[1], BMI2_GYR_USR_GAIN_Y);

            /* Gyroscope user gain correction z-axis */
            gyr_usr_gain->z = (int8_t)BMI2_GET_BIT_POS0(reg_data[2], BMI2_GYR_USR_GAIN_Z);
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This API maps/unmaps feature interrupts to that of interrupt pins.
 */
int8_t bmi270_hc_map_feat_int(const struct bmi2_sens_int_config *sens_int, uint8_t n_sens, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define loop */
    uint8_t loop;

    /* Null-pointer check */
    rslt = null_ptr_check(dev);
    if ((rslt == BMI2_OK) && (sens_int != NULL))
    {
        for (loop = 0; loop < n_sens; loop++)
        {
            switch (sens_int[loop].type)
            {
                case BMI2_STEP_COUNTER:
                case BMI2_STEP_DETECTOR:

                    rslt = bmi2_map_feat_int(sens_int[loop].type, sens_int[loop].hw_int_pin, dev);
                    break;
                default:
                    rslt = BMI2_E_INVALID_SENSOR;
                    break;
            }

            /* Return error if interrupt mapping fails */
            if (rslt != BMI2_OK)
            {
                break;
            }
        }
    }
    else
    {
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/***************************************************************************/

/*!         Local Function Definitions
 ****************************************************************************/

/*!
 * @brief This internal API is used to validate the device structure pointer for
 * null conditions.
 */
static int8_t null_ptr_check(const struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    if ((dev == NULL) || (dev->read == NULL) || (dev->write == NULL) || (dev->delay_us == NULL))
    {
        /* Device structure pointer is not valid */
        rslt = BMI2_E_NULL_PTR;
    }

    return rslt;
}

/*!
 * @brief This internal API selects the sensor/features to be enabled or
 * disabled.
 */
static int8_t select_sensor(const uint8_t *sens_list, uint8_t n_sens, uint64_t *sensor_sel)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Variable to define loop */
    uint8_t count;

    for (count = 0; count < n_sens; count++)
    {
        switch (sens_list[count])
        {
            case BMI2_ACCEL:
                *sensor_sel |= BMI2_ACCEL_SENS_SEL;
                break;
            case BMI2_GYRO:
                *sensor_sel |= BMI2_GYRO_SENS_SEL;
                break;
            case BMI2_AUX:
                *sensor_sel |= BMI2_AUX_SENS_SEL;
                break;
            case BMI2_TEMP:
                *sensor_sel |= BMI2_TEMP_SENS_SEL;
                break;
            case BMI2_STEP_DETECTOR:
                *sensor_sel |= BMI2_STEP_DETECT_SEL;
                break;
            case BMI2_STEP_COUNTER:
                *sensor_sel |= BMI2_STEP_COUNT_SEL;
                break;
            case BMI2_GYRO_GAIN_UPDATE:
                *sensor_sel |= BMI2_GYRO_GAIN_UPDATE_SEL;
                break;
            case BMI2_ACTIVITY_RECOGNITION:
                *sensor_sel |= BMI2_ACTIVITY_RECOGNITION_SEL;
                break;
            default:
                rslt = BMI2_E_INVALID_SENSOR;
                break;
        }
    }

    return rslt;
}

/*!
 * @brief This internal API enables the selected sensor/features.
 */
static int8_t sensor_enable(uint64_t sensor_sel, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to store register values */
    uint8_t reg_data = 0;

    /* Variable to define loop */
    uint8_t loop = 1;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat = 0;

    rslt = bmi2_get_regs(BMI2_PWR_CTRL_ADDR, &reg_data, 1, dev);
    if (rslt == BMI2_OK)
    {
        /* Enable accelerometer */
        if (sensor_sel & BMI2_ACCEL_SENS_SEL)
        {
            reg_data = BMI2_SET_BITS(reg_data, BMI2_ACC_EN, BMI2_ENABLE);
        }

        /* Enable gyroscope */
        if (sensor_sel & BMI2_GYRO_SENS_SEL)
        {
            reg_data = BMI2_SET_BITS(reg_data, BMI2_GYR_EN, BMI2_ENABLE);
        }

        /* Enable auxiliary sensor */
        if (sensor_sel & BMI2_AUX_SENS_SEL)
        {
            reg_data = BMI2_SET_BIT_POS0(reg_data, BMI2_AUX_EN, BMI2_ENABLE);
        }

        /* Enable temperature sensor */
        if (sensor_sel & BMI2_TEMP_SENS_SEL)
        {
            reg_data = BMI2_SET_BITS(reg_data, BMI2_TEMP_EN, BMI2_ENABLE);
        }

        /* Enable the sensors that are set in the power control register */
        if (sensor_sel & BMI2_MAIN_SENSORS)
        {
            rslt = bmi2_set_regs(BMI2_PWR_CTRL_ADDR, &reg_data, 1, dev);
        }
    }

    if ((rslt == BMI2_OK) && (sensor_sel & ~(BMI2_MAIN_SENSORS)))
    {
        /* Get status of advance power save mode */
        aps_stat = dev->aps_status;
        if (aps_stat == BMI2_ENABLE)
        {
            /* Disable advance power save if enabled */
            rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
        }

        if (rslt == BMI2_OK)
        {
            while (loop--)
            {
                /* Enable step detector feature */
                if (sensor_sel & BMI2_STEP_DETECT_SEL)
                {
                    rslt = set_step_detector(BMI2_ENABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat |= BMI2_STEP_DETECT_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Enable step counter feature */
                if (sensor_sel & BMI2_STEP_COUNT_SEL)
                {
                    rslt = set_step_counter(BMI2_ENABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat |= BMI2_STEP_COUNT_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Enable activity recognition feature */
                if (sensor_sel & BMI2_ACTIVITY_RECOGNITION_SEL)
                {
                    rslt = set_act_recog(BMI2_ENABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat |= BMI2_ACTIVITY_RECOGNITION_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Enable gyroscope user gain */
                if (sensor_sel & BMI2_GYRO_GAIN_UPDATE_SEL)
                {
                    rslt = set_gyro_user_gain(BMI2_ENABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat |= BMI2_GYRO_GAIN_UPDATE_SEL;
                    }
                    else
                    {
                        break;
                    }
                }
            }

            /* Enable Advance power save if disabled while
             * configuring and not when already disabled
             */
            if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
            {
                rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
            }
        }
    }

    return rslt;
}

/*!
 * @brief This internal API disables the selected sensors/features.
 */
static int8_t sensor_disable(uint64_t sensor_sel, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to store register values */
    uint8_t reg_data = 0;

    /* Variable to define loop */
    uint8_t loop = 1;

    /* Variable to get the status of advance power save */
    uint8_t aps_stat = 0;

    rslt = bmi2_get_regs(BMI2_PWR_CTRL_ADDR, &reg_data, 1, dev);
    if (rslt == BMI2_OK)
    {
        /* Disable accelerometer */
        if (sensor_sel & BMI2_ACCEL_SENS_SEL)
        {
            reg_data = BMI2_SET_BIT_VAL0(reg_data, BMI2_ACC_EN);
        }

        /* Disable gyroscope */
        if (sensor_sel & BMI2_GYRO_SENS_SEL)
        {
            reg_data = BMI2_SET_BIT_VAL0(reg_data, BMI2_GYR_EN);
        }

        /* Disable auxiliary sensor */
        if (sensor_sel & BMI2_AUX_SENS_SEL)
        {
            reg_data = BMI2_SET_BIT_VAL0(reg_data, BMI2_AUX_EN);
        }

        /* Disable temperature sensor */
        if (sensor_sel & BMI2_TEMP_SENS_SEL)
        {
            reg_data = BMI2_SET_BIT_VAL0(reg_data, BMI2_TEMP_EN);
        }

        /* Disable the sensors that are set in the power control register */
        if (sensor_sel & BMI2_MAIN_SENSORS)
        {
            rslt = bmi2_set_regs(BMI2_PWR_CTRL_ADDR, &reg_data, 1, dev);
        }
    }

    if ((rslt == BMI2_OK) && (sensor_sel & ~(BMI2_MAIN_SENSORS)))
    {
        /* Get status of advance power save mode */
        aps_stat = dev->aps_status;
        if (aps_stat == BMI2_ENABLE)
        {
            /* Disable advance power save if enabled */
            rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
        }

        if (rslt == BMI2_OK)
        {
            while (loop--)
            {
                /* Disable step detector feature */
                if (sensor_sel & BMI2_STEP_DETECT_SEL)
                {
                    rslt = set_step_detector(BMI2_DISABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat &= ~BMI2_STEP_DETECT_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Disable step counter feature */
                if (sensor_sel & BMI2_STEP_COUNT_SEL)
                {
                    rslt = set_step_counter(BMI2_DISABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat &= ~BMI2_STEP_COUNT_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Disable activity recognition feature */
                if (sensor_sel & BMI2_ACTIVITY_RECOGNITION_SEL)
                {
                    rslt = set_act_recog(BMI2_DISABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat |= BMI2_ACTIVITY_RECOGNITION_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Disable gyroscope user gain */
                if (sensor_sel & BMI2_GYRO_GAIN_UPDATE_SEL)
                {
                    rslt = set_gyro_user_gain(BMI2_DISABLE, dev);
                    if (rslt == BMI2_OK)
                    {
                        dev->sens_en_stat &= ~BMI2_GYRO_GAIN_UPDATE_SEL;
                    }
                    else
                    {
                        break;
                    }
                }

                /* Enable Advance power save if disabled while
                 * configuring and not when already disabled
                 */
                if ((aps_stat == BMI2_ENABLE) && (rslt == BMI2_OK))
                {
                    rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
                }
            }
        }
    }

    return rslt;
}

/*!
 * @brief This internal API is used to enable/disable step detector feature.
 */
static int8_t set_step_detector(uint8_t enable, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for step detector */
    struct bmi2_feature_config step_det_config = { 0, 0, 0 };

    /* Search for step detector feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_det_config, BMI2_STEP_DETECTOR, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where step detector feature resides */
        rslt = bmi2_get_feat_config(step_det_config.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset for enable/disable of step detector */
            idx = step_det_config.start_addr + BMI2_STEP_COUNT_FEAT_EN_OFFSET;

            /* Set the feature enable bit */
            feat_config[idx] = BMI2_SET_BITS(feat_config[idx], BMI2_STEP_DET_FEAT_EN, enable);

            /* Set the configuration back to the page */
            rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API is used to enable/disable step counter feature.
 */
static int8_t set_step_counter(uint8_t enable, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for step counter */
    struct bmi2_feature_config step_count_config = { 0, 0, 0 };

    /* Search for step counter feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_count_config, BMI2_STEP_COUNTER, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where step-counter feature resides */
        rslt = bmi2_get_feat_config(step_count_config.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset for enable/disable of step counter */
            idx = step_count_config.start_addr + BMI2_STEP_COUNT_FEAT_EN_OFFSET;

            /* Set the feature enable bit */
            feat_config[idx] = BMI2_SET_BITS(feat_config[idx], BMI2_STEP_COUNT_FEAT_EN, enable);

            /* Set the configuration back to the page */
            rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
* @brief This internal API enables/disables the activity recognition feature.
*/
static int8_t set_act_recog(uint8_t enable, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for activity recognition */
    struct bmi2_feature_config act_recog_cfg = { 0, 0, 0 };

    /* Search for activity recognition and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&act_recog_cfg, BMI2_ACTIVITY_RECOGNITION, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where activity
         * recognition feature resides
         */
        rslt = bmi2_get_feat_config(act_recog_cfg.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset for enable/disable of activity recognition */
            idx = act_recog_cfg.start_addr;

            /* Set the feature enable bit */
            feat_config[idx] = BMI2_SET_BIT_POS0(feat_config[idx], BMI2_ACTIVITY_RECOG_EN, enable);

            /* Set the configuration back to the page */
            rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API is used to enable/disable gyroscope user gain
 * feature.
 */
static int8_t set_gyro_user_gain(uint8_t enable, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for gyroscope user gain */
    struct bmi2_feature_config gyr_user_gain_cfg = { 0, 0, 0 };

    /* Search for user gain feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&gyr_user_gain_cfg, BMI2_GYRO_GAIN_UPDATE, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where user gain feature resides */
        rslt = bmi2_get_feat_config(gyr_user_gain_cfg.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset for enable/disable of user gain */
            idx = gyr_user_gain_cfg.start_addr + BMI2_GYR_USER_GAIN_FEAT_EN_OFFSET;

            /* Set the feature enable bit */
            feat_config[idx] = BMI2_SET_BITS(feat_config[idx], BMI2_GYR_USER_GAIN_FEAT_EN, enable);

            /* Set the configuration back to the page */
            rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API sets step counter parameter configurations.
 */
static int8_t set_step_count_params_config(const uint16_t *step_count_params, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define index */
    uint8_t index = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for step counter parameters */
    struct bmi2_feature_config step_params_config = { 0, 0, 0 };

    /* Variable to index the page number */
    uint8_t page_idx;

    /* Variable to define the start page */
    uint8_t start_page;

    /* Variable to define start address of the parameters */
    uint8_t start_addr;

    /* Variable to define number of bytes */
    uint8_t n_bytes = (BMI2_STEP_CNT_N_PARAMS * 2);

    /* Variable to store number of pages */
    uint8_t n_pages = (n_bytes / 16);

    /* Variable to define the end page */
    uint8_t end_page;

    /* Variable to define the remaining bytes to be read */
    uint8_t remain_len;

    /* Variable to define the maximum words(16 bytes or 8 words) to be read in a page */
    uint8_t max_len = 8;

    /* Variable index bytes in a page */
    uint8_t page_byte_idx;

    /* Variable to index the parameters */
    uint8_t param_idx = 0;

    /* Copy the feature configuration address to a local pointer */
    uint16_t *data_p = (uint16_t *) (void *)feat_config;

    /* Search for step counter parameter feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_params_config, BMI2_STEP_COUNTER_PARAMS, dev);
    if (feat_found)
    {
        /* Get the start page for the step counter parameters */
        start_page = step_params_config.page;

        /* Get the end page for the step counter parameters */
        end_page = start_page + n_pages;

        /* Get the start address for the step counter parameters */
        start_addr = step_params_config.start_addr;

        /* Get the remaining length of bytes to be read */
        remain_len = (uint8_t)((n_bytes - (n_pages * 16)) + start_addr);
        for (page_idx = start_page; page_idx <= end_page; page_idx++)
        {
            /* Get the configuration from the respective page */
            rslt = bmi2_get_feat_config(page_idx, feat_config, dev);
            if (rslt == BMI2_OK)
            {
                /* Start from address 0x00 when switched to next page */
                if (page_idx > start_page)
                {
                    start_addr = 0;
                }

                /* Remaining number of words to be read in the page  */
                if (page_idx == end_page)
                {
                    max_len = (remain_len / 2);
                }

                /* Get offset in words since all the features are set in words length */
                page_byte_idx = start_addr / 2;
                for (; page_byte_idx < max_len;)
                {
                    /* Set parameters 1 to 25 */
                    *(data_p + page_byte_idx) = BMI2_SET_BIT_POS0(*(data_p + page_byte_idx),
                                                                  BMI2_STEP_COUNT_PARAMS,
                                                                  step_count_params[param_idx]);

                    /* Increment offset by 1 word to set to the next parameter */
                    page_byte_idx++;

                    /* Increment to next parameter */
                    param_idx++;
                }

                /* Get total length in bytes to copy from local pointer to the array */
                page_byte_idx = (uint8_t)(page_byte_idx * 2) - step_params_config.start_addr;

                /* Copy the bytes to be set back to the array */
                for (index = 0; index < page_byte_idx; index++)
                {
                    feat_config[step_params_config.start_addr +
                                index] = *((uint8_t *) data_p + step_params_config.start_addr + index);
                }

                /* Set the configuration back to the page */
                rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
            }
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/* @brief This internal API sets step counter configurations like water-mark
 * level, reset-counter and output-configuration step detector and activity.
 */
static int8_t set_step_config(const struct bmi2_step_config *config, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to define index */
    uint8_t index = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for step counter 4 */
    struct bmi2_feature_config step_count_config = { 0, 0, 0 };

    /* Copy the feature configuration address to a local pointer */
    uint16_t *data_p = (uint16_t *) (void *)feat_config;

    /* Search for step counter feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_count_config, BMI2_STEP_COUNTER, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where step counter resides */
        rslt = bmi2_get_feat_config(step_count_config.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset in bytes */
            idx = step_count_config.start_addr;

            /* Get offset in words since all the features are set in words length */
            idx = idx / 2;

            /* Set water-mark level */
            *(data_p + idx) = BMI2_SET_BIT_POS0(*(data_p + idx), BMI2_STEP_COUNT_WM_LEVEL, config->watermark_level);

            /* Set reset-counter */
            *(data_p + idx) = BMI2_SET_BITS(*(data_p + idx), BMI2_STEP_COUNT_RST_CNT, config->reset_counter);

            /* Increment offset by 1 word  to set output
             * configuration of step detector and step activity
             */
            idx++;

            /* Set step buffer size */
            *(data_p + idx) = BMI2_SET_BITS(*(data_p + idx), BMI2_STEP_BUFFER_SIZE, config->step_buffer_size);

            /* Increment offset by 1 more word to get the total length in words */
            idx++;

            /* Get total length in bytes to copy from local pointer to the array */
            idx = (uint8_t)(idx * 2) - step_count_config.start_addr;

            /* Copy the bytes to be set back to the array */
            for (index = 0; index < idx; index++)
            {
                feat_config[step_count_config.start_addr +
                            index] = *((uint8_t *) data_p + step_count_config.start_addr + index);
            }

            /* Set the configuration back to the page */
            rslt = bmi2_set_regs(BMI2_FEATURES_REG_ADDR, feat_config, BMI2_FEAT_SIZE_IN_BYTES, dev);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API gets step counter parameter configurations.
 */
static int8_t get_step_count_params_config(uint16_t *step_count_params, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to set flag */
    uint8_t feat_found;

    /* Variable to define LSB */
    uint16_t lsb = 0;

    /* Variable to define MSB */
    uint16_t msb = 0;

    /* Variable to define a word */
    uint16_t lsb_msb = 0;

    /* Initialize feature configuration for step counter 1 */
    struct bmi2_feature_config step_params_config = { 0, 0, 0 };

    /* Variable to index the page number */
    uint8_t page_idx;

    /* Variable to define the start page */
    uint8_t start_page;

    /* Variable to define start address of the parameters */
    uint8_t start_addr;

    /* Variable to define number of bytes */
    uint8_t n_bytes = (BMI2_STEP_CNT_N_PARAMS * 2);

    /* Variable to store number of pages */
    uint8_t n_pages = (n_bytes / 16);

    /* Variable to define the end page */
    uint8_t end_page;

    /* Variable to define the remaining bytes to be read */
    uint8_t remain_len;

    /* Variable to define the maximum words to be read in a page */
    uint8_t max_len = BMI2_FEAT_SIZE_IN_BYTES;

    /* Variable index bytes in a page */
    uint8_t page_byte_idx;

    /* Variable to index the parameters */
    uint8_t param_idx = 0;

    /* Search for step counter parameter feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_params_config, BMI2_STEP_COUNTER_PARAMS, dev);
    if (feat_found)
    {
        /* Get the start page for the step counter parameters */
        start_page = step_params_config.page;

        /* Get the end page for the step counter parameters */
        end_page = start_page + n_pages;

        /* Get the start address for the step counter parameters */
        start_addr = step_params_config.start_addr;

        /* Get the remaining length of bytes to be read */
        remain_len = (uint8_t)((n_bytes - (n_pages * 16)) + start_addr);
        for (page_idx = start_page; page_idx <= end_page; page_idx++)
        {
            /* Get the configuration from the respective page */
            rslt = bmi2_get_feat_config(page_idx, feat_config, dev);
            if (rslt == BMI2_OK)
            {
                /* Start from address 0x00 when switched to next page */
                if (page_idx > start_page)
                {
                    start_addr = 0;
                }

                /* Remaining number of bytes to be read in the page  */
                if (page_idx == end_page)
                {
                    max_len = remain_len;
                }

                /* Get the offset */
                page_byte_idx = start_addr;
                while (page_byte_idx < max_len)
                {
                    /* Get word to calculate the parameter*/
                    lsb = (uint16_t) feat_config[page_byte_idx++];
                    if (page_byte_idx < max_len)
                    {
                        msb = ((uint16_t) feat_config[page_byte_idx++] << 8);
                    }

                    lsb_msb = lsb | msb;

                    /* Get parameters 1 to 25 */
                    step_count_params[param_idx] = lsb_msb & BMI2_STEP_COUNT_PARAMS_MASK;

                    /* Increment to next parameter */
                    param_idx++;
                }
            }
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API gets step counter/detector/activity configurations.
 */
static int8_t get_step_config(struct bmi2_step_config *config, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to define LSB */
    uint16_t lsb = 0;

    /* Variable to define MSB */
    uint16_t msb = 0;

    /* Variable to define a word */
    uint16_t lsb_msb = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature configuration for step counter */
    struct bmi2_feature_config step_count_config = { 0, 0, 0 };

    /* Search for step counter 4 feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&step_count_config, BMI2_STEP_COUNTER, dev);
    if (feat_found)
    {
        /* Get the configuration from the page where step counter 4 parameter resides */
        rslt = bmi2_get_feat_config(step_count_config.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset for feature enable for step counter/detector/activity */
            idx = step_count_config.start_addr;

            /* Get word to calculate water-mark level and reset counter */
            lsb = (uint16_t) feat_config[idx++];
            msb = ((uint16_t) feat_config[idx++] << 8);
            lsb_msb = lsb | msb;

            /* Get water-mark level */
            config->watermark_level = lsb_msb & BMI2_STEP_COUNT_WM_LEVEL_MASK;

            /* Get reset counter */
            config->reset_counter = (lsb_msb & BMI2_STEP_COUNT_RST_CNT_MASK) >> BMI2_STEP_COUNT_RST_CNT_POS;

            /* Get word to calculate output configuration of step detector and activity */
            lsb = (uint16_t) feat_config[idx++];
            msb = ((uint16_t) feat_config[idx++] << 8);
            lsb_msb = lsb | msb;

            config->step_buffer_size = (lsb_msb & BMI2_STEP_BUFFER_SIZE_MASK) >> BMI2_STEP_BUFFER_SIZE_POS;
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API gets the output values of step counter.
 */
static int8_t get_step_counter_output(uint32_t *step_count, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variables to define index */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature output for step counter */
    struct bmi2_feature_config step_cnt_out_config = { 0, 0, 0 };

    /* Search for step counter output feature and extract its configuration details */
    feat_found = extract_output_feat_config(&step_cnt_out_config, BMI2_STEP_COUNTER, dev);
    if (feat_found)
    {
        /* Get the feature output configuration for step-counter */
        rslt = bmi2_get_feat_config(step_cnt_out_config.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset in bytes for step counter output */
            idx = step_cnt_out_config.start_addr;

            /* Get the step counter output in 4 bytes */
            *step_count = (uint32_t) feat_config[idx++];
            *step_count |= ((uint32_t) feat_config[idx++] << 8);
            *step_count |= ((uint32_t) feat_config[idx++] << 16);
            *step_count |= ((uint32_t) feat_config[idx++] << 24);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API gets the error status related to NVM.
 */
static int8_t get_nvm_error_status(struct bmi2_nvm_err_status *nvm_err_stat, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variables to define index */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature output for NVM error status */
    struct bmi2_feature_config nvm_err_cfg = { 0, 0, 0 };

    /* Search for NVM error status feature and extract its configuration details */
    feat_found = extract_output_feat_config(&nvm_err_cfg, BMI2_NVM_STATUS, dev);
    if (feat_found)
    {
        /* Get the feature output configuration for NVM error status */
        rslt = bmi2_get_feat_config(nvm_err_cfg.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset in bytes for NVM error status */
            idx = nvm_err_cfg.start_addr;

            /* Increment index to get the error status */
            idx++;

            /* Error when NVM load action fails */
            nvm_err_stat->load_error = BMI2_GET_BIT_POS0(feat_config[idx], BMI2_NVM_LOAD_ERR_STATUS);

            /* Error when NVM program action fails */
            nvm_err_stat->prog_error = BMI2_GET_BITS(feat_config[idx], BMI2_NVM_PROG_ERR_STATUS);

            /* Error when NVM erase action fails */
            nvm_err_stat->erase_error = BMI2_GET_BITS(feat_config[idx], BMI2_NVM_ERASE_ERR_STATUS);

            /* Error when NVM program limit is exceeded */
            nvm_err_stat->exceed_error = BMI2_GET_BITS(feat_config[idx], BMI2_NVM_END_EXCEED_STATUS);

            /* Error when NVM privilege mode is not acquired */
            nvm_err_stat->privil_error = BMI2_GET_BITS(feat_config[idx], BMI2_NVM_PRIV_ERR_STATUS);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API is used to get enable status of gyroscope user gain
 * update.
 */
static int8_t get_user_gain_upd_status(uint8_t *status, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variable to define the array offset */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Variable to check APS status */
    uint8_t aps_stat = 0;

    /* Initialize feature configuration for gyroscope user gain */
    struct bmi2_feature_config gyr_user_gain_cfg = { 0, 0, 0 };

    /* Search for user gain feature and extract its configuration details */
    feat_found = bmi2_extract_input_feat_config(&gyr_user_gain_cfg, BMI2_GYRO_GAIN_UPDATE, dev);
    if (feat_found)
    {
        /* Disable advance power save */
        aps_stat = dev->aps_status;
        if (aps_stat == BMI2_ENABLE)
        {
            rslt = bmi2_set_adv_power_save(BMI2_DISABLE, dev);
        }

        if (rslt == BMI2_OK)
        {
            /* Get the configuration from the page where user gain feature resides */
            rslt = bmi2_get_feat_config(gyr_user_gain_cfg.page, feat_config, dev);
            if (rslt == BMI2_OK)
            {
                /* Define the offset for enable/disable of user gain */
                idx = gyr_user_gain_cfg.start_addr + BMI2_GYR_USER_GAIN_FEAT_EN_OFFSET;

                /* Set the feature enable status */
                *status = BMI2_GET_BITS(feat_config[idx], BMI2_GYR_USER_GAIN_FEAT_EN);
            }
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    /* Enable Advance power save if disabled while configuring and not when already disabled */
    if ((rslt == BMI2_OK) && (aps_stat == BMI2_ENABLE))
    {
        rslt = bmi2_set_adv_power_save(BMI2_ENABLE, dev);
    }

    return rslt;
}

/*!
 * @brief This internal API is used to parse and store the activity recognition
 * output from the FIFO data.
 */
static int8_t unpack_act_recog_output(struct bmi2_act_recog_output *act_recog,
                                      uint16_t *data_index,
                                      const struct bmi2_fifo_frame *fifo)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Variables to define 4 bytes of sensor time */
    uint32_t time_stamp_byte4 = 0;
    uint32_t time_stamp_byte3 = 0;
    uint32_t time_stamp_byte2 = 0;
    uint32_t time_stamp_byte1 = 0;

    /* Validate data index */
    if ((*data_index + BMI2_FIFO_VIRT_ACT_DATA_LENGTH) >= fifo->length)
    {
        /* Update the data index to the last byte */
        (*data_index) = fifo->length;

        /* FIFO is empty */
        rslt = BMI2_W_FIFO_EMPTY;
    }
    else
    {
        /* Get time-stamp from the activity recognition frame */
        time_stamp_byte4 = ((uint32_t)(fifo->data[(*data_index) + 3]) << 24);
        time_stamp_byte3 = ((uint32_t)(fifo->data[(*data_index) + 2]) << 16);
        time_stamp_byte2 = fifo->data[(*data_index) + 1] << 8;
        time_stamp_byte1 = fifo->data[(*data_index)];

        /* Update time-stamp from the virtual frame */
        act_recog->time_stamp = (time_stamp_byte4 | time_stamp_byte3 | time_stamp_byte2 | time_stamp_byte1);

        /* Move the data index by 4 bytes */
        (*data_index) = (*data_index) + BMI2_FIFO_VIRT_ACT_TIME_LENGTH;

        /* Update the previous activity from the virtual frame */
        act_recog->prev_act = fifo->data[(*data_index)];

        /* Move the data index by 1 byte */
        (*data_index) = (*data_index) + BMI2_FIFO_VIRT_ACT_TYPE_LENGTH;

        /* Update the current activity from the virtual frame */
        act_recog->curr_act = fifo->data[(*data_index)];

        /* Move the data index by 1 byte */
        (*data_index) = (*data_index) + BMI2_FIFO_VIRT_ACT_STAT_LENGTH;

        /* More frames could be read */
        rslt = BMI2_W_PARTIAL_READ;
    }

    return rslt;
}

/*!
 * @brief This internal API gets the error status related to virtual frames.
 */
static int8_t get_vfrm_error_status(struct bmi2_vfrm_err_status *vfrm_err_stat, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Array to define the feature configuration */
    uint8_t feat_config[BMI2_FEAT_SIZE_IN_BYTES] = { 0 };

    /* Variables to define index */
    uint8_t idx = 0;

    /* Variable to set flag */
    uint8_t feat_found;

    /* Initialize feature output for VFRM error status */
    struct bmi2_feature_config vfrm_err_cfg = { 0, 0, 0 };

    /* Search for VFRM error status feature and extract its configuration details */
    feat_found = extract_output_feat_config(&vfrm_err_cfg, BMI2_VFRM_STATUS, dev);
    if (feat_found)
    {
        /* Get the feature output configuration for VFRM error status */
        rslt = bmi2_get_feat_config(vfrm_err_cfg.page, feat_config, dev);
        if (rslt == BMI2_OK)
        {
            /* Define the offset in bytes for VFRM error status */
            idx = vfrm_err_cfg.start_addr;

            /* Increment index to get the error status */
            idx++;

            /* Internal error while acquiring lock for FIFO */
            vfrm_err_stat->lock_error = BMI2_GET_BITS(feat_config[idx], BMI2_VFRM_LOCK_ERR_STATUS);

            /* Internal error while writing byte into FIFO */
            vfrm_err_stat->write_error = BMI2_GET_BITS(feat_config[idx], BMI2_VFRM_WRITE_ERR_STATUS);

            /* Internal error while writing into FIFO */
            vfrm_err_stat->fatal_error = BMI2_GET_BITS(feat_config[idx], BMI2_VFRM_FATAL_ERR_STATUS);
        }
    }
    else
    {
        rslt = BMI2_E_INVALID_SENSOR;
    }

    return rslt;
}

/*!
 * @brief This internal API skips S4S frame in the FIFO data while getting
 * step activity output.
 */
static int8_t move_if_s4s_frame(const uint8_t *frame_header, uint16_t *data_index, const struct bmi2_fifo_frame *fifo)
{
    /* Variable to define error */
    int8_t rslt = BMI2_OK;

    /* Variable to extract virtual header byte */
    uint8_t virtual_header_mode;

    /* Variable to define pay-load in words */
    uint8_t payload_word = 0;

    /* Variable to define pay-load in bytes */
    uint8_t payload_bytes = 0;

    /* Extract virtual header mode from the frame header */
    virtual_header_mode = BMI2_GET_BITS(*frame_header, BMI2_FIFO_VIRT_FRM_MODE);

    /* If the extracted header byte is a virtual header */
    if (virtual_header_mode == BMI2_FIFO_VIRT_FRM_MODE)
    {
        /* If frame header is not activity recognition header */
        if (*frame_header != 0xC8)
        {
            /* Extract pay-load in words from the header byte */
            payload_word = BMI2_GET_BITS(*frame_header, BMI2_FIFO_VIRT_PAYLOAD) + 1;

            /* Convert to bytes */
            payload_bytes = (uint8_t)(payload_word * 2);

            /* Move the data index by those pay-load bytes */
            rslt = move_next_frame(data_index, payload_bytes, fifo);
        }
    }

    return rslt;
}

/*!
 * @brief This internal API enables/disables compensation of the gain defined
 * in the GAIN register.
 */
static int8_t enable_gyro_gain(uint8_t enable, struct bmi2_dev *dev)
{
    /* Variable to define error */
    int8_t rslt;

    /* Variable to define register data */
    uint8_t reg_data = 0;

    rslt = bmi2_get_regs(BMI2_GYR_OFF_COMP_6_ADDR, &reg_data, 1, dev);
    if (rslt == BMI2_OK)
    {
        reg_data = BMI2_SET_BITS(reg_data, BMI2_GYR_GAIN_EN, enable);
        rslt = bmi2_set_regs(BMI2_GYR_OFF_COMP_6_ADDR, &reg_data, 1, dev);
    }

    return rslt;
}

/*!
 * @brief This internal API is used to extract the output feature configuration
 * details from the look-up table.
 */
static uint8_t extract_output_feat_config(struct bmi2_feature_config *feat_output,
                                          uint8_t type,
                                          const struct bmi2_dev *dev)
{
    /* Variable to define loop */
    uint8_t loop = 0;

    /* Variable to set flag */
    uint8_t feat_found = BMI2_FALSE;

    /* Search for the output feature from the output configuration array */
    while (loop < dev->out_sens)
    {
        if (dev->feat_output[loop].type == type)
        {
            *feat_output = dev->feat_output[loop];
            feat_found = BMI2_TRUE;
            break;
        }

        loop++;
    }

    /* Return flag */
    return feat_found;
}

/*!
 * @brief This internal API is used to move the data index ahead of the
 * current_frame_length parameter when unnecessary FIFO data appears while
 * extracting the user specified data.
 */
static int8_t move_next_frame(uint16_t *data_index, uint8_t current_frame_length, const struct bmi2_fifo_frame *fifo)
{
    /* Variables to define error */
    int8_t rslt = BMI2_OK;

    /* Validate data index */
    if (((*data_index) + current_frame_length) > fifo->length)
    {
        /* Move the data index to the last byte */
        (*data_index) = fifo->length;

        /* FIFO is empty */
        rslt = BMI2_W_FIFO_EMPTY;
    }
    else
    {
        /* Move the data index to next frame */
        (*data_index) = (*data_index) + current_frame_length;

        /* More frames could be read */
        rslt = BMI2_W_PARTIAL_READ;
    }

    return rslt;
}
