# Contributing

Since the open source of PaddlePaddle, we have provided high-quality Chinese and English documents. There are also many developers who have made important contributions to the improvement of the quality of the documentation. Thanks very much for every developer's support for PaddlePaddle documentation.

## Introduction

We very much welcome you to participate in the construction of PaddlePaddle documentation and work with us to improve the quality of PaddlePaddle documentation. At present, PaddlePaddle document is divided into the following parts, you can choose any part of your interest to participate:

- Guides
- Practice
- API Documentation

### Guides

This part of the content is mainly a guide to the use of PaddlePaddle. You can correct or improve the existing content, or you can add documents that you think are important. We very much welcome your suggestions and modifications regarding the use of the guides document.

### Practice

The Practice is mainly to use PaddlePaddle for specific case implementation. At present, many developers have contributed very good cases, such as OCR recognition, face key-point detection, etc. We welcome you to submit your project to our repo, and finally show it on the official website of PaddlePaddle.

### API Documentation

PaddlePaddle's API documentation contains an introduction to the API. We welcome you to propose changes to API documentation, whether it is typo or modification instructions and examples, we are very grateful for any contributions you have made to the API documentation.

## Participation

### Guides

This part of the content is stored in the [docs/docs/guides](https://github.com/PaddlePaddle/docs/tree/develop/docs/guides) directory, you can make your changes by submitting a PR. For more information, please refer to: [Document Contribution Guide](https://github.com/PaddlePaddle/docs/wiki/%E6%96%87%E6%A1%A3%E8%B4%A1%E7%8C%AE%E6%8C%87%E5%8D%97).

### Practice

This part of the content is divided into two parts, the source code and the official website documentation. The source code is stored in the form of a notebook in [book/paddle2.0_docs](https://github.com/PaddlePaddle/book/tree/develop/paddle2.0_docs) directory; after your notebook file is merged, we will convert it into an md file and store it in [docs/docs/tutorial](https: //github.com/PaddlePaddle/docs/tree/develop/docs/tutorial), and then presented to the official website. For more information, please refer to: [[Call for Contribution] Tutorials for PaddlePaddle 2.0](https://github.com/PaddlePaddle/book/issues/905).

### API Documentation

PaddlePaddle provides API documentation in both Chinese and English. The English API documentation is stored in the [Paddle](https://github.com/PaddlePaddle/Paddle/tree/develop/python/paddle), you can modify English documents at this location; and Chinese API documents are stored in the [docs/docs/api](https://github.com/PaddlePaddle/docs/tree/develop/docs/api). You can fix and improve any errors and content in the document, or add content that you think is needed in the document. We are very grateful for all your contributions to the API document. For more information, please refer to: [English API Documentation Contribution Guide](https://github.com/PaddlePaddle/docs/wiki/%E8%8B%B1%E6%96%87API%E6%96%87%E6%A1%A3%E8%B4%A1%E7%8C%AE%E6%8C%87%E5%8D%97), [Chinese API Documentation Contribution Guide](https://github.com/PaddlePaddle/docs/wiki/%E4%B8%AD%E6%96%87API%E6%96%87%E6%A1%A3%E8%B4%A1%E7%8C%AE%E6%8C%87%E5%8D%97).

## Submit PR

Any modification of PaddlePaddle documentation should be completed by submitting a PR. For more information, please refer to [Submit PR](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/guides/08_contribution/local_dev_guide.html).
