# 《Paddle API 兼容性》 智能体规则体系

## 一、目录概述

本目录为《Paddle API 对齐 PyTorch 项目》的 AI 编程规则文件。这些规则文件定义了 AI 智能体在执行 API 对齐任务时的行为准则、工作流程和技术规范。

## 二、设计目标

本规则体系旨在实现以下目标：

1. **自动化 API 对齐**：通过 AI 智能体自动完成 PyTorch API 到 Paddle API 的对齐工作
2. **标准化工作流程**：建立统一、可复用的 API 对齐流程，确保每次对齐的质量一致性
3. **知识沉淀与复用**：将人工经验转化为可执行的规则，降低人工干预成本
4. **可追溯的决策过程**：每个 API 的改动方案都有明确的决策依据，便于审查和优化

## 三、规则文件说明

本目录包含以下规则文件：

| 文件名称 | 角色 | 职责 | 适用阶段 |
|---------|------|------|---------|
| `0-api-compatibility.mdr` | 主控智能体 | 统筹全流程，调度子智能体 | 全流程 |
| `1-scheme-decision.mdr` | 方案决策智能体 | 分析 API 差异，决策改动方案 | Step1 |
| `2-2-sink-to-cpp.mdr` | Cpp 下沉智能体 | 实施 C++下沉方案 | Step2 |
| `3-paconvert-test.mdr` | Pytorch 对齐验证智能体 | 验证 API 对齐一致性 | Step3 |
| `4-modify-docs.mdr` | API 文档修改智能体 | 同步更新 API 中文文档 | Step4 |

## 四、工作流程

规则体系遵循以下标准工作流程，采用**主控智能体调度 + 子智能体执行**的协作模式：

```
主控智能体：接收 PyTorch API 列表
    ↓
主控智能体 → 调用方案决策智能体 (1-scheme-decision.mdr)
    ↓
[决策结果分发，若需 C++下沉] 主控智能体 → 调用 Cpp 下沉智能体 (2-2-sink-to-cpp.mdr)
    ↓
主控智能体 → 调用 Pytorch 对齐验证智能体 (3-paconvert-test.mdr)
    ↓
[验证通过] 主控智能体 → 调用 API 文档修改智能体 (4-modify-docs.mdr)
    ↓
主控智能体：输出对齐结果统计
```

**协作说明**：
- **主控智能体**：负责任务分解、流程调度、结果汇总和异常处理，确保全流程有序推进
- **子智能体**：专注各自领域的专业工作（方案决策、代码修改、对齐验证、文档修改），执行具体任务后返回结果
- **交互方式**：主控智能体通过 subtask 工具调用子智能体，传递必要上下文，接收执行结果并做出下一步决策

## 五、设计原则

本规则体系采用**主控智能体 + 子智能体**的协作模式，主控智能体负责任务分解、流程控制和异常处理，子智能体专注具体领域的专业工作。通过决策驱动选择最优改动方案，强调对齐验证的金标准，并要求文档与代码同步更新，确保 API 对齐的高质量和高效率。

## 六、使用方式

本规则文件**不能单独使用**，需要搭配 AI 智能体使用，作为 Agent 的指令。AI 智能体读取规则文件中的角色定义、工作流程、技术规范，根据步骤执行具体任务，并按规则处理异常情况。

同时，规则文件也可作为**人工学习的参考资料**，帮助开发者了解 API 对齐的标准流程，包含技术背景知识、代码示例和最佳实践。

## 七、环境配置要求

使用本规则体系需配置好代码目录（Paddle、PaConvert、Docs）、知识语料（API 中文文档和差异文档）以及本地已编译好的 Paddle 环境。

## 八、扩展性设计

本规则体系支持扩展，可新增改动方案的规则文件（如 Python 装饰器、修改 API、新增 API 等）、新增其他专业领域的子智能体（如性能优化、兼容性测试、代码审查等）、以及新增其他验证方法（如静态代码分析、性能对比、边界条件验证等）。

## 九、维护规范

规则文件遵循命名规范（主控智能体：`0-{功能}.mdr`，子智能体：`{序号}-{功能}.mdr`），内容需包含角色定义、输入输出规范、技术背景知识、标准工作流程和异常处理等章节。发现规则不完善或有误时，需及时更新，保持一致性和兼容性，重大修改需经评审和测试。

---

> 本文档由 AI Agent 自动生成，日期：2025-12-31，提交：zhwesky2010
