## [ paddle 参数更多 ]torch.nn.functional.group_norm
### [torch.nn.functional.group\_norm](https://docs.pytorch.org/docs/stable/generated/torch.nn.functional.group_norm.html#torch.nn.functional.group_norm)
```python
torch.nn.functional.group_norm(input, num_groups, weight=None, bias=None, eps=1e-05)
```

### [paddle.nn.functional.group\_norm](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/nn/functional/group_norm_cn.html#id0)
```python
paddle.nn.functional.group_norm(x, num_groups, epsilon=1e-05, weight=None, bias=None, data_format='NCHW', name=None)
```

Paddle 相比 PyTorch 支持更多其他参数，具体如下：

### 参数映射

| PyTorch       | PaddlePaddle | 备注                                                   |
| ------------- | ------------ | ------------------------------------------------------ |
| input         | x            | 表示输入的 Tensor ，仅参数名不一致。                      |
| num_groups    | num_groups   | 输入的通道数。                                           |
| weight        | weight       | 权重的 Tensor。                                         |
| bias          | bias         | 偏置的 Tensor。                                         |
| eps           | epsilon      | 为防止方差除零增加的一个很小的值，仅参数名不一致。          |
| -             | data_format  | 输入的数据格式， PyTorch 无此参数， Paddle 保持默认即可。  |
