## [ torch 参数更多 ]torch.load
### [torch.load](https://docs.pytorch.org/docs/stable/generated/torch.load.html#torch.load)
```python
torch.load(f,
           map_location=None,
           pickle_module=pickle,
           *,
           weights_only=False,
           mmap,
           **pickle_load_args)
```

### [paddle.load](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/load_cn.html#paddle.load)
```python
paddle.load(path,
            **configs)
```

PyTorch 相比 Paddle 支持更多其他参数，具体如下：

### 参数映射

| PyTorch          | PaddlePaddle | 备注                                                         |
| ---------------- | ------------ | ------------------------------------------------------------ |
| f                | path         | 载入目标对象实例的路径/内存对象， 仅参数名不一致。           |
| map_location     | -            | 表示如何重新映射存储位置，Paddle 无此参数，暂无转写方式。    |
| pickle_module    | -            | 表示用于 unpickling 元数据和对象的模块，Paddle 无此参数，暂无转写方式。   |
| weights_only     | -            | 指示 unpickler 是否应限制为仅加载张量、原始类型和字典，Paddle 无此参数，暂无转写方式。 |
| **pickle_load_args | -            | 传递给 pickle_module.load（）和 pickle_module.Unpickler（）的可选关键字参数，Paddle 无此参数，暂无转写方式。 |
| mmap             | -            | 指示是否使用 mmap 文件，Paddle 无此参数，暂无转写方式。 |
| -                | **configs      | 表示其他用于兼容的载入配置选项。PyTorch 无此参数，Paddle 保持默认即可。 |
