## [ torch 参数更多 ]torch.meshgrid
### [torch.meshgrid](https://docs.pytorch.org/docs/stable/generated/torch.meshgrid.html#torch.meshgrid)
```python
torch.meshgrid(*tensors, indexing=None)
```

### [paddle.meshgrid](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/meshgrid_cn.html#paddle.meshgrid)
```python
paddle.meshgrid(*args, **kargs)
```

PyTorch 相比 Paddle 支持更多其他参数，具体如下：
### 参数映射

| PyTorch       | PaddlePaddle | 备注                                                   |
| ------------- | ------------ | ------------------------------------------------------ |
| *tensors       | *args         | 输入的 Tensor 列表，仅参数名不一致。                                      |
| indexing      | -            | tensor 的组合模式。Paddle 无此参数，需要转写。                                        |

### 转写示例
#### indexing：tensor 的组合模式
```python
# PyTorch 写法 (indexing 为‘ij’时)
torch.meshgrid(x, y, indexing='ij')

# Paddle 写法
paddle.meshgrid(x, y)

# PyTorch 写法 (indexing 为‘xy’时)
torch.meshgrid(x, y, indexing='xy')

# Paddle 写法
list([i.T for i in paddle.meshgrid(x, y)])
```
