## [ torch 参数更多 ]torch.nn.functional.cosine_embedding_loss
### [torch.nn.functional.cosine\_embedding\_loss](https://docs.pytorch.org/docs/stable/generated/torch.nn.functional.cosine_embedding_loss.html#torch.nn.functional.cosine_embedding_loss)
```python
torch.nn.functional.cosine_embedding_loss(input1, input2, target, margin=0, size_average=None, reduce=None, reduction='mean')
```

### [paddle.nn.functional.cosine\_embedding\_loss](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/nn/functional/cosine_embedding_loss_cn.html#paddle.nn.functional.cosine_embedding_loss)
```python
paddle.nn.functional.cosine_embedding_loss(input1, input2, label, margin=0, reduction='mean', name=None)
```

PyTorch 相比 Paddle 支持更多其他参数，具体如下：

### 参数映射

| PyTorch      | PaddlePaddle | 备注                                           |
| ------------ | ------------ | ---------------------------------------------- |
| input1       | input1       | 输入的 Tensor。                                |
| input2       | input2       | 输入的 Tensor。                                |
| target       | label        | 标签，仅参数名不一致。                                         |
| margin       | margin       | 可以设置的范围为[-1, 1]。                      |
| size_average | -            | 已废弃，和 reduce 组合决定损失计算方式。 需要转写。      |
| reduce       | -            | 已废弃，和 size_average 组合决定损失计算方式。需要转写。 |
| reduction    | reduction    | 指定应用于输出结果的计算方式。                 |

### 转写示例


#### size_average
size_average 为 True
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(size_average=True)

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='mean')
```

size_average 为 False
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(size_average=False)

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='sum')
```
#### reduce
reduce 为 True
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(reduce=True)

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='sum')
```
reduce 为 False
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(reduce=False)

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='none')
```
#### reduction
reduction 为'none'
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(reduction='none')

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='none')
```
reduction 为'mean'
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(reduction='mean')

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='mean')
```
reduction 为'sum'
```python
# PyTorch 写法
torch.nn.functional.cosine_embedding_loss(reduction='sum')

# Paddle 写法
paddle.nn.functional.cosine_embedding_loss(reduction='sum')
```
