## [ torch 参数更多 ]torch.nn.functional.mse_loss
### [torch.nn.functional.mse\_loss](https://docs.pytorch.org/docs/stable/generated/torch.nn.functional.mse_loss.html#torch.nn.functional.mse_loss)
```python
torch.nn.functional.mse_loss(input,
                             target,
                             size_average=None,
                             reduce=None,
                             reduction='mean')
```

### [paddle.nn.functional.mse\_loss](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/nn/functional/mse_loss_cn.html#paddle.nn.functional.mse_loss)
```python
paddle.nn.functional.mse_loss(input,
                              label,
                              reduction='mean',
                              name=None)
```

其中 PyTorch 相⽐ Paddle ⽀持更多其他参数，具体如下：
### 参数映射

| PyTorch       | PaddlePaddle | 备注                                                   |
| ------------- | ------------ | ------------------------------------------------------ |
| input          | input         | 表示预测的 Tensor 。                                     |
| target          | label         | 表示真实的 Tensor 。                                     |
| size_average          | -         | 已弃用 。 需要转写。                                    |
| reduce          | -         | 已弃用 。需要转写。                                     |
| reduction          | reduction         | 表示应用于输出结果的计算方式 。                                     |

### 转写示例


#### size_average
size_average 为 True
```python
# PyTorch 写法
torch.nn.functional.mse_loss(size_average=True)

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='mean')
```

size_average 为 False
```python
# PyTorch 写法
torch.nn.functional.mse_loss(size_average=False)

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='sum')
```
#### reduce
reduce 为 True
```python
# PyTorch 写法
torch.nn.functional.mse_loss(reduce=True)

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='sum')
```
reduce 为 False
```python
# PyTorch 写法
torch.nn.functional.mse_loss(reduce=False)

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='none')
```
#### reduction
reduction 为'none'
```python
# PyTorch 写法
torch.nn.functional.mse_loss(reduction='none')

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='none')
```
reduction 为'mean'
```python
# PyTorch 写法
torch.nn.functional.mse_loss(reduction='mean')

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='mean')
```
reduction 为'sum'
```python
# PyTorch 写法
torch.nn.functional.mse_loss(reduction='sum')

# Paddle 写法
paddle.nn.functional.mse_loss(reduction='sum')
```
