# Generated by Django 2.0.10 on 2019-04-26 18:57

from django.db import migrations
from django.db import models


def set_filename(apps, schema_editor):
    Document = apps.get_model("documents", "Document")
    for doc in Document.objects.all():
        file_name = f"{doc.pk:07}.{doc.file_type}"
        if doc.storage_type == "gpg":
            file_name += ".gpg"

        # Set filename
        doc.filename = file_name

        # Save document
        doc.save()


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "0022_auto_20181007_1420"),
    ]

    operations = [
        migrations.AddField(
            model_name="document",
            name="filename",
            field=models.FilePathField(
                default=None,
                null=True,
                editable=False,
                help_text="Current filename in storage",
                max_length=256,
            ),
        ),
        migrations.RunPython(set_filename),
    ]
