# Generated by Django 3.1.4 on 2020-12-12 14:41

import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("documents", "1006_auto_20201208_2209"),
    ]

    operations = [
        migrations.CreateModel(
            name="SavedView",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("show_on_dashboard", models.BooleanField()),
                ("show_in_sidebar", models.BooleanField()),
                ("sort_field", models.CharField(max_length=128)),
                ("sort_reverse", models.BooleanField(default=False)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SavedViewFilterRule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "rule_type",
                    models.PositiveIntegerField(
                        choices=[
                            (0, "Title contains"),
                            (1, "Content contains"),
                            (2, "ASN is"),
                            (3, "Correspondent is"),
                            (4, "Document type is"),
                            (5, "Is in inbox"),
                            (6, "Has tag"),
                            (7, "Has any tag"),
                            (8, "Created before"),
                            (9, "Created after"),
                            (10, "Created year is"),
                            (11, "Created month is"),
                            (12, "Created day is"),
                            (13, "Added before"),
                            (14, "Added after"),
                            (15, "Modified before"),
                            (16, "Modified after"),
                            (17, "Does not have tag"),
                        ],
                    ),
                ),
                ("value", models.CharField(max_length=128)),
                (
                    "saved_view",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="filter_rules",
                        to="documents.savedview",
                    ),
                ),
            ],
        ),
    ]
