# Generated by Django 3.1.4 on 2021-01-01 23:40

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("documents", "1010_auto_20210101_2159"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="correspondent",
            options={
                "ordering": ("name",),
                "verbose_name": "correspondent",
                "verbose_name_plural": "correspondents",
            },
        ),
        migrations.AlterModelOptions(
            name="document",
            options={
                "ordering": ("-created",),
                "verbose_name": "document",
                "verbose_name_plural": "documents",
            },
        ),
        migrations.AlterModelOptions(
            name="documenttype",
            options={
                "verbose_name": "document type",
                "verbose_name_plural": "document types",
            },
        ),
        migrations.AlterModelOptions(
            name="log",
            options={
                "ordering": ("-created",),
                "verbose_name": "log",
                "verbose_name_plural": "logs",
            },
        ),
        migrations.AlterModelOptions(
            name="savedview",
            options={
                "ordering": ("name",),
                "verbose_name": "saved view",
                "verbose_name_plural": "saved views",
            },
        ),
        migrations.AlterModelOptions(
            name="savedviewfilterrule",
            options={
                "verbose_name": "filter rule",
                "verbose_name_plural": "filter rules",
            },
        ),
        migrations.AlterModelOptions(
            name="tag",
            options={"verbose_name": "tag", "verbose_name_plural": "tags"},
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="is_insensitive",
            field=models.BooleanField(default=True, verbose_name="is insensitive"),
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="match",
            field=models.CharField(blank=True, max_length=256, verbose_name="match"),
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="name",
            field=models.CharField(max_length=128, unique=True, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="document",
            name="added",
            field=models.DateTimeField(
                db_index=True,
                default=django.utils.timezone.now,
                editable=False,
                verbose_name="added",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="archive_checksum",
            field=models.CharField(
                blank=True,
                editable=False,
                help_text="The checksum of the archived document.",
                max_length=32,
                null=True,
                verbose_name="archive checksum",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="archive_serial_number",
            field=models.IntegerField(
                blank=True,
                db_index=True,
                help_text="The position of this document in your physical document archive.",
                null=True,
                unique=True,
                verbose_name="archive serial number",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="checksum",
            field=models.CharField(
                editable=False,
                help_text="The checksum of the original document.",
                max_length=32,
                unique=True,
                verbose_name="checksum",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="content",
            field=models.TextField(
                blank=True,
                help_text="The raw, text-only data of the document. This field is primarily used for searching.",
                verbose_name="content",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="correspondent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="documents",
                to="documents.correspondent",
                verbose_name="correspondent",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="created",
            field=models.DateTimeField(
                db_index=True,
                default=django.utils.timezone.now,
                verbose_name="created",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="document_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="documents",
                to="documents.documenttype",
                verbose_name="document type",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="filename",
            field=models.FilePathField(
                default=None,
                editable=False,
                help_text="Current filename in storage",
                max_length=1024,
                null=True,
                verbose_name="filename",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="mime_type",
            field=models.CharField(
                editable=False,
                max_length=256,
                verbose_name="mime type",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="modified",
            field=models.DateTimeField(
                auto_now=True,
                db_index=True,
                verbose_name="modified",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="storage_type",
            field=models.CharField(
                choices=[
                    ("unencrypted", "Unencrypted"),
                    ("gpg", "Encrypted with GNU Privacy Guard"),
                ],
                default="unencrypted",
                editable=False,
                max_length=11,
                verbose_name="storage type",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="documents",
                to="documents.Tag",
                verbose_name="tags",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="title",
            field=models.CharField(
                blank=True,
                db_index=True,
                max_length=128,
                verbose_name="title",
            ),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="is_insensitive",
            field=models.BooleanField(default=True, verbose_name="is insensitive"),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="match",
            field=models.CharField(blank=True, max_length=256, verbose_name="match"),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="name",
            field=models.CharField(max_length=128, unique=True, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="log",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="created"),
        ),
        migrations.AlterField(
            model_name="log",
            name="group",
            field=models.UUIDField(blank=True, null=True, verbose_name="group"),
        ),
        migrations.AlterField(
            model_name="log",
            name="level",
            field=models.PositiveIntegerField(
                choices=[
                    (10, "debug"),
                    (20, "information"),
                    (30, "warning"),
                    (40, "error"),
                    (50, "critical"),
                ],
                default=20,
                verbose_name="level",
            ),
        ),
        migrations.AlterField(
            model_name="log",
            name="message",
            field=models.TextField(verbose_name="message"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="name",
            field=models.CharField(max_length=128, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="show_in_sidebar",
            field=models.BooleanField(verbose_name="show in sidebar"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="show_on_dashboard",
            field=models.BooleanField(verbose_name="show on dashboard"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="sort_field",
            field=models.CharField(max_length=128, verbose_name="sort field"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="sort_reverse",
            field=models.BooleanField(default=False, verbose_name="sort reverse"),
        ),
        migrations.AlterField(
            model_name="savedview",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
                verbose_name="user",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="saved_view",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="filter_rules",
                to="documents.savedview",
                verbose_name="saved view",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="value",
            field=models.CharField(
                blank=True,
                max_length=128,
                null=True,
                verbose_name="value",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="colour",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "#a6cee3"),
                    (2, "#1f78b4"),
                    (3, "#b2df8a"),
                    (4, "#33a02c"),
                    (5, "#fb9a99"),
                    (6, "#e31a1c"),
                    (7, "#fdbf6f"),
                    (8, "#ff7f00"),
                    (9, "#cab2d6"),
                    (10, "#6a3d9a"),
                    (11, "#b15928"),
                    (12, "#000000"),
                    (13, "#cccccc"),
                ],
                default=1,
                verbose_name="color",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="is_inbox_tag",
            field=models.BooleanField(
                default=False,
                help_text="Marks this tag as an inbox tag: All newly consumed documents will be tagged with inbox tags.",
                verbose_name="is inbox tag",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="is_insensitive",
            field=models.BooleanField(default=True, verbose_name="is insensitive"),
        ),
        migrations.AlterField(
            model_name="tag",
            name="match",
            field=models.CharField(blank=True, max_length=256, verbose_name="match"),
        ),
        migrations.AlterField(
            model_name="tag",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="name",
            field=models.CharField(max_length=128, unique=True, verbose_name="name"),
        ),
    ]
