# Generated by Django 5.1.1 on 2024-09-28 04:42

from pathlib import Path

import pikepdf
from django.conf import settings
from django.core.validators import MinValueValidator
from django.db import migrations
from django.db import models
from django.utils.termcolors import colorize as colourise


def source_path(self):
    if self.filename:
        fname = str(self.filename)

    return Path(settings.ORIGINALS_DIR / fname).resolve()


def add_number_of_pages_to_page_count(apps, schema_editor):
    Document = apps.get_model("documents", "Document")

    if not Document.objects.all().exists():
        return

    for doc in Document.objects.filter(mime_type="application/pdf"):
        print(
            "    {} {} {}".format(
                colourise("*", fg="green"),
                colourise("Calculating number of pages for", fg="white"),
                colourise(doc.filename, fg="cyan"),
            ),
        )

        try:
            with pikepdf.Pdf.open(source_path(doc)) as pdf:
                if pdf.pages is not None:
                    doc.page_count = len(pdf.pages)
                    doc.save()
        except Exception as e:  # pragma: no cover
            print(f"Error retrieving number of pages for {doc.filename}: {e}")


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "1052_document_transaction_id"),
    ]

    operations = [
        migrations.AddField(
            model_name="document",
            name="page_count",
            field=models.PositiveIntegerField(
                blank=False,
                help_text="The number of pages of the document.",
                null=True,
                unique=False,
                validators=[MinValueValidator(1)],
                verbose_name="page count",
                db_index=False,
            ),
        ),
        migrations.RunPython(
            add_number_of_pages_to_page_count,
            migrations.RunPython.noop,
        ),
    ]
