/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.client;

import com.provectus.kafka.ui.client.RetryingKafkaConnectClient;
import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.connect.ApiClient;
import com.provectus.kafka.ui.connect.api.KafkaConnectClientApi;
import com.provectus.kafka.ui.connect.model.Connector;
import com.provectus.kafka.ui.connect.model.ConnectorPlugin;
import com.provectus.kafka.ui.connect.model.ConnectorPluginConfigValidationResponse;
import com.provectus.kafka.ui.connect.model.ConnectorStatus;
import com.provectus.kafka.ui.connect.model.ConnectorTask;
import com.provectus.kafka.ui.connect.model.ConnectorTopics;
import com.provectus.kafka.ui.connect.model.NewConnector;
import com.provectus.kafka.ui.connect.model.TaskStatus;
import com.provectus.kafka.ui.exception.KafkaConnectConflictReponseException;
import com.provectus.kafka.ui.exception.ValidationException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.unit.DataSize;
import org.springframework.web.client.RestClientException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

/*
 * Exception performing whole class analysis ignored.
 */
public class RetryingKafkaConnectClient
extends KafkaConnectClientApi {
    private static final Logger log = LoggerFactory.getLogger(RetryingKafkaConnectClient.class);
    private static final int MAX_RETRIES = 5;
    private static final Duration RETRIES_DELAY = Duration.ofMillis(200L);

    public RetryingKafkaConnectClient(ClustersProperties.ConnectCluster config, @Nullable ClustersProperties.TruststoreConfig truststoreConfig, DataSize maxBuffSize) {
        super((ApiClient)new RetryingApiClient(config, truststoreConfig, maxBuffSize));
    }

    private static Retry conflictCodeRetry() {
        return Retry.fixedDelay((long)5L, (Duration)RETRIES_DELAY).filter(e -> e instanceof WebClientResponseException.Conflict).onRetryExhaustedThrow((spec, signal) -> new KafkaConnectConflictReponseException((WebClientResponseException.Conflict)signal.failure()));
    }

    private static <T> Mono<T> withRetryOnConflict(Mono<T> publisher) {
        return publisher.retryWhen(RetryingKafkaConnectClient.conflictCodeRetry());
    }

    private static <T> Flux<T> withRetryOnConflict(Flux<T> publisher) {
        return publisher.retryWhen(RetryingKafkaConnectClient.conflictCodeRetry());
    }

    private static <T> Mono<T> withBadRequestErrorHandling(Mono<T> publisher) {
        return publisher.onErrorResume(WebClientResponseException.BadRequest.class, e -> Mono.error((Throwable)new ValidationException("Invalid configuration"))).onErrorResume(WebClientResponseException.InternalServerError.class, e -> Mono.error((Throwable)new ValidationException("Invalid configuration")));
    }

    public Mono<Connector> createConnector(NewConnector newConnector) throws RestClientException {
        return RetryingKafkaConnectClient.withBadRequestErrorHandling((Mono)super.createConnector(newConnector));
    }

    public Mono<Connector> setConnectorConfig(String connectorName, Map<String, Object> requestBody) throws RestClientException {
        return RetryingKafkaConnectClient.withBadRequestErrorHandling((Mono)super.setConnectorConfig(connectorName, requestBody));
    }

    public Mono<ResponseEntity<Connector>> createConnectorWithHttpInfo(NewConnector newConnector) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.createConnectorWithHttpInfo(newConnector));
    }

    public Mono<Void> deleteConnector(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.deleteConnector(connectorName));
    }

    public Mono<ResponseEntity<Void>> deleteConnectorWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.deleteConnectorWithHttpInfo(connectorName));
    }

    public Mono<Connector> getConnector(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnector(connectorName));
    }

    public Mono<ResponseEntity<Connector>> getConnectorWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorWithHttpInfo(connectorName));
    }

    public Mono<Map<String, Object>> getConnectorConfig(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorConfig(connectorName));
    }

    public Mono<ResponseEntity<Map<String, Object>>> getConnectorConfigWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorConfigWithHttpInfo(connectorName));
    }

    public Flux<ConnectorPlugin> getConnectorPlugins() throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Flux)super.getConnectorPlugins());
    }

    public Mono<ResponseEntity<List<ConnectorPlugin>>> getConnectorPluginsWithHttpInfo() throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorPluginsWithHttpInfo());
    }

    public Mono<ConnectorStatus> getConnectorStatus(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorStatus(connectorName));
    }

    public Mono<ResponseEntity<ConnectorStatus>> getConnectorStatusWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorStatusWithHttpInfo(connectorName));
    }

    public Mono<TaskStatus> getConnectorTaskStatus(String connectorName, Integer taskId) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorTaskStatus(connectorName, taskId));
    }

    public Mono<ResponseEntity<TaskStatus>> getConnectorTaskStatusWithHttpInfo(String connectorName, Integer taskId) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorTaskStatusWithHttpInfo(connectorName, taskId));
    }

    public Flux<ConnectorTask> getConnectorTasks(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Flux)super.getConnectorTasks(connectorName));
    }

    public Mono<ResponseEntity<List<ConnectorTask>>> getConnectorTasksWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorTasksWithHttpInfo(connectorName));
    }

    public Mono<Map<String, ConnectorTopics>> getConnectorTopics(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorTopics(connectorName));
    }

    public Mono<ResponseEntity<Map<String, ConnectorTopics>>> getConnectorTopicsWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorTopicsWithHttpInfo(connectorName));
    }

    public Flux<String> getConnectors(String search) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Flux)super.getConnectors(search));
    }

    public Mono<ResponseEntity<List<String>>> getConnectorsWithHttpInfo(String search) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.getConnectorsWithHttpInfo(search));
    }

    public Mono<Void> pauseConnector(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.pauseConnector(connectorName));
    }

    public Mono<ResponseEntity<Void>> pauseConnectorWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.pauseConnectorWithHttpInfo(connectorName));
    }

    public Mono<Void> restartConnector(String connectorName, Boolean includeTasks, Boolean onlyFailed) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.restartConnector(connectorName, includeTasks, onlyFailed));
    }

    public Mono<ResponseEntity<Void>> restartConnectorWithHttpInfo(String connectorName, Boolean includeTasks, Boolean onlyFailed) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.restartConnectorWithHttpInfo(connectorName, includeTasks, onlyFailed));
    }

    public Mono<Void> restartConnectorTask(String connectorName, Integer taskId) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.restartConnectorTask(connectorName, taskId));
    }

    public Mono<ResponseEntity<Void>> restartConnectorTaskWithHttpInfo(String connectorName, Integer taskId) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.restartConnectorTaskWithHttpInfo(connectorName, taskId));
    }

    public Mono<Void> resumeConnector(String connectorName) throws WebClientResponseException {
        return super.resumeConnector(connectorName);
    }

    public Mono<ResponseEntity<Void>> resumeConnectorWithHttpInfo(String connectorName) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.resumeConnectorWithHttpInfo(connectorName));
    }

    public Mono<ResponseEntity<Connector>> setConnectorConfigWithHttpInfo(String connectorName, Map<String, Object> requestBody) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.setConnectorConfigWithHttpInfo(connectorName, requestBody));
    }

    public Mono<ConnectorPluginConfigValidationResponse> validateConnectorPluginConfig(String pluginName, Map<String, Object> requestBody) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.validateConnectorPluginConfig(pluginName, requestBody));
    }

    public Mono<ResponseEntity<ConnectorPluginConfigValidationResponse>> validateConnectorPluginConfigWithHttpInfo(String pluginName, Map<String, Object> requestBody) throws WebClientResponseException {
        return RetryingKafkaConnectClient.withRetryOnConflict((Mono)super.validateConnectorPluginConfigWithHttpInfo(pluginName, requestBody));
    }
}

