/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config;

import com.provectus.kafka.ui.config.ClustersProperties;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(value="kafka")
public class ClustersProperties {
    List<Cluster> clusters = new ArrayList();
    String internalTopicPrefix;
    Integer adminClientTimeout;
    PollingProperties polling = new PollingProperties();

    @PostConstruct
    public void validateAndSetDefaults() {
        if (this.clusters != null) {
            this.validateClusterNames();
            this.flattenClusterProperties();
            this.setMetricsDefaults();
        }
    }

    private void setMetricsDefaults() {
        for (Cluster cluster : this.clusters) {
            if (cluster.getMetrics() == null || StringUtils.hasText((String)cluster.getMetrics().getType())) continue;
            cluster.getMetrics().setType("JMX");
        }
    }

    private void flattenClusterProperties() {
        for (Cluster cluster : this.clusters) {
            cluster.setProperties(this.flattenClusterProperties(null, cluster.getProperties()));
        }
    }

    private Map<String, Object> flattenClusterProperties(@Nullable String prefix, @Nullable Map<String, Object> propertiesMap) {
        HashMap<String, Object> flattened = new HashMap<String, Object>();
        if (propertiesMap != null) {
            propertiesMap.forEach((k, v) -> {
                String key;
                String string = key = prefix == null ? k : prefix + "." + k;
                if (v instanceof Map) {
                    flattened.putAll(this.flattenClusterProperties(key, (Map)v));
                } else {
                    flattened.put(key, v);
                }
            });
        }
        return flattened;
    }

    private void validateClusterNames() {
        if (this.clusters.size() == 1 && !StringUtils.hasText((String)((Cluster)this.clusters.get(0)).getName())) {
            ((Cluster)this.clusters.get(0)).setName("Default");
            return;
        }
        HashSet<String> clusterNames = new HashSet<String>();
        for (Cluster clusterProperties : this.clusters) {
            if (!StringUtils.hasText((String)clusterProperties.getName())) {
                throw new IllegalStateException("Application config isn't valid. Cluster names should be provided in case of multiple clusters present");
            }
            if (clusterNames.add(clusterProperties.getName())) continue;
            throw new IllegalStateException("Application config isn't valid. Two clusters can't have the same name");
        }
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public String getInternalTopicPrefix() {
        return this.internalTopicPrefix;
    }

    public Integer getAdminClientTimeout() {
        return this.adminClientTimeout;
    }

    public PollingProperties getPolling() {
        return this.polling;
    }

    public void setClusters(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    public void setInternalTopicPrefix(String internalTopicPrefix) {
        this.internalTopicPrefix = internalTopicPrefix;
    }

    public void setAdminClientTimeout(Integer adminClientTimeout) {
        this.adminClientTimeout = adminClientTimeout;
    }

    public void setPolling(PollingProperties polling) {
        this.polling = polling;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClustersProperties)) {
            return false;
        }
        ClustersProperties other = (ClustersProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$adminClientTimeout = this.getAdminClientTimeout();
        Integer other$adminClientTimeout = other.getAdminClientTimeout();
        if (this$adminClientTimeout == null ? other$adminClientTimeout != null : !((Object)this$adminClientTimeout).equals(other$adminClientTimeout)) {
            return false;
        }
        List this$clusters = this.getClusters();
        List other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        String this$internalTopicPrefix = this.getInternalTopicPrefix();
        String other$internalTopicPrefix = other.getInternalTopicPrefix();
        if (this$internalTopicPrefix == null ? other$internalTopicPrefix != null : !this$internalTopicPrefix.equals(other$internalTopicPrefix)) {
            return false;
        }
        PollingProperties this$polling = this.getPolling();
        PollingProperties other$polling = other.getPolling();
        return !(this$polling == null ? other$polling != null : !this$polling.equals(other$polling));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClustersProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $adminClientTimeout = this.getAdminClientTimeout();
        result = result * 59 + ($adminClientTimeout == null ? 43 : ((Object)$adminClientTimeout).hashCode());
        List $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        String $internalTopicPrefix = this.getInternalTopicPrefix();
        result = result * 59 + ($internalTopicPrefix == null ? 43 : $internalTopicPrefix.hashCode());
        PollingProperties $polling = this.getPolling();
        result = result * 59 + ($polling == null ? 43 : $polling.hashCode());
        return result;
    }

    public String toString() {
        return "ClustersProperties(clusters=" + this.getClusters() + ", internalTopicPrefix=" + this.getInternalTopicPrefix() + ", adminClientTimeout=" + this.getAdminClientTimeout() + ", polling=" + this.getPolling() + ")";
    }
}

