/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config;

import com.provectus.kafka.ui.exception.ValidationException;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(value="webclient")
public class WebclientProperties {
    String maxInMemoryBufferSize;

    @PostConstruct
    public void validate() {
        this.validateAndSetDefaultBufferSize();
    }

    private void validateAndSetDefaultBufferSize() {
        if (this.maxInMemoryBufferSize != null) {
            try {
                DataSize.parse((CharSequence)this.maxInMemoryBufferSize);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid format for webclient.maxInMemoryBufferSize");
            }
        }
    }

    public String getMaxInMemoryBufferSize() {
        return this.maxInMemoryBufferSize;
    }

    public void setMaxInMemoryBufferSize(String maxInMemoryBufferSize) {
        this.maxInMemoryBufferSize = maxInMemoryBufferSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebclientProperties)) {
            return false;
        }
        WebclientProperties other = (WebclientProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$maxInMemoryBufferSize = this.getMaxInMemoryBufferSize();
        String other$maxInMemoryBufferSize = other.getMaxInMemoryBufferSize();
        return !(this$maxInMemoryBufferSize == null ? other$maxInMemoryBufferSize != null : !this$maxInMemoryBufferSize.equals(other$maxInMemoryBufferSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebclientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $maxInMemoryBufferSize = this.getMaxInMemoryBufferSize();
        result = result * 59 + ($maxInMemoryBufferSize == null ? 43 : $maxInMemoryBufferSize.hashCode());
        return result;
    }

    public String toString() {
        return "WebclientProperties(maxInMemoryBufferSize=" + this.getMaxInMemoryBufferSize() + ")";
    }
}

