/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth;

import com.provectus.kafka.ui.config.auth.OAuthProperties;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OAuthPropertiesConverter {
    private static final String TYPE = "type";
    private static final String GOOGLE = "google";
    public static final String DUMMY = "dummy";

    public static OAuth2ClientProperties convertProperties(OAuthProperties properties) {
        OAuth2ClientProperties result = new OAuth2ClientProperties();
        properties.getClient().forEach((key, provider) -> {
            OAuth2ClientProperties.Registration registration = new OAuth2ClientProperties.Registration();
            registration.setClientId(provider.getClientId());
            registration.setClientSecret(provider.getClientSecret());
            registration.setClientName(provider.getClientName());
            registration.setScope(Optional.ofNullable(provider.getScope()).orElse(Set.of()));
            registration.setRedirectUri(provider.getRedirectUri());
            registration.setAuthorizationGrantType(provider.getAuthorizationGrantType());
            result.getRegistration().put(key, registration);
            OAuth2ClientProperties.Provider clientProvider = new OAuth2ClientProperties.Provider();
            OAuthPropertiesConverter.applyCustomTransformations((OAuthProperties.OAuth2Provider)provider);
            clientProvider.setAuthorizationUri(provider.getAuthorizationUri());
            clientProvider.setIssuerUri(provider.getIssuerUri());
            clientProvider.setJwkSetUri(provider.getJwkSetUri());
            clientProvider.setTokenUri(provider.getTokenUri());
            clientProvider.setUserInfoUri(provider.getUserInfoUri());
            clientProvider.setUserNameAttribute(provider.getUserNameAttribute());
            result.getProvider().put(key, clientProvider);
        });
        return result;
    }

    private static void applyCustomTransformations(OAuthProperties.OAuth2Provider provider) {
        OAuthPropertiesConverter.applyGoogleTransformations((OAuthProperties.OAuth2Provider)provider);
    }

    private static void applyGoogleTransformations(OAuthProperties.OAuth2Provider provider) {
        if (!OAuthPropertiesConverter.isGoogle((OAuthProperties.OAuth2Provider)provider)) {
            return;
        }
        String allowedDomain = (String)provider.getCustomParams().get("allowedDomain");
        if (StringUtils.isEmpty((CharSequence)allowedDomain)) {
            return;
        }
        String authorizationUri = CommonOAuth2Provider.GOOGLE.getBuilder("dummy").clientId("dummy").build().getProviderDetails().getAuthorizationUri();
        String newUri = authorizationUri + "?hd=" + allowedDomain;
        provider.setAuthorizationUri(newUri);
    }

    private static boolean isGoogle(OAuthProperties.OAuth2Provider provider) {
        return "google".equalsIgnoreCase((String)provider.getCustomParams().get("type"));
    }

    private OAuthPropertiesConverter() {
    }
}

