/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth.logout;

import com.provectus.kafka.ui.config.auth.OAuthProperties;
import com.provectus.kafka.ui.config.auth.logout.LogoutSuccessHandler;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnProperty(value={"auth.type"}, havingValue="OAUTH2")
public class OAuthLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private final OAuthProperties properties;
    private final List<LogoutSuccessHandler> logoutSuccessHandlers;
    private final ServerLogoutSuccessHandler defaultOidcLogoutHandler;

    public OAuthLogoutSuccessHandler(OAuthProperties properties, List<LogoutSuccessHandler> logoutSuccessHandlers, @Qualifier(value="defaultOidcLogoutHandler") ServerLogoutSuccessHandler handler) {
        this.properties = properties;
        this.logoutSuccessHandlers = logoutSuccessHandlers;
        this.defaultOidcLogoutHandler = handler;
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        OAuth2AuthenticationToken oauthToken = (OAuth2AuthenticationToken)authentication;
        String providerId = oauthToken.getAuthorizedClientRegistrationId();
        OAuthProperties.OAuth2Provider oAuth2Provider = (OAuthProperties.OAuth2Provider)this.properties.getClient().get(providerId);
        return this.getLogoutHandler(oAuth2Provider.getProvider()).map(handler -> handler.handle(exchange, authentication, oAuth2Provider)).orElseGet(() -> this.defaultOidcLogoutHandler.onLogoutSuccess(exchange, authentication));
    }

    private Optional<LogoutSuccessHandler> getLogoutHandler(String provider) {
        return this.logoutSuccessHandlers.stream().filter(h -> h.isApplicable(provider)).findFirst();
    }
}

