/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.AuthorizationApi;
import com.provectus.kafka.ui.model.ActionDTO;
import com.provectus.kafka.ui.model.AuthenticationInfoDTO;
import com.provectus.kafka.ui.model.ResourceTypeDTO;
import com.provectus.kafka.ui.model.UserInfoDTO;
import com.provectus.kafka.ui.model.UserPermissionDTO;
import com.provectus.kafka.ui.model.rbac.Permission;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
public class AccessController
implements AuthorizationApi {
    private static final Logger log = LoggerFactory.getLogger(AccessController.class);
    private final AccessControlService accessControlService;

    public Mono<ResponseEntity<AuthenticationInfoDTO>> getUserAuthInfo(ServerWebExchange exchange) {
        Mono permissions = this.accessControlService.getUser().map(user -> this.accessControlService.getRoles().stream().filter(role -> user.groups().contains(role.getName())).map(role -> this.mapPermissions(role.getPermissions(), role.getClusters())).flatMap(Collection::stream).toList()).switchIfEmpty(Mono.just(Collections.emptyList()));
        Mono userName = ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Principal::getName);
        return userName.zipWith(permissions).map(data -> {
            AuthenticationInfoDTO dto = new AuthenticationInfoDTO(Boolean.valueOf(this.accessControlService.isRbacEnabled()));
            dto.setUserInfo(new UserInfoDTO((String)data.getT1(), (List)data.getT2()));
            return dto;
        }).switchIfEmpty(Mono.just((Object)new AuthenticationInfoDTO(Boolean.valueOf(this.accessControlService.isRbacEnabled())))).map(ResponseEntity::ok);
    }

    private List<UserPermissionDTO> mapPermissions(List<Permission> permissions, List<String> clusters) {
        return permissions.stream().map(permission -> {
            UserPermissionDTO dto = new UserPermissionDTO();
            dto.setClusters(clusters);
            dto.setResource(ResourceTypeDTO.fromValue((String)permission.getResource().toString().toUpperCase()));
            dto.setValue(permission.getValue());
            dto.setActions(permission.getActions().stream().map(String::toUpperCase).map(arg_0 -> this.mapAction(arg_0)).filter(Objects::nonNull).toList());
            return dto;
        }).toList();
    }

    @Nullable
    private ActionDTO mapAction(String name) {
        try {
            return ActionDTO.fromValue((String)name);
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown Action [{}], skipping", (Object)name);
            return null;
        }
    }

    public AccessController(AccessControlService accessControlService) {
        this.accessControlService = accessControlService;
    }
}

