/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.ApplicationConfigApi;
import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.controller.ApplicationConfigController;
import com.provectus.kafka.ui.model.ApplicationConfigDTO;
import com.provectus.kafka.ui.model.ApplicationConfigValidationDTO;
import com.provectus.kafka.ui.model.ApplicationInfoDTO;
import com.provectus.kafka.ui.model.ClusterConfigValidationDTO;
import com.provectus.kafka.ui.model.RestartRequestDTO;
import com.provectus.kafka.ui.model.UploadedFileInfoDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.ApplicationConfigAction;
import com.provectus.kafka.ui.service.ApplicationInfoService;
import com.provectus.kafka.ui.service.KafkaClusterFactory;
import com.provectus.kafka.ui.util.ApplicationRestarter;
import com.provectus.kafka.ui.util.DynamicConfigOperations;
import java.util.Map;
import javax.annotation.Nullable;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@RestController
public class ApplicationConfigController
extends AbstractController
implements ApplicationConfigApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigController.class);
    private static final PropertiesMapper MAPPER = (PropertiesMapper)Mappers.getMapper(PropertiesMapper.class);
    private final DynamicConfigOperations dynamicConfigOperations;
    private final ApplicationRestarter restarter;
    private final KafkaClusterFactory kafkaClusterFactory;
    private final ApplicationInfoService applicationInfoService;

    public Mono<ResponseEntity<ApplicationInfoDTO>> getApplicationInfo(ServerWebExchange exchange) {
        return Mono.just((Object)this.applicationInfoService.getApplicationInfo()).map(ResponseEntity::ok);
    }

    public Mono<ResponseEntity<ApplicationConfigDTO>> getCurrentConfig(ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().applicationConfigActions(new ApplicationConfigAction[]{ApplicationConfigAction.VIEW}).operationName("getCurrentConfig").build();
        return this.validateAccess(context).then(Mono.fromSupplier(() -> ResponseEntity.ok((Object)new ApplicationConfigDTO().properties(MAPPER.toDto(this.dynamicConfigOperations.getCurrentProperties()))))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> restartWithConfig(Mono<RestartRequestDTO> restartRequestDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().applicationConfigActions(new ApplicationConfigAction[]{ApplicationConfigAction.EDIT}).operationName("restartWithConfig").build();
        return this.validateAccess(context).then(restartRequestDto).doOnNext(restartDto -> {
            DynamicConfigOperations.PropertiesStructure newConfig = MAPPER.fromDto(restartDto.getConfig().getProperties());
            this.dynamicConfigOperations.persist(newConfig);
        }).doOnEach(sig -> this.audit(context, sig)).doOnSuccess(dto -> this.restarter.requestRestart()).map(dto -> ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<UploadedFileInfoDTO>> uploadConfigRelatedFile(Flux<Part> fileFlux, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().applicationConfigActions(new ApplicationConfigAction[]{ApplicationConfigAction.EDIT}).operationName("uploadConfigRelatedFile").build();
        return this.validateAccess(context).then(fileFlux.single()).flatMap(file -> this.dynamicConfigOperations.uploadConfigRelatedFile((FilePart)file).map(path -> new UploadedFileInfoDTO().location(path.toString())).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ApplicationConfigValidationDTO>> validateConfig(Mono<ApplicationConfigDTO> configDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().applicationConfigActions(new ApplicationConfigAction[]{ApplicationConfigAction.EDIT}).operationName("validateConfig").build();
        return this.validateAccess(context).then(configDto).flatMap(config -> {
            DynamicConfigOperations.PropertiesStructure newConfig = MAPPER.fromDto(config.getProperties());
            ClustersProperties clustersProperties = newConfig.getKafka();
            return this.validateClustersConfig(clustersProperties).map(validations -> new ApplicationConfigValidationDTO().clusters(validations));
        }).map(ResponseEntity::ok).doOnEach(sig -> this.audit(context, sig));
    }

    private Mono<Map<String, ClusterConfigValidationDTO>> validateClustersConfig(@Nullable ClustersProperties properties) {
        if (properties == null || properties.getClusters() == null) {
            return Mono.just(Map.of());
        }
        properties.validateAndSetDefaults();
        return Flux.fromIterable((Iterable)properties.getClusters()).flatMap(c -> this.kafkaClusterFactory.validate(c).map(v -> Tuples.of((Object)c.getName(), (Object)v))).collectMap(Tuple2::getT1, Tuple2::getT2);
    }

    public ApplicationConfigController(DynamicConfigOperations dynamicConfigOperations, ApplicationRestarter restarter, KafkaClusterFactory kafkaClusterFactory, ApplicationInfoService applicationInfoService) {
        this.dynamicConfigOperations = dynamicConfigOperations;
        this.restarter = restarter;
        this.kafkaClusterFactory = kafkaClusterFactory;
        this.applicationInfoService = applicationInfoService;
    }
}

