/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.KafkaConnectApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.controller.KafkaConnectController;
import com.provectus.kafka.ui.model.ConnectDTO;
import com.provectus.kafka.ui.model.ConnectorActionDTO;
import com.provectus.kafka.ui.model.ConnectorColumnsToSortDTO;
import com.provectus.kafka.ui.model.ConnectorDTO;
import com.provectus.kafka.ui.model.ConnectorPluginConfigValidationResponseDTO;
import com.provectus.kafka.ui.model.ConnectorPluginDTO;
import com.provectus.kafka.ui.model.FullConnectorInfoDTO;
import com.provectus.kafka.ui.model.NewConnectorDTO;
import com.provectus.kafka.ui.model.SortOrderDTO;
import com.provectus.kafka.ui.model.TaskDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.ConnectAction;
import com.provectus.kafka.ui.service.KafkaConnectService;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class KafkaConnectController
extends AbstractController
implements KafkaConnectApi {
    private static final Logger log = LoggerFactory.getLogger(KafkaConnectController.class);
    private static final Set<ConnectorActionDTO> RESTART_ACTIONS = Set.of(ConnectorActionDTO.RESTART, ConnectorActionDTO.RESTART_FAILED_TASKS, ConnectorActionDTO.RESTART_ALL_TASKS);
    private static final String CONNECTOR_NAME = "connectorName";
    private final KafkaConnectService kafkaConnectService;

    public Mono<ResponseEntity<Flux<ConnectDTO>>> getConnects(String clusterName, ServerWebExchange exchange) {
        Flux availableConnects = this.kafkaConnectService.getConnects(this.getCluster(clusterName)).filterWhen(dto -> this.accessControlService.isConnectAccessible(dto, clusterName));
        return Mono.just((Object)ResponseEntity.ok((Object)availableConnects));
    }

    public Mono<ResponseEntity<Flux<String>>> getConnectors(String clusterName, String connectName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).operationName("getConnectors").build();
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)this.kafkaConnectService.getConnectorNames(this.getCluster(clusterName), connectName))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ConnectorDTO>> createConnector(String clusterName, String connectName, @Valid Mono<NewConnectorDTO> connector, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW, ConnectAction.CREATE}).operationName("createConnector").build();
        return this.validateAccess(context).then(this.kafkaConnectService.createConnector(this.getCluster(clusterName), connectName, connector).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ConnectorDTO>> getConnector(String clusterName, String connectName, String connectorName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).connector(connectorName).operationName("getConnector").build();
        return this.validateAccess(context).then(this.kafkaConnectService.getConnector(this.getCluster(clusterName), connectName, connectorName).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> deleteConnector(String clusterName, String connectName, String connectorName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW, ConnectAction.EDIT}).operationName("deleteConnector").operationParams(Map.of(CONNECTOR_NAME, connectName)).build();
        return this.validateAccess(context).then(this.kafkaConnectService.deleteConnector(this.getCluster(clusterName), connectName, connectorName).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<FullConnectorInfoDTO>>> getAllConnectors(String clusterName, String search, ConnectorColumnsToSortDTO orderBy, SortOrderDTO sortOrder, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connectActions(new ConnectAction[]{ConnectAction.VIEW, ConnectAction.EDIT}).operationName("getAllConnectors").build();
        Comparator comparator = sortOrder == null || sortOrder.equals((Object)SortOrderDTO.ASC) ? this.getConnectorsComparator(orderBy) : this.getConnectorsComparator(orderBy).reversed();
        Flux job = this.kafkaConnectService.getAllConnectors(this.getCluster(clusterName), search).filterWhen(dto -> this.accessControlService.isConnectAccessible(dto.getConnect(), clusterName)).filterWhen(dto -> this.accessControlService.isConnectorAccessible(dto.getConnect(), dto.getName(), clusterName)).sort(comparator);
        return Mono.just((Object)ResponseEntity.ok((Object)job)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Map<String, Object>>> getConnectorConfig(String clusterName, String connectName, String connectorName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).operationName("getConnectorConfig").build();
        return this.validateAccess(context).then(this.kafkaConnectService.getConnectorConfig(this.getCluster(clusterName), connectName, connectorName).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ConnectorDTO>> setConnectorConfig(String clusterName, String connectName, String connectorName, Mono<Map<String, Object>> requestBody, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW, ConnectAction.EDIT}).operationName("setConnectorConfig").operationParams(Map.of(CONNECTOR_NAME, connectorName)).build();
        return this.validateAccess(context).then(this.kafkaConnectService.setConnectorConfig(this.getCluster(clusterName), connectName, connectorName, requestBody).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> updateConnectorState(String clusterName, String connectName, String connectorName, ConnectorActionDTO action, ServerWebExchange exchange) {
        ConnectAction[] connectActions = RESTART_ACTIONS.contains(action) ? new ConnectAction[]{ConnectAction.VIEW, ConnectAction.RESTART} : new ConnectAction[]{ConnectAction.VIEW, ConnectAction.EDIT};
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(connectActions).operationName("updateConnectorState").operationParams(Map.of(CONNECTOR_NAME, connectorName)).build();
        return this.validateAccess(context).then(this.kafkaConnectService.updateConnectorState(this.getCluster(clusterName), connectName, connectorName, action).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<TaskDTO>>> getConnectorTasks(String clusterName, String connectName, String connectorName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).operationName("getConnectorTasks").operationParams(Map.of(CONNECTOR_NAME, connectorName)).build();
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)this.kafkaConnectService.getConnectorTasks(this.getCluster(clusterName), connectName, connectorName))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> restartConnectorTask(String clusterName, String connectName, String connectorName, Integer taskId, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW, ConnectAction.RESTART}).operationName("restartConnectorTask").operationParams(Map.of(CONNECTOR_NAME, connectorName)).build();
        return this.validateAccess(context).then(this.kafkaConnectService.restartConnectorTask(this.getCluster(clusterName), connectName, connectorName, taskId).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<ConnectorPluginDTO>>> getConnectorPlugins(String clusterName, String connectName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).operationName("getConnectorPlugins").build();
        return this.validateAccess(context).then(Mono.just((Object)ResponseEntity.ok((Object)this.kafkaConnectService.getConnectorPlugins(this.getCluster(clusterName), connectName)))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ConnectorPluginConfigValidationResponseDTO>> validateConnectorPluginConfig(String clusterName, String connectName, String pluginName, @Valid Mono<Map<String, Object>> requestBody, ServerWebExchange exchange) {
        return this.kafkaConnectService.validateConnectorPluginConfig(this.getCluster(clusterName), connectName, pluginName, requestBody).map(ResponseEntity::ok);
    }

    private Comparator<FullConnectorInfoDTO> getConnectorsComparator(ConnectorColumnsToSortDTO orderBy) {
        Comparator<FullConnectorInfoDTO> defaultComparator = Comparator.comparing(FullConnectorInfoDTO::getName);
        if (orderBy == null) {
            return defaultComparator;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$ConnectorColumnsToSortDTO[orderBy.ordinal()]) {
            case 1 -> Comparator.comparing(FullConnectorInfoDTO::getConnect);
            case 2 -> Comparator.comparing(FullConnectorInfoDTO::getType);
            case 3 -> Comparator.comparing(fullConnectorInfoDTO -> fullConnectorInfoDTO.getStatus().getState());
            default -> defaultComparator;
        };
    }

    public KafkaConnectController(KafkaConnectService kafkaConnectService) {
        this.kafkaConnectService = kafkaConnectService;
    }
}

