/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.SchemasApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.mapper.KafkaSrMapper;
import com.provectus.kafka.ui.mapper.KafkaSrMapperImpl;
import com.provectus.kafka.ui.model.CompatibilityCheckResponseDTO;
import com.provectus.kafka.ui.model.CompatibilityLevelDTO;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.NewSchemaSubjectDTO;
import com.provectus.kafka.ui.model.SchemaSubjectDTO;
import com.provectus.kafka.ui.model.SchemaSubjectsResponseDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.SchemaAction;
import com.provectus.kafka.ui.service.SchemaRegistryService;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class SchemasController
extends AbstractController
implements SchemasApi {
    private static final Logger log = LoggerFactory.getLogger(SchemasController.class);
    private static final Integer DEFAULT_PAGE_SIZE = 25;
    private final KafkaSrMapper kafkaSrMapper = new KafkaSrMapperImpl();
    private final SchemaRegistryService schemaRegistryService;

    protected KafkaCluster getCluster(String clusterName) {
        KafkaCluster c = super.getCluster(clusterName);
        if (c.getSchemaRegistryClient() == null) {
            throw new ValidationException("Schema Registry is not set for cluster " + clusterName);
        }
        return c;
    }

    public Mono<ResponseEntity<CompatibilityCheckResponseDTO>> checkSchemaCompatibility(String clusterName, String subject, @Valid Mono<NewSchemaSubjectDTO> newSchemaSubjectMono, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subject).schemaActions(new SchemaAction[]{SchemaAction.VIEW}).operationName("checkSchemaCompatibility").build();
        return this.validateAccess(context).then(newSchemaSubjectMono.flatMap(subjectDTO -> this.schemaRegistryService.checksSchemaCompatibility(this.getCluster(clusterName), subject, this.kafkaSrMapper.fromDto(subjectDTO))).map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<SchemaSubjectDTO>> createNewSchema(String clusterName, @Valid Mono<NewSchemaSubjectDTO> newSchemaSubjectMono, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schemaActions(new SchemaAction[]{SchemaAction.CREATE}).operationName("createNewSchema").build();
        return this.validateAccess(context).then(newSchemaSubjectMono.flatMap(newSubject -> this.schemaRegistryService.registerNewSchema(this.getCluster(clusterName), newSubject.getSubject(), this.kafkaSrMapper.fromDto(newSubject))).map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> deleteLatestSchema(String clusterName, String subject, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subject).schemaActions(new SchemaAction[]{SchemaAction.DELETE}).operationName("deleteLatestSchema").build();
        return this.validateAccess(context).then(this.schemaRegistryService.deleteLatestSchemaSubject(this.getCluster(clusterName), subject).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public Mono<ResponseEntity<Void>> deleteSchema(String clusterName, String subject, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subject).schemaActions(new SchemaAction[]{SchemaAction.DELETE}).operationName("deleteSchema").build();
        return this.validateAccess(context).then(this.schemaRegistryService.deleteSchemaSubjectEntirely(this.getCluster(clusterName), subject).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public Mono<ResponseEntity<Void>> deleteSchemaByVersion(String clusterName, String subjectName, Integer version, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subjectName).schemaActions(new SchemaAction[]{SchemaAction.DELETE}).operationName("deleteSchemaByVersion").build();
        return this.validateAccess(context).then(this.schemaRegistryService.deleteSchemaSubjectByVersion(this.getCluster(clusterName), subjectName, version).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public Mono<ResponseEntity<Flux<SchemaSubjectDTO>>> getAllVersionsBySubject(String clusterName, String subjectName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subjectName).schemaActions(new SchemaAction[]{SchemaAction.VIEW}).operationName("getAllVersionsBySubject").build();
        Flux schemas = this.schemaRegistryService.getAllVersionsBySubject(this.getCluster(clusterName), subjectName).map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0));
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)schemas)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<CompatibilityLevelDTO>> getGlobalSchemaCompatibilityLevel(String clusterName, ServerWebExchange exchange) {
        return this.schemaRegistryService.getGlobalSchemaCompatibilityLevel(this.getCluster(clusterName)).map(c -> new CompatibilityLevelDTO().compatibility(this.kafkaSrMapper.toDto(c))).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    public Mono<ResponseEntity<SchemaSubjectDTO>> getLatestSchema(String clusterName, String subject, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subject).schemaActions(new SchemaAction[]{SchemaAction.VIEW}).operationName("getLatestSchema").build();
        return this.validateAccess(context).then(this.schemaRegistryService.getLatestSchemaVersionBySubject(this.getCluster(clusterName), subject).map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<SchemaSubjectDTO>> getSchemaByVersion(String clusterName, String subject, Integer version, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schema(subject).schemaActions(new SchemaAction[]{SchemaAction.VIEW}).operationName("getSchemaByVersion").operationParams(Map.of("subject", subject, "version", version)).build();
        return this.validateAccess(context).then(this.schemaRegistryService.getSchemaSubjectByVersion(this.getCluster(clusterName), subject, version).map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<SchemaSubjectsResponseDTO>> getSchemas(String clusterName, @Valid Integer pageNum, @Valid Integer perPage, @Valid String search, ServerWebExchange serverWebExchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getSchemas").build();
        return this.schemaRegistryService.getAllSubjectNames(this.getCluster(clusterName)).flatMapIterable(l -> l).filterWhen(schema -> this.accessControlService.isSchemaAccessible(schema, clusterName)).collectList().flatMap(subjects -> {
            int pageSize = perPage != null && perPage > 0 ? perPage : DEFAULT_PAGE_SIZE;
            int subjectToSkip = ((pageNum != null && pageNum > 0 ? pageNum : 1) - 1) * pageSize;
            List<String> filteredSubjects = subjects.stream().filter(subj -> search == null || StringUtils.containsIgnoreCase((CharSequence)subj, (CharSequence)search)).sorted().toList();
            int totalPages = filteredSubjects.size() / pageSize + (filteredSubjects.size() % pageSize == 0 ? 0 : 1);
            List subjectsToRender = filteredSubjects.stream().skip(subjectToSkip).limit(pageSize).toList();
            return this.schemaRegistryService.getAllLatestVersionSchemas(this.getCluster(clusterName), subjectsToRender).map(subjs -> subjs.stream().map(arg_0 -> ((KafkaSrMapper)this.kafkaSrMapper).toDto(arg_0)).toList()).map(subjs -> new SchemaSubjectsResponseDTO().pageCount(Integer.valueOf(totalPages)).schemas(subjs));
        }).map(ResponseEntity::ok).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> updateGlobalSchemaCompatibilityLevel(String clusterName, @Valid Mono<CompatibilityLevelDTO> compatibilityLevelMono, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schemaActions(new SchemaAction[]{SchemaAction.MODIFY_GLOBAL_COMPATIBILITY}).operationName("updateGlobalSchemaCompatibilityLevel").build();
        return this.validateAccess(context).then(compatibilityLevelMono.flatMap(compatibilityLevelDTO -> this.schemaRegistryService.updateGlobalSchemaCompatibility(this.getCluster(clusterName), this.kafkaSrMapper.fromDto(compatibilityLevelDTO.getCompatibility()))).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public Mono<ResponseEntity<Void>> updateSchemaCompatibilityLevel(String clusterName, String subject, @Valid Mono<CompatibilityLevelDTO> compatibilityLevelMono, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).schemaActions(new SchemaAction[]{SchemaAction.EDIT}).operationName("updateSchemaCompatibilityLevel").operationParams(Map.of("subject", subject)).build();
        return this.validateAccess(context).then(compatibilityLevelMono.flatMap(compatibilityLevelDTO -> this.schemaRegistryService.updateSchemaCompatibility(this.getCluster(clusterName), subject, this.kafkaSrMapper.fromDto(compatibilityLevelDTO.getCompatibility()))).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public SchemasController(SchemaRegistryService schemaRegistryService) {
        this.schemaRegistryService = schemaRegistryService;
    }
}

