/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.TopicsApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.controller.TopicsController;
import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.model.InternalTopic;
import com.provectus.kafka.ui.model.InternalTopicConfig;
import com.provectus.kafka.ui.model.PartitionsIncreaseDTO;
import com.provectus.kafka.ui.model.PartitionsIncreaseResponseDTO;
import com.provectus.kafka.ui.model.ReplicationFactorChangeDTO;
import com.provectus.kafka.ui.model.ReplicationFactorChangeResponseDTO;
import com.provectus.kafka.ui.model.SortOrderDTO;
import com.provectus.kafka.ui.model.TopicAnalysisDTO;
import com.provectus.kafka.ui.model.TopicColumnsToSortDTO;
import com.provectus.kafka.ui.model.TopicConfigDTO;
import com.provectus.kafka.ui.model.TopicCreationDTO;
import com.provectus.kafka.ui.model.TopicDTO;
import com.provectus.kafka.ui.model.TopicDetailsDTO;
import com.provectus.kafka.ui.model.TopicProducerStateDTO;
import com.provectus.kafka.ui.model.TopicUpdateDTO;
import com.provectus.kafka.ui.model.TopicsResponseDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.TopicAction;
import com.provectus.kafka.ui.service.TopicsService;
import com.provectus.kafka.ui.service.analyze.TopicAnalysisService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class TopicsController
extends AbstractController
implements TopicsApi {
    private static final Logger log = LoggerFactory.getLogger(TopicsController.class);
    private static final Integer DEFAULT_PAGE_SIZE = 25;
    private final TopicsService topicsService;
    private final TopicAnalysisService topicAnalysisService;
    private final ClusterMapper clusterMapper;

    public Mono<ResponseEntity<TopicDTO>> createTopic(String clusterName, @Valid Mono<TopicCreationDTO> topicCreationMono, ServerWebExchange exchange) {
        return topicCreationMono.flatMap(topicCreation -> {
            AccessContext context = AccessContext.builder().cluster(clusterName).topicActions(new TopicAction[]{TopicAction.CREATE}).operationName("createTopic").operationParams(topicCreation).build();
            return this.validateAccess(context).then(this.topicsService.createTopic(this.getCluster(clusterName), topicCreation)).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopic(arg_0)).map(s -> new ResponseEntity(s, (HttpStatusCode)HttpStatus.OK)).switchIfEmpty(Mono.just((Object)ResponseEntity.notFound().build())).doOnEach(sig -> this.audit(context, sig));
        });
    }

    public Mono<ResponseEntity<TopicDTO>> recreateTopic(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW, TopicAction.CREATE, TopicAction.DELETE}).operationName("recreateTopic").build();
        return this.validateAccess(context).then(this.topicsService.recreateTopic(this.getCluster(clusterName), topicName).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopic(arg_0)).map(s -> new ResponseEntity(s, (HttpStatusCode)HttpStatus.CREATED))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<TopicDTO>> cloneTopic(String clusterName, String topicName, String newTopicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW, TopicAction.CREATE}).operationName("cloneTopic").operationParams(Map.of("newTopicName", newTopicName)).build();
        return this.validateAccess(context).then(this.topicsService.cloneTopic(this.getCluster(clusterName), topicName, newTopicName).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopic(arg_0)).map(s -> new ResponseEntity(s, (HttpStatusCode)HttpStatus.CREATED))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> deleteTopic(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.DELETE}).operationName("deleteTopic").build();
        return this.validateAccess(context).then(this.topicsService.deleteTopic(this.getCluster(clusterName), topicName).thenReturn((Object)ResponseEntity.ok().build())).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<TopicConfigDTO>>> getTopicConfigs(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW}).operationName("getTopicConfigs").build();
        return this.validateAccess(context).then(this.topicsService.getTopicConfigs(this.getCluster(clusterName), topicName).map(lst -> lst.stream().map(InternalTopicConfig::from).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopicConfig(arg_0)).toList()).map(Flux::fromIterable).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<TopicDetailsDTO>> getTopicDetails(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW}).operationName("getTopicDetails").build();
        return this.validateAccess(context).then(this.topicsService.getTopicDetails(this.getCluster(clusterName), topicName).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopicDetails(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<TopicsResponseDTO>> getTopics(String clusterName, @Valid Integer page, @Valid Integer perPage, @Valid Boolean showInternal, @Valid String search, @Valid TopicColumnsToSortDTO orderBy, @Valid SortOrderDTO sortOrder, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getTopics").build();
        return this.topicsService.getTopicsForPagination(this.getCluster(clusterName)).flatMap(topics -> this.accessControlService.filterViewableTopics(topics, clusterName)).flatMap(topics -> {
            int pageSize = perPage != null && perPage > 0 ? perPage : DEFAULT_PAGE_SIZE;
            int topicsToSkip = ((page != null && page > 0 ? page : 1) - 1) * pageSize;
            Comparator comparator = sortOrder == null || !sortOrder.equals((Object)SortOrderDTO.DESC) ? this.getComparatorForTopic(orderBy) : this.getComparatorForTopic(orderBy).reversed();
            List<InternalTopic> filtered = topics.stream().filter(topic -> !topic.isInternal() || showInternal != null && showInternal != false).filter(topic -> search == null || StringUtils.containsIgnoreCase((CharSequence)topic.getName(), (CharSequence)search)).sorted(comparator).toList();
            int totalPages = filtered.size() / pageSize + (filtered.size() % pageSize == 0 ? 0 : 1);
            List topicsPage = filtered.stream().skip(topicsToSkip).limit(pageSize).map(InternalTopic::getName).collect(Collectors.toList());
            return this.topicsService.loadTopics(this.getCluster(clusterName), topicsPage).map(topicsToRender -> new TopicsResponseDTO().topics(topicsToRender.stream().map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopic(arg_0)).toList()).pageCount(Integer.valueOf(totalPages)));
        }).map(ResponseEntity::ok).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<TopicDTO>> updateTopic(String clusterName, String topicName, @Valid Mono<TopicUpdateDTO> topicUpdate, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW, TopicAction.EDIT}).operationName("updateTopic").build();
        return this.validateAccess(context).then(this.topicsService.updateTopic(this.getCluster(clusterName), topicName, topicUpdate).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toTopic(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<PartitionsIncreaseResponseDTO>> increaseTopicPartitions(String clusterName, String topicName, Mono<PartitionsIncreaseDTO> partitionsIncrease, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW, TopicAction.EDIT}).build();
        return this.validateAccess(context).then(partitionsIncrease.flatMap(partitions -> this.topicsService.increaseTopicPartitions(this.getCluster(clusterName), topicName, partitions)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ReplicationFactorChangeResponseDTO>> changeReplicationFactor(String clusterName, String topicName, Mono<ReplicationFactorChangeDTO> replicationFactorChange, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW, TopicAction.EDIT}).operationName("changeReplicationFactor").build();
        return this.validateAccess(context).then(replicationFactorChange.flatMap(rfc -> this.topicsService.changeReplicationFactor(this.getCluster(clusterName), topicName, rfc)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> analyzeTopic(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.MESSAGES_READ}).operationName("analyzeTopic").build();
        return this.validateAccess(context).then(this.topicAnalysisService.analyze(this.getCluster(clusterName), topicName).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build()));
    }

    public Mono<ResponseEntity<Void>> cancelTopicAnalysis(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.MESSAGES_READ}).operationName("cancelTopicAnalysis").build();
        return this.validateAccess(context).then(Mono.fromRunnable(() -> this.topicAnalysisService.cancelAnalysis(this.getCluster(clusterName), topicName))).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<TopicAnalysisDTO>> getTopicAnalysis(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.MESSAGES_READ}).operationName("getTopicAnalysis").build();
        return this.validateAccess(context).thenReturn((Object)this.topicAnalysisService.getTopicAnalysis(this.getCluster(clusterName), topicName).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build())).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<TopicProducerStateDTO>>> getActiveProducerStates(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW}).operationName("getActiveProducerStates").build();
        Comparator<TopicProducerStateDTO> ordering = Comparator.comparingInt(TopicProducerStateDTO::getPartition).thenComparing(Comparator.comparing(TopicProducerStateDTO::getProducerId).reversed());
        Flux states = this.topicsService.getActiveProducersState(this.getCluster(clusterName), topicName).flatMapMany(statesMap -> Flux.fromStream(statesMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(p -> this.clusterMapper.map(((TopicPartition)e.getKey()).partition(), p))).sorted(ordering)));
        return this.validateAccess(context).thenReturn((Object)states).map(ResponseEntity::ok).doOnEach(sig -> this.audit(context, sig));
    }

    private Comparator<InternalTopic> getComparatorForTopic(TopicColumnsToSortDTO orderBy) {
        Comparator<InternalTopic> defaultComparator = Comparator.comparing(InternalTopic::getName);
        if (orderBy == null) {
            return defaultComparator;
        }
        switch (1.$SwitchMap$com$provectus$kafka$ui$model$TopicColumnsToSortDTO[orderBy.ordinal()]) {
            case 1: {
                return Comparator.comparing(InternalTopic::getPartitionCount);
            }
            case 2: {
                return Comparator.comparing(t -> t.getReplicas() - t.getInSyncReplicas());
            }
            case 3: {
                return Comparator.comparing(InternalTopic::getReplicationFactor);
            }
            case 4: {
                return Comparator.comparing(InternalTopic::getSegmentSize);
            }
        }
        return defaultComparator;
    }

    public TopicsController(TopicsService topicsService, TopicAnalysisService topicAnalysisService, ClusterMapper clusterMapper) {
        this.topicsService = topicsService;
        this.topicAnalysisService = topicAnalysisService;
        this.clusterMapper = clusterMapper;
    }
}

