/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.provectus.kafka.ui.emitter.MessageFilters;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.model.MessageFilterTypeDTO;
import com.provectus.kafka.ui.model.TopicMessageDTO;
import groovy.json.JsonSlurper;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageFilters {
    private static final Logger log = LoggerFactory.getLogger(MessageFilters.class);
    private static GroovyScriptEngineImpl GROOVY_ENGINE;

    private MessageFilters() {
    }

    public static Predicate<TopicMessageDTO> createMsgFilter(String query, MessageFilterTypeDTO type) {
        switch (2.$SwitchMap$com$provectus$kafka$ui$model$MessageFilterTypeDTO[type.ordinal()]) {
            case 1: {
                return MessageFilters.containsStringFilter((String)query);
            }
            case 2: {
                return MessageFilters.groovyScriptFilter((String)query);
            }
        }
        throw new IllegalStateException("Unknown query type: " + type);
    }

    static Predicate<TopicMessageDTO> containsStringFilter(String string) {
        return msg -> StringUtils.contains((CharSequence)msg.getKey(), (CharSequence)string) || StringUtils.contains((CharSequence)msg.getContent(), (CharSequence)string);
    }

    static Predicate<TopicMessageDTO> groovyScriptFilter(String script) {
        GroovyScriptEngineImpl engine = MessageFilters.getGroovyEngine();
        CompiledScript compiledScript = MessageFilters.compileScript((GroovyScriptEngineImpl)engine, (String)script);
        JsonSlurper jsonSlurper = new JsonSlurper();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nullable
    private static Object parseToJsonOrReturnAsIs(JsonSlurper parser, @Nullable String str) {
        if (str == null) {
            return null;
        }
        try {
            return parser.parseText(str);
        }
        catch (Exception e) {
            return str;
        }
    }

    private static synchronized GroovyScriptEngineImpl getGroovyEngine() {
        if (GROOVY_ENGINE == null) {
            GROOVY_ENGINE = (GroovyScriptEngineImpl)new ScriptEngineManager().getEngineByName("groovy");
        }
        return GROOVY_ENGINE;
    }

    private static CompiledScript compileScript(GroovyScriptEngineImpl engine, String script) {
        try {
            return engine.compile(script);
        }
        catch (ScriptException e) {
            throw new ValidationException("Script syntax error: " + e.getMessage());
        }
    }
}

