/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.utils.Bytes;

/*
 * Exception performing whole class analysis ignored.
 */
public record PolledRecords(int count, int bytes, Duration elapsed, ConsumerRecords<Bytes, Bytes> records) implements Iterable<ConsumerRecord<Bytes, Bytes>>
{
    private final int count;
    private final int bytes;
    private final Duration elapsed;
    private final ConsumerRecords<Bytes, Bytes> records;

    public PolledRecords(int count, int bytes, Duration elapsed, ConsumerRecords<Bytes, Bytes> records) {
        this.count = count;
        this.bytes = bytes;
        this.elapsed = elapsed;
        this.records = records;
    }

    static PolledRecords create(ConsumerRecords<Bytes, Bytes> polled, Duration pollDuration) {
        return new PolledRecords(polled.count(), PolledRecords.calculatePolledRecSize(polled), pollDuration, polled);
    }

    public List<ConsumerRecord<Bytes, Bytes>> records(TopicPartition tp) {
        return this.records.records(tp);
    }

    @Override
    public Iterator<ConsumerRecord<Bytes, Bytes>> iterator() {
        return this.records.iterator();
    }

    private static int calculatePolledRecSize(Iterable<ConsumerRecord<Bytes, Bytes>> recs) {
        int polledBytes = 0;
        for (ConsumerRecord<Bytes, Bytes> rec : recs) {
            for (Header header : rec.headers()) {
                polledBytes += (header.key() != null ? header.key().getBytes().length : 0) + (header.value() != null ? header.value().length : 0);
            }
            polledBytes += rec.key() == null ? 0 : rec.serializedKeySize();
            polledBytes += rec.value() == null ? 0 : rec.serializedValueSize();
        }
        return polledBytes;
    }

    public int count() {
        return this.count;
    }

    public int bytes() {
        return this.bytes;
    }

    public Duration elapsed() {
        return this.elapsed;
    }

    public ConsumerRecords<Bytes, Bytes> records() {
        return this.records;
    }
}

