/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.exception;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.provectus.kafka.ui.exception.CustomBaseException;
import com.provectus.kafka.ui.exception.ErrorCode;
import com.provectus.kafka.ui.model.ErrorResponseDTO;
import com.provectus.kafka.ui.model.FieldErrorDTO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.AbstractErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.stereotype.Component;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@Component
@Order(value=-2147483648)
public class GlobalErrorWebExceptionHandler
extends AbstractErrorWebExceptionHandler {
    public GlobalErrorWebExceptionHandler(ErrorAttributes errorAttributes, ApplicationContext applicationContext, ServerCodecConfigurer codecConfigurer) {
        super(errorAttributes, new WebProperties.Resources(), applicationContext);
        this.setMessageWriters(codecConfigurer.getWriters());
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> this.renderErrorResponse(arg_0));
    }

    private Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        Throwable throwable = this.getError(request);
        if (throwable instanceof WebExchangeBindException) {
            return this.render((WebExchangeBindException)throwable, request);
        }
        if (throwable instanceof ResponseStatusException) {
            return this.render((ResponseStatusException)throwable, request);
        }
        if (throwable instanceof CustomBaseException) {
            return this.render((CustomBaseException)throwable, request);
        }
        return this.renderDefault(throwable, request);
    }

    private Mono<ServerResponse> renderDefault(Throwable throwable, ServerRequest request) {
        ErrorResponseDTO response = new ErrorResponseDTO().code(Integer.valueOf(ErrorCode.UNEXPECTED.code())).message((String)this.coalesce((Object[])new String[]{throwable.getMessage(), "Unexpected internal error"})).requestId(this.requestId(request)).timestamp(this.currentTimestamp()).stackTrace(Throwables.getStackTraceAsString((Throwable)throwable));
        return ServerResponse.status((HttpStatusCode)ErrorCode.UNEXPECTED.httpStatus()).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)response);
    }

    private Mono<ServerResponse> render(CustomBaseException baseException, ServerRequest request) {
        ErrorCode errorCode = baseException.getErrorCode();
        ErrorResponseDTO response = new ErrorResponseDTO().code(Integer.valueOf(errorCode.code())).message((String)this.coalesce((Object[])new String[]{baseException.getMessage(), "Internal error"})).requestId(this.requestId(request)).timestamp(this.currentTimestamp()).stackTrace(Throwables.getStackTraceAsString((Throwable)baseException));
        return ServerResponse.status((HttpStatusCode)errorCode.httpStatus()).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)response);
    }

    private Mono<ServerResponse> render(WebExchangeBindException exception, ServerRequest request) {
        Map<String, Set> fieldErrorsMap = exception.getFieldErrors().stream().collect(Collectors.toMap(FieldError::getField, f -> Set.of(this.extractFieldErrorMsg(f)), Sets::union));
        List<FieldErrorDTO> fieldsErrors = fieldErrorsMap.entrySet().stream().map(e -> {
            FieldErrorDTO err = new FieldErrorDTO();
            err.setFieldName((String)e.getKey());
            err.setRestrictions(List.copyOf((Collection)e.getValue()));
            return err;
        }).toList();
        String message = fieldsErrors.isEmpty() ? exception.getMessage() : "Fields validation failure";
        ErrorResponseDTO response = new ErrorResponseDTO().code(Integer.valueOf(ErrorCode.BINDING_FAIL.code())).message(message).requestId(this.requestId(request)).timestamp(this.currentTimestamp()).fieldsErrors(fieldsErrors).stackTrace(Throwables.getStackTraceAsString((Throwable)exception));
        return ServerResponse.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)response);
    }

    private Mono<ServerResponse> render(ResponseStatusException exception, ServerRequest request) {
        String msg = (String)this.coalesce((Object[])new String[]{exception.getReason(), exception.getMessage(), "Server error"});
        ErrorResponseDTO response = new ErrorResponseDTO().code(Integer.valueOf(ErrorCode.UNEXPECTED.code())).message(msg).requestId(this.requestId(request)).timestamp(this.currentTimestamp()).stackTrace(Throwables.getStackTraceAsString((Throwable)exception));
        return ServerResponse.status((HttpStatusCode)exception.getStatusCode()).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)response);
    }

    private String requestId(ServerRequest request) {
        return request.exchange().getRequest().getId();
    }

    private BigDecimal currentTimestamp() {
        return BigDecimal.valueOf(System.currentTimeMillis());
    }

    private String extractFieldErrorMsg(FieldError fieldError) {
        return (String)this.coalesce((Object[])new String[]{fieldError.getDefaultMessage(), fieldError.getCode(), "Invalid field value"});
    }

    private <T> T coalesce(T ... items) {
        return Stream.of(items).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

