/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.mapper.ConsumerGroupMapper;
import com.provectus.kafka.ui.model.BrokerDTO;
import com.provectus.kafka.ui.model.ConsumerGroupDTO;
import com.provectus.kafka.ui.model.ConsumerGroupDetailsDTO;
import com.provectus.kafka.ui.model.ConsumerGroupStateDTO;
import com.provectus.kafka.ui.model.ConsumerGroupTopicPartitionDTO;
import com.provectus.kafka.ui.model.InternalConsumerGroup;
import com.provectus.kafka.ui.model.InternalTopicConsumerGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsumerGroupMapper {
    private ConsumerGroupMapper() {
    }

    public static ConsumerGroupDTO toDto(InternalConsumerGroup c) {
        return ConsumerGroupMapper.convertToConsumerGroup((InternalConsumerGroup)c, (ConsumerGroupDTO)new ConsumerGroupDTO());
    }

    public static ConsumerGroupDTO toDto(InternalTopicConsumerGroup c) {
        ConsumerGroupDetailsDTO consumerGroup = new ConsumerGroupDetailsDTO();
        consumerGroup.setTopics(Integer.valueOf(1));
        consumerGroup.setGroupId(c.getGroupId());
        consumerGroup.setMembers(Integer.valueOf(c.getMembers()));
        consumerGroup.setConsumerLag(c.getConsumerLag());
        consumerGroup.setSimple(Boolean.valueOf(c.isSimple()));
        consumerGroup.setPartitionAssignor(c.getPartitionAssignor());
        consumerGroup.setState(ConsumerGroupMapper.mapConsumerGroupState((ConsumerGroupState)c.getState()));
        Optional.ofNullable(c.getCoordinator()).ifPresent(arg_0 -> ConsumerGroupMapper.lambda$toDto$0((ConsumerGroupDTO)consumerGroup, arg_0));
        return consumerGroup;
    }

    public static ConsumerGroupDetailsDTO toDetailsDto(InternalConsumerGroup g) {
        ConsumerGroupDetailsDTO details = (ConsumerGroupDetailsDTO)ConsumerGroupMapper.convertToConsumerGroup((InternalConsumerGroup)g, (ConsumerGroupDTO)new ConsumerGroupDetailsDTO());
        HashMap<TopicPartition, ConsumerGroupTopicPartitionDTO> partitionMap = new HashMap<TopicPartition, ConsumerGroupTopicPartitionDTO>();
        for (Map.Entry entry : g.getOffsets().entrySet()) {
            ConsumerGroupTopicPartitionDTO partition = new ConsumerGroupTopicPartitionDTO();
            partition.setTopic(((TopicPartition)entry.getKey()).topic());
            partition.setPartition(Integer.valueOf(((TopicPartition)entry.getKey()).partition()));
            partition.setCurrentOffset((Long)entry.getValue());
            Optional<Long> endOffset = Optional.ofNullable(g.getEndOffsets()).map(o -> (Long)o.get(entry.getKey()));
            Long behind = endOffset.map(o -> o - (Long)entry.getValue()).orElse(0L);
            partition.setEndOffset(endOffset.orElse(0L));
            partition.setConsumerLag(behind);
            partitionMap.put((TopicPartition)entry.getKey(), partition);
        }
        for (InternalConsumerGroup.InternalMember member : g.getMembers()) {
            for (TopicPartition topicPartition : member.getAssignment()) {
                ConsumerGroupTopicPartitionDTO partition = partitionMap.computeIfAbsent(topicPartition, tp -> new ConsumerGroupTopicPartitionDTO().topic(tp.topic()).partition(Integer.valueOf(tp.partition())));
                partition.setHost(member.getHost());
                partition.setConsumerId(member.getConsumerId());
                partitionMap.put(topicPartition, partition);
            }
        }
        details.setPartitions(new ArrayList(partitionMap.values()));
        return details;
    }

    private static <T extends ConsumerGroupDTO> T convertToConsumerGroup(InternalConsumerGroup c, T consumerGroup) {
        consumerGroup.setGroupId(c.getGroupId());
        consumerGroup.setMembers(Integer.valueOf(c.getMembers().size()));
        consumerGroup.setConsumerLag(c.getConsumerLag());
        consumerGroup.setTopics(c.getTopicNum());
        consumerGroup.setSimple(Boolean.valueOf(c.isSimple()));
        Optional.ofNullable(c.getState()).ifPresent(s -> consumerGroup.setState(ConsumerGroupMapper.mapConsumerGroupState((ConsumerGroupState)s)));
        Optional.ofNullable(c.getCoordinator()).ifPresent(cd -> consumerGroup.setCoordinator(ConsumerGroupMapper.mapCoordinator((Node)cd)));
        consumerGroup.setPartitionAssignor(c.getPartitionAssignor());
        return consumerGroup;
    }

    private static BrokerDTO mapCoordinator(Node node) {
        return new BrokerDTO().host(node.host()).id(Integer.valueOf(node.id())).port(Integer.valueOf(node.port()));
    }

    private static ConsumerGroupStateDTO mapConsumerGroupState(ConsumerGroupState state) {
        switch (1.$SwitchMap$org$apache$kafka$common$ConsumerGroupState[state.ordinal()]) {
            case 1: {
                return ConsumerGroupStateDTO.DEAD;
            }
            case 2: {
                return ConsumerGroupStateDTO.EMPTY;
            }
            case 3: {
                return ConsumerGroupStateDTO.STABLE;
            }
            case 4: {
                return ConsumerGroupStateDTO.PREPARING_REBALANCE;
            }
            case 5: {
                return ConsumerGroupStateDTO.COMPLETING_REBALANCE;
            }
        }
        return ConsumerGroupStateDTO.UNKNOWN;
    }

    private static /* synthetic */ void lambda$toDto$0(ConsumerGroupDTO consumerGroup, Node cd) {
        consumerGroup.setCoordinator(ConsumerGroupMapper.mapCoordinator((Node)cd));
    }
}

