/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.connect.model.Connector;
import com.provectus.kafka.ui.connect.model.ConnectorPlugin;
import com.provectus.kafka.ui.connect.model.ConnectorPluginConfig;
import com.provectus.kafka.ui.connect.model.ConnectorPluginConfigDefinition;
import com.provectus.kafka.ui.connect.model.ConnectorPluginConfigValidationResponse;
import com.provectus.kafka.ui.connect.model.ConnectorPluginConfigValue;
import com.provectus.kafka.ui.connect.model.ConnectorStatusConnector;
import com.provectus.kafka.ui.connect.model.ConnectorTask;
import com.provectus.kafka.ui.connect.model.NewConnector;
import com.provectus.kafka.ui.connect.model.Task;
import com.provectus.kafka.ui.connect.model.TaskStatus;
import com.provectus.kafka.ui.mapper.KafkaConnectMapper;
import com.provectus.kafka.ui.mapper.KafkaConnectMapperImpl;
import com.provectus.kafka.ui.model.ConnectorDTO;
import com.provectus.kafka.ui.model.ConnectorPluginConfigDTO;
import com.provectus.kafka.ui.model.ConnectorPluginConfigDefinitionDTO;
import com.provectus.kafka.ui.model.ConnectorPluginConfigValidationResponseDTO;
import com.provectus.kafka.ui.model.ConnectorPluginConfigValueDTO;
import com.provectus.kafka.ui.model.ConnectorPluginDTO;
import com.provectus.kafka.ui.model.ConnectorStateDTO;
import com.provectus.kafka.ui.model.ConnectorStatusDTO;
import com.provectus.kafka.ui.model.ConnectorTaskStatusDTO;
import com.provectus.kafka.ui.model.ConnectorTypeDTO;
import com.provectus.kafka.ui.model.NewConnectorDTO;
import com.provectus.kafka.ui.model.TaskDTO;
import com.provectus.kafka.ui.model.TaskIdDTO;
import com.provectus.kafka.ui.model.TaskStatusDTO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KafkaConnectMapperImpl
implements KafkaConnectMapper {
    public NewConnector toClient(NewConnectorDTO newConnector) {
        if (newConnector == null) {
            return null;
        }
        NewConnector newConnector1 = new NewConnector();
        newConnector1.setName(newConnector.getName());
        Map map = newConnector.getConfig();
        if (map != null) {
            newConnector1.setConfig(new LinkedHashMap(map));
        }
        return newConnector1;
    }

    public ConnectorDTO fromClient(Connector connector) {
        if (connector == null) {
            return null;
        }
        ConnectorDTO connectorDTO = new ConnectorDTO();
        connectorDTO.setName(connector.getName());
        Map map = connector.getConfig();
        if (map != null) {
            connectorDTO.setConfig(new LinkedHashMap(map));
        }
        connectorDTO.setTasks(this.taskListToTaskIdDTOList(connector.getTasks()));
        connectorDTO.setType(this.typeEnumToConnectorTypeDTO(connector.getType()));
        return connectorDTO;
    }

    public ConnectorStatusDTO fromClient(ConnectorStatusConnector connectorStatus) {
        if (connectorStatus == null) {
            return null;
        }
        ConnectorStatusDTO connectorStatusDTO = new ConnectorStatusDTO();
        connectorStatusDTO.setState(this.stateEnumToConnectorStateDTO(connectorStatus.getState()));
        connectorStatusDTO.setWorkerId(connectorStatus.getWorkerId());
        return connectorStatusDTO;
    }

    public TaskDTO fromClient(ConnectorTask connectorTask) {
        if (connectorTask == null) {
            return null;
        }
        TaskDTO taskDTO = new TaskDTO();
        taskDTO.setId(this.taskToTaskIdDTO(connectorTask.getId()));
        Map map = connectorTask.getConfig();
        if (map != null) {
            taskDTO.setConfig(new LinkedHashMap(map));
        }
        return taskDTO;
    }

    public TaskStatusDTO fromClient(TaskStatus taskStatus) {
        if (taskStatus == null) {
            return null;
        }
        TaskStatusDTO taskStatusDTO = new TaskStatusDTO();
        taskStatusDTO.setId(taskStatus.getId());
        taskStatusDTO.setState(this.stateEnumToConnectorTaskStatusDTO(taskStatus.getState()));
        taskStatusDTO.setWorkerId(taskStatus.getWorkerId());
        taskStatusDTO.setTrace(taskStatus.getTrace());
        return taskStatusDTO;
    }

    public ConnectorPluginDTO fromClient(ConnectorPlugin connectorPlugin) {
        if (connectorPlugin == null) {
            return null;
        }
        ConnectorPluginDTO connectorPluginDTO = new ConnectorPluginDTO();
        connectorPluginDTO.setPropertyClass(connectorPlugin.getPropertyClass());
        return connectorPluginDTO;
    }

    public ConnectorPluginConfigValidationResponseDTO fromClient(ConnectorPluginConfigValidationResponse connectorPluginConfigValidationResponse) {
        if (connectorPluginConfigValidationResponse == null) {
            return null;
        }
        ConnectorPluginConfigValidationResponseDTO connectorPluginConfigValidationResponseDTO = new ConnectorPluginConfigValidationResponseDTO();
        connectorPluginConfigValidationResponseDTO.setName(connectorPluginConfigValidationResponse.getName());
        connectorPluginConfigValidationResponseDTO.setErrorCount(connectorPluginConfigValidationResponse.getErrorCount());
        List list = connectorPluginConfigValidationResponse.getGroups();
        if (list != null) {
            connectorPluginConfigValidationResponseDTO.setGroups(new ArrayList(list));
        }
        connectorPluginConfigValidationResponseDTO.setConfigs(this.connectorPluginConfigListToConnectorPluginConfigDTOList(connectorPluginConfigValidationResponse.getConfigs()));
        return connectorPluginConfigValidationResponseDTO;
    }

    protected TaskIdDTO taskToTaskIdDTO(Task task) {
        if (task == null) {
            return null;
        }
        TaskIdDTO taskIdDTO = new TaskIdDTO();
        taskIdDTO.setConnector(task.getConnector());
        taskIdDTO.setTask(task.getTask());
        return taskIdDTO;
    }

    protected List<TaskIdDTO> taskListToTaskIdDTOList(List<Task> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TaskIdDTO> list1 = new ArrayList<TaskIdDTO>(list.size());
        for (Task task : list) {
            list1.add(this.taskToTaskIdDTO(task));
        }
        return list1;
    }

    protected ConnectorTypeDTO typeEnumToConnectorTypeDTO(Connector.TypeEnum typeEnum) {
        if (typeEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$Connector$TypeEnum[typeEnum.ordinal()]) {
            case 1 -> ConnectorTypeDTO.SOURCE;
            case 2 -> ConnectorTypeDTO.SINK;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + typeEnum);
        };
    }

    protected ConnectorStateDTO stateEnumToConnectorStateDTO(ConnectorStatusConnector.StateEnum stateEnum) {
        if (stateEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$ConnectorStatusConnector$StateEnum[stateEnum.ordinal()]) {
            case 1 -> ConnectorStateDTO.RUNNING;
            case 2 -> ConnectorStateDTO.FAILED;
            case 3 -> ConnectorStateDTO.PAUSED;
            case 4 -> ConnectorStateDTO.UNASSIGNED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + stateEnum);
        };
    }

    protected ConnectorTaskStatusDTO stateEnumToConnectorTaskStatusDTO(TaskStatus.StateEnum stateEnum) {
        if (stateEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$TaskStatus$StateEnum[stateEnum.ordinal()]) {
            case 1 -> ConnectorTaskStatusDTO.RUNNING;
            case 2 -> ConnectorTaskStatusDTO.FAILED;
            case 3 -> ConnectorTaskStatusDTO.PAUSED;
            case 4 -> ConnectorTaskStatusDTO.RESTARTING;
            case 5 -> ConnectorTaskStatusDTO.UNASSIGNED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + stateEnum);
        };
    }

    protected ConnectorPluginConfigDefinitionDTO.TypeEnum typeEnumToTypeEnum(ConnectorPluginConfigDefinition.TypeEnum typeEnum) {
        if (typeEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$ConnectorPluginConfigDefinition$TypeEnum[typeEnum.ordinal()]) {
            case 1 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.BOOLEAN;
            case 2 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.CLASS;
            case 3 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.DOUBLE;
            case 4 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.INT;
            case 5 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.LIST;
            case 6 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.LONG;
            case 7 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.PASSWORD;
            case 8 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.SHORT;
            case 9 -> ConnectorPluginConfigDefinitionDTO.TypeEnum.STRING;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + typeEnum);
        };
    }

    protected ConnectorPluginConfigDefinitionDTO.ImportanceEnum importanceEnumToImportanceEnum(ConnectorPluginConfigDefinition.ImportanceEnum importanceEnum) {
        if (importanceEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$ConnectorPluginConfigDefinition$ImportanceEnum[importanceEnum.ordinal()]) {
            case 1 -> ConnectorPluginConfigDefinitionDTO.ImportanceEnum.LOW;
            case 2 -> ConnectorPluginConfigDefinitionDTO.ImportanceEnum.MEDIUM;
            case 3 -> ConnectorPluginConfigDefinitionDTO.ImportanceEnum.HIGH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + importanceEnum);
        };
    }

    protected ConnectorPluginConfigDefinitionDTO.WidthEnum widthEnumToWidthEnum(ConnectorPluginConfigDefinition.WidthEnum widthEnum) {
        if (widthEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$connect$model$ConnectorPluginConfigDefinition$WidthEnum[widthEnum.ordinal()]) {
            case 1 -> ConnectorPluginConfigDefinitionDTO.WidthEnum.SHORT;
            case 2 -> ConnectorPluginConfigDefinitionDTO.WidthEnum.MEDIUM;
            case 3 -> ConnectorPluginConfigDefinitionDTO.WidthEnum.LONG;
            case 4 -> ConnectorPluginConfigDefinitionDTO.WidthEnum.NONE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + widthEnum);
        };
    }

    protected ConnectorPluginConfigDefinitionDTO connectorPluginConfigDefinitionToConnectorPluginConfigDefinitionDTO(ConnectorPluginConfigDefinition connectorPluginConfigDefinition) {
        if (connectorPluginConfigDefinition == null) {
            return null;
        }
        ConnectorPluginConfigDefinitionDTO connectorPluginConfigDefinitionDTO = new ConnectorPluginConfigDefinitionDTO();
        connectorPluginConfigDefinitionDTO.setName(connectorPluginConfigDefinition.getName());
        connectorPluginConfigDefinitionDTO.setType(this.typeEnumToTypeEnum(connectorPluginConfigDefinition.getType()));
        connectorPluginConfigDefinitionDTO.setRequired(connectorPluginConfigDefinition.getRequired());
        connectorPluginConfigDefinitionDTO.setDefaultValue(connectorPluginConfigDefinition.getDefaultValue());
        connectorPluginConfigDefinitionDTO.setImportance(this.importanceEnumToImportanceEnum(connectorPluginConfigDefinition.getImportance()));
        connectorPluginConfigDefinitionDTO.setDocumentation(connectorPluginConfigDefinition.getDocumentation());
        connectorPluginConfigDefinitionDTO.setGroup(connectorPluginConfigDefinition.getGroup());
        connectorPluginConfigDefinitionDTO.setWidth(this.widthEnumToWidthEnum(connectorPluginConfigDefinition.getWidth()));
        connectorPluginConfigDefinitionDTO.setDisplayName(connectorPluginConfigDefinition.getDisplayName());
        List list = connectorPluginConfigDefinition.getDependents();
        if (list != null) {
            connectorPluginConfigDefinitionDTO.setDependents(new ArrayList(list));
        }
        connectorPluginConfigDefinitionDTO.setOrder(connectorPluginConfigDefinition.getOrder());
        return connectorPluginConfigDefinitionDTO;
    }

    protected ConnectorPluginConfigValueDTO connectorPluginConfigValueToConnectorPluginConfigValueDTO(ConnectorPluginConfigValue connectorPluginConfigValue) {
        List list1;
        if (connectorPluginConfigValue == null) {
            return null;
        }
        ConnectorPluginConfigValueDTO connectorPluginConfigValueDTO = new ConnectorPluginConfigValueDTO();
        connectorPluginConfigValueDTO.setName(connectorPluginConfigValue.getName());
        connectorPluginConfigValueDTO.setValue(connectorPluginConfigValue.getValue());
        List list = connectorPluginConfigValue.getRecommendedValues();
        if (list != null) {
            connectorPluginConfigValueDTO.setRecommendedValues(new ArrayList(list));
        }
        if ((list1 = connectorPluginConfigValue.getErrors()) != null) {
            connectorPluginConfigValueDTO.setErrors(new ArrayList(list1));
        }
        connectorPluginConfigValueDTO.setVisible(connectorPluginConfigValue.getVisible());
        return connectorPluginConfigValueDTO;
    }

    protected ConnectorPluginConfigDTO connectorPluginConfigToConnectorPluginConfigDTO(ConnectorPluginConfig connectorPluginConfig) {
        if (connectorPluginConfig == null) {
            return null;
        }
        ConnectorPluginConfigDTO connectorPluginConfigDTO = new ConnectorPluginConfigDTO();
        connectorPluginConfigDTO.setDefinition(this.connectorPluginConfigDefinitionToConnectorPluginConfigDefinitionDTO(connectorPluginConfig.getDefinition()));
        connectorPluginConfigDTO.setValue(this.connectorPluginConfigValueToConnectorPluginConfigValueDTO(connectorPluginConfig.getValue()));
        return connectorPluginConfigDTO;
    }

    protected List<ConnectorPluginConfigDTO> connectorPluginConfigListToConnectorPluginConfigDTOList(List<ConnectorPluginConfig> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ConnectorPluginConfigDTO> list1 = new ArrayList<ConnectorPluginConfigDTO>(list.size());
        for (ConnectorPluginConfig connectorPluginConfig : list) {
            list1.add(this.connectorPluginConfigToConnectorPluginConfigDTO(connectorPluginConfig));
        }
        return list1;
    }
}

