/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.mapper.KafkaSrMapper;
import com.provectus.kafka.ui.mapper.KafkaSrMapperImpl;
import com.provectus.kafka.ui.model.CompatibilityCheckResponseDTO;
import com.provectus.kafka.ui.model.CompatibilityLevelDTO;
import com.provectus.kafka.ui.model.NewSchemaSubjectDTO;
import com.provectus.kafka.ui.model.SchemaReferenceDTO;
import com.provectus.kafka.ui.model.SchemaTypeDTO;
import com.provectus.kafka.ui.sr.model.Compatibility;
import com.provectus.kafka.ui.sr.model.CompatibilityCheckResponse;
import com.provectus.kafka.ui.sr.model.NewSubject;
import com.provectus.kafka.ui.sr.model.SchemaReference;
import com.provectus.kafka.ui.sr.model.SchemaType;
import java.util.ArrayList;
import java.util.List;

public class KafkaSrMapperImpl
implements KafkaSrMapper {
    public List<SchemaReferenceDTO> toDto(List<SchemaReference> references) {
        if (references == null) {
            return null;
        }
        ArrayList<SchemaReferenceDTO> list = new ArrayList<SchemaReferenceDTO>(references.size());
        for (SchemaReference schemaReference : references) {
            list.add(this.schemaReferenceToSchemaReferenceDTO(schemaReference));
        }
        return list;
    }

    public CompatibilityCheckResponseDTO toDto(CompatibilityCheckResponse ccr) {
        if (ccr == null) {
            return null;
        }
        CompatibilityCheckResponseDTO compatibilityCheckResponseDTO = new CompatibilityCheckResponseDTO();
        compatibilityCheckResponseDTO.setIsCompatible(ccr.getIsCompatible());
        return compatibilityCheckResponseDTO;
    }

    public CompatibilityLevelDTO.CompatibilityEnum toDto(Compatibility compatibility) {
        if (compatibility == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$sr$model$Compatibility[compatibility.ordinal()]) {
            case 1 -> CompatibilityLevelDTO.CompatibilityEnum.BACKWARD;
            case 2 -> CompatibilityLevelDTO.CompatibilityEnum.BACKWARD_TRANSITIVE;
            case 3 -> CompatibilityLevelDTO.CompatibilityEnum.FORWARD;
            case 4 -> CompatibilityLevelDTO.CompatibilityEnum.FORWARD_TRANSITIVE;
            case 5 -> CompatibilityLevelDTO.CompatibilityEnum.FULL;
            case 6 -> CompatibilityLevelDTO.CompatibilityEnum.FULL_TRANSITIVE;
            case 7 -> CompatibilityLevelDTO.CompatibilityEnum.NONE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + compatibility);
        };
    }

    public NewSubject fromDto(NewSchemaSubjectDTO subjectDto) {
        if (subjectDto == null) {
            return null;
        }
        NewSubject newSubject = new NewSubject();
        newSubject.setSchema(subjectDto.getSchema());
        newSubject.setSchemaType(this.schemaTypeDTOToSchemaType(subjectDto.getSchemaType()));
        newSubject.setReferences(this.schemaReferenceDTOListToSchemaReferenceList(subjectDto.getReferences()));
        return newSubject;
    }

    public Compatibility fromDto(CompatibilityLevelDTO.CompatibilityEnum dtoEnum) {
        if (dtoEnum == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$CompatibilityLevelDTO$CompatibilityEnum[dtoEnum.ordinal()]) {
            case 1 -> Compatibility.BACKWARD;
            case 2 -> Compatibility.BACKWARD_TRANSITIVE;
            case 3 -> Compatibility.FORWARD;
            case 4 -> Compatibility.FORWARD_TRANSITIVE;
            case 5 -> Compatibility.FULL;
            case 6 -> Compatibility.FULL_TRANSITIVE;
            case 7 -> Compatibility.NONE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + dtoEnum);
        };
    }

    protected SchemaReferenceDTO schemaReferenceToSchemaReferenceDTO(SchemaReference schemaReference) {
        if (schemaReference == null) {
            return null;
        }
        SchemaReferenceDTO schemaReferenceDTO = new SchemaReferenceDTO();
        schemaReferenceDTO.setName(schemaReference.getName());
        schemaReferenceDTO.setSubject(schemaReference.getSubject());
        schemaReferenceDTO.setVersion(schemaReference.getVersion());
        return schemaReferenceDTO;
    }

    protected SchemaType schemaTypeDTOToSchemaType(SchemaTypeDTO schemaTypeDTO) {
        if (schemaTypeDTO == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$SchemaTypeDTO[schemaTypeDTO.ordinal()]) {
            case 1 -> SchemaType.AVRO;
            case 2 -> SchemaType.JSON;
            case 3 -> SchemaType.PROTOBUF;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + schemaTypeDTO);
        };
    }

    protected SchemaReference schemaReferenceDTOToSchemaReference(SchemaReferenceDTO schemaReferenceDTO) {
        if (schemaReferenceDTO == null) {
            return null;
        }
        SchemaReference schemaReference = new SchemaReference();
        schemaReference.setName(schemaReferenceDTO.getName());
        schemaReference.setSubject(schemaReferenceDTO.getSubject());
        schemaReference.setVersion(schemaReferenceDTO.getVersion());
        return schemaReference;
    }

    protected List<SchemaReference> schemaReferenceDTOListToSchemaReferenceList(List<SchemaReferenceDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SchemaReference> list1 = new ArrayList<SchemaReference>(list.size());
        for (SchemaReferenceDTO schemaReferenceDTO : list) {
            list1.add(this.schemaReferenceDTOToSchemaReference(schemaReferenceDTO));
        }
        return list1;
    }
}

