/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.google.common.base.Throwables;
import com.provectus.kafka.ui.model.BrokerDiskUsageDTO;
import com.provectus.kafka.ui.model.ClusterFeature;
import com.provectus.kafka.ui.model.InternalLogDirStats;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.MetricsCollectionErrorDTO;
import com.provectus.kafka.ui.model.PartitionsStats;
import com.provectus.kafka.ui.model.ServerStatusDTO;
import com.provectus.kafka.ui.model.Statistics;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;

public class InternalClusterState {
    private String name;
    private ServerStatusDTO status;
    private MetricsCollectionErrorDTO lastError;
    private Integer topicCount;
    private Integer brokerCount;
    private Integer activeControllers;
    private Integer onlinePartitionCount;
    private Integer offlinePartitionCount;
    private Integer inSyncReplicasCount;
    private Integer outOfSyncReplicasCount;
    private Integer underReplicatedPartitionCount;
    private List<BrokerDiskUsageDTO> diskUsage;
    private String version;
    private List<ClusterFeature> features;
    private BigDecimal bytesInPerSec;
    private BigDecimal bytesOutPerSec;
    private Boolean readOnly;

    public InternalClusterState(KafkaCluster cluster, Statistics statistics) {
        this.name = cluster.getName();
        this.status = statistics.getStatus();
        this.lastError = Optional.ofNullable(statistics.getLastKafkaException()).map(e -> new MetricsCollectionErrorDTO().message(e.getMessage()).stackTrace(Throwables.getStackTraceAsString((Throwable)e))).orElse(null);
        this.topicCount = statistics.getTopicDescriptions().size();
        this.brokerCount = statistics.getClusterDescription().getNodes().size();
        this.activeControllers = Optional.ofNullable(statistics.getClusterDescription().getController()).map(Node::id).orElse(null);
        this.version = statistics.getVersion();
        if (statistics.getLogDirInfo() != null) {
            this.diskUsage = statistics.getLogDirInfo().getBrokerStats().entrySet().stream().map(e -> new BrokerDiskUsageDTO().brokerId((Integer)e.getKey()).segmentSize(Long.valueOf(((InternalLogDirStats.SegmentStats)e.getValue()).getSegmentSize())).segmentCount(Integer.valueOf(((InternalLogDirStats.SegmentStats)e.getValue()).getSegmentsCount()))).collect(Collectors.toList());
        }
        this.features = statistics.getFeatures();
        this.bytesInPerSec = statistics.getMetrics().getBrokerBytesInPerSec().values().stream().reduce(BigDecimal::add).orElse(null);
        this.bytesOutPerSec = statistics.getMetrics().getBrokerBytesOutPerSec().values().stream().reduce(BigDecimal::add).orElse(null);
        PartitionsStats partitionsStats = new PartitionsStats(statistics.getTopicDescriptions().values());
        this.onlinePartitionCount = partitionsStats.getOnlinePartitionCount();
        this.offlinePartitionCount = partitionsStats.getOfflinePartitionCount();
        this.inSyncReplicasCount = partitionsStats.getInSyncReplicasCount();
        this.outOfSyncReplicasCount = partitionsStats.getOutOfSyncReplicasCount();
        this.underReplicatedPartitionCount = partitionsStats.getUnderReplicatedPartitionCount();
        this.readOnly = cluster.isReadOnly();
    }

    public String getName() {
        return this.name;
    }

    public ServerStatusDTO getStatus() {
        return this.status;
    }

    public MetricsCollectionErrorDTO getLastError() {
        return this.lastError;
    }

    public Integer getTopicCount() {
        return this.topicCount;
    }

    public Integer getBrokerCount() {
        return this.brokerCount;
    }

    public Integer getActiveControllers() {
        return this.activeControllers;
    }

    public Integer getOnlinePartitionCount() {
        return this.onlinePartitionCount;
    }

    public Integer getOfflinePartitionCount() {
        return this.offlinePartitionCount;
    }

    public Integer getInSyncReplicasCount() {
        return this.inSyncReplicasCount;
    }

    public Integer getOutOfSyncReplicasCount() {
        return this.outOfSyncReplicasCount;
    }

    public Integer getUnderReplicatedPartitionCount() {
        return this.underReplicatedPartitionCount;
    }

    public List<BrokerDiskUsageDTO> getDiskUsage() {
        return this.diskUsage;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ClusterFeature> getFeatures() {
        return this.features;
    }

    public BigDecimal getBytesInPerSec() {
        return this.bytesInPerSec;
    }

    public BigDecimal getBytesOutPerSec() {
        return this.bytesOutPerSec;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(ServerStatusDTO status) {
        this.status = status;
    }

    public void setLastError(MetricsCollectionErrorDTO lastError) {
        this.lastError = lastError;
    }

    public void setTopicCount(Integer topicCount) {
        this.topicCount = topicCount;
    }

    public void setBrokerCount(Integer brokerCount) {
        this.brokerCount = brokerCount;
    }

    public void setActiveControllers(Integer activeControllers) {
        this.activeControllers = activeControllers;
    }

    public void setOnlinePartitionCount(Integer onlinePartitionCount) {
        this.onlinePartitionCount = onlinePartitionCount;
    }

    public void setOfflinePartitionCount(Integer offlinePartitionCount) {
        this.offlinePartitionCount = offlinePartitionCount;
    }

    public void setInSyncReplicasCount(Integer inSyncReplicasCount) {
        this.inSyncReplicasCount = inSyncReplicasCount;
    }

    public void setOutOfSyncReplicasCount(Integer outOfSyncReplicasCount) {
        this.outOfSyncReplicasCount = outOfSyncReplicasCount;
    }

    public void setUnderReplicatedPartitionCount(Integer underReplicatedPartitionCount) {
        this.underReplicatedPartitionCount = underReplicatedPartitionCount;
    }

    public void setDiskUsage(List<BrokerDiskUsageDTO> diskUsage) {
        this.diskUsage = diskUsage;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFeatures(List<ClusterFeature> features) {
        this.features = features;
    }

    public void setBytesInPerSec(BigDecimal bytesInPerSec) {
        this.bytesInPerSec = bytesInPerSec;
    }

    public void setBytesOutPerSec(BigDecimal bytesOutPerSec) {
        this.bytesOutPerSec = bytesOutPerSec;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalClusterState)) {
            return false;
        }
        InternalClusterState other = (InternalClusterState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$topicCount = this.getTopicCount();
        Integer other$topicCount = other.getTopicCount();
        if (this$topicCount == null ? other$topicCount != null : !((Object)this$topicCount).equals(other$topicCount)) {
            return false;
        }
        Integer this$brokerCount = this.getBrokerCount();
        Integer other$brokerCount = other.getBrokerCount();
        if (this$brokerCount == null ? other$brokerCount != null : !((Object)this$brokerCount).equals(other$brokerCount)) {
            return false;
        }
        Integer this$activeControllers = this.getActiveControllers();
        Integer other$activeControllers = other.getActiveControllers();
        if (this$activeControllers == null ? other$activeControllers != null : !((Object)this$activeControllers).equals(other$activeControllers)) {
            return false;
        }
        Integer this$onlinePartitionCount = this.getOnlinePartitionCount();
        Integer other$onlinePartitionCount = other.getOnlinePartitionCount();
        if (this$onlinePartitionCount == null ? other$onlinePartitionCount != null : !((Object)this$onlinePartitionCount).equals(other$onlinePartitionCount)) {
            return false;
        }
        Integer this$offlinePartitionCount = this.getOfflinePartitionCount();
        Integer other$offlinePartitionCount = other.getOfflinePartitionCount();
        if (this$offlinePartitionCount == null ? other$offlinePartitionCount != null : !((Object)this$offlinePartitionCount).equals(other$offlinePartitionCount)) {
            return false;
        }
        Integer this$inSyncReplicasCount = this.getInSyncReplicasCount();
        Integer other$inSyncReplicasCount = other.getInSyncReplicasCount();
        if (this$inSyncReplicasCount == null ? other$inSyncReplicasCount != null : !((Object)this$inSyncReplicasCount).equals(other$inSyncReplicasCount)) {
            return false;
        }
        Integer this$outOfSyncReplicasCount = this.getOutOfSyncReplicasCount();
        Integer other$outOfSyncReplicasCount = other.getOutOfSyncReplicasCount();
        if (this$outOfSyncReplicasCount == null ? other$outOfSyncReplicasCount != null : !((Object)this$outOfSyncReplicasCount).equals(other$outOfSyncReplicasCount)) {
            return false;
        }
        Integer this$underReplicatedPartitionCount = this.getUnderReplicatedPartitionCount();
        Integer other$underReplicatedPartitionCount = other.getUnderReplicatedPartitionCount();
        if (this$underReplicatedPartitionCount == null ? other$underReplicatedPartitionCount != null : !((Object)this$underReplicatedPartitionCount).equals(other$underReplicatedPartitionCount)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ServerStatusDTO this$status = this.getStatus();
        ServerStatusDTO other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        MetricsCollectionErrorDTO this$lastError = this.getLastError();
        MetricsCollectionErrorDTO other$lastError = other.getLastError();
        if (this$lastError == null ? other$lastError != null : !this$lastError.equals(other$lastError)) {
            return false;
        }
        List this$diskUsage = this.getDiskUsage();
        List other$diskUsage = other.getDiskUsage();
        if (this$diskUsage == null ? other$diskUsage != null : !((Object)this$diskUsage).equals(other$diskUsage)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List this$features = this.getFeatures();
        List other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        BigDecimal this$bytesInPerSec = this.getBytesInPerSec();
        BigDecimal other$bytesInPerSec = other.getBytesInPerSec();
        if (this$bytesInPerSec == null ? other$bytesInPerSec != null : !((Object)this$bytesInPerSec).equals(other$bytesInPerSec)) {
            return false;
        }
        BigDecimal this$bytesOutPerSec = this.getBytesOutPerSec();
        BigDecimal other$bytesOutPerSec = other.getBytesOutPerSec();
        return !(this$bytesOutPerSec == null ? other$bytesOutPerSec != null : !((Object)this$bytesOutPerSec).equals(other$bytesOutPerSec));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalClusterState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $topicCount = this.getTopicCount();
        result = result * 59 + ($topicCount == null ? 43 : ((Object)$topicCount).hashCode());
        Integer $brokerCount = this.getBrokerCount();
        result = result * 59 + ($brokerCount == null ? 43 : ((Object)$brokerCount).hashCode());
        Integer $activeControllers = this.getActiveControllers();
        result = result * 59 + ($activeControllers == null ? 43 : ((Object)$activeControllers).hashCode());
        Integer $onlinePartitionCount = this.getOnlinePartitionCount();
        result = result * 59 + ($onlinePartitionCount == null ? 43 : ((Object)$onlinePartitionCount).hashCode());
        Integer $offlinePartitionCount = this.getOfflinePartitionCount();
        result = result * 59 + ($offlinePartitionCount == null ? 43 : ((Object)$offlinePartitionCount).hashCode());
        Integer $inSyncReplicasCount = this.getInSyncReplicasCount();
        result = result * 59 + ($inSyncReplicasCount == null ? 43 : ((Object)$inSyncReplicasCount).hashCode());
        Integer $outOfSyncReplicasCount = this.getOutOfSyncReplicasCount();
        result = result * 59 + ($outOfSyncReplicasCount == null ? 43 : ((Object)$outOfSyncReplicasCount).hashCode());
        Integer $underReplicatedPartitionCount = this.getUnderReplicatedPartitionCount();
        result = result * 59 + ($underReplicatedPartitionCount == null ? 43 : ((Object)$underReplicatedPartitionCount).hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ServerStatusDTO $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        MetricsCollectionErrorDTO $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : $lastError.hashCode());
        List $diskUsage = this.getDiskUsage();
        result = result * 59 + ($diskUsage == null ? 43 : ((Object)$diskUsage).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        BigDecimal $bytesInPerSec = this.getBytesInPerSec();
        result = result * 59 + ($bytesInPerSec == null ? 43 : ((Object)$bytesInPerSec).hashCode());
        BigDecimal $bytesOutPerSec = this.getBytesOutPerSec();
        result = result * 59 + ($bytesOutPerSec == null ? 43 : ((Object)$bytesOutPerSec).hashCode());
        return result;
    }

    public String toString() {
        return "InternalClusterState(name=" + this.getName() + ", status=" + this.getStatus() + ", lastError=" + this.getLastError() + ", topicCount=" + this.getTopicCount() + ", brokerCount=" + this.getBrokerCount() + ", activeControllers=" + this.getActiveControllers() + ", onlinePartitionCount=" + this.getOnlinePartitionCount() + ", offlinePartitionCount=" + this.getOfflinePartitionCount() + ", inSyncReplicasCount=" + this.getInSyncReplicasCount() + ", outOfSyncReplicasCount=" + this.getOutOfSyncReplicasCount() + ", underReplicatedPartitionCount=" + this.getUnderReplicatedPartitionCount() + ", diskUsage=" + this.getDiskUsage() + ", version=" + this.getVersion() + ", features=" + this.getFeatures() + ", bytesInPerSec=" + this.getBytesInPerSec() + ", bytesOutPerSec=" + this.getBytesOutPerSec() + ", readOnly=" + this.getReadOnly() + ")";
    }
}

