/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.InternalLogDirStats;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public final class InternalLogDirStats {
    private final Map<TopicPartition, SegmentStats> partitionsStats;
    private final Map<String, SegmentStats> topicStats;
    private final Map<Integer, SegmentStats> brokerStats;

    public static InternalLogDirStats empty() {
        return new InternalLogDirStats(Map.of());
    }

    public InternalLogDirStats(Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>> log) {
        List topicPartitions = log.entrySet().stream().flatMap(b -> ((Map)b.getValue()).entrySet().stream().flatMap(topicMap -> ((DescribeLogDirsResponse.LogDirInfo)topicMap.getValue()).replicaInfos.entrySet().stream().map(e -> Tuples.of((Object)((Integer)b.getKey()), (Object)((TopicPartition)e.getKey()), (Object)((DescribeLogDirsResponse.ReplicaInfo)e.getValue()).size)))).toList();
        this.partitionsStats = topicPartitions.stream().collect(Collectors.groupingBy(Tuple2::getT2, Collectors.collectingAndThen(Collectors.summarizingLong(Tuple3::getT3), SegmentStats::new)));
        this.topicStats = topicPartitions.stream().collect(Collectors.groupingBy(t -> ((TopicPartition)t.getT2()).topic(), Collectors.collectingAndThen(Collectors.summarizingLong(Tuple3::getT3), SegmentStats::new)));
        this.brokerStats = topicPartitions.stream().collect(Collectors.groupingBy(Tuple2::getT1, Collectors.collectingAndThen(Collectors.summarizingLong(Tuple3::getT3), SegmentStats::new)));
    }

    public Map<TopicPartition, SegmentStats> getPartitionsStats() {
        return this.partitionsStats;
    }

    public Map<String, SegmentStats> getTopicStats() {
        return this.topicStats;
    }

    public Map<Integer, SegmentStats> getBrokerStats() {
        return this.brokerStats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalLogDirStats)) {
            return false;
        }
        InternalLogDirStats other = (InternalLogDirStats)o;
        Map this$partitionsStats = this.getPartitionsStats();
        Map other$partitionsStats = other.getPartitionsStats();
        if (this$partitionsStats == null ? other$partitionsStats != null : !((Object)this$partitionsStats).equals(other$partitionsStats)) {
            return false;
        }
        Map this$topicStats = this.getTopicStats();
        Map other$topicStats = other.getTopicStats();
        if (this$topicStats == null ? other$topicStats != null : !((Object)this$topicStats).equals(other$topicStats)) {
            return false;
        }
        Map this$brokerStats = this.getBrokerStats();
        Map other$brokerStats = other.getBrokerStats();
        return !(this$brokerStats == null ? other$brokerStats != null : !((Object)this$brokerStats).equals(other$brokerStats));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $partitionsStats = this.getPartitionsStats();
        result = result * 59 + ($partitionsStats == null ? 43 : ((Object)$partitionsStats).hashCode());
        Map $topicStats = this.getTopicStats();
        result = result * 59 + ($topicStats == null ? 43 : ((Object)$topicStats).hashCode());
        Map $brokerStats = this.getBrokerStats();
        result = result * 59 + ($brokerStats == null ? 43 : ((Object)$brokerStats).hashCode());
        return result;
    }

    public String toString() {
        return "InternalLogDirStats(partitionsStats=" + this.getPartitionsStats() + ", topicStats=" + this.getTopicStats() + ", brokerStats=" + this.getBrokerStats() + ")";
    }
}

