/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.InternalTopicConsumerGroup;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;

/*
 * Exception performing whole class analysis ignored.
 */
public final class InternalTopicConsumerGroup {
    private final String groupId;
    private final int members;
    @Nullable
    private final Long consumerLag;
    private final boolean isSimple;
    private final String partitionAssignor;
    private final ConsumerGroupState state;
    @Nullable
    private final Node coordinator;

    public static InternalTopicConsumerGroup create(String topic, ConsumerGroupDescription g, Map<TopicPartition, Long> committedOffsets, Map<TopicPartition, Long> endOffsets) {
        return InternalTopicConsumerGroup.builder().groupId(g.groupId()).members((int)g.members().stream().filter(m -> m.assignment().topicPartitions().stream().anyMatch(p -> p.topic().equals(topic))).count()).consumerLag(InternalTopicConsumerGroup.calculateConsumerLag(committedOffsets, endOffsets)).isSimple(g.isSimpleConsumerGroup()).partitionAssignor(g.partitionAssignor()).state(g.state()).coordinator(g.coordinator()).build();
    }

    @Nullable
    private static Long calculateConsumerLag(Map<TopicPartition, Long> committedOffsets, Map<TopicPartition, Long> endOffsets) {
        if (committedOffsets.isEmpty()) {
            return null;
        }
        return committedOffsets.entrySet().stream().mapToLong(e -> Optional.ofNullable((Long)endOffsets.get(e.getKey())).map(o -> o - (Long)e.getValue()).orElse(0L)).sum();
    }

    InternalTopicConsumerGroup(String groupId, int members, @Nullable Long consumerLag, boolean isSimple, String partitionAssignor, ConsumerGroupState state, @Nullable Node coordinator) {
        this.groupId = groupId;
        this.members = members;
        this.consumerLag = consumerLag;
        this.isSimple = isSimple;
        this.partitionAssignor = partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
    }

    public static InternalTopicConsumerGroupBuilder builder() {
        return new InternalTopicConsumerGroupBuilder();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getMembers() {
        return this.members;
    }

    @Nullable
    public Long getConsumerLag() {
        return this.consumerLag;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    public ConsumerGroupState getState() {
        return this.state;
    }

    @Nullable
    public Node getCoordinator() {
        return this.coordinator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalTopicConsumerGroup)) {
            return false;
        }
        InternalTopicConsumerGroup other = (InternalTopicConsumerGroup)o;
        if (this.getMembers() != other.getMembers()) {
            return false;
        }
        if (this.isSimple() != other.isSimple()) {
            return false;
        }
        Long this$consumerLag = this.getConsumerLag();
        Long other$consumerLag = other.getConsumerLag();
        if (this$consumerLag == null ? other$consumerLag != null : !((Object)this$consumerLag).equals(other$consumerLag)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$partitionAssignor = this.getPartitionAssignor();
        String other$partitionAssignor = other.getPartitionAssignor();
        if (this$partitionAssignor == null ? other$partitionAssignor != null : !this$partitionAssignor.equals(other$partitionAssignor)) {
            return false;
        }
        ConsumerGroupState this$state = this.getState();
        ConsumerGroupState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Node this$coordinator = this.getCoordinator();
        Node other$coordinator = other.getCoordinator();
        return !(this$coordinator == null ? other$coordinator != null : !this$coordinator.equals(other$coordinator));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMembers();
        result = result * 59 + (this.isSimple() ? 79 : 97);
        Long $consumerLag = this.getConsumerLag();
        result = result * 59 + ($consumerLag == null ? 43 : ((Object)$consumerLag).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $partitionAssignor = this.getPartitionAssignor();
        result = result * 59 + ($partitionAssignor == null ? 43 : $partitionAssignor.hashCode());
        ConsumerGroupState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Node $coordinator = this.getCoordinator();
        result = result * 59 + ($coordinator == null ? 43 : $coordinator.hashCode());
        return result;
    }

    public String toString() {
        return "InternalTopicConsumerGroup(groupId=" + this.getGroupId() + ", members=" + this.getMembers() + ", consumerLag=" + this.getConsumerLag() + ", isSimple=" + this.isSimple() + ", partitionAssignor=" + this.getPartitionAssignor() + ", state=" + this.getState() + ", coordinator=" + this.getCoordinator() + ")";
    }
}

