/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.Statistics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PartitionDistributionStats {
    private static final Logger log = LoggerFactory.getLogger(PartitionDistributionStats.class);
    private static final int MIN_PARTITIONS_FOR_SKEW_CALCULATION = 50;
    private final Map<Node, Integer> partitionLeaders;
    private final Map<Node, Integer> partitionsCount;
    private final Map<Node, Integer> inSyncPartitions;
    private final double avgLeadersCntPerBroker;
    private final double avgPartitionsPerBroker;
    private final boolean skewCanBeCalculated;

    public static PartitionDistributionStats create(Statistics stats) {
        return PartitionDistributionStats.create((Statistics)stats, (int)50);
    }

    static PartitionDistributionStats create(Statistics stats, int minPartitionsForSkewCalculation) {
        HashMap partitionLeaders = new HashMap();
        HashMap partitionsReplicated = new HashMap();
        HashMap isr = new HashMap();
        int partitionsCnt = 0;
        for (TopicDescription td : stats.getTopicDescriptions().values()) {
            for (TopicPartitionInfo tp : td.partitions()) {
                ++partitionsCnt;
                tp.replicas().forEach(r -> PartitionDistributionStats.incr((Map)partitionsReplicated, (Node)r));
                tp.isr().forEach(r -> PartitionDistributionStats.incr((Map)isr, (Node)r));
                if (tp.leader() == null) continue;
                PartitionDistributionStats.incr(partitionLeaders, (Node)tp.leader());
            }
        }
        int nodesWithPartitions = partitionsReplicated.size();
        int partitionReplications = partitionsReplicated.values().stream().mapToInt(i -> i).sum();
        double avgPartitionsPerBroker = nodesWithPartitions == 0 ? 0.0 : (double)partitionReplications / (double)nodesWithPartitions;
        int nodesWithLeaders = partitionLeaders.size();
        int leadersCnt = partitionLeaders.values().stream().mapToInt(i -> i).sum();
        double avgLeadersCntPerBroker = nodesWithLeaders == 0 ? 0.0 : (double)leadersCnt / (double)nodesWithLeaders;
        return new PartitionDistributionStats(partitionLeaders, partitionsReplicated, isr, avgLeadersCntPerBroker, avgPartitionsPerBroker, partitionsCnt >= minPartitionsForSkewCalculation);
    }

    private static void incr(Map<Node, Integer> map, Node n) {
        map.compute(n, (k, c) -> {
            int n;
            if (c == null) {
                n = 1;
            } else {
                c = c + 1;
                n = c;
            }
            return n;
        });
    }

    @Nullable
    public BigDecimal partitionsSkew(Node node) {
        return this.calculateAvgSkew((Integer)this.partitionsCount.get(node), this.avgPartitionsPerBroker);
    }

    @Nullable
    public BigDecimal leadersSkew(Node node) {
        return this.calculateAvgSkew((Integer)this.partitionLeaders.get(node), this.avgLeadersCntPerBroker);
    }

    @Nullable
    private BigDecimal calculateAvgSkew(@Nullable Integer value, double avgValue) {
        if (avgValue == 0.0 || !this.skewCanBeCalculated) {
            return null;
        }
        value = value == null ? 0 : value;
        return new BigDecimal(((double)value.intValue() - avgValue) / avgValue * 100.0).setScale(1, RoundingMode.HALF_UP);
    }

    private PartitionDistributionStats(Map<Node, Integer> partitionLeaders, Map<Node, Integer> partitionsCount, Map<Node, Integer> inSyncPartitions, double avgLeadersCntPerBroker, double avgPartitionsPerBroker, boolean skewCanBeCalculated) {
        this.partitionLeaders = partitionLeaders;
        this.partitionsCount = partitionsCount;
        this.inSyncPartitions = inSyncPartitions;
        this.avgLeadersCntPerBroker = avgLeadersCntPerBroker;
        this.avgPartitionsPerBroker = avgPartitionsPerBroker;
        this.skewCanBeCalculated = skewCanBeCalculated;
    }

    public Map<Node, Integer> getPartitionLeaders() {
        return this.partitionLeaders;
    }

    public Map<Node, Integer> getPartitionsCount() {
        return this.partitionsCount;
    }

    public Map<Node, Integer> getInSyncPartitions() {
        return this.inSyncPartitions;
    }

    public double getAvgLeadersCntPerBroker() {
        return this.avgLeadersCntPerBroker;
    }

    public double getAvgPartitionsPerBroker() {
        return this.avgPartitionsPerBroker;
    }

    public boolean isSkewCanBeCalculated() {
        return this.skewCanBeCalculated;
    }
}

