/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.admin.TopicDescription;

public class PartitionsStats {
    private int partitionsCount;
    private int replicasCount;
    private int onlinePartitionCount;
    private int offlinePartitionCount;
    private int inSyncReplicasCount;
    private int outOfSyncReplicasCount;
    private int underReplicatedPartitionCount;

    public PartitionsStats(TopicDescription description) {
        this(List.of(description));
    }

    public PartitionsStats(Collection<TopicDescription> topicDescriptions) {
        topicDescriptions.stream().flatMap(t -> t.partitions().stream()).forEach(p -> {
            ++this.partitionsCount;
            this.replicasCount += p.replicas().size();
            this.onlinePartitionCount += p.leader() != null ? 1 : 0;
            this.offlinePartitionCount += p.leader() == null ? 1 : 0;
            this.inSyncReplicasCount += p.isr().size();
            this.outOfSyncReplicasCount += p.replicas().size() - p.isr().size();
            if (p.replicas().size() > p.isr().size()) {
                ++this.underReplicatedPartitionCount;
            }
        });
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public int getReplicasCount() {
        return this.replicasCount;
    }

    public int getOnlinePartitionCount() {
        return this.onlinePartitionCount;
    }

    public int getOfflinePartitionCount() {
        return this.offlinePartitionCount;
    }

    public int getInSyncReplicasCount() {
        return this.inSyncReplicasCount;
    }

    public int getOutOfSyncReplicasCount() {
        return this.outOfSyncReplicasCount;
    }

    public int getUnderReplicatedPartitionCount() {
        return this.underReplicatedPartitionCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public void setReplicasCount(int replicasCount) {
        this.replicasCount = replicasCount;
    }

    public void setOnlinePartitionCount(int onlinePartitionCount) {
        this.onlinePartitionCount = onlinePartitionCount;
    }

    public void setOfflinePartitionCount(int offlinePartitionCount) {
        this.offlinePartitionCount = offlinePartitionCount;
    }

    public void setInSyncReplicasCount(int inSyncReplicasCount) {
        this.inSyncReplicasCount = inSyncReplicasCount;
    }

    public void setOutOfSyncReplicasCount(int outOfSyncReplicasCount) {
        this.outOfSyncReplicasCount = outOfSyncReplicasCount;
    }

    public void setUnderReplicatedPartitionCount(int underReplicatedPartitionCount) {
        this.underReplicatedPartitionCount = underReplicatedPartitionCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionsStats)) {
            return false;
        }
        PartitionsStats other = (PartitionsStats)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPartitionsCount() != other.getPartitionsCount()) {
            return false;
        }
        if (this.getReplicasCount() != other.getReplicasCount()) {
            return false;
        }
        if (this.getOnlinePartitionCount() != other.getOnlinePartitionCount()) {
            return false;
        }
        if (this.getOfflinePartitionCount() != other.getOfflinePartitionCount()) {
            return false;
        }
        if (this.getInSyncReplicasCount() != other.getInSyncReplicasCount()) {
            return false;
        }
        if (this.getOutOfSyncReplicasCount() != other.getOutOfSyncReplicasCount()) {
            return false;
        }
        return this.getUnderReplicatedPartitionCount() == other.getUnderReplicatedPartitionCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionsStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionsCount();
        result = result * 59 + this.getReplicasCount();
        result = result * 59 + this.getOnlinePartitionCount();
        result = result * 59 + this.getOfflinePartitionCount();
        result = result * 59 + this.getInSyncReplicasCount();
        result = result * 59 + this.getOutOfSyncReplicasCount();
        result = result * 59 + this.getUnderReplicatedPartitionCount();
        return result;
    }

    public String toString() {
        return "PartitionsStats(partitionsCount=" + this.getPartitionsCount() + ", replicasCount=" + this.getReplicasCount() + ", onlinePartitionCount=" + this.getOnlinePartitionCount() + ", offlinePartitionCount=" + this.getOfflinePartitionCount() + ", inSyncReplicasCount=" + this.getInSyncReplicasCount() + ", outOfSyncReplicasCount=" + this.getOutOfSyncReplicasCount() + ", underReplicatedPartitionCount=" + this.getUnderReplicatedPartitionCount() + ")";
    }
}

