/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.provectus.kafka.ui.model.TopicMessageDTO;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.RecordHeaders;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.ConsumerRecordDeserializer;
import com.provectus.kafka.ui.serdes.RecordHeadersImpl;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.UnaryOperator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsumerRecordDeserializer {
    private static final Logger log = LoggerFactory.getLogger(ConsumerRecordDeserializer.class);
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private final String keySerdeName;
    private final Serde.Deserializer keyDeserializer;
    private final String valueSerdeName;
    private final Serde.Deserializer valueDeserializer;
    private final String fallbackSerdeName;
    private final Serde.Deserializer fallbackKeyDeserializer;
    private final Serde.Deserializer fallbackValueDeserializer;
    private final UnaryOperator<TopicMessageDTO> masker;

    public TopicMessageDTO deserialize(ConsumerRecord<Bytes, Bytes> rec) {
        TopicMessageDTO message = new TopicMessageDTO();
        this.fillKey(message, rec);
        this.fillValue(message, rec);
        this.fillHeaders(message, rec);
        message.setPartition(Integer.valueOf(rec.partition()));
        message.setOffset(Long.valueOf(rec.offset()));
        message.setTimestampType(ConsumerRecordDeserializer.mapToTimestampType((TimestampType)rec.timestampType()));
        message.setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(rec.timestamp()), UTC_ZONE_ID));
        message.setKeySize(ConsumerRecordDeserializer.getKeySize(rec));
        message.setValueSize(ConsumerRecordDeserializer.getValueSize(rec));
        message.setHeadersSize(ConsumerRecordDeserializer.getHeadersSize(rec));
        return (TopicMessageDTO)this.masker.apply(message);
    }

    private static TopicMessageDTO.TimestampTypeEnum mapToTimestampType(TimestampType timestampType) {
        return switch (1.$SwitchMap$org$apache$kafka$common$record$TimestampType[timestampType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> TopicMessageDTO.TimestampTypeEnum.CREATE_TIME;
            case 2 -> TopicMessageDTO.TimestampTypeEnum.LOG_APPEND_TIME;
            case 3 -> TopicMessageDTO.TimestampTypeEnum.NO_TIMESTAMP_TYPE;
        };
    }

    private void fillHeaders(TopicMessageDTO message, ConsumerRecord<Bytes, Bytes> rec) {
        HashMap headers = new HashMap();
        rec.headers().iterator().forEachRemaining(header -> headers.put(header.key(), header.value() != null ? new String(header.value()) : null));
        message.setHeaders(headers);
    }

    private void fillKey(TopicMessageDTO message, ConsumerRecord<Bytes, Bytes> rec) {
        if (rec.key() == null) {
            return;
        }
        try {
            DeserializeResult deserResult = this.keyDeserializer.deserialize((RecordHeaders)new RecordHeadersImpl(), ((Bytes)rec.key()).get());
            message.setKey(deserResult.getResult());
            message.setKeySerde(this.keySerdeName);
            message.setKeyDeserializeProperties(deserResult.getAdditionalProperties());
        }
        catch (Exception e) {
            log.trace("Error deserializing key for key topic: {}, partition {}, offset {}, with serde {}", new Object[]{rec.topic(), rec.partition(), rec.offset(), this.keySerdeName, e});
            DeserializeResult deserResult = this.fallbackKeyDeserializer.deserialize((RecordHeaders)new RecordHeadersImpl(), ((Bytes)rec.key()).get());
            message.setKey(deserResult.getResult());
            message.setKeySerde(this.fallbackSerdeName);
        }
    }

    private void fillValue(TopicMessageDTO message, ConsumerRecord<Bytes, Bytes> rec) {
        if (rec.value() == null) {
            return;
        }
        try {
            DeserializeResult deserResult = this.valueDeserializer.deserialize((RecordHeaders)new RecordHeadersImpl(rec.headers()), ((Bytes)rec.value()).get());
            message.setContent(deserResult.getResult());
            message.setValueSerde(this.valueSerdeName);
            message.setValueDeserializeProperties(deserResult.getAdditionalProperties());
        }
        catch (Exception e) {
            log.trace("Error deserializing key for value topic: {}, partition {}, offset {}, with serde {}", new Object[]{rec.topic(), rec.partition(), rec.offset(), this.valueSerdeName, e});
            DeserializeResult deserResult = this.fallbackValueDeserializer.deserialize((RecordHeaders)new RecordHeadersImpl(rec.headers()), ((Bytes)rec.value()).get());
            message.setContent(deserResult.getResult());
            message.setValueSerde(this.fallbackSerdeName);
        }
    }

    private static Long getHeadersSize(ConsumerRecord<Bytes, Bytes> consumerRecord) {
        Headers headers = consumerRecord.headers();
        if (headers != null) {
            return Arrays.stream(headers.toArray()).mapToLong(ConsumerRecordDeserializer::headerSize).sum();
        }
        return 0L;
    }

    private static Long getKeySize(ConsumerRecord<Bytes, Bytes> consumerRecord) {
        return consumerRecord.key() != null ? Long.valueOf(consumerRecord.serializedKeySize()) : null;
    }

    private static Long getValueSize(ConsumerRecord<Bytes, Bytes> consumerRecord) {
        return consumerRecord.value() != null ? Long.valueOf(consumerRecord.serializedValueSize()) : null;
    }

    private static int headerSize(Header header) {
        int key = header.key() != null ? header.key().getBytes().length : 0;
        int val = header.value() != null ? header.value().length : 0;
        return key + val;
    }

    public ConsumerRecordDeserializer(String keySerdeName, Serde.Deserializer keyDeserializer, String valueSerdeName, Serde.Deserializer valueDeserializer, String fallbackSerdeName, Serde.Deserializer fallbackKeyDeserializer, Serde.Deserializer fallbackValueDeserializer, UnaryOperator<TopicMessageDTO> masker) {
        this.keySerdeName = keySerdeName;
        this.keyDeserializer = keyDeserializer;
        this.valueSerdeName = valueSerdeName;
        this.valueDeserializer = valueDeserializer;
        this.fallbackSerdeName = fallbackSerdeName;
        this.fallbackKeyDeserializer = fallbackKeyDeserializer;
        this.fallbackValueDeserializer = fallbackValueDeserializer;
        this.masker = masker;
    }
}

