/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.ClassloaderUtil;
import com.provectus.kafka.ui.serdes.CustomSerdeLoader;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
class CustomSerdeLoader {
    private final Map<Path, ClassLoader> classloaders = new ConcurrentHashMap();

    CustomSerdeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomSerde loadAndConfigure(String className, String filePath, PropertyResolver serdeProps, PropertyResolver clusterProps, PropertyResolver globalProps) {
        CustomSerde customSerde;
        Path locationPath = Path.of(filePath, new String[0]);
        ClassLoader serdeClassloader = this.createClassloader(locationPath);
        ClassLoader origCL = ClassloaderUtil.compareAndSwapLoaders((ClassLoader)serdeClassloader);
        try {
            Class<?> serdeClass = serdeClassloader.loadClass(className);
            Serde serde = (Serde)serdeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            serde.configure(serdeProps, clusterProps, globalProps);
            customSerde = new CustomSerde(serde, serdeClassloader);
        }
        catch (Throwable throwable) {
            ClassloaderUtil.compareAndSwapLoaders((ClassLoader)origCL);
            throw throwable;
        }
        ClassloaderUtil.compareAndSwapLoaders((ClassLoader)origCL);
        return customSerde;
    }

    private static boolean isArchive(Path path) {
        String archivePath = path.toString().toLowerCase();
        return Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0]) && (archivePath.endsWith(".jar") || archivePath.endsWith(".zip"));
    }

    private static List<URL> findArchiveFiles(Path location) {
        if (CustomSerdeLoader.isArchive((Path)location)) {
            return List.of(location.toUri().toURL());
        }
        if (Files.isDirectory(location, new LinkOption[0])) {
            ArrayList<URL> archiveFiles = new ArrayList<URL>();
            try (Stream<Path> files = Files.walk(location, new FileVisitOption[0]);){
                List paths = files.filter(CustomSerdeLoader::isArchive).collect(Collectors.toList());
                for (Path path : paths) {
                    archiveFiles.add(path.toUri().toURL());
                }
            }
            return archiveFiles;
        }
        return List.of();
    }

    private ClassLoader createClassloader(Path location) {
        if (!Files.exists(location, new LinkOption[0])) {
            throw new IllegalStateException("Location does not exist");
        }
        List archives = CustomSerdeLoader.findArchiveFiles((Path)location);
        if (archives.isEmpty()) {
            throw new IllegalStateException("No archive files were found");
        }
        return this.classloaders.computeIfAbsent(location, l -> AccessController.doPrivileged(() -> new ChildFirstClassloader((URL[])archives.toArray(URL[]::new), CustomSerdeLoader.class.getClassLoader())));
    }
}

