/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.provectus.kafka.ui.serde.api.Serde;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class ProducerRecordCreator {
    private final Serde.Serializer keySerializer;
    private final Serde.Serializer valuesSerializer;

    public ProducerRecord<byte[], byte[]> create(String topic, @Nullable Integer partition, @Nullable String key, @Nullable String value, @Nullable Map<String, String> headers) {
        return new ProducerRecord(topic, partition, (Object)(key == null ? null : this.keySerializer.serialize(key)), (Object)(value == null ? null : this.valuesSerializer.serialize(value)), headers == null ? null : this.createHeaders(headers));
    }

    private Iterable<Header> createHeaders(Map<String, String> clientHeaders) {
        RecordHeaders headers = new RecordHeaders();
        clientHeaders.forEach((k, v) -> headers.add((Header)new RecordHeader(k, v.getBytes())));
        return headers;
    }

    public ProducerRecordCreator(Serde.Serializer keySerializer, Serde.Serializer valuesSerializer) {
        this.keySerializer = keySerializer;
        this.valuesSerializer = valuesSerializer;
    }
}

