/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import com.provectus.kafka.ui.serdes.builtin.ConsumerOffsetsSerde;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ConsumerOffsetsSerde
implements BuiltInSerde {
    private static final JsonMapper JSON_MAPPER = ConsumerOffsetsSerde.createMapper();
    private static final String ASSIGNMENT = "assignment";
    private static final String CLIENT_HOST = "client_host";
    private static final String CLIENT_ID = "client_id";
    private static final String COMMIT_TIMESTAMP = "commit_timestamp";
    private static final String CURRENT_STATE_TIMESTAMP = "current_state_timestamp";
    private static final String GENERATION = "generation";
    private static final String LEADER = "leader";
    private static final String MEMBERS = "members";
    private static final String MEMBER_ID = "member_id";
    private static final String METADATA = "metadata";
    private static final String OFFSET = "offset";
    private static final String PROTOCOL = "protocol";
    private static final String PROTOCOL_TYPE = "protocol_type";
    private static final String REBALANCE_TIMEOUT = "rebalance_timeout";
    private static final String SESSION_TIMEOUT = "session_timeout";
    private static final String SUBSCRIPTION = "subscription";
    public static final String TOPIC = "__consumer_offsets";

    public static String name() {
        return TOPIC;
    }

    private static JsonMapper createMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Struct.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        JsonMapper mapper = new JsonMapper();
        mapper.registerModule((Module)module);
        return mapper;
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return topic.equals(TOPIC);
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return false;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        throw new UnsupportedOperationException();
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return switch (2.$SwitchMap$com$provectus$kafka$ui$serde$api$Serde$Target[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.keyDeserializer();
            case 2 -> this.valueDeserializer();
        };
    }

    private Serde.Deserializer keyDeserializer() {
        Schema commitKeySchema = new Schema(new Field[]{new Field("group", (Type)Type.STRING, ""), new Field("topic", (Type)Type.STRING, ""), new Field("partition", (Type)Type.INT32, "")});
        Schema groupMetadataSchema = new Schema(new Field[]{new Field("group", (Type)Type.STRING, "")});
        return (headers, data) -> {
            ByteBuffer bb = ByteBuffer.wrap(data);
            short version = bb.getShort();
            return new DeserializeResult(this.toJson(switch (version) {
                case 0, 1 -> commitKeySchema.read(bb);
                case 2 -> groupMetadataSchema.read(bb);
                default -> throw new IllegalStateException("Unknown group metadata message version: " + version);
            }), DeserializeResult.Type.JSON, Map.of());
        };
    }

    private Serde.Deserializer valueDeserializer() {
        Schema commitOffsetSchemaV0 = new Schema(new Field[]{new Field(OFFSET, (Type)Type.INT64, ""), new Field(METADATA, (Type)Type.STRING, ""), new Field(COMMIT_TIMESTAMP, (Type)Type.INT64, "")});
        Schema commitOffsetSchemaV1 = new Schema(new Field[]{new Field(OFFSET, (Type)Type.INT64, ""), new Field(METADATA, (Type)Type.STRING, ""), new Field(COMMIT_TIMESTAMP, (Type)Type.INT64, ""), new Field("expire_timestamp", (Type)Type.INT64, "")});
        Schema commitOffsetSchemaV2 = new Schema(new Field[]{new Field(OFFSET, (Type)Type.INT64, ""), new Field(METADATA, (Type)Type.STRING, ""), new Field(COMMIT_TIMESTAMP, (Type)Type.INT64, "")});
        Schema commitOffsetSchemaV3 = new Schema(new Field[]{new Field(OFFSET, (Type)Type.INT64, ""), new Field("leader_epoch", (Type)Type.INT32, ""), new Field(METADATA, (Type)Type.STRING, ""), new Field(COMMIT_TIMESTAMP, (Type)Type.INT64, "")});
        Schema commitOffsetSchemaV4 = new Schema(new Field[]{new Field(OFFSET, (Type)Type.INT64, ""), new Field("leader_epoch", (Type)Type.INT32, ""), new Field(METADATA, (Type)Type.COMPACT_STRING, ""), new Field(COMMIT_TIMESTAMP, (Type)Type.INT64, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        Schema metadataSchema0 = new Schema(new Field[]{new Field(PROTOCOL_TYPE, (Type)Type.STRING, ""), new Field(GENERATION, (Type)Type.INT32, ""), new Field(PROTOCOL, (Type)Type.NULLABLE_STRING, ""), new Field(LEADER, (Type)Type.NULLABLE_STRING, ""), new Field(MEMBERS, (Type)new ArrayOf((Type)new Schema(new Field[]{new Field(MEMBER_ID, (Type)Type.STRING, ""), new Field(CLIENT_ID, (Type)Type.STRING, ""), new Field(CLIENT_HOST, (Type)Type.STRING, ""), new Field(SESSION_TIMEOUT, (Type)Type.INT32, ""), new Field(SUBSCRIPTION, (Type)Type.BYTES, ""), new Field(ASSIGNMENT, (Type)Type.BYTES, "")})), "")});
        Schema metadataSchema1 = new Schema(new Field[]{new Field(PROTOCOL_TYPE, (Type)Type.STRING, ""), new Field(GENERATION, (Type)Type.INT32, ""), new Field(PROTOCOL, (Type)Type.NULLABLE_STRING, ""), new Field(LEADER, (Type)Type.NULLABLE_STRING, ""), new Field(MEMBERS, (Type)new ArrayOf((Type)new Schema(new Field[]{new Field(MEMBER_ID, (Type)Type.STRING, ""), new Field(CLIENT_ID, (Type)Type.STRING, ""), new Field(CLIENT_HOST, (Type)Type.STRING, ""), new Field(REBALANCE_TIMEOUT, (Type)Type.INT32, ""), new Field(SESSION_TIMEOUT, (Type)Type.INT32, ""), new Field(SUBSCRIPTION, (Type)Type.BYTES, ""), new Field(ASSIGNMENT, (Type)Type.BYTES, "")})), "")});
        Schema metadataSchema2 = new Schema(new Field[]{new Field(PROTOCOL_TYPE, (Type)Type.STRING, ""), new Field(GENERATION, (Type)Type.INT32, ""), new Field(PROTOCOL, (Type)Type.NULLABLE_STRING, ""), new Field(LEADER, (Type)Type.NULLABLE_STRING, ""), new Field(CURRENT_STATE_TIMESTAMP, (Type)Type.INT64, ""), new Field(MEMBERS, (Type)new ArrayOf((Type)new Schema(new Field[]{new Field(MEMBER_ID, (Type)Type.STRING, ""), new Field(CLIENT_ID, (Type)Type.STRING, ""), new Field(CLIENT_HOST, (Type)Type.STRING, ""), new Field(REBALANCE_TIMEOUT, (Type)Type.INT32, ""), new Field(SESSION_TIMEOUT, (Type)Type.INT32, ""), new Field(SUBSCRIPTION, (Type)Type.BYTES, ""), new Field(ASSIGNMENT, (Type)Type.BYTES, "")})), "")});
        Schema metadataSchema3 = new Schema(new Field[]{new Field(PROTOCOL_TYPE, (Type)Type.STRING, ""), new Field(GENERATION, (Type)Type.INT32, ""), new Field(PROTOCOL, (Type)Type.NULLABLE_STRING, ""), new Field(LEADER, (Type)Type.NULLABLE_STRING, ""), new Field(CURRENT_STATE_TIMESTAMP, (Type)Type.INT64, ""), new Field(MEMBERS, (Type)new ArrayOf((Type)new Schema(new Field[]{new Field(MEMBER_ID, (Type)Type.STRING, ""), new Field("group_instance_id", (Type)Type.NULLABLE_STRING, ""), new Field(CLIENT_ID, (Type)Type.STRING, ""), new Field(CLIENT_HOST, (Type)Type.STRING, ""), new Field(REBALANCE_TIMEOUT, (Type)Type.INT32, ""), new Field(SESSION_TIMEOUT, (Type)Type.INT32, ""), new Field(SUBSCRIPTION, (Type)Type.BYTES, ""), new Field(ASSIGNMENT, (Type)Type.BYTES, "")})), "")});
        Schema metadataSchema4 = new Schema(new Field[]{new Field(PROTOCOL_TYPE, (Type)Type.COMPACT_STRING, ""), new Field(GENERATION, (Type)Type.INT32, ""), new Field(PROTOCOL, (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field(LEADER, (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field(CURRENT_STATE_TIMESTAMP, (Type)Type.INT64, ""), new Field(MEMBERS, (Type)new CompactArrayOf((Type)new Schema(new Field[]{new Field(MEMBER_ID, (Type)Type.COMPACT_STRING, ""), new Field("group_instance_id", (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field(CLIENT_ID, (Type)Type.COMPACT_STRING, ""), new Field(CLIENT_HOST, (Type)Type.COMPACT_STRING, ""), new Field(REBALANCE_TIMEOUT, (Type)Type.INT32, ""), new Field(SESSION_TIMEOUT, (Type)Type.INT32, ""), new Field(SUBSCRIPTION, (Type)Type.COMPACT_BYTES, ""), new Field(ASSIGNMENT, (Type)Type.COMPACT_BYTES, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])})), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        return (headers, data) -> {
            String result;
            ByteBuffer bb = ByteBuffer.wrap(data);
            short version = bb.getShort();
            try {
                result = this.toJson(switch (version) {
                    case 0 -> metadataSchema0.read(bb);
                    case 1 -> metadataSchema1.read(bb);
                    case 2 -> metadataSchema2.read(bb);
                    case 3 -> metadataSchema3.read(bb);
                    case 4 -> metadataSchema4.read(bb);
                    default -> throw new IllegalArgumentException("Unrecognized version: " + version);
                });
            }
            catch (Throwable e) {
                bb = bb.rewind();
                bb.getShort();
                result = this.toJson(switch (version) {
                    case 0 -> commitOffsetSchemaV0.read(bb);
                    case 1 -> commitOffsetSchemaV1.read(bb);
                    case 2 -> commitOffsetSchemaV2.read(bb);
                    case 3 -> commitOffsetSchemaV3.read(bb);
                    case 4 -> commitOffsetSchemaV4.read(bb);
                    default -> throw new IllegalArgumentException("Unrecognized version: " + version);
                });
            }
            if (bb.remaining() != 0) {
                throw new IllegalArgumentException("Message buffer is not read to the end, which is likely means message is unrecognized");
            }
            return new DeserializeResult(result, DeserializeResult.Type.JSON, Map.of());
        };
    }

    private String toJson(Struct s) {
        return JSON_MAPPER.writeValueAsString((Object)s);
    }
}

