/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.google.common.primitives.Ints;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.util.Map;
import java.util.Optional;

public class Int32Serde
implements BuiltInSerde {
    public static String name() {
        return "Int32";
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.of(new SchemaDescription(String.format("{   \"type\" : \"integer\",   \"minimum\" : %s,   \"maximum\" : %s }", Integer.MIN_VALUE, Integer.MAX_VALUE), Map.of()));
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> Ints.toByteArray((int)Integer.parseInt(input));
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> new DeserializeResult(String.valueOf(Ints.fromByteArray((byte[])data)), DeserializeResult.Type.JSON, Map.of());
    }
}

