/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import com.provectus.kafka.ui.serdes.builtin.ProtobufFileSerde;
import com.provectus.kafka.ui.util.jsonschema.ProtobufSchemaConverter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProtobufFileSerde
implements BuiltInSerde {
    private static final Logger log = LoggerFactory.getLogger(ProtobufFileSerde.class);
    private static final ProtobufSchemaConverter SCHEMA_CONVERTER = new ProtobufSchemaConverter();
    private Map<String, Descriptors.Descriptor> messageDescriptorMap = new HashMap();
    private Map<String, Descriptors.Descriptor> keyMessageDescriptorMap = new HashMap();
    private Map<Descriptors.Descriptor, Path> descriptorPaths = new HashMap();
    @Nullable
    private Descriptors.Descriptor defaultMessageDescriptor;
    @Nullable
    private Descriptors.Descriptor defaultKeyMessageDescriptor;

    public static String name() {
        return "ProtobufFile";
    }

    public boolean canBeAutoConfigured(PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        return Configuration.canBeAutoConfigured((PropertyResolver)kafkaClusterProperties);
    }

    public void autoConfigure(PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        this.configure(Configuration.create((PropertyResolver)kafkaClusterProperties));
    }

    public void configure(PropertyResolver serdeProperties, PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        this.configure(Configuration.create((PropertyResolver)serdeProperties));
    }

    @VisibleForTesting
    void configure(Configuration configuration) {
        if (configuration.defaultMessageDescriptor() == null && configuration.defaultKeyMessageDescriptor() == null && configuration.messageDescriptorMap().isEmpty() && configuration.keyMessageDescriptorMap().isEmpty()) {
            throw new ValidationException("Neither default, not per-topic descriptors defined for " + ProtobufFileSerde.name() + " serde");
        }
        this.defaultMessageDescriptor = configuration.defaultMessageDescriptor();
        this.defaultKeyMessageDescriptor = configuration.defaultKeyMessageDescriptor();
        this.descriptorPaths = configuration.descriptorPaths();
        this.messageDescriptorMap = configuration.messageDescriptorMap();
        this.keyMessageDescriptorMap = configuration.keyMessageDescriptorMap();
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    private Optional<Descriptors.Descriptor> descriptorFor(String topic, Serde.Target type) {
        return type == Serde.Target.KEY ? Optional.ofNullable((Descriptors.Descriptor)this.keyMessageDescriptorMap.get(topic)).or(() -> Optional.ofNullable(this.defaultKeyMessageDescriptor)) : Optional.ofNullable((Descriptors.Descriptor)this.messageDescriptorMap.get(topic)).or(() -> Optional.ofNullable(this.defaultMessageDescriptor));
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return this.descriptorFor(topic, type).isPresent();
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return this.descriptorFor(topic, type).isPresent();
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        Descriptors.Descriptor descriptor = (Descriptors.Descriptor)this.descriptorFor(topic, type).orElseThrow();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        Descriptors.Descriptor descriptor = (Descriptors.Descriptor)this.descriptorFor(topic, type).orElseThrow();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return this.descriptorFor(topic, type).map(arg_0 -> this.toSchemaDescription(arg_0));
    }

    private SchemaDescription toSchemaDescription(Descriptors.Descriptor descriptor) {
        Path path = (Path)this.descriptorPaths.get(descriptor);
        return new SchemaDescription(SCHEMA_CONVERTER.convert(path.toUri(), descriptor).toJson(), Map.of("messageName", descriptor.getFullName()));
    }

    private static String readFileAsString(Path path) {
        return Files.readString(path);
    }
}

