/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public class StringSerde
implements BuiltInSerde {
    private Charset encoding = StandardCharsets.UTF_8;

    public static String name() {
        return "String";
    }

    public void configure(PropertyResolver serdeProperties, PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        serdeProperties.getProperty("encoding", String.class).map(Charset::forName).ifPresent(e -> {
            this.encoding = e;
        });
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> input.getBytes(this.encoding);
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> new DeserializeResult(new String(data, this.encoding), DeserializeResult.Type.STRING, Map.of());
    }
}

