/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.util.Map;
import java.util.Optional;

public class UInt32Serde
implements BuiltInSerde {
    public static String name() {
        return "UInt32";
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.of(new SchemaDescription(String.format("{   \"type\" : \"integer\",   \"minimum\" : 0,   \"maximum\" : %s}", UnsignedInteger.MAX_VALUE), Map.of()));
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> Ints.toByteArray((int)Integer.parseUnsignedInt(input));
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> new DeserializeResult(UnsignedInteger.fromIntBits((int)Ints.fromByteArray((byte[])data)).toString(), DeserializeResult.Type.JSON, Map.of());
    }
}

