/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLong;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.util.Map;
import java.util.Optional;

public class UInt64Serde
implements BuiltInSerde {
    public static String name() {
        return "UInt64";
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.of(new SchemaDescription(String.format("{   \"type\" : \"integer\",   \"minimum\" : 0,   \"maximum\" : %s }", UnsignedLong.MAX_VALUE), Map.of()));
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> Longs.toByteArray((long)Long.parseUnsignedLong(input));
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> new DeserializeResult(UnsignedLong.fromLongBits((long)Longs.fromByteArray((byte[])data)).toString(), DeserializeResult.Type.JSON, Map.of());
    }
}

